/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.connectorbinding;

import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConnectorManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.WizardInterface;
import com.metamatrix.console.ui.views.deploy.util.DeployPkgUtils;
import com.metamatrix.console.ui.views.deploy.util.DeployTableSorter;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.toolbox.ui.widget.CheckBox;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumn;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumnModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class NewBindingWizardPSCEnablePanel
extends BasicWizardSubpanelContainer
implements ActionListener,
ListSelectionListener,
TableModelListener {
    private static String[] SERVICE_HDRS = new String[3];
    private static final int PSC_COL = 0;
    private static final int CONFIGURATION_COL = 1;
    private static final int ENABLED_COL = 2;
    private static final String NEXT_STARTUP_CONFIG = "Next Startup";
    public static SimpleDateFormat DATE_FORMATTER;
    private TableWidget tblPSCs;
    private DefaultTableModel tmdlPSCs;
    private HashMap mapPSCtoEnabledForNextStartup = new HashMap();
    private HashMap mapNextStartupPSCXref = new HashMap();
    private int numRowsDifferentNextStartup = 0;
    private CheckBox chk;
    private LabelWidget lblConnectorName = new LabelWidget("Connector Type:");
    private TextFieldWidget txfConnectorName = new TextFieldWidget();
    private TextFieldWidget txfBindingName = new TextFieldWidget();
    private LabelWidget lblBindingName = new LabelWidget("Binding Name:");
    private JPanel pnlOuter = new JPanel();
    private JPanel pnlTable = new JPanel();
    private ConnectionInfo connection;

    public NewBindingWizardPSCEnablePanel(WizardInterface wizardInterface, ConnectionInfo connection) {
        super(wizardInterface);
        this.connection = connection;
        this.init();
    }

    private ConnectorManager getConnectorManager() {
        return ModelManager.getConnectorManager(this.connection);
    }

    public void setNewConnectorBindingInfo(String bindingName, String connectorTypeName) {
        this.txfBindingName.setText(bindingName);
        this.txfConnectorName.setText(connectorTypeName);
    }

    private void init() {
        this.createTablePanel();
        this.txfBindingName.setEditable(false);
        this.txfConnectorName.setEditable(false);
        Insets insDefault = new Insets(3, 3, 3, 3);
        this.pnlOuter.setLayout(new GridBagLayout());
        this.pnlOuter.add((Component)this.lblBindingName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, insDefault, 0, 0));
        this.pnlOuter.add((Component)this.txfBindingName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, insDefault, 0, 0));
        this.pnlOuter.add((Component)this.lblConnectorName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, insDefault, 0, 0));
        this.pnlOuter.add((Component)this.txfConnectorName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, insDefault, 0, 0));
        this.pnlOuter.add((Component)this.pnlTable, new GridBagConstraints(0, 2, 0, 0, 1.0, 1.0, 10, 1, new Insets(12, 3, 3, 3), 0, 0));
        this.setMainContent(this.pnlOuter);
        this.setStepText(3, "Set Enabled State of New Binding in PSCs, and Create the Binding.");
        this.populateTable();
    }

    private JPanel createTablePanel() {
        this.pnlTable = new JPanel();
        this.pnlTable.setLayout(new GridLayout(1, 1));
        this.tblPSCs = new TableWidget();
        this.tmdlPSCs = DeployPkgUtils.setup(this.tblPSCs, SERVICE_HDRS, 10, new int[]{2});
        this.tblPSCs.getSelectionModel().addListSelectionListener(this);
        this.tblPSCs.setComparator(new DeployTableSorter());
        this.doTableSetup();
        this.tmdlPSCs.addTableModelListener(this);
        JScrollPane spnServices = new JScrollPane(this.tblPSCs);
        this.pnlTable.add(spnServices);
        return this.pnlTable;
    }

    private void populateTable() {
        this.loadPSCsForNextStartup();
        this.createPSCXrefs();
        this.tmdlPSCs.setNumRows(0);
        try {
            if (this.mapPSCtoEnabledForNextStartup != null) {
                for (ProductServiceConfig psc : this.mapPSCtoEnabledForNextStartup.keySet()) {
                    Vector<Object> row = new Vector<Object>(SERVICE_HDRS.length);
                    row.setSize(SERVICE_HDRS.length);
                    row.setElementAt(psc, 0);
                    row.setElementAt(NEXT_STARTUP_CONFIG, 1);
                    Boolean enabledForNextStartup = (Boolean)this.mapPSCtoEnabledForNextStartup.get(psc);
                    row.setElementAt(enabledForNextStartup, 2);
                    this.tmdlPSCs.addRow(row);
                }
            }
        }
        catch (Exception theException) {
            ExceptionUtility.showMessage("  ", theException);
            LogManager.logError((String)"PSC-DEPLOYMENT", (Throwable)theException, (String)(this.getClass() + ":setDomainObject"));
        }
    }

    private void doTableSetup() {
        this.tblPSCs.sizeColumnsToFitData();
        EnhancedTableColumnModel etcmNextStartup = this.tblPSCs.getEnhancedColumnModel();
        TableColumn clmConnBindColumnNextStartup = etcmNextStartup.getColumn(2);
        this.tblPSCs.sizeColumnToFitData((EnhancedTableColumn)clmConnBindColumnNextStartup);
        this.sortPSCTable();
    }

    private void sortPSCTable() {
        EnhancedTableColumnModel etcmPSCs = this.tblPSCs.getEnhancedColumnModel();
        TableColumn clmPSCColumn = etcmPSCs.getColumn(0);
        etcmPSCs.setColumnSortedAscending((EnhancedTableColumn)clmPSCColumn, false);
    }

    private void loadPSCsForNextStartup() {
        this.mapPSCtoEnabledForNextStartup.clear();
        try {
            Configuration config = this.getNextStartupConfig();
            Collection colPsc = this.getConnectorManager().getAllConnectorsPSCsByConfig(config);
            if (colPsc != null) {
                for (ProductServiceConfig psc : colPsc) {
                    Boolean enabled = null;
                    enabled = psc.getServiceComponentDefnIDs().size() > 0 ? Boolean.TRUE : Boolean.FALSE;
                    this.mapPSCtoEnabledForNextStartup.put(psc, enabled);
                }
            }
        }
        catch (Exception theException) {
            ExceptionUtility.showMessage("  ", theException);
            LogManager.logError((String)"PSC-DEPLOYMENT", (Throwable)theException, (String)(this.getClass() + ":setDomainObject"));
        }
    }

    private void createPSCXrefs() {
        for (ProductServiceConfig psc : this.mapPSCtoEnabledForNextStartup.keySet()) {
            this.mapNextStartupPSCXref.put(psc.getName(), psc);
        }
    }

    @Override
    public void actionPerformed(ActionEvent theEvent) {
    }

    @Override
    public void tableChanged(TableModelEvent theEvent) {
        int iSelectedRow = theEvent.getFirstRow();
        String sConfigOfSelectedRow = this.getConfigTypeForRow(iSelectedRow);
        if (sConfigOfSelectedRow.equals(NEXT_STARTUP_CONFIG)) {
            int row = theEvent.getFirstRow();
            ProductServiceConfig psc = (ProductServiceConfig)this.tmdlPSCs.getValueAt(row, 0);
            ProductServiceConfig pscNS = (ProductServiceConfig)this.mapNextStartupPSCXref.get(psc.getName());
            Object saveEnabled = this.mapPSCtoEnabledForNextStartup.get(pscNS);
            if (!saveEnabled.equals(this.tmdlPSCs.getValueAt(row, 2))) {
                ++this.numRowsDifferentNextStartup;
            } else if (this.numRowsDifferentNextStartup > 0) {
                --this.numRowsDifferentNextStartup;
            }
            this.checkResetState();
        }
    }

    private String getConfigTypeForRow(int iRow) {
        String sConfigOfSelectedRow = (String)this.tmdlPSCs.getValueAt(iRow, 1);
        return sConfigOfSelectedRow;
    }

    @Override
    public void valueChanged(ListSelectionEvent theEvent) {
        int row = this.tblPSCs.getSelectedRow();
        if (row != -1) {
            TableCellEditor editor = this.tblPSCs.getCellEditor(row, 2);
            this.chk = (CheckBox)editor.getTableCellEditorComponent(this.tblPSCs, this.tblPSCs.getValueAt(row, 2), true, row, 2);
            this.chk.addActionListener(this);
            this.tblPSCs.getSelectionModel().removeListSelectionListener(this);
        }
    }

    private void checkResetState() {
    }

    private Configuration getNextStartupConfig() {
        Configuration cfg = null;
        try {
            cfg = this.getConnectorManager().getNextStartupConfig();
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed retrieving the Next Startup Config", e);
        }
        return cfg;
    }

    public ProductServiceConfig[] getEnabledConfigs() {
        int numRows = this.tblPSCs.getRowCount();
        ArrayList<ProductServiceConfig> pscsList = new ArrayList<ProductServiceConfig>(numRows);
        for (int i = 0; i < numRows; ++i) {
            Boolean enabledBool = (Boolean)this.tblPSCs.getModel().getValueAt(i, 2);
            if (!enabledBool.booleanValue()) continue;
            ProductServiceConfig psc = (ProductServiceConfig)this.tblPSCs.getModel().getValueAt(i, 0);
            pscsList.add(psc);
        }
        ProductServiceConfig[] pscs = new ProductServiceConfig[pscsList.size()];
        Iterator it = pscsList.iterator();
        int i = 0;
        while (it.hasNext()) {
            pscs[i] = (ProductServiceConfig)it.next();
            ++i;
        }
        return pscs;
    }

    static {
        NewBindingWizardPSCEnablePanel.SERVICE_HDRS[0] = "PSC";
        NewBindingWizardPSCEnablePanel.SERVICE_HDRS[1] = "Configuration";
        NewBindingWizardPSCEnablePanel.SERVICE_HDRS[2] = "Enabled";
        String pattern = DeployPkgUtils.getString("pfp.datepattern", true);
        if (pattern == null) {
            pattern = "MMM dd, yyyy hh:mm:ss";
        }
        DATE_FORMATTER = new SimpleDateFormat(pattern);
    }
}

