/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.connectorbinding;

import com.metamatrix.common.actions.ModificationActionQueue;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConnectorManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.InitialAndCurrentValues;
import com.metamatrix.console.ui.util.PropertiedObjectPanelHolder;
import com.metamatrix.console.ui.util.WizardInterface;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.CheckBox;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.property.PropertiedObjectPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JPanel;

public class NewBindingWizardSpecificationPanel
extends BasicWizardSubpanelContainer
implements PropertyChangeListener,
ComponentListener {
    private PropertiedObjectPanel popThePanel;
    private ComponentType ctConnector = null;
    private String sConnectorBindingName = "Unknown";
    private TextFieldWidget txfConnectorName = new TextFieldWidget();
    private LabelWidget lblConnectorName = new LabelWidget();
    private TextFieldWidget txfBindingName = new TextFieldWidget();
    private LabelWidget lblBindingName = new LabelWidget();
    private JPanel pnlOuter = new JPanel();
    private JPanel pnlPOPShell = new JPanel(new GridLayout(1, 1));
    private ConfigurationObjectEditor coeEditor;
    private ModificationActionQueue maqActionQForBinding;
    private ConnectorBinding scdNewConnectorBinding;
    private PropertiedObject poPropObject;
    private PropertiedObjectEditor poeEditor;
    private Map valuesMap = new HashMap();
    private Map defsMap = new HashMap();
    private ConnectionInfo connection = null;

    public NewBindingWizardSpecificationPanel(WizardInterface wizardInterface, ConnectionInfo connection) {
        super(wizardInterface);
        this.connection = connection;
        this.init();
    }

    private ConnectorManager getConnectorManager() {
        return ModelManager.getConnectorManager(this.connection);
    }

    private void init() {
        this.pnlPOPShell.setPreferredSize(new Dimension(200, 300));
        this.pnlOuter.setLayout(new GridBagLayout());
        this.lblBindingName.setText("Binding Name:");
        this.lblConnectorName.setText("Connector Type:");
        this.txfBindingName.setEditable(false);
        this.txfConnectorName.setEditable(false);
        this.pnlOuter.add((Component)this.lblBindingName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 0), 5, 4));
        this.pnlOuter.add((Component)this.txfBindingName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 1), 1, 0));
        this.pnlOuter.add((Component)this.lblConnectorName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 0), 5, 4));
        this.pnlOuter.add((Component)this.txfConnectorName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 1), 1, 0));
        this.pnlOuter.add((Component)this.pnlPOPShell, new GridBagConstraints(0, 2, 2, 3, 1.0, 1.0, 10, 1, new Insets(8, 0, 0, 1), 1, 0));
        this.setMainContent(this.pnlOuter);
        this.setStepText(2, "Specify Details for this Connector Binding.");
        this.setupListening();
    }

    public ConfigurationObjectEditor getConfigurationObjectEditor() {
        return this.coeEditor;
    }

    private void updateTextFields() {
        this.txfConnectorName.setText(this.ctConnector.getName());
        this.txfBindingName.setText(this.sConnectorBindingName);
    }

    public void updatePropertiedObjectPanel(ComponentType ctConnector, String sConnectorBindingName, boolean initBinding) {
        boolean showingWaitCursor;
        this.ctConnector = ctConnector;
        this.sConnectorBindingName = sConnectorBindingName;
        this.updateTextFields();
        try {
            showingWaitCursor = true;
            StaticUtilities.startWait(ConsoleMainFrame.getInstance());
            this.coeEditor = this.getConnectorManager().getConnectorBindingEditor();
            this.scdNewConnectorBinding = initBinding ? this.getConnectorManager().getTentativeConnectorBinding(ctConnector, this.coeEditor, sConnectorBindingName) : this.getConnectorManager().copyConnectorBinding(this.scdNewConnectorBinding, this.coeEditor, sConnectorBindingName);
            this.maqActionQForBinding = this.coeEditor.getDestination();
            this.poPropObject = this.getConnectorManager().getPropertiedObject((ServiceComponentDefn)this.scdNewConnectorBinding);
            this.poeEditor = this.getConnectorManager().getPropertiedObjectEditor(this.maqActionQForBinding);
            this.popThePanel = new PropertiedObjectPanel(this.poeEditor, this.getConnectorManager().getEncryptor());
            this.poeEditor.setReadOnly(this.poPropObject, false);
            this.popThePanel.setNameColumnHeaderWidth(0);
            this.popThePanel.setPropertiedObject(this.poPropObject);
            this.popThePanel.setShowRequiredProperties(true);
            this.popThePanel.setShowInvalidProperties(true);
            this.popThePanel.setShowHiddenProperties(false);
            this.popThePanel.setShowExpertProperties(true);
            this.popThePanel.setShowOptionalProperties(false);
            this.popThePanel.refreshDisplay();
            this.popThePanel.createComponent();
            this.pnlPOPShell.removeAll();
            ItemListener popChangeListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ev) {
                    NewBindingWizardSpecificationPanel.this.includeOptionalsChanged(ev);
                }
            };
            this.pnlPOPShell.add(new PropertiedObjectPanelHolder(this.popThePanel, popChangeListener));
            this.setInitialValues();
            this.popThePanel.addPropertyChangeListener(this);
            this.setButtons();
        }
        catch (Exception e) {
            StaticUtilities.endWait(ConsoleMainFrame.getInstance());
            showingWaitCursor = false;
            ExceptionUtility.showMessage("Failed while creating Connector Binding Panel", e);
        }
        if (showingWaitCursor) {
            StaticUtilities.endWait(ConsoleMainFrame.getInstance());
        }
    }

    private void includeOptionalsChanged(ItemEvent ev) {
        CheckBox cb = (CheckBox)ev.getSource();
        this.popThePanel.setShowOptionalProperties(cb.isSelected());
        this.popThePanel.refreshDisplay();
    }

    public ConnectorBinding getNewConnectorBinding() {
        return this.scdNewConnectorBinding;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setButtons();
    }

    public void setButtons() {
        AbstractButton forwardButton = this.getWizardInterface().getForwardButton();
        forwardButton.setEnabled(!this.anyValueInvalid());
        this.repaint();
    }

    private boolean anyValueInvalid() {
        int iInvalidCount = this.popThePanel.getInvalidDefinitions().size();
        boolean anyInvalid = iInvalidCount > 0;
        return anyInvalid;
    }

    private void setInitialValues() {
        PropertiedObject propObj = this.popThePanel.getPropertiedObject();
        List defs = this.poeEditor.getPropertyDefinitions(propObj);
        for (PropertyDefinition def : defs) {
            this.defsMap.put(def.getName(), def);
            Object value = this.poeEditor.getValue(propObj, def);
            InitialAndCurrentValues vals = new InitialAndCurrentValues(value, value);
            this.valuesMap.put(def, vals);
        }
    }

    public void setupListening() {
        this.addComponentListener(this);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.setInitialPostRealizeState();
        this.removeComponentListener(this);
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public void setInitialPostRealizeState() {
        this.setButtons();
    }
}

