/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.deploy;

import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.ui.views.deploy.DetailPanel;
import com.metamatrix.console.ui.views.deploy.util.DeployPkgUtils;
import com.metamatrix.console.ui.views.deploy.util.DeployTableSorter;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumn;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumnModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.table.TableColumn;

public final class ConfigSummaryPanel
extends DetailPanel {
    private TableWidget tblDeployments;
    private TableWidget tblPscs;
    private Configuration config;
    private DefaultTableModel deployTblModel;
    private DefaultTableModel pscsTblModel;

    public ConfigSummaryPanel(ConnectionInfo conn) {
        super(conn);
        this.setTitle(this.getString("csp.title"));
    }

    public ConfigSummaryPanel(ConfigurationID theConfigId, ConnectionInfo conn) throws ExternalException {
        this(conn);
        this.setConfigId(theConfigId);
    }

    @Override
    protected JPanel construct(boolean readOnly) {
        JPanel pnl = new JPanel(new GridBagLayout());
        JPanel pnlDeployments = new JPanel();
        pnlDeployments.setLayout(new GridLayout(1, 1));
        TitledBorder tBorder = new TitledBorder(this.getString("csp.pnlDeployments.title"));
        pnlDeployments.setBorder(new CompoundBorder(tBorder, DeployPkgUtils.EMPTY_BORDER));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.weightx = 0.3;
        gbc.weighty = 0.3;
        pnl.add((Component)pnlDeployments, gbc);
        this.tblDeployments = new TableWidget();
        this.deployTblModel = DeployPkgUtils.setup(this.tblDeployments, DeployPkgUtils.DEPLOY_HDRS, DeployPkgUtils.getInt("csp.deploytblrows", 10), null);
        this.tblDeployments.setComparator(new DeployTableSorter());
        JScrollPane spnDeployments = new JScrollPane(this.tblDeployments);
        pnlDeployments.add(spnDeployments);
        JPanel pnlPscs = new JPanel(new GridLayout(1, 1));
        tBorder = new TitledBorder(this.getString("csp.pnlPscs.title"));
        pnlPscs.setBorder(new CompoundBorder(tBorder, DeployPkgUtils.EMPTY_BORDER));
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        pnl.add((Component)pnlPscs, gbc);
        this.tblPscs = new TableWidget();
        this.pscsTblModel = DeployPkgUtils.setup(this.tblPscs, DeployPkgUtils.PSC_SERV_DEF_HDRS, DeployPkgUtils.getInt("csp.psctblrows", 10), null);
        this.tblPscs.setComparator(new DeployTableSorter());
        JScrollPane spnPscs = new JScrollPane(this.tblPscs);
        pnlPscs.add(spnPscs);
        return pnl;
    }

    private void sortFirstColumnInTable(TableWidget twidget) {
        EnhancedTableColumnModel etcmTabelCM = twidget.getEnhancedColumnModel();
        TableColumn tColumn = etcmTabelCM.getColumn(0);
        etcmTabelCM.setColumnSortedAscending((EnhancedTableColumn)tColumn, false);
    }

    @Override
    public void setDomainObject(Object theDomainObject, Object[] theAncestors) {
        if (!(theDomainObject instanceof Configuration)) {
            throw new IllegalArgumentException(this.getString("msg.invalidclass", new Object[]{"Configuration", theDomainObject.getClass()}));
        }
        this.config = (Configuration)theDomainObject;
        super.setDomainObject(this.config, theAncestors);
        try {
            DeployPkgUtils.loadDeployments(this.config, this.deployTblModel, this.getConnectionInfo());
            this.tblDeployments.sizeColumnsToFitData();
            this.sortFirstColumnInTable(this.tblDeployments);
            DeployPkgUtils.loadPscServiceDefintions(this.config, this.pscsTblModel, this.getConnectionInfo());
            this.tblPscs.sizeColumnsToFitData();
            this.sortFirstColumnInTable(this.tblPscs);
        }
        catch (ExternalException theException) {
            ExceptionUtility.showMessage(this.getString("msg.configmgrproblem", new Object[]{this.getClass(), "setDomainObject"}), "" + theException.getMessage(), (Throwable)((Object)theException));
            LogManager.logError((String)"PSC-DEPLOYMENT", (Throwable)((Object)theException), (String)(this.getClass() + ":setDomainObject"));
        }
    }
}

