/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.deploy;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConfigurationManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.ChooserPanel;
import com.metamatrix.console.ui.util.WizardInterface;
import com.metamatrix.console.ui.util.WizardInterfaceImpl;
import com.metamatrix.console.ui.views.deploy.util.DeployPkgUtils;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.toolbox.ui.widget.DialogPanel;
import com.metamatrix.toolbox.ui.widget.DialogWindow;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import javax.swing.JPanel;

public final class ConfigurationImportWizard {
    private static final String[] FILE_EXTENSIONS = (String[])DeployPkgUtils.getObject("dmp.importexport.extensions");
    private static final String FILE_VIEW_DESC = DeployPkgUtils.getString("dmp.importexport.description");
    private static final String CHOOSER_DESC = "Select configuration file to import to the Next Startup configuration.";
    private ChooserPanel pnlChooser;
    private ConfirmationPage pnlConfirmation;
    private WizardImpl wizard;
    private DialogWindow dlg;
    private Collection configObjs;
    private String fileName;
    private ConnectionInfo connectionInfo;

    public ConfigurationImportWizard(ConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
        this.wizard = new WizardImpl();
        this.pnlChooser = new ChooserPanel(this.wizard, 1, 0, CHOOSER_DESC, FILE_EXTENSIONS, FILE_VIEW_DESC, "metamatrix.console.directory");
        this.pnlChooser.enableForwardButton(false);
        this.pnlChooser.init();
        this.pnlConfirmation = new ConfirmationPage(this.wizard);
        this.wizard.addPage(this.pnlChooser);
        this.wizard.addPage(this.pnlConfirmation);
    }

    public ConfigurationManager getConfigurationManager() {
        return ModelManager.getConfigurationManager(this.connectionInfo);
    }

    public Collection getImportedObjects() {
        return this.configObjs;
    }

    private void nextPage() {
        this.fileName = this.pnlChooser.getSelectedFullFileName();
        try {
            this.configObjs = this.getConfigurationManager().importObjects(this.fileName);
            this.pnlChooser.saveCurrentDirLocation();
        }
        catch (Exception theException) {
            Object[] args = new Object[]{this.fileName};
            ExceptionUtility.showMessage(DeployPkgUtils.getString("dmp.msg.importerror"), DeployPkgUtils.getString("dmp.msg.importerrordetail", args), theException);
            LogManager.logError((String)"PSC-DEPLOYMENT", (Throwable)theException, (String)DeployPkgUtils.getString("dmp.msg.importerror", args));
            this.pnlChooser.enableForwardButton(false);
            return;
        }
        this.pnlConfirmation.setConfiguration("Next Startup");
        this.pnlConfirmation.setConflicts(false);
        this.pnlConfirmation.setFileName(this.fileName);
        this.wizard.showPage(this.pnlConfirmation);
    }

    public boolean run() {
        boolean finished;
        this.dlg = new DialogWindow((Frame)ConsoleMainFrame.getInstance(), DeployPkgUtils.getString("dmp.import.title"), (DialogPanel)this.wizard);
        this.dlg.setLocationRelativeTo(ConsoleMainFrame.getInstance());
        this.dlg.show();
        boolean bl = finished = this.wizard.getSelectedButton() != null && this.wizard.getSelectedButton() == this.wizard.getFinishButton();
        if (finished) {
            this.pnlChooser.saveCurrentDirLocation();
        }
        return finished;
    }

    private class WizardImpl
    extends WizardInterfaceImpl {
        @Override
        public void showNextPage() {
            ConfigurationImportWizard.this.nextPage();
        }
    }

    private class ConfirmationPage
    extends BasicWizardSubpanelContainer {
        private TextFieldWidget txfConfig;
        private TextFieldWidget txfFile;

        public ConfirmationPage(WizardInterface wizardInterface) {
            super(wizardInterface);
            this.setStepText(2, "Confirm import to Next Startup configuration.");
            JPanel pnl = new JPanel(new GridBagLayout());
            this.setMainContent(pnl);
            LabelWidget lblFile = new LabelWidget(DeployPkgUtils.getString("dmp.import.lblFile"));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(3, 3, 3, 3);
            gbc.anchor = 13;
            pnl.add((Component)lblFile, gbc);
            this.txfFile = DeployPkgUtils.createTextField("dirpath");
            this.txfFile.setEditable(false);
            ++gbc.gridx;
            gbc.anchor = 17;
            pnl.add((Component)this.txfFile, gbc);
            LabelWidget lblConfig = new LabelWidget(DeployPkgUtils.getString("dmp.import.lblConfig"));
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.anchor = 13;
            pnl.add((Component)lblConfig, gbc);
            this.txfConfig = DeployPkgUtils.createTextField("configname");
            this.txfConfig.setEditable(false);
            ++gbc.gridx;
            gbc.anchor = 17;
            pnl.add((Component)this.txfConfig, gbc);
            LabelWidget lblMsg = new LabelWidget(DeployPkgUtils.getString("dmp.import.msg.confirmationpage"));
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.anchor = 10;
            gbc.insets = new Insets(20, 3, 3, 3);
            gbc.gridwidth = 0;
            pnl.add((Component)lblMsg, gbc);
        }

        public void setConfiguration(String theConfigName) {
            this.txfConfig.setText(theConfigName);
        }

        public void setConflicts(boolean theConflictsFlag) {
        }

        public void setFileName(String theFileName) {
            this.txfFile.setText(theFileName);
        }
    }
}

