/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.deploy;

import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.ProductType;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConfigurationManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.ui.views.deploy.model.ConfigurationTreeModel;
import com.metamatrix.console.ui.views.deploy.util.DeployPkgUtils;
import com.metamatrix.toolbox.ui.widget.tree.DefaultTreeCellRenderer;
import com.metamatrix.toolbox.ui.widget.tree.DefaultTreeNode;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;

public final class ConfigurationTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final Icon NEXT_CONFIG_ICON = DeployPkgUtils.getIcon("icon.nextstartup");
    private static final Icon START_CONFIG_ICON = DeployPkgUtils.getIcon("icon.startup");
    private static final Icon HOST_ICON = DeployPkgUtils.getIcon("icon.host");
    private static final Icon PROCESS_ICON = DeployPkgUtils.getIcon("icon.process");
    private static final Icon SERVICE_ICON = DeployPkgUtils.getIcon("icon.service");
    private static final Icon PSC_ICON = DeployPkgUtils.getIcon("icon.psc");
    private static final Icon DEPLOYMENTS_ICON = DeployPkgUtils.getIcon("icon.deployments");
    private static final Icon CONNECTOR_ICON = DeployPkgUtils.getIcon("icon.connector");
    private static final Icon METADATA_SERVER_ICON = DeployPkgUtils.getIcon("icon.mdserver");
    private static final Icon METAMATRIX_SERVER_ICON = DeployPkgUtils.getIcon("icon.mmserver");
    private static final Icon PLATFORM_ICON = DeployPkgUtils.getIcon("icon.platform");
    private static final Icon PSC_HDR_ICON = DeployPkgUtils.getIcon("icon.pschdr");
    private ConnectionInfo connectionInfo;

    public ConfigurationTreeCellRenderer(ConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
        if (value == null) {
            return this;
        }
        super.getTreeCellRendererComponent(tree, value, isSelected, isExpanded, isLeaf, row, hasFocus);
        Object userObj = ((DefaultTreeNode)value).getContent();
        if (userObj instanceof Configuration) {
            if (((DefaultTreeNode)value).getName().equals(ConfigurationTreeModel.DEPLOYMENTS_HDR)) {
                this.setIcon(DEPLOYMENTS_ICON);
            } else if (((DefaultTreeNode)value).getName().equals(ConfigurationTreeModel.PSC_DEFS_HDR)) {
                this.setIcon(PSC_HDR_ICON);
            } else {
                ConfigurationID configId = (ConfigurationID)((Configuration)userObj).getID();
                if (this.getConfigurationManager().isNextStartUpConfig(configId)) {
                    this.setIcon(NEXT_CONFIG_ICON);
                } else if (this.getConfigurationManager().isStartUpConfig(configId)) {
                    this.setIcon(START_CONFIG_ICON);
                }
            }
        } else if (userObj instanceof ServiceComponentDefn) {
            this.setIcon(SERVICE_ICON);
        } else if (userObj instanceof ConfigurationTreeModel.PscWrapper) {
            this.setIcon(PSC_ICON);
        } else if (userObj instanceof VMComponentDefn) {
            this.setIcon(PROCESS_ICON);
        } else if (userObj instanceof ConfigurationTreeModel.HostWrapper) {
            this.setIcon(HOST_ICON);
        } else if (userObj instanceof ProductType) {
            ProductType product = (ProductType)userObj;
            if (product.getName().equals("Platform")) {
                this.setIcon(PLATFORM_ICON);
            } else if (product.getName().equals("Integration Server")) {
                this.setIcon(METAMATRIX_SERVER_ICON);
            } else if (product.getName().equals("Connectors")) {
                this.setIcon(CONNECTOR_ICON);
            }
        } else if (userObj instanceof DeployedComponent) {
            this.setIcon(SERVICE_ICON);
        }
        return this;
    }

    private ConfigurationManager getConfigurationManager() {
        return ModelManager.getConfigurationManager(this.connectionInfo);
    }
}

