/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.deploy;

import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.ProductType;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.xml.XMLConfigurationImportExportUtility;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.properties.ObjectPropertyManager;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.directory.DirectoryEntry;
import com.metamatrix.common.tree.directory.DirectoryEntryFilter;
import com.metamatrix.common.tree.directory.DirectoryEntryView;
import com.metamatrix.common.tree.directory.FileSystemFilter;
import com.metamatrix.common.tree.directory.FileSystemView;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConfigurationManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.RuntimeMgmtManager;
import com.metamatrix.console.notification.RuntimeUpdateNotification;
import com.metamatrix.console.security.UserCapabilities;
import com.metamatrix.console.ui.NotifyOnExitConsole;
import com.metamatrix.console.ui.layout.MenuEntry;
import com.metamatrix.console.ui.layout.WorkspaceController;
import com.metamatrix.console.ui.layout.WorkspacePanel;
import com.metamatrix.console.ui.util.AbstractPanelAction;
import com.metamatrix.console.ui.views.deploy.ConfigSummaryPanel;
import com.metamatrix.console.ui.views.deploy.ConfigurationImportWizard;
import com.metamatrix.console.ui.views.deploy.ConfigurationTreeCellRenderer;
import com.metamatrix.console.ui.views.deploy.ConfirmationPanel;
import com.metamatrix.console.ui.views.deploy.DeployedHostPanel;
import com.metamatrix.console.ui.views.deploy.DeployedProcessPanel;
import com.metamatrix.console.ui.views.deploy.DeployedPscPanel;
import com.metamatrix.console.ui.views.deploy.DeployedServicePanel;
import com.metamatrix.console.ui.views.deploy.DeploymentsSummaryPanel;
import com.metamatrix.console.ui.views.deploy.DetailPanel;
import com.metamatrix.console.ui.views.deploy.ProductDefinitionPanel;
import com.metamatrix.console.ui.views.deploy.PscDefinitionPanel;
import com.metamatrix.console.ui.views.deploy.PscSummaryPanel;
import com.metamatrix.console.ui.views.deploy.ServiceDefinitionPanel;
import com.metamatrix.console.ui.views.deploy.event.ConfigurationModifier;
import com.metamatrix.console.ui.views.deploy.event.ConfigurationTreeModelEvent;
import com.metamatrix.console.ui.views.deploy.event.ConfigurationTreeModelListener;
import com.metamatrix.console.ui.views.deploy.model.ConfigurationTreeModel;
import com.metamatrix.console.ui.views.deploy.util.DeployPkgUtils;
import com.metamatrix.console.util.DialogUtility;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.Refreshable;
import com.metamatrix.console.util.StaticProperties;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.preference.UserPreferences;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.DialogWindow;
import com.metamatrix.toolbox.ui.widget.DirectoryChooserPanel;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.Splitter;
import com.metamatrix.toolbox.ui.widget.TreeWidget;
import com.metamatrix.toolbox.ui.widget.menu.DefaultPopupMenuFactory;
import com.metamatrix.toolbox.ui.widget.tree.DefaultTreeNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public final class DeployMainPanel
extends JPanel
implements ItemListener,
ConfigurationTreeModelListener,
NotifyOnExitConsole,
TreeSelectionListener,
WorkspacePanel,
Refreshable {
    private static int HISTORY_LIMIT = DeployPkgUtils.getInt("dmp.historylimit", 50);
    private JComboBox cbxLocation;
    private TreeWidget tree;
    private JSplitPane splitter;
    private ConfigSummaryPanel pnlConfigSummary;
    private DeployedHostPanel pnlDeployedHost;
    private DeployedProcessPanel pnlDeployedProcess;
    private DeployedPscPanel pnlDeployedPsc;
    private DeployedServicePanel pnlDeployedService;
    private PscSummaryPanel pnlPscSummary;
    private ProductDefinitionPanel pnlProductDefn;
    private PscDefinitionPanel pnlPscDefn;
    private ServiceDefinitionPanel pnlServiceDefn;
    private DeploymentsSummaryPanel pnlDeploymentsSummary;
    private JPanel pnlTreeOpsSizer;
    private JPanel pnlTree;
    private ConfigurationTreeCellRenderer renderer;
    private ConnectionInfo connection;
    private ArrayList actions = new ArrayList();
    private PanelAction actionBack = new PanelAction(0);
    private PanelAction actionNext = new PanelAction(3);
    private PanelAction actionForward = new PanelAction(1);
    private PanelAction actionUp = new PanelAction(2);
    private PanelAction actionClear = new PanelAction(4);
    private PanelAction actionImport = new PanelAction(6);
    private PanelAction actionExport = new PanelAction(7);
    private PanelAction actionBounce = new PanelAction(9);
    private PanelAction actionSynch = new PanelAction(10);
    private List treeActions;
    private HashMap navNodeMap = new HashMap();
    private HashMap nodeNavMap = new HashMap();
    private DetailPanel pnlDetail;
    private boolean eventProcessing = false;
    private ConfigurationTreeModel treeModel;
    private boolean editMode = true;
    private DefaultTreeNode saveNode;
    private ConfigurationID configId;
    private ObjectPropertyManager dflts;
    private boolean programmaticTreeSelection = false;
    private TreePath currentTreePath = null;

    public DeployMainPanel(ConnectionInfo conn) throws ExternalException {
        this.connection = conn;
        if (this.dflts == null) {
            this.dflts = new ObjectPropertyManager("com/metamatrix/console/ui/views/runtime/data/ui");
        }
        this.setLayout(new BorderLayout(3, 3));
        this.setBorder(DeployPkgUtils.EMPTY_BORDER);
        this.construct();
        try {
            this.editMode = UserCapabilities.getInstance().canUpdateConfiguration(this.connection);
            if (!this.editMode) {
                this.setActionsDisabled();
            }
        }
        catch (Exception theException) {
            throw new ExternalException("DeployMainPanel:init", theException);
        }
    }

    private void back() {
        this.cbxLocation.setSelectedIndex(this.cbxLocation.getSelectedIndex() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bounce() throws ExternalException {
        boolean continuing = this.switchingPanels();
        if (continuing) {
            ConfirmationPanel pnlConfirm = new ConfirmationPanel("dlg.bounceserver.msg");
            DialogWindow.show(this, this.dflts.getString("dlg.bounceserver.title"), pnlConfirm);
            if (pnlConfirm.isConfirmed()) {
                StaticUtilities.startWait(this);
                try {
                    this.getRuntimeMgmtManager().bounceServer();
                }
                finally {
                    StaticUtilities.endWait(this);
                }
            }
        }
    }

    private void clearHistory() {
        Object currentItem = this.cbxLocation.getSelectedItem();
        this.cbxLocation.removeAllItems();
        this.cbxLocation.addItem(currentItem);
        this.actionClear.setEnabled(false);
    }

    private void clearTreeActionsPanel() {
        if (this.treeActions != null) {
            int size = this.treeActions.size();
            for (int i = 0; i < size; ++i) {
                AbstractPanelAction action = (AbstractPanelAction)this.treeActions.get(i);
                action.removeComponent((JComponent)this.pnlTreeOpsSizer.getComponent(i));
            }
            this.pnlTreeOpsSizer.removeAll();
            this.treeActions = null;
        }
    }

    private void construct() throws ExternalException {
        this.actions.add(new MenuEntry("action", this.actionClear));
        this.actions.add(MenuEntry.DEFAULT_SEPARATOR);
        this.actions.add(new MenuEntry("action", this.actionImport));
        this.actions.add(new MenuEntry("action", this.actionExport));
        this.actions.add(MenuEntry.DEFAULT_SEPARATOR);
        this.actions.add(new MenuEntry("action", this.actionBounce));
        this.actions.add(new MenuEntry("action", this.actionSynch));
        this.actions.add(MenuEntry.DEFAULT_SEPARATOR);
        JPanel pnlNavigation = new JPanel(new GridBagLayout());
        pnlNavigation.setBorder(new CompoundBorder(new EtchedBorder(), DeployPkgUtils.EMPTY_BORDER));
        this.add((Component)pnlNavigation, "North");
        LabelWidget lblLocation = new LabelWidget(DeployPkgUtils.getString("dmp.lblLocation"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 2);
        pnlNavigation.add((Component)lblLocation, gbc);
        this.cbxLocation = new JComboBox();
        this.cbxLocation.addItemListener(this);
        this.cbxLocation.setBackground(Color.white);
        Font font = this.cbxLocation.getFont();
        String fontName = DeployPkgUtils.getString("dmp.nav.font.name", true);
        this.cbxLocation.setFont(new Font(fontName == null ? font.getName() : fontName, 0, font.getSize() - DeployPkgUtils.getInt("dmp.nav.font.size", 0)));
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        pnlNavigation.add((Component)this.cbxLocation, gbc);
        ButtonWidget btnUp = new ButtonWidget();
        this.setup("action", btnUp, this.actionUp);
        btnUp.setPreferredSize(new Dimension(btnUp.getPreferredSize().width, this.cbxLocation.getPreferredSize().height));
        btnUp.setMargin(new Insets(2, 2, 2, 2));
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        pnlNavigation.add((Component)btnUp, gbc);
        ButtonWidget btnDown = new ButtonWidget();
        this.setup("action", btnDown, this.actionNext);
        btnDown.setPreferredSize(new Dimension(btnUp.getPreferredSize().width, this.cbxLocation.getPreferredSize().height));
        btnDown.setMargin(new Insets(2, 2, 2, 2));
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 0;
        pnlNavigation.add((Component)btnDown, gbc);
        ButtonWidget btnBack = new ButtonWidget();
        this.setup("action", btnBack, this.actionBack);
        btnBack.setPreferredSize(new Dimension(btnUp.getPreferredSize().width, this.cbxLocation.getPreferredSize().height));
        btnBack.setMargin(new Insets(2, 2, 2, 2));
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        pnlNavigation.add((Component)btnBack, gbc);
        ButtonWidget btnForward = new ButtonWidget();
        this.setup("action", btnForward, this.actionForward);
        btnForward.setPreferredSize(new Dimension(btnUp.getPreferredSize().width, this.cbxLocation.getPreferredSize().height));
        btnForward.setMargin(new Insets(2, 2, 2, 2));
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        pnlNavigation.add((Component)btnForward, gbc);
        this.splitter = new Splitter(){
            boolean init = false;

            @Override
            public void paint(Graphics theGraphics) {
                super.paint(theGraphics);
                if (!this.init) {
                    Double temp = (Double)DeployPkgUtils.getObject("dmp.splitter.pos");
                    double initPos = temp == null ? 0.35 : temp;
                    this.init = true;
                    int treeWidth = ((DeployMainPanel)DeployMainPanel.this).pnlTree.getPreferredSize().width;
                    int width = this.getSize().width;
                    if ((double)treeWidth / (double)width < initPos) {
                        DeployMainPanel.this.splitter.setDividerLocation(treeWidth);
                    } else {
                        DeployMainPanel.this.splitter.setDividerLocation(initPos);
                    }
                }
            }
        };
        this.splitter.setOneTouchExpandable(true);
        this.add((Component)this.splitter, "Center");
        this.pnlTree = new JPanel(new GridBagLayout());
        this.pnlTree.setMinimumSize(this.pnlTree.getMinimumSize());
        this.splitter.setLeftComponent(this.pnlTree);
        this.tree = new TreeWidget(){

            @Override
            public String getToolTipText(MouseEvent theEvent) {
                TreePath path = DeployMainPanel.this.tree.getPathForLocation(theEvent.getX(), theEvent.getY());
                if (path == null) {
                    return null;
                }
                DefaultTreeNode node = (DefaultTreeNode)path.getLastPathComponent();
                return DeployMainPanel.this.getLocationObject(node).toString();
            }
        };
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setVisibleRowCount(10);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.treeModel = new ConfigurationTreeModel();
        this.tree.setModel(this.treeModel);
        this.renderer = new ConfigurationTreeCellRenderer(this.connection);
        this.tree.setCellRenderer(this.renderer);
        this.tree.getSelectionModel().addTreeSelectionListener(this);
        this.tree.setPopupMenuFactory(new TreeMenuFactory(this.tree, this));
        this.tree.registerKeyboardAction(this.actionBack, (String)this.actionBack.getValue("Name"), KeyStroke.getKeyStroke(37, 0), 0);
        this.tree.registerKeyboardAction(this.actionForward, (String)this.actionForward.getValue("Name"), KeyStroke.getKeyStroke(39, 0), 0);
        this.tree.registerKeyboardAction(this.actionNext, (String)this.actionNext.getValue("Name"), KeyStroke.getKeyStroke(40, 0), 0);
        this.tree.registerKeyboardAction(this.actionUp, (String)this.actionUp.getValue("Name"), KeyStroke.getKeyStroke(38, 0), 0);
        JScrollPane spnTree = new JScrollPane(this.tree);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.pnlTree.add((Component)spnTree, gbc);
        JPanel pnlTreeOps = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.pnlTree.add((Component)pnlTreeOps, gbc);
        this.pnlTreeOpsSizer = new JPanel(new GridLayout(1, 0));
        pnlTreeOps.add(this.pnlTreeOpsSizer);
        this.getConfigurationManager().addConfigurationChangeListener(this.treeModel);
        this.getConfigurationManager().refreshImpl();
        this.setInitialTreeState(true);
        this.treeModel.addConfigurationTreeModelListener(this);
    }

    private void deleteFromHistory(DefaultTreeNode theNode) {
        Object navigation;
        int i;
        this.eventProcessing = true;
        List kids = theNode.getChildren();
        if (kids != null) {
            int size = kids.size();
            for (i = 0; i < size; ++i) {
                this.deleteFromHistory((DefaultTreeNode)kids.get(i));
            }
        }
        if ((navigation = this.nodeNavMap.get(theNode)) != null) {
            for (i = this.cbxLocation.getItemCount() - 1; i >= 0; --i) {
                Object item = this.cbxLocation.getItemAt(i);
                if (!item.toString().equals(navigation.toString())) continue;
                this.cbxLocation.removeItemAt(i);
                if (i - 1 >= 0 && i <= this.cbxLocation.getItemCount() - 1 && this.cbxLocation.getItemAt(i).toString().equals(this.cbxLocation.getItemAt(i - 1).toString())) {
                    this.cbxLocation.removeItemAt(i);
                }
                this.navNodeMap.remove(item);
                this.nodeNavMap.remove(theNode);
            }
        }
        this.eventProcessing = false;
    }

    private void exportConfig() throws ExternalException {
        String[] extensions = (String[])DeployPkgUtils.getObject("dmp.importexport.extensions");
        FileSystemView view = new FileSystemView();
        String dirTxt = (String)UserPreferences.getInstance().getValue("metamatrix.console.directory");
        if (dirTxt != null) {
            try {
                view.setHome((TreeNode)view.lookup(dirTxt));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        FileSystemFilter[] filters = null;
        if (extensions != null) {
            FileSystemFilter filter = new FileSystemFilter(view, extensions, DeployPkgUtils.getString("dmp.importexport.description"));
            filters = new FileSystemFilter[]{filter};
        }
        DirectoryChooserPanel pnlChooser = filters == null ? new DirectoryChooserPanel((DirectoryEntryView)view, 1) : new DirectoryChooserPanel((DirectoryEntryView)view, 1, (DirectoryEntryFilter[])filters);
        pnlChooser.setAcceptButtonLabel(DeployPkgUtils.getString("dmp.export.open"));
        pnlChooser.setShowPassThruFilter(false);
        DialogWindow.show(this, DeployPkgUtils.getString("dmp.export.title", new Object[]{this.configId}), pnlChooser);
        if (pnlChooser.getSelectedButton() == pnlChooser.getAcceptButton()) {
            DirectoryEntry result = (DirectoryEntry)pnlChooser.getSelectedTreeNode();
            String filename = result.getNamespace();
            int index = filename.lastIndexOf(File.separatorChar);
            String path = filename.substring(0, index);
            UserPreferences.getInstance().setValue("metamatrix.console.directory", path);
            UserPreferences.getInstance().saveChanges();
            try {
                Collection exportObjs = this.getConfigurationManager().getConfigObjects(this.configId);
                FileOutputStream fileOutput = new FileOutputStream(filename);
                XMLConfigurationImportExportUtility xmlUtil = new XMLConfigurationImportExportUtility();
                String userName = UserCapabilities.getLoggedInUser(this.connection).getName();
                String version = StaticProperties.getVersion();
                Properties props = new Properties();
                props.put("ApplicationCreatedBy", DeployPkgUtils.getString("dmp.console.name"));
                props.put("ApplicationVersion", version);
                props.put("UserCreatedBy", userName);
                xmlUtil.exportConfiguration((OutputStream)fileOutput, exportObjs, props);
            }
            catch (Exception theException) {
                theException.printStackTrace();
                String detail = DeployPkgUtils.getString("dmp.msg.exporterrordetail", new Object[]{this.configId, filename});
                throw new ExternalException(detail + " " + theException.getMessage(), theException);
            }
        }
    }

    @Override
    public boolean finishUp() {
        return this.switchingPanels();
    }

    private String formatNavigationTip(String theLocation) {
        return theLocation.substring(theLocation.lastIndexOf(File.separatorChar) + 1);
    }

    private void forward() {
        this.cbxLocation.setSelectedIndex(this.cbxLocation.getSelectedIndex() + 1);
    }

    private Object[] getAncestors(TreePath thePath) {
        TreePath path = thePath.getParentPath();
        ArrayList<Object> ancestors = new ArrayList<Object>();
        int count = path.getPathCount();
        if (count != 0) {
            for (int i = count - 1; i >= 0; --i) {
                DefaultTreeNode node = (DefaultTreeNode)path.getPathComponent(i);
                if (this.treeModel.isHeaderNode(node) || node == this.treeModel.getRoot()) continue;
                Object content = node.getContent();
                if (content instanceof ConfigurationTreeModel.PscWrapper) {
                    ancestors.add(((ConfigurationTreeModel.PscWrapper)content).getPsc());
                    continue;
                }
                if (content instanceof ConfigurationTreeModel.HostWrapper) {
                    ancestors.add(((ConfigurationTreeModel.HostWrapper)content).getHost());
                    continue;
                }
                ancestors.add(content);
            }
        }
        return ancestors.toArray();
    }

    private ConfigurationID getConfigId(DefaultTreeNode theNode) {
        if (theNode == null) {
            throw new IllegalStateException(DeployPkgUtils.getString("dmp.msg.confignotfound"));
        }
        Object domainObj = theNode.getContent();
        if (!(domainObj instanceof Configuration)) {
            return this.getConfigId(theNode.getParent());
        }
        ConfigurationID id = (ConfigurationID)((Configuration)domainObj).getID();
        return id;
    }

    private DefaultTreeNode getDownNode() {
        DefaultTreeNode node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        DefaultTreeNode parent = node.getParent();
        int numKids = parent.getChildCount();
        int index = parent.getChildIndex(node);
        int downIndex = index + 1 == numKids ? 0 : index + 1;
        return parent.getChild(downIndex);
    }

    private Object getLocationObject(DefaultTreeNode theNode) {
        if (theNode == null) {
            return "";
        }
        ArrayList<String> path = new ArrayList<String>();
        DefaultTreeNode node = theNode;
        while (node.getParent() != null) {
            path.add(node.getName());
            node = node.getParent();
        }
        StringBuffer location = new StringBuffer(File.separatorChar);
        int size = path.size();
        for (int i = size - 1; i >= 0; --i) {
            location.append(File.separatorChar).append(path.get(i));
        }
        return location;
    }

    private DefaultTreeNode getSelectedNode() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        return (DefaultTreeNode)path.getLastPathComponent();
    }

    @Override
    public String getTitle() {
        return DeployPkgUtils.getString("dmp.title");
    }

    @Override
    public ConnectionInfo getConnection() {
        return this.connection;
    }

    public RuntimeMgmtManager getRuntimeMgmtManager() {
        return ModelManager.getRuntimeMgmtManager(this.getConnection());
    }

    public ConfigurationManager getConfigurationManager() {
        return ModelManager.getConfigurationManager(this.getConnection());
    }

    private List getTreeActions() {
        return this.treeActions;
    }

    @Override
    public void receiveUpdateNotification(RuntimeUpdateNotification notification) {
    }

    @Override
    public boolean havePendingChanges() {
        boolean pending = false;
        if (this.pnlDetail instanceof ConfigurationModifier) {
            pending = !((ConfigurationModifier)((Object)this.pnlDetail)).isPersisted();
        }
        return pending;
    }

    private void importConfig() throws ExternalException {
        ConfigurationImportWizard wizard;
        boolean continuing = this.switchingPanels();
        if (continuing && (wizard = new ConfigurationImportWizard(this.connection)).run()) {
            Collection configObjs = wizard.getImportedObjects();
            this.getConfigurationManager().commitImportedObjects(configObjs);
            this.refresh();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent theEvent) {
        if (theEvent.getStateChange() == 1 && !this.eventProcessing) {
            this.eventProcessing = true;
            Object item = theEvent.getItem();
            DefaultTreeNode node = (DefaultTreeNode)this.navNodeMap.get(item);
            this.selectNode(node);
            this.updateNavigationState();
            this.eventProcessing = false;
        }
    }

    private void next() {
        this.selectNode(this.getDownNode());
    }

    @Override
    public void refresh() {
        boolean continuing = this.switchingPanels();
        if (continuing) {
            this.eventProcessing = true;
            this.navNodeMap.clear();
            this.nodeNavMap.clear();
            this.pnlDetail = null;
            boolean deploymentHdr = false;
            boolean pscDefHdr = false;
            Object userObj = null;
            if (this.saveNode != null) {
                userObj = this.saveNode.getContent();
            }
            if (this.treeModel.isDeploymentsHeaderNode(this.saveNode)) {
                deploymentHdr = true;
            } else if (this.treeModel.isPscDefinitionsHeaderNode(this.saveNode)) {
                pscDefHdr = true;
            }
            DefaultTreeNode tempSaveNode = this.saveNode;
            this.saveNode = null;
            this.clearTreeActionsPanel();
            this.tree.getSelectionModel().removeTreeSelectionListener(this);
            this.treeModel.removeConfigurationTreeModelListener(this);
            this.cbxLocation.removeItemListener(this);
            this.cbxLocation.removeAllItems();
            this.treeModel.refresh();
            ConfigurationManager configManager = this.getConfigurationManager();
            if (configManager.getListeners().size() == 0) {
                configManager.addConfigurationChangeListener(this.treeModel);
            }
            try {
                configManager.refreshImpl();
            }
            catch (ExternalException theException) {
                ExceptionUtility.showMessage(DeployPkgUtils.getString("dmp.msg.refresherror"), "" + theException.getMessage(), (Throwable)((Object)theException));
                LogManager.logError((String)"PSC-DEPLOYMENT", (Throwable)((Object)theException), (String)DeployPkgUtils.getString("dmp.msg.refresherror"));
            }
            if (this.saveNode == null) {
                this.saveNode = tempSaveNode;
            }
            this.tree.getSelectionModel().addTreeSelectionListener(this);
            this.treeModel.addConfigurationTreeModelListener(this);
            this.cbxLocation.addItemListener(this);
            this.setInitialTreeState(false);
            DefaultTreeNode node = null;
            node = deploymentHdr ? this.treeModel.getDeploymentsHeaderNode((Configuration)userObj) : (pscDefHdr ? this.treeModel.getPscDefinitionsHeaderNode((Configuration)userObj) : this.treeModel.getUserObjectNode(userObj));
            this.eventProcessing = false;
            if (node == null) {
                if (this.tree.getRowCount() > 0) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            DeployMainPanel.this.tree.setSelectionRow(0);
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                } else {
                    this.selectNode(node);
                }
            } else {
                this.selectNode(node);
            }
        }
    }

    @Override
    public List resume() {
        if (this.getConfigurationManager().isRefreshNeeded()) {
            this.refresh();
        }
        if (this.pnlDetail == null) {
            return null;
        }
        List clone = (List)this.actions.clone();
        List detailActions = this.pnlDetail.getActions();
        if (!detailActions.isEmpty()) {
            clone.add(MenuEntry.DEFAULT_SEPARATOR);
            clone.addAll(detailActions);
        }
        return clone;
    }

    private void selectNode(final DefaultTreeNode theNode) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ArrayList<DefaultTreeNode> pathNodes = new ArrayList<DefaultTreeNode>();
                pathNodes.add(theNode);
                for (DefaultTreeNode parent = theNode.getParent(); parent != null; parent = parent.getParent()) {
                    pathNodes.add(parent);
                }
                Collections.reverse(pathNodes);
                TreePath path = new TreePath(pathNodes.toArray());
                DeployMainPanel.this.tree.setSelectionPath(path);
                DeployMainPanel.this.tree.scrollRowToVisible(DeployMainPanel.this.tree.getRowForPath(path));
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void setActionsDisabled() {
        this.actionImport.setEnabled(false);
        this.actionBounce.setEnabled(false);
        this.actionSynch.setEnabled(false);
    }

    private void setInitialTreeState(final boolean theSelectFirstNode) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DefaultTreeNode root = (DefaultTreeNode)DeployMainPanel.this.treeModel.getRoot();
                int numOtherKids = root.getChildren().size() - 1;
                for (int row = 0; row < DeployMainPanel.this.tree.getRowCount() - numOtherKids; ++row) {
                    DeployMainPanel.this.tree.expandRow(row);
                }
                if (theSelectFirstNode && DeployMainPanel.this.tree.getRowCount() > 0) {
                    DeployMainPanel.this.tree.setSelectionRow(0);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void setup(String theMenuEntryType, AbstractButton theButton, AbstractPanelAction theAction) {
        theAction.addComponent(theButton);
        this.actions.add(new MenuEntry(theMenuEntryType, theAction));
    }

    private boolean switchingPanels() {
        boolean switching = true;
        if (this.havePendingChanges()) {
            if (this.pnlDetail instanceof NotifyOnExitConsole) {
                switching = ((NotifyOnExitConsole)((Object)this.pnlDetail)).finishUp();
            } else if (this.pnlDetail instanceof DeployedHostPanel || this.pnlDetail instanceof DeployedProcessPanel) {
                String panelObjectString;
                String msg;
                if (this.pnlDetail instanceof DeployedHostPanel) {
                    msg = "Save changes to deployed host " + ((DeployedHostPanel)this.pnlDetail).getHostName() + "?";
                    panelObjectString = "deployed host";
                } else {
                    msg = "Save changes to deployed process " + ((DeployedProcessPanel)this.pnlDetail).getProcessName() + "?";
                    panelObjectString = "deployed process";
                }
                int response = DialogUtility.showPendingChangesDialog(msg, this.getConnection().getURL(), this.getConnection().getUser());
                switch (response) {
                    case 0: {
                        try {
                            ((ConfigurationModifier)((Object)this.pnlDetail)).persist();
                        }
                        catch (ExternalException ex) {
                            String errMsg = "Error saving changes to " + panelObjectString;
                            LogManager.logError((String)"PSC-DEPLOYMENT", (Throwable)((Object)ex), (String)errMsg);
                            ExceptionUtility.showMessage(errMsg, (Throwable)((Object)ex));
                        }
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        switching = false;
                    }
                }
            } else {
                ConfirmationPanel pnlConfirm = new ConfirmationPanel("dmp.msg.confirmsave", "icon.warning", "dmp.btnOk", "dmp.btnCancel");
                try {
                    DialogWindow.show(this, DeployPkgUtils.getString("dmp.confirmsavedlg.title"), pnlConfirm);
                }
                catch (Exception ex) {
                    ExceptionUtility.showMessage(ex.getMessage(), ex);
                    return true;
                }
                if (pnlConfirm.isConfirmed()) {
                    try {
                        ((ConfigurationModifier)((Object)this.pnlDetail)).persist();
                    }
                    catch (ExternalException theException) {
                        ExceptionUtility.showMessage(DeployPkgUtils.getString("msg.persistproblem"), "" + theException.getMessage(), (Throwable)((Object)theException));
                        LogManager.logError((String)"PSC-DEPLOYMENT", (Throwable)((Object)theException), (String)DeployPkgUtils.getString("msg.persistproblem"));
                    }
                } else {
                    ((ConfigurationModifier)((Object)this.pnlDetail)).reset();
                }
            }
        }
        return switching;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synch() throws ExternalException {
        ConfirmationPanel pnlConfirm = new ConfirmationPanel("dlg.synch.msg");
        DialogWindow.show(this, this.dflts.getString("dlg.synch.title"), pnlConfirm);
        this.paintImmediately(this.getBounds());
        if (pnlConfirm.isConfirmed()) {
            try {
                StaticUtilities.startWait(this);
                this.getRuntimeMgmtManager().synchronizeServer();
            }
            finally {
                StaticUtilities.endWait(this);
            }
        }
    }

    @Override
    public void treeNodesChanged(ConfigurationTreeModelEvent theEvent) {
        if (theEvent.isNew()) {
            if (theEvent.isHostChange()) {
                Configuration config = theEvent.getConfiguration();
                if (config.getID().equals((Object)this.pnlDetail.getConfigId())) {
                    this.selectNode(theEvent.getSourceNode());
                }
            } else if (!(this.pnlDetail instanceof DeployedProcessPanel) && !theEvent.isServiceDefinitionChange()) {
                this.selectNode(theEvent.getSourceNode());
            }
        } else if (theEvent.isDeleted()) {
            this.deleteFromHistory(theEvent.getSourceNode());
            if (theEvent.isHostChange()) {
                Configuration config = theEvent.getConfiguration();
                if (config.getID().equals((Object)this.pnlDetail.getConfigId())) {
                    this.selectNode(this.treeModel.getDeploymentsHeaderNode(config));
                }
            } else if (!(this.pnlDetail instanceof DeployedProcessPanel) || this.pnlDetail instanceof DeployedProcessPanel && theEvent.isProcessChange()) {
                this.selectNode(theEvent.getSourceNodeParent());
            }
        } else if (!theEvent.isModified() && theEvent.isRefreshStart()) {
            this.refresh();
        }
    }

    private void up() {
        DefaultTreeNode child = this.getSelectedNode();
        this.selectNode(child.getParent());
    }

    private void updateNavigationState() {
        String tip;
        String tip2;
        int index = this.cbxLocation.getSelectedIndex();
        int lastIndex = this.cbxLocation.getItemCount() - 1;
        if (index - 1 >= 0) {
            tip2 = this.formatNavigationTip(this.cbxLocation.getItemAt(index - 1).toString());
            this.actionBack.putValue("ShortDescription", DeployPkgUtils.getString("dmp.actionBack.tip") + tip2);
            if (!this.actionBack.isEnabled()) {
                this.actionBack.setEnabled(true);
            }
        } else {
            this.actionBack.putValue("ShortDescription", null);
            if (this.actionBack.isEnabled()) {
                this.actionBack.setEnabled(false);
            }
        }
        if (index + 1 <= lastIndex) {
            tip2 = this.formatNavigationTip(this.cbxLocation.getItemAt(index + 1).toString());
            this.actionForward.putValue("ShortDescription", DeployPkgUtils.getString("dmp.actionForward.tip") + tip2);
            if (!this.actionForward.isEnabled()) {
                this.actionForward.setEnabled(true);
            }
        } else {
            this.actionForward.putValue("ShortDescription", null);
            if (this.actionForward.isEnabled()) {
                this.actionForward.setEnabled(false);
            }
        }
        DefaultTreeNode child = this.getSelectedNode();
        DefaultTreeNode parent = child.getParent();
        if (parent == this.tree.getModel().getRoot()) {
            this.actionUp.putValue("ShortDescription", null);
            if (this.actionUp.isEnabled()) {
                this.actionUp.setEnabled(false);
            }
        } else {
            tip = this.formatNavigationTip(this.getLocationObject(parent).toString());
            this.actionUp.putValue("ShortDescription", DeployPkgUtils.getString("dmp.actionUp.tip") + tip);
            if (!this.actionUp.isEnabled()) {
                this.actionUp.setEnabled(true);
            }
        }
        if (parent.getChildCount() > 1) {
            tip = this.formatNavigationTip(this.getLocationObject(this.getDownNode()).toString());
            this.actionNext.putValue("ShortDescription", DeployPkgUtils.getString("dmp.actionNext.tip") + tip);
            if (!this.actionNext.isEnabled()) {
                this.actionNext.setEnabled(true);
            }
        } else {
            this.actionNext.putValue("ShortDescription", null);
            if (this.actionNext.isEnabled()) {
                this.actionNext.setEnabled(false);
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent theEvent) {
        if (!this.programmaticTreeSelection) {
            DetailPanel pnl = null;
            TreePath path = theEvent.getNewLeadSelectionPath();
            if (this.tree.isSelectionEmpty()) {
                if (this.treeModel.contains(this.saveNode)) {
                    this.eventProcessing = true;
                    this.selectNode(this.saveNode);
                    this.eventProcessing = false;
                }
            } else {
                DefaultTreeNode node = (DefaultTreeNode)path.getLastPathComponent();
                if (!this.eventProcessing) {
                    this.eventProcessing = true;
                    Object location = this.getLocationObject(node);
                    this.navNodeMap.put(location, node);
                    this.nodeNavMap.put(node, location);
                    this.cbxLocation.addItem(location);
                    if (this.cbxLocation.getItemCount() > 1) {
                        this.actionClear.setEnabled(true);
                    }
                    this.cbxLocation.setSelectedIndex(this.cbxLocation.getItemCount() - 1);
                    if (this.cbxLocation.getItemCount() > HISTORY_LIMIT) {
                        this.cbxLocation.removeItemAt(0);
                    }
                    this.updateNavigationState();
                    this.eventProcessing = false;
                }
                boolean switching = false;
                try {
                    switching = this.switchingPanels();
                    if (switching) {
                        this.configId = this.getConfigId(node);
                        Object domainObj = node.getContent();
                        if (this.treeModel.isDeploymentsHeaderNode(node)) {
                            if (this.pnlDeploymentsSummary == null) {
                                this.pnlDeploymentsSummary = new DeploymentsSummaryPanel(this.configId, this.connection);
                            }
                            pnl = this.pnlDeploymentsSummary;
                        } else if (this.treeModel.isPscDefinitionsHeaderNode(node)) {
                            if (this.pnlPscSummary == null) {
                                this.pnlPscSummary = new PscSummaryPanel(this.configId, this.connection);
                            }
                            pnl = this.pnlPscSummary;
                        } else if (domainObj instanceof ConfigurationTreeModel.PscWrapper) {
                            ConfigurationTreeModel.PscWrapper wrapper = (ConfigurationTreeModel.PscWrapper)domainObj;
                            if (wrapper.isDefinition()) {
                                if (this.pnlPscDefn == null) {
                                    this.pnlPscDefn = new PscDefinitionPanel(this.configId, this.connection, this);
                                }
                                pnl = this.pnlPscDefn;
                            } else {
                                if (this.pnlDeployedPsc == null) {
                                    this.pnlDeployedPsc = new DeployedPscPanel(this.connection, this.configId);
                                }
                                pnl = this.pnlDeployedPsc;
                            }
                            domainObj = wrapper.getPsc();
                        } else if (domainObj instanceof ServiceComponentDefn) {
                            if (this.pnlServiceDefn == null) {
                                this.pnlServiceDefn = new ServiceDefinitionPanel(true, null, this.configId, this.connection);
                            }
                            pnl = this.pnlServiceDefn;
                        } else if (domainObj instanceof Configuration) {
                            if (this.pnlConfigSummary == null) {
                                this.pnlConfigSummary = new ConfigSummaryPanel(this.configId, this.connection);
                            }
                            pnl = this.pnlConfigSummary;
                        } else if (domainObj instanceof ConfigurationTreeModel.HostWrapper) {
                            if (this.pnlDeployedHost == null) {
                                this.pnlDeployedHost = new DeployedHostPanel(this, this.configId, this.connection);
                            }
                            pnl = this.pnlDeployedHost;
                            domainObj = ((ConfigurationTreeModel.HostWrapper)domainObj).getHost();
                        } else if (domainObj instanceof ProductType) {
                            if (this.pnlProductDefn == null) {
                                this.pnlProductDefn = new ProductDefinitionPanel(this.configId, this.connection);
                            }
                            pnl = this.pnlProductDefn;
                        } else if (domainObj instanceof VMComponentDefn) {
                            if (this.pnlDeployedProcess == null) {
                                this.pnlDeployedProcess = new DeployedProcessPanel(this.configId, this.connection);
                            }
                            pnl = this.pnlDeployedProcess;
                        } else if (domainObj instanceof DeployedComponent) {
                            if (this.pnlDeployedService == null) {
                                this.pnlDeployedService = new DeployedServicePanel(this.configId, this.connection);
                            }
                            pnl = this.pnlDeployedService;
                        } else {
                            String msg = DeployPkgUtils.getString("dmp.msg.unknowntype") + domainObj.getClass();
                            IllegalStateException ise = new IllegalStateException(msg);
                            ExceptionUtility.showMessage(DeployPkgUtils.getString("msg.configmgrproblem", new Object[]{this.getClass(), "valueChanged"}), "" + msg, ise);
                            LogManager.logError((String)"PSC-DEPLOYMENT", (Throwable)ise, (String)"valueChanged");
                            return;
                        }
                        if (!pnl.getConfigId().equals((Object)this.configId)) {
                            pnl.setConfigId(this.configId);
                        }
                        pnl.setDomainObject(domainObj, this.getAncestors(path));
                        if (pnl != this.pnlDetail) {
                            this.clearTreeActionsPanel();
                            this.treeActions = pnl.getTreeActions();
                            if (this.treeActions != null) {
                                int size = this.treeActions.size();
                                for (int i = 0; i < size; ++i) {
                                    ButtonWidget btn = new ButtonWidget();
                                    AbstractPanelAction action = (AbstractPanelAction)this.treeActions.get(i);
                                    action.addComponent(btn);
                                    this.pnlTreeOpsSizer.add(btn);
                                }
                            }
                            this.pnlDetail = pnl;
                            WorkspaceController.getInstance().updateActions(this);
                            this.splitter.setRightComponent(this.pnlDetail);
                        }
                        this.saveNode = node;
                        boolean enable = this.editMode && this.getConfigurationManager().isEditable(this.configId);
                        pnl.setEnabled(enable);
                        this.currentTreePath = theEvent.getNewLeadSelectionPath();
                    } else {
                        this.programmaticTreeSelection = true;
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                DeployMainPanel.this.tree.setSelectionPath(DeployMainPanel.this.currentTreePath);
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                        this.programmaticTreeSelection = false;
                    }
                }
                catch (ExternalException theException) {
                    ExceptionUtility.showMessage(DeployPkgUtils.getString("msg.configmgrproblem", new Object[]{this.getClass(), "valueChanged"}), "" + theException.getMessage(), (Throwable)((Object)theException));
                    LogManager.logError((String)"PSC-DEPLOYMENT", (Throwable)((Object)theException), (String)"valueChanged");
                }
            }
        }
    }

    private static class TreeMenuFactory
    extends DefaultPopupMenuFactory {
        JPopupMenu pop = new JPopupMenu();
        DeployMainPanel pnl;

        public TreeMenuFactory(TreeWidget theTree, DeployMainPanel thePanel) {
            this.pnl = thePanel;
        }

        @Override
        protected JPopupMenu createTreePopupMenu(TreeWidget tree) {
            return this.pop;
        }

        @Override
        public JPopupMenu getPopupMenu(Component context) {
            if (context instanceof TreeWidget) {
                this.pop.removeAll();
                List actions = this.pnl.getTreeActions();
                if (actions != null) {
                    int size = actions.size();
                    int i = 0;
                    while (i < size) {
                        this.pop.add((Action)actions.get(i++));
                    }
                    return this.pop;
                }
            }
            return null;
        }
    }

    private class PanelAction
    extends AbstractPanelAction {
        public static final int BACK = 0;
        public static final int FORWARD = 1;
        public static final int UP = 2;
        public static final int NEXT = 3;
        public static final int CLEAR = 4;
        public static final int IMPORT = 6;
        public static final int EXPORT = 7;
        public static final int BOUNCE = 9;
        public static final int SYNCH = 10;

        public PanelAction(int theType) {
            super(theType);
            String iconId = null;
            if (DeployMainPanel.this.dflts == null) {
                DeployMainPanel.this.dflts = new ObjectPropertyManager("com/metamatrix/console/ui/views/runtime/data/ui");
            }
            if (theType == 0) {
                iconId = "icon.back";
                this.putValue("menu.item.name", DeployPkgUtils.getString("dmp.actionBack.menu"));
                this.setMnemonic(DeployPkgUtils.getMnemonic("dmp.actionBack.mnemonic"));
            } else if (theType == 1) {
                iconId = "icon.forward";
                this.putValue("menu.item.name", DeployPkgUtils.getString("dmp.actionForward.menu"));
                this.setMnemonic(DeployPkgUtils.getMnemonic("dmp.actionForward.mnemonic"));
            } else if (theType == 2) {
                iconId = "icon.up";
                this.putValue("menu.item.name", DeployPkgUtils.getString("dmp.actionUp.menu"));
            } else if (theType == 3) {
                iconId = "icon.next";
                this.putValue("menu.item.name", DeployPkgUtils.getString("dmp.actionNext.menu"));
            } else if (theType == 4) {
                iconId = "icon.clear";
                this.putValue("ShortDescription", DeployPkgUtils.getString("dmp.actionClear.tip"));
                this.putValue("menu.item.name", DeployPkgUtils.getString("dmp.actionClear.menu"));
                this.setEnabled(false);
            } else if (theType == 6) {
                iconId = "icon.import";
                this.putValue("ShortDescription", DeployPkgUtils.getString("dmp.actionImport.tip"));
                this.putValue("menu.item.name", DeployPkgUtils.getString("dmp.actionImport.menu"));
            } else if (theType == 7) {
                iconId = "icon.export";
                this.putValue("ShortDescription", DeployPkgUtils.getString("dmp.actionExport.tip"));
                this.putValue("menu.item.name", DeployPkgUtils.getString("dmp.actionExport.menu"));
            } else if (theType == 9) {
                iconId = "icon.blank";
                this.putValue("ShortDescription", DeployMainPanel.this.dflts.getString("actionBounce.tip"));
                this.putValue("menu.item.name", DeployMainPanel.this.dflts.getString("actionBounce.menu"));
            } else if (theType == 10) {
                iconId = "icon.blank";
                this.putValue("ShortDescription", DeployMainPanel.this.dflts.getString("actionSynch.tip"));
                this.putValue("menu.item.name", DeployMainPanel.this.dflts.getString("actionSynch.menu"));
            } else {
                throw new IllegalArgumentException(DeployPkgUtils.getString("msg.invalidactiontype") + theType + ".");
            }
            if (iconId != null) {
                this.putValue("SmallIcon", DeployPkgUtils.getIcon(iconId));
            }
        }

        @Override
        public void actionImpl(ActionEvent theEvent) throws ExternalException {
            if (this.type == 0) {
                DeployMainPanel.this.back();
            } else if (this.type == 1) {
                DeployMainPanel.this.forward();
            } else if (this.type == 2) {
                DeployMainPanel.this.up();
            } else if (this.type == 3) {
                DeployMainPanel.this.next();
            } else if (this.type == 4) {
                DeployMainPanel.this.clearHistory();
            } else if (this.type == 6) {
                DeployMainPanel.this.importConfig();
            } else if (this.type == 7) {
                DeployMainPanel.this.exportConfig();
            } else if (this.type == 9) {
                DeployMainPanel.this.bounce();
            } else if (this.type == 10) {
                DeployMainPanel.this.synch();
            }
        }

        @Override
        protected void handleError(Exception theException) {
            String emsg = null;
            if (this.type == 6) {
                emsg = DeployPkgUtils.getString("dmp.msg.importerror");
            } else if (this.type == 7) {
                emsg = DeployPkgUtils.getString("dmp.msg.exporterror");
            } else if (this.type == 9) {
                emsg = DeployPkgUtils.getString("dmp.msg.bounceerror");
            } else if (this.type == 10) {
                emsg = DeployPkgUtils.getString("dmp.msg.syncherror");
            }
            if (emsg != null) {
                ExceptionUtility.showMessage(emsg, theException.getMessage(), theException);
                LogManager.logError((String)"PSC-DEPLOYMENT", (Throwable)theException, (String)this.paramString());
            } else {
                super.handleError(theException);
            }
        }
    }
}

