/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.deploy;

import com.metamatrix.admin.api.objects.Host;
import com.metamatrix.admin.api.server.ServerAdmin;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.model.BasicHost;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConfigurationPropertiedObjectEditor;
import com.metamatrix.console.ui.util.AbstractPanelAction;
import com.metamatrix.console.ui.views.deploy.ConfirmationPanel;
import com.metamatrix.console.ui.views.deploy.CreatePanel;
import com.metamatrix.console.ui.views.deploy.DeployMainPanel;
import com.metamatrix.console.ui.views.deploy.DetailPanel;
import com.metamatrix.console.ui.views.deploy.event.ConfigurationModifier;
import com.metamatrix.console.ui.views.deploy.util.DeployPkgUtils;
import com.metamatrix.console.ui.views.deploy.util.DeployTableSorter;
import com.metamatrix.console.ui.views.deploy.util.PropertyConstants;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.DialogWindow;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import com.metamatrix.toolbox.ui.widget.property.PropertiedObjectPanel;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumn;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumnModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableColumn;

public final class DeployedHostPanel
extends DetailPanel
implements ConfigurationModifier,
DocumentListener,
PropertyChangeListener,
PropertyConstants {
    private static String[] PROC_HDRS = new String[4];
    private static final int PROC_COL = 0;
    private static final int MIN_HEAP_COL = 1;
    private static final int MAX_HEAP_COL = 2;
    private static final int LOG_COL = 3;
    private TableWidget tblProcs;
    private ProcessPOP pnlProps;
    private JPanel pnlPropsOuter;
    private PanelAction actionApply;
    private PanelAction actionNew;
    private PanelAction actionDelete;
    private PanelAction actionReset;
    private com.metamatrix.common.config.api.Host host;
    private DefaultTableModel procTblModel;
    private ArrayList treeActions;
    private int nextVMPort = 31000;
    private DeployMainPanel mainPanel;
    private boolean propsDifferent = false;
    private HashMap propValueMap = new HashMap();
    private HashMap propDefsMap = new HashMap();
    private ConfigurationPropertiedObjectEditor propEditor;
    private PropertiedObject propObj;

    public DeployedHostPanel(ConnectionInfo connInfo) {
        super(connInfo);
        this.setTitle(this.getString("dhp.title"));
    }

    public DeployedHostPanel(DeployMainPanel mainPanel, ConfigurationID theConfigId, ConnectionInfo connInfo) throws ExternalException {
        this(connInfo);
        this.mainPanel = mainPanel;
        this.setConfigId(theConfigId);
    }

    @Override
    public void changedUpdate(DocumentEvent theEvent) {
        this.checkResetState();
    }

    public void checkResetState() {
        if (this.isPropertiesValid() && this.propsDifferent) {
            if (!this.actionApply.isEnabled()) {
                this.actionApply.setEnabled(true);
                this.actionReset.setEnabled(true);
            }
        } else if (this.actionApply.isEnabled()) {
            this.actionApply.setEnabled(false);
            this.actionReset.setEnabled(false);
        }
    }

    private boolean isPropertiesValid() {
        return this.pnlProps.getInvalidDefinitions().isEmpty();
    }

    @Override
    protected JPanel construct(boolean readOnly) {
        this.treeActions = new ArrayList();
        this.actionApply = new PanelAction(0);
        this.actionApply.setEnabled(false);
        this.actionNew = new PanelAction(1);
        this.actionDelete = new PanelAction(2);
        this.actionReset = new PanelAction(3);
        this.actionReset.setEnabled(false);
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.pnlPropsOuter = new JPanel(new GridLayout(1, 1));
        this.setPnlPropsOuterBorder(null);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.insets = this.includingHdr() ? new Insets(3, 3, 5, 3) : new Insets(0, 0, 0, 0);
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        pnl.add((Component)this.pnlPropsOuter, gbc);
        try {
            this.propEditor = this.getConfigurationManager().getPropertiedObjectEditor();
            this.pnlProps = new ProcessPOP(this.propEditor);
            this.pnlProps.setReadOnlyForced(readOnly);
            this.pnlProps.createComponent();
            this.pnlProps.setColumnHeaderNames(this.getString("pop.propertyname.hdr"), this.getString("pop.propertyvalue.hdr"));
            this.pnlProps.addPropertyChangeListener(this);
            this.pnlProps.setShowInvalidProperties(true);
            this.pnlProps.setShowRequiredProperties(true);
            this.pnlProps.setShowExpertProperties(true);
            this.pnlPropsOuter.add(this.pnlProps);
        }
        catch (ExternalException theException) {
            throw new IllegalStateException(this.getString("msg.configmgrproblem", new Object[]{this.getClass(), "construct"}));
        }
        JPanel pnlProcs = new JPanel(new GridLayout(1, 1));
        TitledBorder tBorder = new TitledBorder(this.getString("dhp.pnlProcs.title"));
        pnlProcs.setBorder(new CompoundBorder(tBorder, DeployPkgUtils.EMPTY_BORDER));
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.weightx = 0.6;
        gbc.weighty = 0.6;
        pnl.add((Component)pnlProcs, gbc);
        this.tblProcs = new TableWidget();
        this.procTblModel = DeployPkgUtils.setup(this.tblProcs, PROC_HDRS, DeployPkgUtils.getInt("dhp.procstblrows", 5), null);
        this.procTblModel = (DefaultTableModel)this.tblProcs.getModel();
        this.tblProcs.setComparator(new DeployTableSorter());
        JScrollPane spnProcs = new JScrollPane(this.tblProcs);
        pnlProcs.add(spnProcs);
        JPanel pnlOps = new JPanel();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 10;
        gbc.gridwidth = 0;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        pnl.add((Component)pnlOps, gbc);
        JPanel pnlOpsSizer = new JPanel(new GridLayout(1, 4, 10, 0));
        pnlOps.add(pnlOpsSizer);
        ButtonWidget btnApply = new ButtonWidget();
        this.setup("action", btnApply, this.actionApply);
        pnlOpsSizer.add(btnApply);
        ButtonWidget btnNew = new ButtonWidget();
        this.setup("action", btnNew, this.actionNew);
        pnlOpsSizer.add(btnNew);
        ButtonWidget btnDelete = new ButtonWidget();
        this.setup("action", btnDelete, this.actionDelete);
        pnlOpsSizer.add(btnDelete);
        ButtonWidget btnReset = new ButtonWidget();
        this.setup("action", btnReset, this.actionReset);
        pnlOpsSizer.add(btnReset);
        return pnl;
    }

    private void setPnlPropsOuterBorder(String serviceName) {
        String title = serviceName == null ? "Properties" : "Properties of " + serviceName;
        TitledBorder tBorder = new TitledBorder(title);
        if (this.includingHdr()) {
            this.pnlPropsOuter.setBorder(new CompoundBorder(tBorder, DeployPkgUtils.EMPTY_BORDER));
        } else {
            this.pnlPropsOuter.setBorder(tBorder);
        }
    }

    private void delete() throws ExternalException {
        Object[] hostName = new Object[]{this.host.getName()};
        ConfirmationPanel pnlConfirm = new ConfirmationPanel("dhp.msg.confirmdelete", hostName);
        DialogWindow.show(this, DeployPkgUtils.getString("dhp.confirmdelete.title", hostName), pnlConfirm);
        if (pnlConfirm.isConfirmed()) {
            this.getConfigurationManager().deleteHost(this.host, this.getConfigId());
            this.mainPanel.refresh();
            this.checkResetState();
        }
    }

    public String getHostName() {
        String str = "";
        if (this.host != null) {
            str = this.host.toString();
        }
        return str;
    }

    @Override
    public List getTreeActions() {
        return this.treeActions;
    }

    @Override
    public void insertUpdate(DocumentEvent theEvent) {
        this.changedUpdate(theEvent);
    }

    @Override
    public boolean isPersisted() {
        return !this.actionApply.isEnabled();
    }

    private void newProcess() throws ExternalException {
        CreatePanel pnl = new CreatePanel("dhp.msg.createprocess", "icon.process.big", "dhp.lblnewprocess", "processname");
        DialogWindow.show(this, DeployPkgUtils.getString("dhp.newprocessdlg.title"), pnl);
        if (pnl.isConfirmed()) {
            String processName = pnl.getName();
            this.getConfigurationManager().createProcess(processName, Integer.toString(this.nextVMPort), this.host, this.getConfigId());
        }
    }

    @Override
    public void persist() throws ExternalException {
        if (this.propsDifferent) {
            StaticUtilities.displayModalDialogWithOK("Modify Process Properties", "Note change will not take effect until Host is restarted.");
            this.getConfigurationManager().modifyPropertiedObject(this.propEditor);
            this.propValueMap.clear();
            this.propsDifferent = false;
        }
        this.checkResetState();
    }

    @Override
    public void propertyChange(PropertyChangeEvent theEvent) {
        this.propsDifferent = false;
        String eventProp = theEvent.getPropertyName();
        if (this.propValueMap.containsKey(eventProp)) {
            Object current;
            Object original = this.propValueMap.get(eventProp);
            boolean bl = this.propsDifferent = !this.equivalent(original, current = theEvent.getNewValue());
            if (!this.propsDifferent) {
                for (String prop : this.propValueMap.keySet()) {
                    PropertyDefinition def;
                    if (prop.equals(eventProp)) continue;
                    original = this.propValueMap.get(prop);
                    boolean bl2 = this.propsDifferent = !this.equivalent(original, current = this.propEditor.getValue(this.propObj, def = (PropertyDefinition)this.propDefsMap.get(prop)));
                    if (!this.propsDifferent) continue;
                    break;
                }
            }
        } else {
            this.propsDifferent = true;
            this.propValueMap.put(eventProp, theEvent.getOldValue());
        }
        this.checkResetState();
    }

    private boolean equivalent(Object theValue, Object theOtherValue) {
        return theValue == null && theOtherValue == null || theValue != null && theOtherValue != null && theValue.equals(theOtherValue);
    }

    @Override
    public void removeUpdate(DocumentEvent theEvent) {
        this.changedUpdate(theEvent);
    }

    @Override
    public void reset() {
        if (this.propsDifferent) {
            this.resetPropertiedObject();
        }
        this.propsDifferent = false;
        this.checkResetState();
    }

    private void resetPropertiedObject() {
        this.propsDifferent = false;
        for (String prop : this.propValueMap.keySet()) {
            PropertyDefinition def = (PropertyDefinition)this.propDefsMap.get(prop);
            this.propEditor.setValue(this.propObj, def, this.propValueMap.get(prop));
        }
        this.pnlProps.refreshDisplay();
        this.propValueMap.clear();
    }

    private void sortFirstColumnInTable(TableWidget twidget) {
        EnhancedTableColumnModel etcmTabelCM = twidget.getEnhancedColumnModel();
        TableColumn tColumn = etcmTabelCM.getColumn(0);
        etcmTabelCM.setColumnSortedAscending((EnhancedTableColumn)tColumn, false);
    }

    @Override
    public void setDomainObject(Object theDomainObject, Object[] theAncestors) {
        try {
            if (theDomainObject == null) {
                this.host = this.getConfigurationManager().createHost(this.getString("dhp.newhost"));
            } else if (theDomainObject instanceof com.metamatrix.common.config.api.Host) {
                this.host = (com.metamatrix.common.config.api.Host)theDomainObject;
                ServerAdmin admin = this.getConnectionInfo().getServerAdmin();
                Collection adminHosts = admin.getHosts(this.host.getFullName());
                for (Host adminHost : adminHosts) {
                    ((BasicHost)this.host).setProperties(adminHost.getProperties());
                }
            } else {
                throw new IllegalArgumentException(this.getString("msg.invalidclass", new Object[]{"Host", theDomainObject.getClass()}));
            }
            super.setDomainObject(this.host, theAncestors);
            this.setTitleSuffix(this.host.getName());
            if (this.propEditor == null) {
                this.propEditor = this.getConfigurationManager().getPropertiedObjectEditor();
            }
            this.propDefsMap.clear();
            this.propValueMap.clear();
            this.propObj = this.getConfigurationManager().getPropertiedObjectForComponentObject((ComponentObject)this.host);
            this.pnlProps.setNameColumnHeaderWidth(0);
            this.pnlProps.setPropertiedObject(this.propObj);
            this.pnlProps.resizeNameColumn();
            this.savePropertyDefinitions();
            ConfigurationID configId = this.getConfigId();
            this.procTblModel.setNumRows(0);
            Collection procs = this.getConfigurationManager().getConfig(configId).getVMsForHost((HostID)this.host.getID());
            String port = null;
            if (procs != null) {
                for (VMComponentDefn process : procs) {
                    Vector<Object> processRow = new Vector<Object>(PROC_HDRS.length);
                    processRow.setSize(PROC_HDRS.length);
                    processRow.setElementAt(process, 0);
                    processRow.setElementAt(process.getProperty("vm.starter.minHeapSize"), 1);
                    processRow.setElementAt(process.getProperty("vm.starter.maxHeapSize"), 2);
                    port = process.getPort();
                    this.setNextVMPort(port);
                    processRow.setElementAt(port, 3);
                    this.procTblModel.addRow(processRow);
                }
            }
            this.tblProcs.sizeColumnsToFitData();
            this.sortFirstColumnInTable(this.tblProcs);
        }
        catch (Exception theException) {
            ExceptionUtility.showMessage(this.getString("msg.configmgrproblem", new Object[]{this.getClass(), "setDomainObject"}), "" + theException.getMessage(), theException);
            LogManager.logError((String)"PSC-DEPLOYMENT", (Throwable)theException, (String)(this.getClass() + ":setDomainObject"));
        }
    }

    private void savePropertyDefinitions() {
        if (this.propObj != null) {
            List defs = this.propEditor.getPropertyDefinitions(this.propObj);
            for (PropertyDefinition def : defs) {
                this.propDefsMap.put(def.getName(), def);
            }
        }
    }

    private void setNextVMPort(String port) {
        int p = port == null || port.length() == 0 ? this.nextVMPort : Integer.parseInt(port);
        if (p < this.nextVMPort) {
            return;
        }
        this.nextVMPort = p > this.nextVMPort ? p + 1 : ++this.nextVMPort;
    }

    @Override
    public void setEnabled(boolean theEnableFlag) {
        this.actionNew.setEnabled(theEnableFlag);
        Collection hosts = this.getConfigurationManager().getHosts(this.getConfigId());
        if (hosts != null && hosts.size() > 1) {
            this.actionDelete.setEnabled(theEnableFlag);
        } else {
            this.actionDelete.setEnabled(false);
        }
    }

    static {
        DeployedHostPanel.PROC_HDRS[0] = DeployPkgUtils.getString("dhp.process.hdr");
        DeployedHostPanel.PROC_HDRS[1] = DeployPkgUtils.getString("dhp.minheap.hdr");
        DeployedHostPanel.PROC_HDRS[2] = DeployPkgUtils.getString("dhp.maxheap.hdr");
        DeployedHostPanel.PROC_HDRS[3] = DeployPkgUtils.getString("dhp.vmport.hdr");
    }

    class ProcessPOP
    extends PropertiedObjectPanel {
        public ProcessPOP(PropertiedObjectEditor poe) {
            super(poe, DeployedHostPanel.this.getEncryptor());
        }

        @Override
        public void resizeNameColumn() {
            super.resizeNameColumn();
        }
    }

    private class PanelAction
    extends AbstractPanelAction {
        public static final int APPLY = 0;
        public static final int NEW = 1;
        public static final int DELETE = 2;
        public static final int RESET = 3;

        public PanelAction(int theType) {
            super(theType);
            if (theType == 0) {
                this.putValue("Name", DeployedHostPanel.this.getString("dhp.actionApply"));
                this.putValue("ShortDescription", DeployedHostPanel.this.getString("dhp.actionApply.tip"));
                this.setMnemonic(DeployedHostPanel.this.getMnemonicChar("dhp.actionApply.mnemonic"));
            } else if (theType == 1) {
                this.putValue("Name", DeployedHostPanel.this.getString("dhp.actionNew"));
                this.putValue("ShortDescription", DeployedHostPanel.this.getString("dhp.actionNew.tip"));
                this.setMnemonic(DeployedHostPanel.this.getMnemonicChar("dhp.actionNew.mnemonic"));
            } else if (theType == 2) {
                this.putValue("Name", DeployedHostPanel.this.getString("dhp.actionDelete"));
                this.putValue("ShortDescription", DeployedHostPanel.this.getString("dhp.actionDelete.tip"));
                this.setMnemonic(DeployedHostPanel.this.getMnemonicChar("dhp.actionDelete.mnemonic"));
            } else if (theType == 3) {
                this.putValue("Name", DeployedHostPanel.this.getString("dhp.actionReset"));
                this.putValue("ShortDescription", DeployedHostPanel.this.getString("dhp.actionReset.tip"));
                this.setMnemonic(DeployedHostPanel.this.getMnemonicChar("dhp.actionReset.mnemonic"));
            } else {
                throw new IllegalArgumentException(DeployedHostPanel.this.getString("msg.invalidactiontype", new Object[]{"" + theType}));
            }
        }

        @Override
        protected void actionImpl(ActionEvent theEvent) throws ExternalException {
            if (this.type == 0) {
                DeployedHostPanel.this.persist();
            } else if (this.type == 1) {
                DeployedHostPanel.this.newProcess();
            } else if (this.type == 2) {
                DeployedHostPanel.this.delete();
            } else if (this.type == 3) {
                DeployedHostPanel.this.reset();
            }
        }
    }
}

