/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.deploy;

import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ProductType;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConfigurationPropertiedObjectEditor;
import com.metamatrix.console.ui.util.AbstractPanelAction;
import com.metamatrix.console.ui.views.deploy.ConfirmationPanel;
import com.metamatrix.console.ui.views.deploy.DetailPanel;
import com.metamatrix.console.ui.views.deploy.event.ConfigurationModifier;
import com.metamatrix.console.ui.views.deploy.util.DeployPkgUtils;
import com.metamatrix.console.ui.views.deploy.util.DeployTableSorter;
import com.metamatrix.console.ui.views.deploy.util.PropertyConstants;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.DialogWindow;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import com.metamatrix.toolbox.ui.widget.property.PropertiedObjectPanel;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public final class DeployedProcessPanel
extends DetailPanel
implements ConfigurationModifier,
PropertyConstants,
ActionListener,
PropertyChangeListener,
ItemListener {
    private static final String NO_PSC = DeployPkgUtils.getString("drp.nodeployedpsc");
    private static String[] PSC_HDRS = new String[2];
    private static final int PROD_COL = 0;
    private static final int PSC_COL = 1;
    private TableWidget tblPscs;
    private TextFieldWidget txfHost;
    private PanelAction actionApply;
    private PanelAction actionDelete;
    private PanelAction actionReset;
    private VMComponentDefn process;
    private ProcessPOP pnlProps;
    private JPanel pnlPropsOuter;
    private DefaultTableModel tblModel;
    private HashMap prodRowMap = new HashMap();
    private HashMap propValueMap = new HashMap();
    private HashMap propDefsMap = new HashMap();
    private int numPscsDifferent = 0;
    private PscCellComponent pscCellComp;
    private boolean processEvents = true;
    private ConfigurationPropertiedObjectEditor propEditor;
    private PropertiedObject propObj;
    private boolean deleting = false;
    private boolean propsDifferent = false;
    private String processName = "";

    public DeployedProcessPanel(ConnectionInfo connInfo) {
        super(connInfo);
        this.setTitle(DeployPkgUtils.getString("drp.title"));
    }

    public DeployedProcessPanel(ConfigurationID theConfigId, ConnectionInfo connInfo) throws ExternalException {
        this(connInfo);
        this.setConfigId(theConfigId);
    }

    @Override
    public void actionPerformed(ActionEvent theEvent) {
        this.checkResetState();
    }

    private void checkResetState() {
        if (this.isPropertiesValid() && (this.propsDifferent || this.numPscsDifferent > 0)) {
            if (!this.actionApply.isEnabled()) {
                this.actionApply.setEnabled(true);
                this.actionReset.setEnabled(true);
            }
        } else if (this.actionApply.isEnabled()) {
            this.actionApply.setEnabled(false);
            this.actionReset.setEnabled(false);
        }
    }

    private boolean isPropertiesValid() {
        return this.pnlProps.getInvalidDefinitions().isEmpty();
    }

    @Override
    protected JPanel construct(boolean readOnly) {
        this.actionApply = new PanelAction(0);
        this.actionApply.setEnabled(false);
        this.actionDelete = new PanelAction(1);
        this.actionReset = new PanelAction(2);
        this.actionReset.setEnabled(false);
        JPanel pnl = new JPanel(new GridBagLayout());
        LabelWidget lblHost = DeployPkgUtils.createLabel("drp.lblHost");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.anchor = 13;
        pnl.add((Component)lblHost, gbc);
        this.txfHost = DeployPkgUtils.createTextField("hostname");
        this.txfHost.setEditable(false);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.1;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        pnl.add((Component)this.txfHost, gbc);
        this.pnlPropsOuter = new JPanel(new GridLayout(1, 1));
        this.setPnlPropsOuterBorder(null);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.insets = this.includingHdr() ? new Insets(3, 3, 5, 3) : new Insets(0, 0, 0, 0);
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        pnl.add((Component)this.pnlPropsOuter, gbc);
        try {
            this.propEditor = this.getConfigurationManager().getPropertiedObjectEditor();
            this.pnlProps = new ProcessPOP(this.propEditor);
            this.pnlProps.setReadOnlyForced(readOnly);
            this.pnlProps.createComponent();
            this.pnlProps.setColumnHeaderNames(this.getString("pop.propertyname.hdr"), this.getString("pop.propertyvalue.hdr"));
            this.pnlProps.addPropertyChangeListener(this);
            this.pnlProps.setShowInvalidProperties(true);
            this.pnlProps.setShowRequiredProperties(true);
            this.pnlProps.setShowExpertProperties(true);
            this.pnlPropsOuter.add(this.pnlProps);
        }
        catch (ExternalException theException) {
            throw new IllegalStateException(this.getString("msg.configmgrproblem", new Object[]{this.getClass(), "construct"}));
        }
        JPanel pnlPscs = new JPanel(new GridLayout(1, 1));
        TitledBorder tBorder = new TitledBorder(this.getString("drp.pnlPscs.title"));
        pnlPscs.setBorder(new CompoundBorder(tBorder, DeployPkgUtils.EMPTY_BORDER));
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(3, 3, 5, 3);
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        pnl.add((Component)pnlPscs, gbc);
        this.tblPscs = new TableWidget();
        this.tblModel = DeployPkgUtils.setup(this.tblPscs, PSC_HDRS, DeployPkgUtils.getInt("drp.pscstblrows", 10), new int[]{1});
        TableColumn pscCol = this.tblPscs.getColumnModel().getColumn(1);
        this.pscCellComp = new PscCellComponent();
        pscCol.setCellEditor(this.pscCellComp);
        pscCol.setCellRenderer(this.pscCellComp);
        this.tblPscs.setSortable(false);
        this.tblPscs.setComparator(new DeployTableSorter());
        JScrollPane spnPscs = new JScrollPane(this.tblPscs);
        pnlPscs.add(spnPscs);
        JPanel pnlOps = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(3, 3, 3, 3);
        pnl.add((Component)pnlOps, gbc);
        JPanel pnlOpsSizer = new JPanel(new GridLayout(1, 3, 10, 0));
        pnlOps.add(pnlOpsSizer);
        ButtonWidget btnApply = new ButtonWidget();
        this.setup("action", btnApply, this.actionApply);
        pnlOpsSizer.add(btnApply);
        ButtonWidget btnDelete = new ButtonWidget();
        this.setup("action", btnDelete, this.actionDelete);
        pnlOpsSizer.add(btnDelete);
        ButtonWidget btnReset = new ButtonWidget();
        this.setup("action", btnReset, this.actionReset);
        pnlOpsSizer.add(btnReset);
        return pnl;
    }

    private void setPnlPropsOuterBorder(String serviceName) {
        String title = serviceName == null ? "Properties" : "Properties of " + serviceName;
        TitledBorder tBorder = new TitledBorder(title);
        if (this.includingHdr()) {
            this.pnlPropsOuter.setBorder(new CompoundBorder(tBorder, DeployPkgUtils.EMPTY_BORDER));
        } else {
            this.pnlPropsOuter.setBorder(tBorder);
        }
    }

    private void delete() throws ExternalException {
        Object[] processName = new Object[]{this.process.getName()};
        ConfirmationPanel pnlConfirm = new ConfirmationPanel("drp.msg.confirmdelete", processName);
        DialogWindow.show(this, DeployPkgUtils.getString("drp.confirmdelete.title", processName), pnlConfirm);
        if (pnlConfirm.isConfirmed()) {
            this.deleting = true;
            this.getConfigurationManager().deleteProcess(this.process, this.getConfigId());
            this.numPscsDifferent = 0;
            this.propsDifferent = false;
            this.checkResetState();
            this.deleting = false;
        }
    }

    private int findProductRow(ProductType theProduct) {
        int row = -1;
        int rows = this.tblModel.getRowCount();
        for (int i = 0; i < rows; ++i) {
            if (!this.tblModel.getValueAt(i, 0).equals(theProduct)) continue;
            row = i;
            break;
        }
        return row;
    }

    public String getProcessName() {
        String str = "";
        if (this.process != null) {
            str = this.process.toString();
        }
        return str;
    }

    private void initTable() {
        try {
            Map prodPscs = this.getConfigurationManager().getAllProductPscs(this.getConfigId());
            this.pscCellComp.setPscValues(prodPscs);
            if (this.tblModel.getRowCount() == 0) {
                Iterator prodItr = prodPscs.keySet().iterator();
                while (prodItr.hasNext()) {
                    Vector<Object> row = new Vector<Object>(PSC_HDRS.length);
                    row.setSize(PSC_HDRS.length);
                    row.setElementAt(prodItr.next(), 0);
                    row.setElementAt(NO_PSC, 1);
                    this.tblModel.addRow(row);
                }
            }
        }
        catch (Exception theException) {
            ExceptionUtility.showMessage(this.getString("msg.configmgrproblem", new Object[]{this.getClass(), "initTable"}), "" + theException.getMessage(), theException);
            LogManager.logError((String)"PSC-DEPLOYMENT", (Throwable)theException, (String)(this.getClass() + ":initTable"));
        }
        int rows = this.tblModel.getRowCount();
        int i = 0;
        while (i < rows) {
            this.tblModel.setValueAt(NO_PSC, i++, 1);
        }
    }

    @Override
    public boolean isPersisted() {
        boolean persisted = true;
        if (!this.deleting && this.actionApply.isEnabled()) {
            persisted = false;
        }
        return persisted;
    }

    @Override
    public void propertyChange(PropertyChangeEvent theEvent) {
        this.propsDifferent = false;
        String eventProp = theEvent.getPropertyName();
        if (this.propValueMap.containsKey(eventProp)) {
            Object current;
            Object original = this.propValueMap.get(eventProp);
            boolean bl = this.propsDifferent = !this.equivalent(original, current = theEvent.getNewValue());
            if (!this.propsDifferent) {
                for (String prop : this.propValueMap.keySet()) {
                    PropertyDefinition def;
                    if (prop.equals(eventProp)) continue;
                    original = this.propValueMap.get(prop);
                    boolean bl2 = this.propsDifferent = !this.equivalent(original, current = this.propEditor.getValue(this.propObj, def = (PropertyDefinition)this.propDefsMap.get(prop)));
                    if (!this.propsDifferent) continue;
                    break;
                }
            }
        } else {
            this.propsDifferent = true;
            this.propValueMap.put(eventProp, theEvent.getOldValue());
        }
        this.checkResetState();
    }

    private boolean equivalent(Object theValue, Object theOtherValue) {
        return theValue == null && theOtherValue == null || theValue != null && theOtherValue != null && theValue.equals(theOtherValue);
    }

    @Override
    public void itemStateChanged(ItemEvent theEvent) {
        if (this.processEvents) {
            JComboBox pscEditor = (JComboBox)theEvent.getSource();
            int row = this.tblPscs.getSelectedRow();
            if (theEvent.getStateChange() == 1 && row != -1 && pscEditor.getSelectedIndex() != -1) {
                Object psc = pscEditor.getSelectedItem();
                this.tblModel.setValueAt(psc, row, 1);
                Object saveValue = this.prodRowMap.get(this.tblModel.getValueAt(row, 0));
                boolean diff = false;
                if (saveValue == null) {
                    if (!psc.equals(NO_PSC)) {
                        diff = true;
                    }
                } else if (!psc.equals(saveValue)) {
                    diff = true;
                }
                if (diff) {
                    ++this.numPscsDifferent;
                } else if (this.numPscsDifferent > 0) {
                    --this.numPscsDifferent;
                }
                this.checkResetState();
            }
        }
    }

    @Override
    public void persist() throws ExternalException {
        if (this.propsDifferent) {
            StaticUtilities.displayModalDialogWithOK("Modify Process Properties", "Note change will not take effect until Process is restarted in the Runtime panel.");
            this.getConfigurationManager().modifyPropertiedObject(this.propEditor);
            this.propValueMap.clear();
            this.propsDifferent = false;
        }
        this.checkResetState();
        if (this.numPscsDifferent > 0) {
            int rows = this.tblModel.getRowCount();
            for (int i = 0; i < rows; ++i) {
                ProductType prod = (ProductType)this.tblModel.getValueAt(i, 0);
                Object savedPsc = this.prodRowMap.get(prod);
                Object currentPsc = this.tblModel.getValueAt(i, 1);
                Object[] ancestors = this.getAncestors();
                Host host = (Host)ancestors[0];
                if (savedPsc == null && !currentPsc.equals(NO_PSC)) {
                    this.getConfigurationManager().deployPsc((ProductServiceConfig)currentPsc, this.process, host, this.getConfigId());
                    this.prodRowMap.put(prod, currentPsc);
                    continue;
                }
                if (savedPsc != null && !savedPsc.equals(currentPsc) && !currentPsc.equals(NO_PSC)) {
                    this.getConfigurationManager().changeDeployedPsc((ProductServiceConfig)savedPsc, (ProductServiceConfig)currentPsc, this.process, host, this.getConfigId());
                    this.prodRowMap.put(prod, currentPsc);
                    continue;
                }
                if (savedPsc == null || !currentPsc.equals(NO_PSC)) continue;
                this.getConfigurationManager().deleteDeployedPsc((ProductServiceConfig)savedPsc, this.process, host, this.getConfigId());
                this.prodRowMap.put(prod, null);
            }
        }
        this.numPscsDifferent = 0;
        this.checkResetState();
    }

    @Override
    public void reset() {
        if (this.propsDifferent) {
            this.resetPropertiedObject();
        }
        int rows = this.tblModel.getRowCount();
        for (int i = 0; i < rows; ++i) {
            Object prod = this.tblModel.getValueAt(i, 0);
            Object psc = this.prodRowMap.get(prod);
            if (psc == null) {
                if (this.tblModel.getValueAt(i, 1).equals(NO_PSC)) continue;
                this.tblModel.setValueAt(NO_PSC, i, 1);
                continue;
            }
            if (this.tblModel.getValueAt(i, 1).equals(psc)) continue;
            this.tblModel.setValueAt(psc, i, 1);
        }
        this.numPscsDifferent = 0;
        this.propsDifferent = false;
        this.checkResetState();
    }

    private void resetPropertiedObject() {
        this.propsDifferent = false;
        for (String prop : this.propValueMap.keySet()) {
            PropertyDefinition def = (PropertyDefinition)this.propDefsMap.get(prop);
            this.propEditor.setValue(this.propObj, def, this.propValueMap.get(prop));
        }
        this.pnlProps.refreshDisplay();
        this.propValueMap.clear();
    }

    @Override
    public void setConfigId(ConfigurationID theConfigId) {
        super.setConfigId(theConfigId);
        this.setMMLEnabled(true);
    }

    @Override
    public void setDomainObject(Object theDomainObject, Object[] theAncestors) {
        try {
            if (theDomainObject == null) {
                this.process = this.getConfigurationManager().createProcess(this.getString("drp.newprocess"), null, (Host)theAncestors[0], this.getConfigId());
            } else if (theDomainObject instanceof VMComponentDefn) {
                this.process = (VMComponentDefn)theDomainObject;
                this.processName = this.process.getName();
            } else {
                throw new IllegalArgumentException(this.getString("msg.invalidclass", new Object[]{"VMComponentDefn", theDomainObject.getClass()}));
            }
            super.setDomainObject(this.process, theAncestors);
            if (this.propEditor == null) {
                this.propEditor = this.getConfigurationManager().getPropertiedObjectEditor();
            }
            this.propDefsMap.clear();
            this.propValueMap.clear();
            this.propObj = this.getConfigurationManager().getPropertiedObjectForComponentObject((ComponentObject)this.process);
            this.pnlProps.setNameColumnHeaderWidth(0);
            this.pnlProps.setPropertiedObject(this.propObj);
            this.pnlProps.resizeNameColumn();
            this.savePropertyDefinitions();
            this.setTitleSuffix(this.processName);
            Host host = (Host)theAncestors[0];
            this.txfHost.setText(host.getName());
            this.initTable();
            this.prodRowMap.clear();
            Collection pscs = this.getConfigurationManager().getDeployedPscs(this.process);
            if (pscs != null) {
                for (ProductServiceConfig psc : pscs) {
                    ProductType product = this.getConfigurationManager().getProduct(psc);
                    this.tblModel.setValueAt(psc, this.findProductRow(product), 1);
                    this.prodRowMap.put(product, psc);
                }
            }
            this.tblPscs.sizeColumnsToFitData();
        }
        catch (Exception theException) {
            ExceptionUtility.showMessage(this.getString("msg.configmgrproblem", new Object[]{this.getClass(), "setDomainObject"}), "" + theException.getMessage(), theException);
            LogManager.logError((String)"PSC-DEPLOYMENT", (Throwable)theException, (String)(this.getClass() + ":setDomainObject"));
        }
    }

    private void savePropertyDefinitions() {
        if (this.propObj != null) {
            List defs = this.propEditor.getPropertyDefinitions(this.propObj);
            for (PropertyDefinition def : defs) {
                this.propDefsMap.put(def.getName(), def);
            }
        }
    }

    @Override
    public void setEnabled(boolean theEnableFlag) {
        if (this.isEnabled() != theEnableFlag) {
            super.setEnabled(theEnableFlag);
            this.pnlProps.setReadOnlyForced(!theEnableFlag);
            this.pnlProps.refreshDisplay();
            this.actionDelete.setEnabled(theEnableFlag);
            this.tblPscs.setColumnEditable(1, theEnableFlag);
            if (!theEnableFlag) {
                this.tblPscs.editingStopped(new ChangeEvent(this));
            }
        }
    }

    public void setMMLEnabled(boolean theEnableFlag) {
        this.pnlProps.setReadOnlyForced(!theEnableFlag);
        this.pnlProps.refreshDisplay();
        if (!theEnableFlag) {
            this.tblPscs.editingStopped(new ChangeEvent(this));
        }
    }

    static {
        DeployedProcessPanel.PSC_HDRS[0] = DeployPkgUtils.getString("drp.product.hdr");
        DeployedProcessPanel.PSC_HDRS[1] = DeployPkgUtils.getString("drp.psc.hdr");
    }

    class ProcessPOP
    extends PropertiedObjectPanel {
        public ProcessPOP(PropertiedObjectEditor poe) {
            super(poe, DeployedProcessPanel.this.getEncryptor());
        }

        @Override
        public void resizeNameColumn() {
            super.resizeNameColumn();
        }
    }

    private class PscCellComponent
    extends DefaultCellEditor
    implements TableCellRenderer {
        HashMap map;
        JComboBox cbxRenderer;

        public PscCellComponent() {
            super(new JComboBox(){

                @Override
                public void updateUI() {
                    this.setUI(BasicComboBoxUI.createUI(this));
                }
            });
            this.map = new HashMap();
            JComboBox cbx = (JComboBox)this.getComponent();
            cbx.addItemListener(DeployedProcessPanel.this);
            this.cbxRenderer = new JComboBox(){

                @Override
                public void updateUI() {
                    this.setUI(BasicComboBoxUI.createUI(this));
                }
            };
        }

        @Override
        public Component getTableCellEditorComponent(JTable theTable, Object theValue, boolean theSelectedFlag, int theRow, int theColumn) {
            JComboBox cbx = (JComboBox)this.getComponent();
            Object prod = DeployedProcessPanel.this.tblModel.getValueAt(theRow, 0);
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.map.get(prod);
            DeployedProcessPanel.this.processEvents = false;
            cbx.setModel(model);
            cbx.setSelectedItem(DeployedProcessPanel.this.tblModel.getValueAt(theRow, 1));
            DeployedProcessPanel.this.processEvents = true;
            return cbx;
        }

        @Override
        public Component getTableCellRendererComponent(JTable theTable, Object theValue, boolean theSelectedFlag, boolean hasFocus, int theRow, int theColumn) {
            this.cbxRenderer.setModel(new DefaultComboBoxModel<Object>(new Object[]{theValue}));
            Color clr = theSelectedFlag ? theTable.getSelectionBackground() : theTable.getBackground();
            this.cbxRenderer.setBackground(clr);
            return this.cbxRenderer;
        }

        public void setPscValues(Map theProductPscs) {
            this.map.clear();
            if (theProductPscs != null) {
                for (ProductType product : theProductPscs.keySet()) {
                    List pscs = (List)theProductPscs.get(product);
                    pscs.add(0, NO_PSC);
                    DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(pscs.toArray());
                    this.map.put(product, model);
                }
            }
        }
    }

    private class PanelAction
    extends AbstractPanelAction {
        public static final int APPLY = 0;
        public static final int DELETE = 1;
        public static final int RESET = 2;

        public PanelAction(int theType) {
            super(theType);
            if (theType == 0) {
                this.putValue("Name", DeployedProcessPanel.this.getString("drp.actionApply"));
                this.putValue("ShortDescription", DeployedProcessPanel.this.getString("drp.actionApply.tip"));
                this.setMnemonic(DeployedProcessPanel.this.getMnemonicChar("drp.actionApply.mnemonic"));
            } else if (theType == 1) {
                this.putValue("Name", DeployedProcessPanel.this.getString("drp.actionDelete"));
                this.putValue("ShortDescription", DeployedProcessPanel.this.getString("drp.actionDelete.tip"));
                this.setMnemonic(DeployedProcessPanel.this.getMnemonicChar("drp.actionDelete.mnemonic"));
            } else if (theType == 2) {
                this.putValue("Name", DeployedProcessPanel.this.getString("drp.actionReset"));
                this.putValue("ShortDescription", DeployedProcessPanel.this.getString("drp.actionReset.tip"));
                this.setMnemonic(DeployedProcessPanel.this.getMnemonicChar("drp.actionReset.mnemonic"));
            } else {
                throw new IllegalArgumentException(DeployedProcessPanel.this.getString("msg.invalidactiontype", new Object[]{"" + theType}));
            }
        }

        @Override
        protected void actionImpl(ActionEvent theEvent) throws ExternalException {
            if (this.type == 0) {
                DeployedProcessPanel.this.persist();
            } else if (this.type == 1) {
                DeployedProcessPanel.this.delete();
            } else if (this.type == 2) {
                DeployedProcessPanel.this.reset();
            }
        }

        @Override
        public String toString() {
            if (this.type == 0) {
                return DeployedProcessPanel.this.getString("drp.actionApply.msg", new Object[]{DeployedProcessPanel.this.processName});
            }
            if (this.type == 1) {
                return DeployedProcessPanel.this.getString("drp.actionDelete.msg", new Object[]{DeployedProcessPanel.this.processName});
            }
            if (this.type == 2) {
                return DeployedProcessPanel.this.getString("drp.actionReset.msg", new Object[]{DeployedProcessPanel.this.processName});
            }
            return null;
        }
    }
}

