/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.deploy;

import com.metamatrix.common.config.api.ComponentDefnID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ProductType;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.ui.views.deploy.DetailPanel;
import com.metamatrix.console.ui.views.deploy.util.DeployPkgUtils;
import com.metamatrix.console.ui.views.deploy.util.DeployTableSorter;
import com.metamatrix.console.ui.views.deploy.util.PropertyConstants;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumn;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumnModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.table.TableColumn;

public final class DeployedPscPanel
extends DetailPanel
implements PropertyConstants {
    private static final String[] SERVICE_HDRS = new String[2];
    private static final int SERV_COL = 0;
    private static final int ESSENTIAL_COL = 1;
    private TableWidget tblServices;
    private TextFieldWidget txfHost;
    private TextFieldWidget txfProcess;
    private TextFieldWidget txfProduct;
    private ProductServiceConfig psc;
    private DefaultTableModel tblModel;

    public DeployedPscPanel(ConnectionInfo connInfo) {
        super(connInfo);
        this.setTitle(this.getString("dpp.title"));
    }

    public DeployedPscPanel(ConnectionInfo connInfo, ConfigurationID theConfigId) throws ExternalException {
        this(connInfo);
        this.setConfigId(theConfigId);
    }

    @Override
    protected JPanel construct(boolean readOnly) {
        JPanel pnl = new JPanel(new GridBagLayout());
        LabelWidget lblHost = DeployPkgUtils.createLabel("dpp.lblHost");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        pnl.add((Component)lblHost, gbc);
        this.txfHost = DeployPkgUtils.createTextField("hostname");
        this.txfHost.setEditable(false);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.2;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        pnl.add((Component)this.txfHost, gbc);
        LabelWidget lblProcess = DeployPkgUtils.createLabel("dpp.lblProcess");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        pnl.add((Component)lblProcess, gbc);
        this.txfProcess = DeployPkgUtils.createTextField("processname");
        this.txfProcess.setEditable(false);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 0.2;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        pnl.add((Component)this.txfProcess, gbc);
        LabelWidget lblProduct = DeployPkgUtils.createLabel("dpp.lblProduct");
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        pnl.add((Component)lblProduct, gbc);
        this.txfProduct = DeployPkgUtils.createTextField("productname");
        this.txfProduct.setEditable(false);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 0.2;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        pnl.add((Component)this.txfProduct, gbc);
        JPanel pnlServices = new JPanel(new GridLayout(1, 1));
        TitledBorder tBorder = new TitledBorder(this.getString("dpp.pnlServices.title"));
        pnlServices.setBorder(new CompoundBorder(tBorder, DeployPkgUtils.EMPTY_BORDER));
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        pnl.add((Component)pnlServices, gbc);
        this.tblServices = new TableWidget();
        this.tblModel = DeployPkgUtils.setup(this.tblServices, SERVICE_HDRS, DeployPkgUtils.getInt("dpp.servicestblrows", 10), null);
        this.tblServices.setComparator(new DeployTableSorter());
        JScrollPane spnServices = new JScrollPane(this.tblServices);
        pnlServices.add(spnServices);
        return pnl;
    }

    @Override
    public void setConfigId(ConfigurationID theConfigId) {
        super.setConfigId(theConfigId);
        this.setTitleSuffix(this.getString("dpp.title.suffix"));
    }

    private void sortFirstColumnInTable(TableWidget twidget) {
        EnhancedTableColumnModel etcmTabelCM = twidget.getEnhancedColumnModel();
        TableColumn tColumn = etcmTabelCM.getColumn(0);
        etcmTabelCM.setColumnSortedAscending((EnhancedTableColumn)tColumn, false);
    }

    @Override
    public void setDomainObject(Object theDomainObject, Object[] theAncestors) {
        if (!(theDomainObject instanceof ProductServiceConfig)) {
            throw new IllegalArgumentException(this.getString("msg.invalidclass", new Object[]{"ProductServiceConfig", theDomainObject.getClass()}));
        }
        this.psc = (ProductServiceConfig)theDomainObject;
        this.setTitleSuffix(this.psc.getName());
        super.setDomainObject(this.psc, theAncestors);
        try {
            Configuration config = this.getConfigurationManager().getConfig(this.getConfigId());
            VMComponentDefn process = (VMComponentDefn)theAncestors[0];
            this.txfProcess.setText(process.getName());
            Host host = (Host)theAncestors[1];
            this.txfHost.setText(host.getName());
            ProductType product = this.getConfigurationManager().getProduct(this.psc);
            this.txfProduct.setText(product.getName());
            this.tblModel.setNumRows(0);
            Collection services = this.getConfigurationManager().getDeployedServices(this.psc, process);
            if (services != null) {
                for (DeployedComponent servDp : services) {
                    ServiceComponentDefnID id = servDp.getServiceComponentDefnID();
                    ServiceComponentDefn service = (ServiceComponentDefn)config.getComponentDefn((ComponentDefnID)id);
                    Vector<Object> row = new Vector<Object>(SERVICE_HDRS.length);
                    row.setSize(SERVICE_HDRS.length);
                    row.setElementAt(service, 0);
                    String essential = service.getProperty(ESSENTIAL_PROP);
                    if (essential == null) {
                        essential = "";
                    }
                    row.setElementAt(new Boolean(essential), 1);
                    this.tblModel.addRow(row);
                }
            }
            this.tblServices.sizeColumnsToFitData();
            this.sortFirstColumnInTable(this.tblServices);
        }
        catch (Exception theException) {
            ExceptionUtility.showMessage(this.getString("msg.configmgrproblem", new Object[]{this.getClass(), "setDomainObject"}), "" + theException.getMessage(), theException);
            LogManager.logError((String)"PSC-DEPLOYMENT", (Throwable)theException, (String)(this.getClass() + ":setDomainObject"));
        }
    }

    static {
        DeployedPscPanel.SERVICE_HDRS[0] = DeployPkgUtils.getString("dpp.service.hdr");
        DeployedPscPanel.SERVICE_HDRS[1] = DeployPkgUtils.getString("dpp.essential.hdr");
    }
}

