/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.deploy;

import com.metamatrix.common.config.api.ComponentDefnID;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ProductType;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.ui.views.deploy.DetailPanel;
import com.metamatrix.console.ui.views.deploy.util.DeployPkgUtils;
import com.metamatrix.console.ui.views.deploy.util.PropertyConstants;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.toolbox.ui.widget.CheckBox;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import com.metamatrix.toolbox.ui.widget.property.PropertiedObjectPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;

public final class DeployedServicePanel
extends DetailPanel
implements PropertyConstants {
    private CheckBox chkEssential;
    private PropertiedObjectPanel pnlProps;
    private JPanel pnlPropsOuter;
    private TextFieldWidget txfHost;
    private TextFieldWidget txfProc;
    private TextFieldWidget txfProd;
    private TextFieldWidget txfPsc;
    private TextFieldWidget txfService;
    private PropertiedObjectEditor editor;

    public DeployedServicePanel(ConnectionInfo connInfo) {
        super(connInfo);
        this.setTitle(this.getString("dvp.title"));
    }

    public DeployedServicePanel(ConfigurationID theConfigId, ConnectionInfo connInfo) throws ExternalException {
        this(connInfo);
        this.setConfigId(theConfigId);
    }

    @Override
    protected JPanel construct(boolean readOnly) {
        JPanel pnl = new JPanel(new GridBagLayout());
        LabelWidget lblHost = DeployPkgUtils.createLabel("dvp.lblHost");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        pnl.add((Component)lblHost, gbc);
        this.txfHost = DeployPkgUtils.createTextField("type.hostname");
        this.txfHost.setEditable(false);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        pnl.add((Component)this.txfHost, gbc);
        LabelWidget lblProc = DeployPkgUtils.createLabel("dvp.lblProc");
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 13;
        pnl.add((Component)lblProc, gbc);
        this.txfProc = DeployPkgUtils.createTextField("type.processname");
        this.txfProc.setEditable(false);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.anchor = 17;
        pnl.add((Component)this.txfProc, gbc);
        LabelWidget lblProd = DeployPkgUtils.createLabel("dvp.lblProduct");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(3, 3, 10, 3);
        gbc.anchor = 13;
        pnl.add((Component)lblProd, gbc);
        this.txfProd = DeployPkgUtils.createTextField("type.productname");
        this.txfProd.setEditable(false);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        pnl.add((Component)this.txfProd, gbc);
        LabelWidget lblPsc = DeployPkgUtils.createLabel("dvp.lblPsc");
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 13;
        pnl.add((Component)lblPsc, gbc);
        this.txfPsc = DeployPkgUtils.createTextField("type.pscname");
        this.txfPsc.setEditable(false);
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.anchor = 17;
        pnl.add((Component)this.txfPsc, gbc);
        LabelWidget lblService = DeployPkgUtils.createLabel("dvp.lblService");
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.anchor = 13;
        pnl.add((Component)lblService, gbc);
        this.txfService = DeployPkgUtils.createTextField("type.servicename");
        this.txfService.setEditable(false);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 17;
        pnl.add((Component)this.txfService, gbc);
        LabelWidget lblEssential = DeployPkgUtils.createLabel("dvp.lblEssential");
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.anchor = 13;
        pnl.add((Component)lblEssential, gbc);
        this.chkEssential = new CheckBox();
        this.chkEssential.setEnabled(false);
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.anchor = 17;
        pnl.add((Component)this.chkEssential, gbc);
        this.pnlPropsOuter = new JPanel(new GridLayout(1, 1));
        TitledBorder tBorder = new TitledBorder(this.getString("dvp.pnlProps.title"));
        this.pnlPropsOuter.setBorder(new CompoundBorder(tBorder, DeployPkgUtils.EMPTY_BORDER));
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        pnl.add((Component)this.pnlPropsOuter, gbc);
        try {
            this.editor = this.getConfigurationManager().getPropertiedObjectEditor();
            this.pnlProps = new PropertiedObjectPanel(this.editor, this.getEncryptor());
            this.pnlProps.createComponent();
            this.pnlProps.setColumnHeaderNames(this.getString("pop.propertyname.hdr"), this.getString("pop.propertyvalue.hdr"));
            this.pnlProps.setReadOnlyForced(true);
            this.pnlPropsOuter.add(this.pnlProps);
        }
        catch (ExternalException theException) {
            ExceptionUtility.showMessage(this.getString("msg.configmgrproblem", new Object[]{this.getClass(), "construct"}), (Throwable)((Object)theException));
            LogManager.logError((String)"PSC-DEPLOYMENT", (Throwable)((Object)theException), (String)(this.getClass() + ":construct"));
        }
        return pnl;
    }

    @Override
    public void setDomainObject(Object theDomainObject, Object[] theAncestors) {
        if (!(theDomainObject instanceof DeployedComponent)) {
            throw new IllegalArgumentException(this.getString("msg.invalidclass", new Object[]{"DeployedComponent", theDomainObject.getClass()}));
        }
        ServiceComponentDefnID id = ((DeployedComponent)theDomainObject).getServiceComponentDefnID();
        Configuration config = this.getConfigurationManager().getConfig(this.getConfigId());
        ServiceComponentDefn service = (ServiceComponentDefn)config.getComponentDefn((ComponentDefnID)id);
        super.setDomainObject(service, theAncestors);
        this.setTitleSuffix(service.toString());
        this.txfService.setText(service.toString());
        Host host = (Host)theAncestors[2];
        this.txfHost.setText(host.getName());
        VMComponentDefn process = (VMComponentDefn)theAncestors[1];
        this.txfProc.setText(process.getName());
        ProductServiceConfig psc = (ProductServiceConfig)theAncestors[0];
        this.txfPsc.setText(psc.getName());
        ProductType product = this.getConfigurationManager().getProduct(psc);
        this.txfProd.setText(product.getName());
        String essential = service.getProperty(ESSENTIAL_PROP);
        if (essential == null) {
            essential = "";
        }
        this.chkEssential.setSelected(new Boolean(essential));
        PropertiedObject propObj = this.getConfigurationManager().getPropertiedObjectForComponentObject((ComponentObject)service);
        this.pnlProps.setNameColumnHeaderWidth(0);
        this.pnlProps.setPropertiedObject(propObj);
    }
}

