/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.deploy;

import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.ui.views.deploy.DetailPanel;
import com.metamatrix.console.ui.views.deploy.util.DeployPkgUtils;
import com.metamatrix.console.ui.views.deploy.util.DeployTableSorter;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.DialogPanel;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumn;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumnModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.table.TableColumn;

public final class DeploymentsSummaryPanel
extends DetailPanel {
    private TableWidget tblDeployments;
    private Configuration config;
    private DefaultTableModel deployTblModel;
    private ArrayList treeActions;

    public DeploymentsSummaryPanel(ConnectionInfo connInfo) {
        super(connInfo);
        this.setTitle(this.getString("dsp.title"));
    }

    public DeploymentsSummaryPanel(ConfigurationID theConfigId, ConnectionInfo conn) throws ExternalException {
        this(conn);
        this.setConfigId(theConfigId);
    }

    @Override
    protected JPanel construct(boolean readOnly) {
        this.treeActions = new ArrayList();
        JPanel pnl = new JPanel(new GridBagLayout());
        JPanel pnlDeployments = new JPanel(new GridLayout(1, 1));
        TitledBorder tBorder = new TitledBorder(this.getString("dsp.pnlDeployments.title"));
        pnlDeployments.setBorder(new CompoundBorder(tBorder, DeployPkgUtils.EMPTY_BORDER));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.insets = new Insets(3, 3, 0, 3);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        pnl.add((Component)pnlDeployments, gbc);
        this.tblDeployments = new TableWidget();
        this.deployTblModel = DeployPkgUtils.setup(this.tblDeployments, DeployPkgUtils.DEPLOY_HDRS, DeployPkgUtils.getInt("dsp.deploytblrows", 10), null);
        this.tblDeployments.setComparator(new DeployTableSorter());
        JScrollPane spnDeployments = new JScrollPane(this.tblDeployments);
        pnlDeployments.add(spnDeployments);
        JPanel pnlOps = new JPanel();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 0;
        gbc.insets = new Insets(3, 3, 0, 3);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        pnl.add((Component)pnlOps, gbc);
        JPanel pnlOpsSizer = new JPanel(new GridLayout(1, 1));
        pnlOps.add(pnlOpsSizer);
        return pnl;
    }

    @Override
    public List getTreeActions() {
        return this.treeActions;
    }

    private void sortFirstColumnInTable(TableWidget twidget) {
        EnhancedTableColumnModel etcmTabelCM = twidget.getEnhancedColumnModel();
        TableColumn tColumn = etcmTabelCM.getColumn(0);
        etcmTabelCM.setColumnSortedAscending((EnhancedTableColumn)tColumn, false);
    }

    @Override
    public void setDomainObject(Object theDomainObject, Object[] theAncestors) {
        if (!(theDomainObject instanceof Configuration)) {
            throw new IllegalArgumentException(this.getString("msg.invalidclass", new Object[]{"Configuration", theDomainObject.getClass()}));
        }
        this.config = (Configuration)theDomainObject;
        super.setDomainObject(this.config, theAncestors);
        try {
            DeployPkgUtils.loadDeployments(this.config, this.deployTblModel, this.getConnectionInfo());
            this.tblDeployments.sizeColumnsToFitData();
            this.sortFirstColumnInTable(this.tblDeployments);
        }
        catch (ExternalException theException) {
            ExceptionUtility.showMessage(this.getString("msg.configmgrproblem", new Object[]{this.getClass(), "setDomainObject"}), "" + theException.getMessage(), (Throwable)((Object)theException));
            LogManager.logError((String)"PSC-DEPLOYMENT", (Throwable)((Object)theException), (String)(this.getClass() + ":setDomainObject"));
        }
    }

    public class HostExistsInfoPanel
    extends DialogPanel {
        public HostExistsInfoPanel(String theHostName) {
            JPanel pnl = new JPanel(new GridBagLayout());
            pnl.setBorder(BorderFactory.createEmptyBorder(30, 40, 30, 40));
            LabelWidget lbl = new LabelWidget(DeployPkgUtils.getString("dsp.hostexists.msg", new Object[]{theHostName}));
            lbl.setIcon(DeployPkgUtils.getIcon("icon.info"));
            pnl.add(lbl);
            this.setContent(pnl);
            ButtonWidget btnOk = this.getAcceptButton();
            btnOk.setText(DeployPkgUtils.getString("dsp.hostexists.btnOk"));
            this.removeNavigationButton(this.getCancelButton());
        }
    }
}

