/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.deploy;

import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.util.crypto.Encryptor;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConfigurationManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.security.UserCapabilities;
import com.metamatrix.console.ui.layout.MenuEntry;
import com.metamatrix.console.ui.util.AbstractPanelAction;
import com.metamatrix.console.ui.views.deploy.util.DeployPkgUtils;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JPanel;

public abstract class DetailPanel
extends JPanel {
    private LabelWidget lblConfig;
    private LabelWidget lblTitle;
    protected ArrayList actions = new ArrayList();
    private Object[] ancestors;
    private ConfigurationID configId;
    protected Object domainObj;
    private String title = this.getString("dp.title");
    private String titleSuffix = this.getString("dp.titlesuffix");
    private boolean includingHdr;
    private ConnectionInfo connectionInfo;

    public DetailPanel(boolean includeHdr, ConnectionInfo connectionInfo) {
        super(new GridBagLayout());
        boolean canModify;
        this.includingHdr = includeHdr;
        this.connectionInfo = connectionInfo;
        this.setBorder(DeployPkgUtils.EMPTY_BORDER);
        this.lblConfig = new LabelWidget();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        if (includeHdr) {
            this.add((Component)this.lblConfig, gbc);
        }
        this.lblTitle = new LabelWidget();
        Font font = this.lblTitle.getFont();
        this.lblTitle.setFont(font.deriveFont(font.getSize2D() * 1.5f));
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc = new GridBagConstraints();
        gbc.anchor = 10;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        if (includeHdr) {
            this.add((Component)this.lblTitle, gbc);
        }
        JPanel pnl = this.construct(!(canModify = UserCapabilities.getInstance().canUpdateConfiguration(this.getConnectionInfo())));
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)pnl, gbc);
        this.setMinimumSize(new Dimension(0, 0));
    }

    public DetailPanel(ConnectionInfo connectionInfo) {
        this(true, connectionInfo);
    }

    protected boolean includingHdr() {
        return this.includingHdr;
    }

    protected abstract JPanel construct(boolean var1);

    public List getActions() {
        return this.actions;
    }

    public Object[] getAncestors() {
        return this.ancestors;
    }

    public ConfigurationID getConfigId() {
        return this.configId;
    }

    public Object getDomainObject() {
        return this.domainObj;
    }

    public Icon getIcon(String theKey) {
        return DeployPkgUtils.getIcon(theKey);
    }

    public int getInt(String theKey, int theDefault) {
        return DeployPkgUtils.getInt(theKey, theDefault);
    }

    public int getMnemonicChar(String theKey) {
        return DeployPkgUtils.getMnemonic(theKey);
    }

    public String getString(String theKey) {
        return DeployPkgUtils.getString(theKey);
    }

    public String getString(String theKey, Object[] theArgs) {
        return DeployPkgUtils.getString(theKey, theArgs);
    }

    public List getTreeActions() {
        return null;
    }

    public void setConfigId(ConfigurationID theConfigId) {
        this.configId = theConfigId;
        String iconId = null;
        if (this.getConfigurationManager().isNextStartUpConfig(this.configId)) {
            iconId = "icon.nextstartup.big";
        } else if (this.getConfigurationManager().isStartUpConfig(this.configId)) {
            iconId = "icon.startup.big";
        }
        if (iconId != null) {
            this.lblConfig.setIcon(this.getIcon(iconId));
            Configuration config = this.getConfigurationManager().getConfig(this.configId);
            this.lblConfig.setText(config.getName());
            this.setTitleSuffix(config.getName());
        }
    }

    public void setDomainObject(Object theDomainObject, Object[] theAncestors) {
        this.domainObj = theDomainObject;
        this.ancestors = theAncestors;
    }

    protected void setTitle(String theTitle) {
        this.title = theTitle;
        this.lblTitle.setText(this.title);
    }

    protected void setTitleSuffix(String theSuffix) {
        this.titleSuffix = theSuffix;
        this.lblTitle.setText(this.getString("dp.lblTitle", new Object[]{this.title, this.titleSuffix}));
    }

    protected void setup(String theMenuEntryType, AbstractButton theButton, AbstractPanelAction theAction) {
        theAction.addComponent(theButton);
        this.actions.add(new MenuEntry(theMenuEntryType, theAction));
    }

    protected ConfigurationManager getConfigurationManager() {
        return ModelManager.getConfigurationManager(this.connectionInfo);
    }

    protected Encryptor getEncryptor() {
        return ModelManager.getConfigurationManager(this.connectionInfo).getEncryptor();
    }

    protected ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }
}

