/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.deploy;

import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ProductType;
import com.metamatrix.common.config.api.ProductTypeID;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConfigurationManager;
import com.metamatrix.console.ui.util.AbstractPanelAction;
import com.metamatrix.console.ui.views.deploy.CreatePSCPanel;
import com.metamatrix.console.ui.views.deploy.DetailPanel;
import com.metamatrix.console.ui.views.deploy.util.DeployPkgUtils;
import com.metamatrix.console.ui.views.deploy.util.DeployTableSorter;
import com.metamatrix.console.ui.views.deploy.util.PropertyConstants;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.DialogWindow;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumn;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumnModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.table.TableColumn;

public final class ProductDefinitionPanel
extends DetailPanel
implements PropertyConstants {
    private static final String[] SERVICES_HDRS = new String[4];
    private static final int PSC_COL = 0;
    private static final int SERVICE_COL = 1;
    private static final int ENABLED_COL = 2;
    private static final int ESSENTIAL_COL = 3;
    private TableWidget tblServices;
    private TextFieldWidget txfProduct;
    private PanelAction actionNew;
    private ProductType product;
    private DefaultTableModel tblModel;

    public ProductDefinitionPanel(ConnectionInfo connectionInfo) {
        super(connectionInfo);
        this.setTitle(this.getString("pdp.title"));
    }

    public ProductDefinitionPanel(ConfigurationID theConfigId, ConnectionInfo connectionInfo) throws ExternalException {
        this(connectionInfo);
        this.setConfigId(theConfigId);
    }

    @Override
    protected JPanel construct(boolean readOnly) {
        JPanel pnl = new JPanel(new GridBagLayout());
        this.actionNew = new PanelAction(4);
        LabelWidget lblProduct = DeployPkgUtils.createLabel("pdp.lblProduct");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        pnl.add((Component)lblProduct, gbc);
        this.txfProduct = DeployPkgUtils.createTextField("productname");
        this.txfProduct.setEditable(false);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        pnl.add((Component)this.txfProduct, gbc);
        JPanel pnlServices = new JPanel(new GridLayout(1, 1));
        TitledBorder tBorder = new TitledBorder(this.getString("pdp.pnlServices.title"));
        pnlServices.setBorder(new CompoundBorder(tBorder, DeployPkgUtils.EMPTY_BORDER));
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        pnl.add((Component)pnlServices, gbc);
        this.tblServices = new TableWidget();
        this.tblModel = DeployPkgUtils.setup(this.tblServices, SERVICES_HDRS, DeployPkgUtils.getInt("pdp.servicestblrows", 10), null);
        this.tblServices.setComparator(new DeployTableSorter());
        JScrollPane spnServices = new JScrollPane(this.tblServices);
        pnlServices.add(spnServices);
        JPanel pnlOps = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(3, 3, 3, 3);
        pnl.add((Component)pnlOps, gbc);
        JPanel pnlOpsSizer = new JPanel(new GridLayout(1, 1, 10, 0));
        pnlOps.add(pnlOpsSizer);
        ButtonWidget btnNew = new ButtonWidget();
        this.setup("action", btnNew, this.actionNew);
        pnlOpsSizer.add(btnNew);
        return pnl;
    }

    @Override
    public void setEnabled(boolean theEnableFlag) {
        this.actionNew.setEnabled(theEnableFlag);
    }

    @Override
    public void setConfigId(ConfigurationID theConfigId) {
        super.setConfigId(theConfigId);
        this.setTitleSuffix(this.getString("pdp.title.suffix"));
    }

    private void sortFirstColumnInTable(TableWidget twidget) {
        EnhancedTableColumnModel etcmTabelCM = twidget.getEnhancedColumnModel();
        TableColumn tColumn = etcmTabelCM.getColumn(0);
        etcmTabelCM.setColumnSortedAscending((EnhancedTableColumn)tColumn, false);
    }

    @Override
    public void setDomainObject(Object theDomainObject, Object[] theAncestors) {
        if (!(theDomainObject instanceof ProductType)) {
            throw new IllegalArgumentException(this.getString("msg.invalidclass", new Object[]{"ProductType", theDomainObject.getClass()}));
        }
        this.product = (ProductType)theDomainObject;
        this.setTitleSuffix(this.product.getName());
        super.setDomainObject(this.product, theAncestors);
        this.txfProduct.setText(this.product.getName());
        Configuration config = (Configuration)theAncestors[0];
        this.tblModel.setNumRows(0);
        try {
            ConfigurationManager configMgr = this.getConfigurationManager();
            Collection pscs = configMgr.getPscDefinitions(this.product, config);
            if (pscs != null) {
                for (ProductServiceConfig psc : pscs) {
                    Collection services = configMgr.getServiceDefinitions(psc, config);
                    if (services == null) continue;
                    for (ServiceComponentDefn service : services) {
                        Vector<Object> row = new Vector<Object>(SERVICES_HDRS.length);
                        row.setSize(SERVICES_HDRS.length);
                        row.setElementAt(psc, 0);
                        row.setElementAt(service, 1);
                        ServiceComponentDefnID svcID = (ServiceComponentDefnID)service.getID();
                        if (!psc.containsService(svcID)) {
                            throw new Exception("Service " + svcID + " not contained in PSC " + psc.getName());
                        }
                        Boolean enabled = new Boolean(psc.isServiceEnabled(svcID));
                        row.setElementAt(enabled, 2);
                        row.setElementAt(new Boolean(service.getProperty(ESSENTIAL_PROP)), 3);
                        this.tblModel.addRow(row);
                    }
                }
            }
            this.tblServices.sizeColumnsToFitData();
            this.sortFirstColumnInTable(this.tblServices);
        }
        catch (Exception theException) {
            ExceptionUtility.showMessage(this.getString("msg.configmgrproblem", new Object[]{this.getClass(), "setDomainObject"}), "" + theException.getMessage(), theException);
            LogManager.logError((String)"PSC-DEPLOYMENT", (Throwable)theException, (String)(this.getClass() + ":setDomainObject"));
        }
    }

    private void newPSC() throws ExternalException {
        Configuration config = this.getConfigurationManager().getConfig(Configuration.NEXT_STARTUP_ID);
        ArrayList<Object> pscServiceNames = null;
        if (this.product.getName().equals("Connectors")) {
            Collection bindings = config.getConnectorBindings();
            if (bindings != null) {
                pscServiceNames = new ArrayList<Object>(bindings.size());
                for (ConnectorBinding cb : bindings) {
                    pscServiceNames.add(cb.getID());
                }
            } else {
                pscServiceNames = Collections.EMPTY_LIST;
            }
        } else {
            Collection d = config.getServiceComponentDefns();
            if (d != null) {
                pscServiceNames = new ArrayList(d.size());
                for (ServiceComponentDefn cd : d) {
                    ServiceComponentDefnID id = (ServiceComponentDefnID)cd.getID();
                    pscServiceNames.add(id);
                }
            } else {
                pscServiceNames = Collections.EMPTY_LIST;
            }
        }
        CreatePSCPanel pnl = new CreatePSCPanel("pfp.msg.createpscdef", "icon.psc.big", "pfp.lblnewpscdef", "pscname", null, pscServiceNames);
        DialogWindow.show(this, DeployPkgUtils.getString("pfp.newpscdefdlg.title"), pnl);
        if (pnl.isConfirmed()) {
            String pscDefName = pnl.getName();
            List services = pnl.getSelectedServices();
            this.getConfigurationManager().createPscDef(pscDefName, (ProductTypeID)this.product.getID(), services, this.getConfigId());
        }
    }

    static {
        ProductDefinitionPanel.SERVICES_HDRS[0] = DeployPkgUtils.getString("pdp.psc.hdr");
        ProductDefinitionPanel.SERVICES_HDRS[1] = DeployPkgUtils.getString("pdp.service.hdr");
        ProductDefinitionPanel.SERVICES_HDRS[2] = DeployPkgUtils.getString("pdp.enabled.hdr");
        ProductDefinitionPanel.SERVICES_HDRS[3] = DeployPkgUtils.getString("pdp.essential.hdr");
    }

    private class PanelAction
    extends AbstractPanelAction {
        public static final int NEW = 4;

        public PanelAction(int theType) {
            super(theType);
            if (theType != 4) {
                throw new IllegalArgumentException(ProductDefinitionPanel.this.getString("msg.invalidactiontype") + theType);
            }
            this.putValue("Name", ProductDefinitionPanel.this.getString("pfp.actionNew"));
            this.putValue("ShortDescription", ProductDefinitionPanel.this.getString("pfp.actionNew.tip"));
            this.setMnemonic(ProductDefinitionPanel.this.getMnemonicChar("pfp.actionNew.mnemonic"));
        }

        @Override
        protected void actionImpl(ActionEvent theEvent) throws ExternalException {
            if (this.type == 4) {
                ProductDefinitionPanel.this.newPSC();
            }
        }
    }
}

