/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.deploy;

import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ProductServiceConfigID;
import com.metamatrix.common.config.api.ProductType;
import com.metamatrix.common.config.api.ProductTypeID;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.ui.NotifyOnExitConsole;
import com.metamatrix.console.ui.util.AbstractPanelAction;
import com.metamatrix.console.ui.views.deploy.ConfirmationPanel;
import com.metamatrix.console.ui.views.deploy.CreatePSCPanel;
import com.metamatrix.console.ui.views.deploy.CreatePanel;
import com.metamatrix.console.ui.views.deploy.DeployMainPanel;
import com.metamatrix.console.ui.views.deploy.DetailPanel;
import com.metamatrix.console.ui.views.deploy.SelectedServiceInfo;
import com.metamatrix.console.ui.views.deploy.ServiceDefinitionPanel;
import com.metamatrix.console.ui.views.deploy.UpdatePSCPanel;
import com.metamatrix.console.ui.views.deploy.event.ConfigurationModifier;
import com.metamatrix.console.ui.views.deploy.util.DeployPkgUtils;
import com.metamatrix.console.ui.views.deploy.util.DeployTableSorter;
import com.metamatrix.console.ui.views.deploy.util.PropertyConstants;
import com.metamatrix.console.util.DialogUtility;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.CheckBox;
import com.metamatrix.toolbox.ui.widget.DialogWindow;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.Splitter;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumn;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumnModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public final class PscDefinitionPanel
extends DetailPanel
implements ActionListener,
ConfigurationModifier,
NotifyOnExitConsole,
ListSelectionListener,
PropertyConstants,
TableModelListener {
    private static String[] SERVICE_HDRS = new String[3];
    private static final int SERV_COL = 0;
    private static final int ENABLED_COL = 1;
    private static final int ESSENTIAL_COL = 2;
    public static SimpleDateFormat DATE_FORMATTER;
    private TableWidget tblServices;
    private TextFieldWidget txfProd;
    private TextFieldWidget txfCreated;
    private TextFieldWidget txfCreatedBy;
    private TextFieldWidget txfModified;
    private TextFieldWidget txfModifiedBy;
    private ServiceDefinitionPanel sdp;
    private DeployMainPanel dmp;
    private PanelAction actionApply;
    private PanelAction actionCopy;
    private PanelAction actionNew;
    private PanelAction actionAssign;
    private PanelAction actionDelete;
    private PanelAction actionReset;
    private ProductServiceConfig pscDef;
    private DefaultTableModel tblModel;
    private ArrayList treeActions;
    private HashMap saveServEnabledMap = new HashMap();
    private int numRowsDifferent = 0;
    private CheckBox chk;
    private boolean programmaticTableSelectionChange = false;
    private Map pscToSelectedServiceMap = new HashMap();
    private boolean deleting = false;

    public PscDefinitionPanel(ConnectionInfo connInfo, DeployMainPanel mainPanel) {
        super(connInfo);
        this.dmp = mainPanel;
        this.setTitle(this.getString("pfp.title"));
    }

    public PscDefinitionPanel(ConfigurationID theConfigId, ConnectionInfo connInfo, DeployMainPanel mainPanel) throws ExternalException {
        this(connInfo, mainPanel);
        this.setConfigId(theConfigId);
    }

    @Override
    public void actionPerformed(ActionEvent theEvent) {
        this.tblModel.setValueAt(new Boolean(this.chk.isSelected()), this.tblServices.convertRowIndexToModel(this.tblServices.getSelectedRow()), 1);
        this.tblServices.editingCanceled(new ChangeEvent(this));
    }

    public void checkResetState() {
        if (this.numRowsDifferent > 0 || this.sdp.propertiesHaveChanged()) {
            if (!this.actionApply.isEnabled()) {
                this.actionApply.setEnabled(true);
                this.actionReset.setEnabled(true);
            }
        } else if (this.actionApply.isEnabled()) {
            this.actionApply.setEnabled(false);
            this.actionReset.setEnabled(false);
        }
    }

    @Override
    protected JPanel construct(boolean readOnly) {
        this.treeActions = new ArrayList();
        this.actionApply = new PanelAction(0);
        this.actionApply.setEnabled(false);
        this.actionCopy = new PanelAction(1);
        this.actionNew = new PanelAction(4);
        this.actionAssign = new PanelAction(5);
        this.actionDelete = new PanelAction(2);
        this.actionReset = new PanelAction(3);
        this.actionReset.setEnabled(false);
        JPanel pnl = new JPanel(new GridBagLayout());
        LabelWidget lblProd = DeployPkgUtils.createLabel("pfp.lblProduct");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 3, 5, 3);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        pnl.add((Component)lblProd, gbc);
        this.txfProd = DeployPkgUtils.createTextField("productname");
        this.txfProd.setEditable(false);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        pnl.add((Component)this.txfProd, gbc);
        LabelWidget lblCreated = DeployPkgUtils.createLabel("pfp.lblCreated");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.anchor = 13;
        pnl.add((Component)lblCreated, gbc);
        this.txfCreated = DeployPkgUtils.createTextField("timestamp");
        this.txfCreated.setEditable(false);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        pnl.add((Component)this.txfCreated, gbc);
        LabelWidget lblCreatedBy = DeployPkgUtils.createLabel("pfp.lblCreatedBy");
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 13;
        pnl.add((Component)lblCreatedBy, gbc);
        this.txfCreatedBy = DeployPkgUtils.createTextField("username");
        this.txfCreatedBy.setEditable(false);
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.anchor = 17;
        pnl.add((Component)this.txfCreatedBy, gbc);
        LabelWidget lblModified = DeployPkgUtils.createLabel("pfp.lblModified");
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 13;
        pnl.add((Component)lblModified, gbc);
        this.txfModified = DeployPkgUtils.createTextField("timestamp");
        this.txfModified.setEditable(false);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 17;
        pnl.add((Component)this.txfModified, gbc);
        LabelWidget lblModifiedBy = DeployPkgUtils.createLabel("pfp.lblModifiedBy");
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.anchor = 13;
        pnl.add((Component)lblModifiedBy, gbc);
        this.txfModifiedBy = DeployPkgUtils.createTextField("username");
        this.txfModifiedBy.setEditable(false);
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.anchor = 17;
        pnl.add((Component)this.txfModifiedBy, gbc);
        JPanel pnlServices = new JPanel(new GridLayout(1, 1));
        TitledBorder tBorder = new TitledBorder(this.getString("pfp.pnlServices.title"));
        pnlServices.setBorder(new CompoundBorder(tBorder, DeployPkgUtils.EMPTY_BORDER));
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.insets = new Insets(3, 3, 5, 3);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        pnl.add((Component)pnlServices, gbc);
        this.tblServices = new TableWidget();
        this.tblModel = DeployPkgUtils.setup(this.tblServices, SERVICE_HDRS, DeployPkgUtils.getInt("pfp.servicestblrows", 10), new int[]{1});
        this.tblServices.getSelectionModel().addListSelectionListener(this);
        this.tblServices.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                PscDefinitionPanel.this.listSelectionChanged();
            }
        });
        this.tblServices.setComparator(new DeployTableSorter());
        this.tblModel.addTableModelListener(this);
        JScrollPane spnServices = new JScrollPane(this.tblServices);
        this.sdp = new ServiceDefinitionPanel(false, this, this.getConfigId(), this.getConnectionInfo());
        final Splitter splitPane = new Splitter(0, true, spnServices, this.sdp);
        pnlServices.add(splitPane);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                splitPane.setDividerLocation(0.5);
            }
        });
        JPanel pnlOps = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(3, 3, 3, 3);
        pnl.add((Component)pnlOps, gbc);
        JPanel pnlOpsSizer = new JPanel(new GridLayout(1, 4, 10, 0));
        pnlOps.add(pnlOpsSizer);
        ButtonWidget btnApply = new ButtonWidget();
        this.setup("action", btnApply, this.actionApply);
        pnlOpsSizer.add(btnApply);
        ButtonWidget btnNew = new ButtonWidget();
        this.setup("action", btnNew, this.actionNew);
        pnlOpsSizer.add(btnNew);
        ButtonWidget btnAssign = new ButtonWidget();
        this.setup("action", btnAssign, this.actionAssign);
        pnlOpsSizer.add(btnAssign);
        ButtonWidget btnCopy = new ButtonWidget();
        this.setup("action", btnCopy, this.actionCopy);
        pnlOpsSizer.add(btnCopy);
        ButtonWidget btnDelete = new ButtonWidget();
        this.setup("action", btnDelete, this.actionDelete);
        pnlOpsSizer.add(btnDelete);
        ButtonWidget btnReset = new ButtonWidget();
        this.setup("action", btnReset, this.actionReset);
        pnlOpsSizer.add(btnReset);
        return pnl;
    }

    private void copy() throws ExternalException {
        CreatePanel pnl = new CreatePanel("pfp.msg.createpscdef", "icon.psc.big", "pfp.lblnewpscdef", "pscname");
        DialogWindow.show(this, DeployPkgUtils.getString("pfp.newpscdefdlg.title"), pnl);
        if (pnl.isConfirmed()) {
            this.getAncestors();
            String pscDefName = pnl.getName();
            this.getConfigurationManager().copyPscDef(pscDefName, this.pscDef, this.getConfigId());
        }
    }

    private void newPSC() throws ExternalException {
        Configuration config = this.getConfigurationManager().getConfig(Configuration.NEXT_STARTUP_ID);
        ArrayList<Object> pscServiceNames = null;
        if (this.pscDef.getComponentTypeID().getName().equals("Connectors")) {
            Collection bindings = config.getConnectorBindings();
            if (bindings != null) {
                pscServiceNames = new ArrayList<Object>(bindings.size());
                for (ConnectorBinding cb : bindings) {
                    pscServiceNames.add(cb.getID());
                }
            } else {
                pscServiceNames = Collections.EMPTY_LIST;
            }
        } else {
            Collection d = config.getServiceComponentDefns();
            if (d != null) {
                pscServiceNames = new ArrayList(d.size());
                for (ServiceComponentDefn cd : d) {
                    ServiceComponentDefnID id = (ServiceComponentDefnID)cd.getID();
                    pscServiceNames.add(id);
                }
            } else {
                pscServiceNames = Collections.EMPTY_LIST;
            }
        }
        CreatePSCPanel pnl = new CreatePSCPanel("pfp.msg.createpscdef", "icon.psc.big", "pfp.lblnewpscdef", "pscname", this.pscDef, pscServiceNames);
        DialogWindow.show(this, DeployPkgUtils.getString("pfp.newpscdefdlg.title"), pnl);
        if (pnl.isConfirmed()) {
            String pscDefName = pnl.getName();
            List services = pnl.getSelectedServices();
            this.getConfigurationManager().createPscDef(pscDefName, (ProductTypeID)this.pscDef.getComponentTypeID(), services, this.getConfigId());
        }
    }

    private void assign() throws ExternalException {
        Configuration config = this.getConfigurationManager().getConfig(Configuration.NEXT_STARTUP_ID);
        ArrayList<Object> pscServiceNames = null;
        if (this.pscDef.getComponentTypeID().getName().equals("Connectors")) {
            Collection bindings = config.getConnectorBindings();
            if (bindings != null) {
                pscServiceNames = new ArrayList<Object>(bindings.size());
                for (ConnectorBinding cb : bindings) {
                    pscServiceNames.add(cb.getID());
                }
            } else {
                pscServiceNames = Collections.EMPTY_LIST;
            }
        } else {
            Collection d = config.getServiceComponentDefns();
            if (d != null) {
                pscServiceNames = new ArrayList(d.size());
                for (ServiceComponentDefn cd : d) {
                    ServiceComponentDefnID id = (ServiceComponentDefnID)cd.getID();
                    pscServiceNames.add(id);
                }
            } else {
                pscServiceNames = Collections.EMPTY_LIST;
            }
        }
        UpdatePSCPanel pnl = new UpdatePSCPanel("pfp.msg.editpscdef", "icon.psc.big", "pfp.lbleditpscdef", "pscname", this.pscDef, pscServiceNames, true);
        DialogWindow.show(this, DeployPkgUtils.getString("pfp.editpscdefdlg.title"), pnl);
        if (pnl.isConfirmed()) {
            List services = pnl.getSelectedServices();
            this.pscDef = this.getConfigurationManager().updatePscDef(this.pscDef, services);
            this.getConfigurationManager().setRefreshNeeded();
            this.dmp.refresh();
        }
    }

    private void delete() throws ExternalException {
        if (this.getConfigurationManager().getConfig(Configuration.NEXT_STARTUP_ID).isPSCDeployed((ProductServiceConfigID)this.pscDef.getID())) {
            String msg = "PSC " + this.pscDef.getID() + " cannot be deleted until it has be undeployed." + "  Please undeploy the PSC and then try again.";
            String hdr = "Deleting PSC";
            StaticUtilities.displayModalDialogWithOK(hdr, msg);
            return;
        }
        ConfirmationPanel pnlConfirm = new ConfirmationPanel("pfp.msg.confirmdelete");
        DialogWindow.show(this, DeployPkgUtils.getString("pfp.confirmdelete.title", new Object[]{this.pscDef.getName()}), pnlConfirm);
        if (pnlConfirm.isConfirmed()) {
            this.deleting = true;
            ProductType product = (ProductType)this.getAncestors()[0];
            this.getConfigurationManager().deletePscDefinition(this.pscDef, product, this.getConfigId());
            this.deleting = false;
        }
    }

    @Override
    public List getTreeActions() {
        return this.treeActions;
    }

    @Override
    public boolean havePendingChanges() {
        return !this.isPersisted();
    }

    @Override
    public boolean finishUp() {
        boolean continuing = true;
        if (this.sdp.propertiesHaveChanged()) {
            continuing = this.savePropertiesForService();
        }
        if (continuing && this.numRowsDifferent > 0) {
            String msg = "Save changes to PSC " + this.pscDef.toString() + "?";
            int response = DialogUtility.showPendingChangesDialog(msg, this.getConfigurationManager().getConnection().getURL(), this.getConfigurationManager().getConnection().getUser());
            switch (response) {
                case 0: {
                    try {
                        this.persist();
                    }
                    catch (ExternalException ex) {
                        String errMsg = "Error saving changes to PSC";
                        LogManager.logError((String)"PSC-DEPLOYMENT", (Throwable)((Object)ex), (String)errMsg);
                        ExceptionUtility.showMessage(errMsg, (Throwable)((Object)ex));
                    }
                    break;
                }
                case 1: {
                    continuing = true;
                    this.reset();
                    break;
                }
                case 2: {
                    continuing = false;
                }
            }
        }
        return continuing;
    }

    @Override
    public boolean isPersisted() {
        boolean persisted = true;
        if (!this.deleting && this.actionApply.isEnabled()) {
            persisted = false;
        }
        return persisted;
    }

    @Override
    public void persist() throws ExternalException {
        if (this.sdp.propertiesHaveChanged()) {
            this.sdp.persist();
        }
        if (this.numRowsDifferent > 0) {
            int rows = this.tblModel.getRowCount();
            for (int i = 0; i < rows; ++i) {
                Object service = this.tblModel.getValueAt(i, 0);
                Boolean saveEnabled = (Boolean)this.saveServEnabledMap.get(service);
                Boolean enabled = (Boolean)this.tblModel.getValueAt(i, 1);
                if (saveEnabled.booleanValue() == enabled.booleanValue()) continue;
                this.getConfigurationManager().setEnabled((ServiceComponentDefn)service, this.pscDef, enabled, this.getConfigurationManager().getConfig(this.getConfigId()));
                this.saveServEnabledMap.put(service, enabled);
            }
            this.numRowsDifferent = 0;
        }
        this.checkResetState();
    }

    @Override
    public void reset() {
        if (this.numRowsDifferent > 0) {
            int rows = this.tblModel.getRowCount();
            for (int i = 0; i < rows; ++i) {
                Object saveEnabled = this.saveServEnabledMap.get(this.tblModel.getValueAt(i, 0));
                if (saveEnabled.equals(this.tblModel.getValueAt(i, 1))) continue;
                this.tblModel.setValueAt(saveEnabled, i, 1);
                this.tblServices.editingCanceled(new ChangeEvent(this));
            }
        }
        this.numRowsDifferent = 0;
        this.sdp.reset();
        this.checkResetState();
    }

    @Override
    public void setConfigId(ConfigurationID theConfigId) {
        super.setConfigId(theConfigId);
        this.setTitleSuffix(this.getString("pfp.title.suffix"));
    }

    private void setCreateModifiedFields(ProductServiceConfig thePsc) {
        Date modDate;
        Date createDate = thePsc.getCreatedDate();
        if (createDate != null) {
            this.txfCreated.setText(DATE_FORMATTER.format(createDate));
            this.txfCreatedBy.setText(thePsc.getCreatedBy());
        }
        if ((modDate = thePsc.getLastChangedDate()) != null) {
            this.txfModified.setText(DATE_FORMATTER.format(modDate));
            this.txfModifiedBy.setText(thePsc.getLastChangedBy());
        }
    }

    private void sortFirstColumnInTable(TableWidget twidget) {
        EnhancedTableColumnModel etcmTabelCM = twidget.getEnhancedColumnModel();
        TableColumn tColumn = etcmTabelCM.getColumn(0);
        etcmTabelCM.setColumnSortedAscending((EnhancedTableColumn)tColumn, false);
    }

    @Override
    public void setDomainObject(Object theDomainObject, Object[] theAncestors) {
        if (theDomainObject instanceof ProductServiceConfig) {
            this.pscDef = (ProductServiceConfig)theDomainObject;
            this.setTitleSuffix(this.pscDef.getName());
            SelectedServiceInfo servInfo = (SelectedServiceInfo)this.pscToSelectedServiceMap.get(this.pscDef);
            if (servInfo == null) {
                this.sdp.displayDetailFor(null, null);
            } else {
                this.sdp.displayDetailFor(servInfo.getService(), servInfo.getAncestors());
            }
        } else {
            throw new IllegalArgumentException(this.getString("msg.invalidclass", new Object[]{"ProductServiceConfig", theDomainObject.getClass()}));
        }
        super.setDomainObject(this.pscDef, theAncestors);
        this.setCreateModifiedFields(this.pscDef);
        this.saveServEnabledMap.clear();
        this.tblModel.setNumRows(0);
        try {
            ProductType product = (ProductType)theAncestors[0];
            this.txfProd.setText(product.getName());
            Configuration config = this.getConfigurationManager().getConfig(this.getConfigId());
            Collection services = this.getConfigurationManager().getServiceDefinitions(this.pscDef, config);
            if (services != null) {
                for (ServiceComponentDefn service : services) {
                    Vector<Object> row = new Vector<Object>(SERVICE_HDRS.length);
                    row.setSize(SERVICE_HDRS.length);
                    row.setElementAt(service, 0);
                    ServiceComponentDefnID svcID = (ServiceComponentDefnID)service.getID();
                    if (!this.pscDef.containsService(svcID)) {
                        throw new Exception("Service " + svcID + " not contained in PSC " + this.pscDef.getName());
                    }
                    Boolean enabled = new Boolean(this.pscDef.isServiceEnabled(svcID));
                    row.setElementAt(enabled, 1);
                    this.saveServEnabledMap.put(service, enabled);
                    row.setElementAt(new Boolean(service.getProperty(ESSENTIAL_PROP)), 2);
                    this.tblModel.addRow(row);
                }
            }
            this.tblServices.sizeColumnsToFitData();
            this.sortFirstColumnInTable(this.tblServices);
        }
        catch (Exception theException) {
            ExceptionUtility.showMessage(this.getString("msg.configmgrproblem", new Object[]{this.getClass(), "setDomainObject"}), theException);
            LogManager.logError((String)"PSC-DEPLOYMENT", (Throwable)theException, (String)(this.getClass() + ":setDomainObject"));
        }
    }

    @Override
    public void setEnabled(boolean theEnableFlag) {
        this.actionCopy.setEnabled(theEnableFlag);
        this.actionNew.setEnabled(theEnableFlag);
        this.actionAssign.setEnabled(theEnableFlag);
        this.actionDelete.setEnabled(theEnableFlag);
        this.tblServices.setColumnEditable(1, theEnableFlag);
    }

    @Override
    public void tableChanged(TableModelEvent theEvent) {
        if (theEvent.getColumn() == 1) {
            int row = theEvent.getFirstRow();
            Object service = this.tblModel.getValueAt(row, 0);
            Object saveEnabled = this.saveServEnabledMap.get(service);
            if (!saveEnabled.equals(this.tblModel.getValueAt(row, 1))) {
                ++this.numRowsDifferent;
            } else if (this.numRowsDifferent > 0) {
                --this.numRowsDifferent;
            }
            this.checkResetState();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent theEvent) {
        int row;
        if (!this.programmaticTableSelectionChange && (row = this.tblServices.getSelectedRow()) != -1) {
            TableCellEditor editor = this.tblServices.getCellEditor(row, 1);
            int modelRow = this.tblServices.convertRowIndexToModel(row);
            this.chk = (CheckBox)editor.getTableCellEditorComponent(this.tblServices, this.tblServices.getValueAt(modelRow, 1), true, row, 1);
            this.chk.addActionListener(this);
            this.tblServices.getSelectionModel().removeListSelectionListener(this);
        }
    }

    private void listSelectionChanged() {
        if (!this.programmaticTableSelectionChange) {
            boolean cancellingChange = false;
            if (this.sdp.propertiesHaveChanged()) {
                boolean bl = cancellingChange = !this.savePropertiesForService();
            }
            if (cancellingChange) {
                int prevModelRow = this.getModelRowForService(this.sdp.getService());
                int prevViewRow = this.tblServices.convertRowIndexToView(prevModelRow);
                this.programmaticTableSelectionChange = true;
                this.tblServices.getSelectionModel().setSelectionInterval(prevViewRow, prevViewRow);
                this.programmaticTableSelectionChange = false;
            } else {
                int row = this.tblServices.getSelectedRow();
                if (row < 0) {
                    this.pscToSelectedServiceMap.put(this.pscDef, null);
                    this.sdp.displayDetailFor(null, null);
                } else {
                    int modelRow = this.tblServices.convertRowIndexToModel(row);
                    ServiceComponentDefn serviceDef = this.getServiceDefForRow(modelRow);
                    Object[] ancestors = this.getAncestors();
                    this.pscToSelectedServiceMap.put(this.pscDef, new SelectedServiceInfo(serviceDef, ancestors));
                    this.sdp.displayDetailFor(serviceDef, ancestors);
                }
            }
        }
    }

    private boolean savePropertiesForService() {
        boolean cancellingChange = false;
        String msg = "Save changes to properties for service " + this.sdp.getService().toString() + "?";
        int response = DialogUtility.showPendingChangesDialog(msg, this.getConfigurationManager().getConnection().getURL(), this.getConfigurationManager().getConnection().getUser());
        switch (response) {
            case 0: {
                try {
                    this.sdp.persist();
                }
                catch (ExternalException ex) {
                    String errMsg = "Error saving service property changes";
                    LogManager.logError((String)"PSC-DEPLOYMENT", (Throwable)((Object)ex), (String)errMsg);
                    ExceptionUtility.showMessage(errMsg, (Throwable)((Object)ex));
                }
                cancellingChange = false;
                break;
            }
            case 1: {
                cancellingChange = true;
                this.reset();
                break;
            }
            case 2: {
                cancellingChange = true;
            }
        }
        return !cancellingChange;
    }

    private int getModelRowForService(ServiceComponentDefn service) {
        int matchRow = -1;
        int curRow = 0;
        int numRows = this.tblServices.getRowCount();
        while (matchRow < 0 && curRow < numRows) {
            ServiceComponentDefn curService = (ServiceComponentDefn)this.tblModel.getValueAt(curRow, 0);
            if (curService.equals(service)) {
                matchRow = curRow;
                continue;
            }
            ++curRow;
        }
        return matchRow;
    }

    private ServiceComponentDefn getServiceDefForRow(int modelRow) {
        ServiceComponentDefn def = (ServiceComponentDefn)this.tblModel.getValueAt(modelRow, 0);
        return def;
    }

    static {
        PscDefinitionPanel.SERVICE_HDRS[0] = DeployPkgUtils.getString("pfp.service.hdr");
        PscDefinitionPanel.SERVICE_HDRS[1] = DeployPkgUtils.getString("pfp.enabled.hdr");
        PscDefinitionPanel.SERVICE_HDRS[2] = DeployPkgUtils.getString("pfp.essential.hdr");
        String pattern = DeployPkgUtils.getString("pfp.datepattern", true);
        if (pattern == null) {
            pattern = "MMM dd, yyyy hh:mm:ss";
        }
        DATE_FORMATTER = new SimpleDateFormat(pattern);
    }

    private class PanelAction
    extends AbstractPanelAction {
        public static final int APPLY = 0;
        public static final int COPY = 1;
        public static final int DELETE = 2;
        public static final int RESET = 3;
        public static final int NEW = 4;
        public static final int ASSIGN = 5;

        public PanelAction(int theType) {
            super(theType);
            if (theType == 0) {
                this.putValue("Name", PscDefinitionPanel.this.getString("pfp.actionApply"));
                this.putValue("ShortDescription", PscDefinitionPanel.this.getString("pfp.actionApply.tip"));
                this.setMnemonic(PscDefinitionPanel.this.getMnemonicChar("pfp.actionApply.mnemonic"));
            } else if (theType == 1) {
                this.putValue("Name", PscDefinitionPanel.this.getString("pfp.actionCopy"));
                this.putValue("ShortDescription", PscDefinitionPanel.this.getString("pfp.actionCopy.tip"));
                this.setMnemonic(PscDefinitionPanel.this.getMnemonicChar("pfp.actionCopy.mnemonic"));
            } else if (theType == 2) {
                this.putValue("Name", PscDefinitionPanel.this.getString("pfp.actionDelete"));
                this.putValue("ShortDescription", PscDefinitionPanel.this.getString("pfp.actionDelete.tip"));
                this.setMnemonic(PscDefinitionPanel.this.getMnemonicChar("pfp.actionDelete.mnemonic"));
            } else if (theType == 3) {
                this.putValue("Name", PscDefinitionPanel.this.getString("pfp.actionReset"));
                this.putValue("ShortDescription", PscDefinitionPanel.this.getString("pfp.actionReset.tip"));
                this.setMnemonic(PscDefinitionPanel.this.getMnemonicChar("pfp.actionReset.mnemonic"));
            } else if (theType == 4) {
                this.putValue("Name", PscDefinitionPanel.this.getString("pfp.actionNew"));
                this.putValue("ShortDescription", PscDefinitionPanel.this.getString("pfp.actionNew.tip"));
                this.setMnemonic(PscDefinitionPanel.this.getMnemonicChar("pfp.actionNew.mnemonic"));
            } else if (theType == 5) {
                this.putValue("Name", PscDefinitionPanel.this.getString("pfp.actionEdit"));
                this.putValue("ShortDescription", PscDefinitionPanel.this.getString("pfp.actionEdit.tip"));
                this.setMnemonic(PscDefinitionPanel.this.getMnemonicChar("pfp.actionEdit.mnemonic"));
            } else {
                throw new IllegalArgumentException(PscDefinitionPanel.this.getString("msg.invalidactiontype") + theType);
            }
        }

        @Override
        protected void actionImpl(ActionEvent theEvent) throws ExternalException {
            if (this.type == 0) {
                PscDefinitionPanel.this.persist();
            } else if (this.type == 4) {
                PscDefinitionPanel.this.newPSC();
            } else if (this.type == 5) {
                PscDefinitionPanel.this.assign();
            } else if (this.type == 1) {
                PscDefinitionPanel.this.copy();
            } else if (this.type == 2) {
                PscDefinitionPanel.this.delete();
            } else if (this.type == 3) {
                PscDefinitionPanel.this.reset();
            }
        }
    }
}

