/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.deploy;

import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.ui.views.deploy.DetailPanel;
import com.metamatrix.console.ui.views.deploy.util.DeployPkgUtils;
import com.metamatrix.console.ui.views.deploy.util.DeployTableSorter;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumn;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumnModel;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.table.TableColumn;

public final class PscSummaryPanel
extends DetailPanel {
    private TableWidget tblPscs;
    private Configuration config;
    private DefaultTableModel pscsTblModel;
    private ConnectionInfo connection;

    public PscSummaryPanel(ConnectionInfo connInfo) {
        super(connInfo);
        this.connection = connInfo;
        this.setTitle(this.getString("psp.title"));
    }

    public PscSummaryPanel(ConfigurationID theConfigId, ConnectionInfo connInfo) throws ExternalException {
        this(connInfo);
        this.setConfigId(theConfigId);
    }

    @Override
    protected JPanel construct(boolean readOnly) {
        JPanel pnl = new JPanel(new GridLayout(1, 1));
        TitledBorder tBorder = new TitledBorder(this.getString("psp.pnl.title"));
        pnl.setBorder(new CompoundBorder(tBorder, DeployPkgUtils.EMPTY_BORDER));
        this.tblPscs = new TableWidget();
        this.pscsTblModel = DeployPkgUtils.setup(this.tblPscs, DeployPkgUtils.PSC_SERV_DEF_HDRS, DeployPkgUtils.getInt("psp.psctblrows", 10), null);
        this.tblPscs.setComparator(new DeployTableSorter());
        JScrollPane spnPscs = new JScrollPane(this.tblPscs);
        pnl.add(spnPscs);
        return pnl;
    }

    private void sortFirstColumnInTable(TableWidget twidget) {
        EnhancedTableColumnModel etcmTabelCM = twidget.getEnhancedColumnModel();
        TableColumn tColumn = etcmTabelCM.getColumn(0);
        etcmTabelCM.setColumnSortedAscending((EnhancedTableColumn)tColumn, false);
    }

    @Override
    public void setDomainObject(Object theDomainObject, Object[] theAncestors) {
        if (!(theDomainObject instanceof Configuration)) {
            throw new IllegalArgumentException(this.getString("msg.invalidclass", new Object[]{"Configuration", theDomainObject.getClass()}));
        }
        this.config = (Configuration)theDomainObject;
        super.setDomainObject(this.config, theAncestors);
        try {
            DeployPkgUtils.loadPscServiceDefintions(this.config, this.pscsTblModel, this.connection);
            this.tblPscs.sizeColumnsToFitData();
            this.sortFirstColumnInTable(this.tblPscs);
        }
        catch (ExternalException theException) {
            ExceptionUtility.showMessage(this.getString("msg.configmgrproblem", new Object[]{this.getClass(), "setDomainObject"}), "" + theException.getMessage(), (Throwable)((Object)theException));
            LogManager.logError((String)"PSC-DEPLOYMENT", (Throwable)((Object)theException), (String)(this.getClass() + ":setDomainObject"));
        }
    }
}

