/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.deploy;

import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ProductType;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConfigurationPropertiedObjectEditor;
import com.metamatrix.console.security.UserCapabilities;
import com.metamatrix.console.ui.util.AbstractPanelAction;
import com.metamatrix.console.ui.views.deploy.DetailPanel;
import com.metamatrix.console.ui.views.deploy.PscDefinitionPanel;
import com.metamatrix.console.ui.views.deploy.event.ConfigurationModifier;
import com.metamatrix.console.ui.views.deploy.util.DeployPkgUtils;
import com.metamatrix.console.ui.views.deploy.util.PropertyConstants;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.CheckBox;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import com.metamatrix.toolbox.ui.widget.property.PropertiedObjectPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;

public final class ServiceDefinitionPanel
extends DetailPanel
implements ActionListener,
ConfigurationModifier,
PropertyChangeListener,
PropertyConstants {
    private CheckBox chkEnabled;
    private CheckBox chkEssential;
    private ServiceDefPOP pnlProps;
    private JPanel pnlPropsOuter;
    private TextFieldWidget txfProd;
    private TextFieldWidget txfPsc;
    private TextFieldWidget txfService;
    private PanelAction actionApply;
    private PanelAction actionReset;
    private ConfigurationPropertiedObjectEditor propEditor;
    private boolean saveEnabled;
    private ServiceComponentDefn service;
    private HashMap propValueMap = new HashMap();
    private PropertiedObject propObj;
    private HashMap propDefsMap = new HashMap();
    private boolean propsDifferent = false;
    private Set changedPropertyNames = new HashSet();
    private boolean propsDifferentRequiresRestart = false;
    private PscDefinitionPanel parentPanel;
    private boolean editMode;

    public ServiceDefinitionPanel(boolean includingHdr, PscDefinitionPanel parentPanel, ConfigurationID theConfigId, ConnectionInfo connInfo) {
        super(includingHdr, connInfo);
        this.parentPanel = parentPanel;
        this.setTitle(this.getString("sdp.title"));
        this.setConfigId(theConfigId);
        this.editMode = UserCapabilities.getInstance().canUpdateConfiguration(connInfo);
    }

    @Override
    public void actionPerformed(ActionEvent theEvent) {
        this.checkResetState();
    }

    private void checkResetState() {
        if (this.includingHdr()) {
            if (this.isPropertiesValid() && (this.propsDifferent || this.chkEnabled.isSelected() != this.saveEnabled)) {
                if (!this.actionApply.isEnabled()) {
                    this.actionApply.setEnabled(true);
                    this.actionReset.setEnabled(true);
                }
            } else if (this.actionApply.isEnabled()) {
                this.actionApply.setEnabled(false);
                this.actionReset.setEnabled(false);
            }
        } else {
            this.parentPanel.checkResetState();
        }
    }

    @Override
    protected JPanel construct(boolean readOnly) {
        this.actionApply = new PanelAction(0);
        this.actionApply.setEnabled(false);
        this.actionReset = new PanelAction(1);
        this.actionReset.setEnabled(false);
        JPanel pnl = new JPanel(new GridBagLayout());
        LabelWidget lblProd = DeployPkgUtils.createLabel("sdp.lblProd");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 3, 10, 3);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        if (this.includingHdr()) {
            pnl.add((Component)lblProd, gbc);
        }
        this.txfProd = DeployPkgUtils.createTextField("productname");
        this.txfProd.setEditable(false);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        if (this.includingHdr()) {
            pnl.add((Component)this.txfProd, gbc);
        }
        LabelWidget lblPsc = DeployPkgUtils.createLabel("sdp.lblPsc");
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        if (this.includingHdr()) {
            pnl.add((Component)lblPsc, gbc);
        }
        this.txfPsc = DeployPkgUtils.createTextField("pscname");
        this.txfPsc.setEditable(false);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weightx = 0.2;
        gbc.weighty = 0.0;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        if (this.includingHdr()) {
            pnl.add((Component)this.txfPsc, gbc);
        }
        LabelWidget lblService = DeployPkgUtils.createLabel("sdp.lblService");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.anchor = 13;
        if (this.includingHdr()) {
            pnl.add((Component)lblService, gbc);
        }
        this.txfService = DeployPkgUtils.createTextField("servicename");
        this.txfService.setEditable(false);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 0.3;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        if (this.includingHdr()) {
            pnl.add((Component)this.txfService, gbc);
        }
        LabelWidget lblEnabled = DeployPkgUtils.createLabel("sdp.lblEnabled");
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        if (this.includingHdr()) {
            pnl.add((Component)lblEnabled, gbc);
        }
        this.chkEnabled = new CheckBox();
        this.chkEnabled.addActionListener(this);
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.anchor = 17;
        if (this.includingHdr()) {
            pnl.add((Component)this.chkEnabled, gbc);
        }
        LabelWidget lblEssential = DeployPkgUtils.createLabel("sdp.lblEssential");
        gbc.gridx = 4;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        if (this.includingHdr()) {
            pnl.add((Component)lblEssential, gbc);
        }
        this.chkEssential = new CheckBox();
        this.chkEssential.setEnabled(false);
        gbc.gridx = 5;
        gbc.gridy = 1;
        gbc.anchor = 17;
        if (this.includingHdr()) {
            pnl.add((Component)this.chkEssential, gbc);
        }
        this.pnlPropsOuter = new JPanel(new GridLayout(1, 1));
        this.setPnlPropsOuterBorder(null);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.insets = this.includingHdr() ? new Insets(3, 3, 20, 3) : new Insets(0, 0, 0, 0);
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        pnl.add((Component)this.pnlPropsOuter, gbc);
        JPanel pnlOps = new JPanel();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.fill = 0;
        gbc.anchor = 10;
        gbc.insets = this.includingHdr() ? new Insets(3, 3, 3, 3) : new Insets(0, 0, 0, 0);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        pnl.add((Component)pnlOps, gbc);
        if (this.includingHdr()) {
            JPanel pnlOpsSizer = new JPanel(new GridLayout(1, 2, 10, 0));
            pnlOps.add(pnlOpsSizer);
            ButtonWidget btnApply = new ButtonWidget();
            this.setup("action", btnApply, this.actionApply);
            pnlOpsSizer.add(btnApply);
            ButtonWidget btnReset = new ButtonWidget();
            this.setup("action", btnReset, this.actionReset);
            pnlOpsSizer.add(btnReset);
        }
        try {
            this.propEditor = this.getConfigurationManager().getPropertiedObjectEditor();
            this.pnlProps = new ServiceDefPOP(this.propEditor);
            this.pnlProps.setReadOnlyForced(readOnly);
            this.pnlProps.createComponent();
            this.pnlProps.setColumnHeaderNames(this.getString("pop.propertyname.hdr"), this.getString("pop.propertyvalue.hdr"));
            this.pnlProps.addPropertyChangeListener(this);
            this.pnlProps.setShowInvalidProperties(true);
            this.pnlProps.setShowRequiredProperties(true);
            this.pnlProps.setShowExpertProperties(true);
            this.pnlPropsOuter.add(this.pnlProps);
        }
        catch (ExternalException theException) {
            throw new IllegalStateException(this.getString("msg.configmgrproblem", new Object[]{this.getClass(), "construct"}));
        }
        return pnl;
    }

    private void setPnlPropsOuterBorder(String serviceName) {
        String title = serviceName == null ? "Properties" : "Properties of " + serviceName;
        TitledBorder tBorder = new TitledBorder(title);
        if (this.includingHdr()) {
            this.pnlPropsOuter.setBorder(new CompoundBorder(tBorder, DeployPkgUtils.EMPTY_BORDER));
        } else {
            this.pnlPropsOuter.setBorder(tBorder);
        }
    }

    private boolean equivalent(Object theValue, Object theOtherValue) {
        return theValue == null && theOtherValue == null || theValue != null && theOtherValue != null && theValue.equals(theOtherValue);
    }

    @Override
    public boolean isPersisted() {
        boolean persisted = this.includingHdr() ? !this.actionApply.isEnabled() : this.parentPanel.isPersisted();
        return persisted;
    }

    private boolean isPropertiesValid() {
        return this.pnlProps.getInvalidDefinitions().isEmpty();
    }

    @Override
    public void persist() throws ExternalException {
        if (this.includingHdr() && this.saveEnabled != this.chkEnabled.isSelected()) {
            this.saveEnabled = this.chkEnabled.isSelected();
        }
        if (this.propsDifferent) {
            String message = "Note change will not take effect until service/connector is restarted in the Runtime panel.";
            if (this.propsDifferentRequiresRestart) {
                message = message + "\n\nYou have changed some properties marked \"[REQUIRES RESTART]\".  These properties will not take effect until the server is restarted or bounced.";
            }
            StaticUtilities.displayModalDialogWithOK("Modify Service Properties", message);
            this.getConfigurationManager().modifyPropertiedObject(this.propEditor);
            this.propValueMap.clear();
            this.propsDifferent = false;
            this.propsDifferentRequiresRestart = false;
            this.changedPropertyNames.clear();
        }
        this.checkResetState();
    }

    @Override
    public void propertyChange(PropertyChangeEvent theEvent) {
        String eventProp = theEvent.getPropertyName();
        if (this.propValueMap.containsKey(eventProp)) {
            Object current;
            boolean different;
            Object original = this.propValueMap.get(eventProp);
            boolean bl = different = !this.equivalent(original, current = theEvent.getNewValue());
            if (different) {
                this.changedPropertyNames.add(eventProp);
            } else {
                this.changedPropertyNames.remove(eventProp);
            }
        } else {
            this.propValueMap.put(eventProp, theEvent.getOldValue());
            this.changedPropertyNames.add(eventProp);
        }
        this.propsDifferent = this.changedPropertyNames.size() > 0;
        this.propsDifferentRequiresRestart = this.checkPropsDifferentRequiresRestart();
        this.checkResetState();
    }

    private boolean checkPropsDifferentRequiresRestart() {
        if (this.propsDifferent) {
            for (String prop : this.changedPropertyNames) {
                PropertyDefinition def = (PropertyDefinition)this.propDefsMap.get(prop);
                if (def == null || !def.getRequiresRestart()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean propertiesHaveChanged() {
        return this.propsDifferent;
    }

    @Override
    public void reset() {
        if (this.chkEnabled.isSelected() != this.saveEnabled) {
            this.chkEnabled.setSelected(this.saveEnabled);
        }
        if (this.propsDifferent) {
            this.resetPropertiedObject();
        }
        this.checkResetState();
    }

    private void resetPropertiedObject() {
        this.propsDifferent = false;
        this.propsDifferentRequiresRestart = false;
        this.changedPropertyNames.clear();
        for (String prop : this.propValueMap.keySet()) {
            PropertyDefinition def = (PropertyDefinition)this.propDefsMap.get(prop);
            this.propEditor.setValue(this.propObj, def, this.propValueMap.get(prop));
        }
        this.pnlProps.refreshDisplay();
        this.propValueMap.clear();
    }

    private void savePropertyDefinitions() {
        if (this.propObj != null) {
            List defs = this.propEditor.getPropertyDefinitions(this.propObj);
            for (PropertyDefinition def : defs) {
                this.propDefsMap.put(def.getName(), def);
            }
        }
    }

    @Override
    public void setConfigId(ConfigurationID theConfigId) {
        super.setConfigId(theConfigId);
        this.setTitleSuffix(this.getString("sdp.title.suffix"));
    }

    public ServiceComponentDefn getService() {
        return this.service;
    }

    public void displayDetailFor(ServiceComponentDefn serviceDef, Object[] theAncestors) {
        this.setDomainObject(serviceDef, theAncestors);
    }

    @Override
    public void setDomainObject(Object theDomainObject, Object[] theAncestors) {
        if (theDomainObject instanceof ServiceComponentDefn) {
            this.service = (ServiceComponentDefn)theDomainObject;
            this.setTitleSuffix(this.service.toString());
            this.setPnlPropsOuterBorder(this.service.toString());
        } else {
            if (theDomainObject != null) {
                throw new IllegalArgumentException(this.getString("msg.invalidclass", new Object[]{"ServiceComponentDefn", theDomainObject.getClass()}));
            }
            this.service = null;
            this.setPnlPropsOuterBorder(null);
        }
        super.setDomainObject(this.service, theAncestors);
        if (this.includingHdr()) {
            ProductServiceConfig psc = (ProductServiceConfig)theAncestors[0];
            this.txfPsc.setText(psc.getName());
            this.txfService.setText(this.service.toString());
            String essential = this.service.getProperty(ESSENTIAL_PROP);
            if (essential == null) {
                essential = "";
            }
            this.chkEssential.setSelected(new Boolean(essential));
            ProductType product = this.getConfigurationManager().getProduct(psc);
            this.txfProd.setText(product.getName());
            ServiceComponentDefnID svcID = (ServiceComponentDefnID)this.service.getID();
            if (!psc.containsService(svcID)) {
                throw new IllegalArgumentException("Service " + svcID + " not contained in PSC " + psc.getName());
            }
            this.saveEnabled = psc.isServiceEnabled((ServiceComponentDefnID)this.service.getID());
            this.chkEnabled.setSelected(this.saveEnabled);
        }
        this.propDefsMap.clear();
        this.propValueMap.clear();
        if (theDomainObject != null) {
            this.propObj = this.getConfigurationManager().getPropertiedObjectForComponentObject((ComponentObject)this.service);
            this.pnlProps.setNameColumnHeaderWidth(0);
            this.pnlProps.setPropertiedObject(this.propObj);
            this.setEnabled(this.editMode && this.getConfigurationManager().isEditable(this.service.getConfigurationID()));
        } else {
            this.propObj = null;
            this.pnlProps.setPropertiedObject(null);
        }
        this.pnlProps.resizeNameColumn();
        this.savePropertyDefinitions();
    }

    @Override
    public void setEnabled(boolean theEnableFlag) {
        this.chkEnabled.setEnabled(theEnableFlag);
        this.pnlProps.setReadOnlyForced(!theEnableFlag);
        this.pnlProps.refreshDisplay();
    }

    class ServiceDefPOP
    extends PropertiedObjectPanel {
        public ServiceDefPOP(PropertiedObjectEditor poe) {
            super(poe, ServiceDefinitionPanel.this.getEncryptor());
        }

        @Override
        public void resizeNameColumn() {
            super.resizeNameColumn();
        }
    }

    private class PanelAction
    extends AbstractPanelAction {
        public static final int APPLY = 0;
        public static final int RESET = 1;

        public PanelAction(int theType) {
            super(theType);
            if (theType == 0) {
                this.putValue("Name", ServiceDefinitionPanel.this.getString("sdp.actionApply"));
                this.putValue("ShortDescription", ServiceDefinitionPanel.this.getString("sdp.actionApply.tip"));
                this.setMnemonic(ServiceDefinitionPanel.this.getMnemonicChar("sdp.actionApply.mnemonic"));
            } else if (theType == 1) {
                this.putValue("Name", ServiceDefinitionPanel.this.getString("sdp.actionReset"));
                this.putValue("ShortDescription", ServiceDefinitionPanel.this.getString("sdp.actionReset.tip"));
                this.setMnemonic(ServiceDefinitionPanel.this.getMnemonicChar("sdp.actionReset.mnemonic"));
            } else {
                throw new IllegalArgumentException(ServiceDefinitionPanel.this.getString("msg.invalidactiontype") + theType);
            }
        }

        @Override
        protected void actionImpl(ActionEvent theEvent) throws ExternalException {
            if (this.type == 0) {
                ServiceDefinitionPanel.this.persist();
            } else if (this.type == 1) {
                ServiceDefinitionPanel.this.reset();
            }
        }
    }
}

