/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.deploy;

import com.metamatrix.common.config.api.ComponentDefnID;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.ui.views.deploy.ConfirmationPanel;
import com.metamatrix.console.ui.views.deploy.util.DeployPkgUtils;
import com.metamatrix.toolbox.ui.widget.AccumulatorPanel;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class UpdatePSCPanel
extends ConfirmationPanel
implements ActionListener,
DocumentListener {
    private static final KeyStroke ENTER_RELEASED = KeyStroke.getKeyStroke(10, 0, true);
    private TextFieldWidget txf;
    private ButtonWidget btnCreate;
    private AccumulatorPanel pnlAssignments;
    private ProductServiceConfig pscDef;
    private List serviceNames;

    public UpdatePSCPanel(String theMessageId, String theIconId, String theLabelId, String theNameTypeId, ProductServiceConfig psc, List serviceNames, boolean editPSC) {
        super(theMessageId, theIconId, !editPSC ? "rp.btnCreate" : "rp.btnApply", "rp.btnCancel");
        this.init(theLabelId, theNameTypeId, psc, serviceNames);
        if (editPSC) {
            this.txf.setText(psc.getName());
            this.txf.setEditable(false);
        }
    }

    public UpdatePSCPanel(String theMessageId, String theIconId, String theLabelId, String theNameTypeId, ProductServiceConfig psc, List serviceNames) {
        super(theMessageId, theIconId, "rp.btnCreate", "rp.btnCancel");
        this.init(theLabelId, theNameTypeId, psc, serviceNames);
    }

    private void init(String theLabelId, String theNameTypeId, ProductServiceConfig psc, List serviceNames) {
        this.pscDef = psc;
        this.serviceNames = serviceNames;
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel pnl = new JPanel();
        LabelWidget lbl = new LabelWidget(DeployPkgUtils.getString(theLabelId));
        pnl.add(lbl);
        this.txf = DeployPkgUtils.createTextField(theNameTypeId);
        this.txf.getDocument().addDocumentListener(this);
        this.txf.registerKeyboardAction(this, ENTER_RELEASED, 0);
        pnl.add(this.txf);
        mainPanel.add((Component)pnl, "North");
        mainPanel.add((Component)this.createAssignmentPanel(), "Center");
        this.addContent(mainPanel);
        this.btnCreate = this.getAcceptButton();
        this.btnCreate.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent theEvent) {
        this.btnCreate.doClick();
    }

    @Override
    public void changedUpdate(DocumentEvent theEvent) {
        if (this.txf.getText().length() > 0 && !this.btnCreate.isEnabled()) {
            this.btnCreate.setEnabled(true);
        } else if (this.txf.getText().length() == 0 && this.btnCreate.isEnabled()) {
            this.btnCreate.setEnabled(false);
        }
    }

    @Override
    public String getName() {
        return this.txf.getText();
    }

    @Override
    public void insertUpdate(DocumentEvent theEvent) {
        this.changedUpdate(theEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent theEvent) {
        this.changedUpdate(theEvent);
    }

    private JPanel createAssignmentPanel() {
        JPanel pnl = new JPanel(new GridLayout(1, 1));
        ArrayList<ComponentDefnID> currNames = null;
        if (this.pscDef != null) {
            Iterator itIds = this.pscDef.getServiceComponentDefnIDs().iterator();
            currNames = new ArrayList<ComponentDefnID>(this.pscDef.getServiceComponentDefnIDs().size());
            while (itIds.hasNext()) {
                ComponentDefnID id = (ComponentDefnID)itIds.next();
                currNames.add(id);
            }
        } else {
            currNames = Collections.EMPTY_LIST;
        }
        if (this.serviceNames == null) {
            Exception theException = new Exception("Null ServiceNames");
            theException.printStackTrace();
            LogManager.logError((String)"USERS", (Throwable)theException, (String)"Error calling UserManager.getRoles()");
            return pnl;
        }
        Collections.sort(this.serviceNames);
        if (!currNames.isEmpty()) {
            Collections.sort(currNames);
        }
        this.pnlAssignments = new AccumulatorPanel(this.serviceNames, currNames);
        this.pnlAssignments.getAcceptButton().setVisible(false);
        this.pnlAssignments.getCancelButton().setVisible(true);
        this.pnlAssignments.setAllowsReorderingValues(false);
        this.pnlAssignments.setInitialValues(currNames);
        this.pnlAssignments.setMinimumValuesAllowed(DeployPkgUtils.getInt("rp.minselected", 0));
        this.pnlAssignments.remove(this.pnlAssignments.getNavigationBar());
        this.pnlAssignments.getAvailableValuesHeader().setText(DeployPkgUtils.getString("rp.avail.hdr"));
        this.pnlAssignments.getValuesHeader().setText(DeployPkgUtils.getString("rp.select.hdr"));
        pnl.add(this.pnlAssignments);
        return pnl;
    }

    public List getSelectedServices() {
        return this.pnlAssignments.getValues();
    }
}

