/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.deploy.event;

import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ProductType;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.VMComponentDefn;
import java.util.EventObject;

public class ConfigurationChangeEvent
extends EventObject {
    public static final int DELETED = 1;
    public static final int MODIFIED = 2;
    public static final int NEW = 4;
    public static final int REFRESH_START = 8;
    public static final int REFRESH_END = 16;
    protected static final int CONFIGURATION = 32;
    protected static final int HOST = 64;
    protected static final int PROCESS = 128;
    protected static final int DEPLOYED_PSC = 256;
    protected static final int DEPLOYED_SERVICE = 512;
    protected static final int PRODUCT = 1024;
    protected static final int PSC_DEFN = 2048;
    protected static final int SERVICE_DEFN = 4096;
    protected int type;
    protected Object[] ancestors;
    private Configuration config;

    protected ConfigurationChangeEvent(int theType, Object theChangedObject, Configuration theConfig) {
        super(theChangedObject);
        if (theChangedObject == null) {
            throw new IllegalArgumentException("Object cannot be null.");
        }
        if (theConfig == null) {
            throw new IllegalArgumentException("Configuration cannot be null.");
        }
        if (theType != 1 && theType != 2 && theType != 4 && theType != 8 && theType != 16) {
            throw new IllegalArgumentException("Invalid event type <" + theType + ">.");
        }
        this.config = theConfig;
        this.type = theType;
    }

    public ConfigurationChangeEvent(int theType, Object theChangedObject, Configuration theConfig, Object[] theAncestors) {
        this(theType, theChangedObject, theConfig);
        this.setAncestors(theAncestors);
    }

    public ConfigurationChangeEvent(int theRefreshType, Object theSource) {
        super(theSource);
        if (theRefreshType != 8 && theRefreshType != 16) {
            throw new IllegalArgumentException("Invalid refresh event type <" + theRefreshType + ">.");
        }
        this.type = theRefreshType;
    }

    public Object[] getAncestors() {
        return this.ancestors;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public ProductServiceConfig getDeployedPsc() {
        ProductServiceConfig psc = null;
        if (this.isDeployedPscChange()) {
            psc = (ProductServiceConfig)this.getSource();
        } else {
            int index = this.getAncestorIndex(256);
            if (index != -1) {
                psc = (ProductServiceConfig)this.ancestors[index];
            }
        }
        return psc;
    }

    public DeployedComponent getDeployedService() {
        DeployedComponent service = null;
        if (this.isDeployedServiceChange()) {
            service = (DeployedComponent)this.getSource();
        }
        return service;
    }

    public Host getHost() {
        Host host = null;
        if (this.isHostChange()) {
            host = (Host)this.getSource();
        } else {
            int index = this.getAncestorIndex(64);
            if (index != -1) {
                host = (Host)this.ancestors[index];
            }
        }
        return host;
    }

    public VMComponentDefn getProcess() {
        VMComponentDefn process = null;
        if (this.isProcessChange()) {
            process = (VMComponentDefn)this.getSource();
        } else {
            int index = this.getAncestorIndex(128);
            if (index != -1) {
                process = (VMComponentDefn)this.ancestors[index];
            }
        }
        return process;
    }

    public ProductType getProduct() {
        ProductType product = null;
        if (this.isProductChange()) {
            product = (ProductType)this.getSource();
        } else {
            int index = this.getAncestorIndex(1024);
            if (index != -1) {
                product = (ProductType)this.ancestors[index];
            }
        }
        return product;
    }

    public ProductServiceConfig getPscDefinition() {
        ProductServiceConfig psc = null;
        if (this.isPscDefinitionChange()) {
            psc = (ProductServiceConfig)this.getSource();
        } else {
            int index = this.getAncestorIndex(2048);
            if (index != -1) {
                psc = (ProductServiceConfig)this.ancestors[index];
            }
        }
        return psc;
    }

    public ServiceComponentDefn getServiceDefinition() {
        ServiceComponentDefn service = null;
        if (this.isServiceDefinitionChange()) {
            service = (ServiceComponentDefn)this.getSource();
        }
        return service;
    }

    public int getType() {
        return this.type;
    }

    private String getTypeText() {
        StringBuffer txt = new StringBuffer();
        if (this.isDeleted()) {
            txt.append("delete");
        } else if (this.isModified()) {
            txt.append("modify");
        } else if (this.isNew()) {
            txt.append("new");
        } else if (this.isRefreshStart()) {
            txt.append("refresh start");
        } else if (this.isRefreshEnd()) {
            txt.append("refresh end");
        } else {
            txt.append("unknown");
        }
        txt.append(":");
        if (this.isConfigurationChange()) {
            txt.append("configuration");
        } else if (this.isConfigurationChange()) {
            txt.append("configuration");
        } else if (this.isDeployedPscChange()) {
            txt.append("deployed PSC");
        } else if (this.isDeployedServiceChange()) {
            txt.append("deployed service");
        } else if (this.isHostChange()) {
            txt.append("host");
        } else if (this.isProcessChange()) {
            txt.append("process");
        } else if (this.isProductChange()) {
            txt.append("product");
        } else if (this.isPscDefinitionChange()) {
            txt.append("PSC definition");
        } else if (this.isServiceDefinitionChange()) {
            txt.append("service definition");
        } else {
            txt.append("unknown");
        }
        return txt.toString();
    }

    public boolean isConfigurationChange() {
        return (this.type & 0x20) == 32;
    }

    public boolean isDeleted() {
        return (this.type & 1) == 1;
    }

    public boolean isDeployedPscChange() {
        return (this.type & 0x100) == 256;
    }

    public boolean isDeployedServiceChange() {
        return (this.type & 0x200) == 512;
    }

    public boolean isModified() {
        return (this.type & 2) == 2;
    }

    public boolean isNew() {
        return (this.type & 4) == 4;
    }

    public boolean isHostChange() {
        return (this.type & 0x40) == 64;
    }

    public boolean isRefreshEnd() {
        return (this.type & 0x10) == 16;
    }

    public boolean isRefreshStart() {
        return (this.type & 8) == 8;
    }

    public boolean isProcessChange() {
        return (this.type & 0x80) == 128;
    }

    public boolean isProductChange() {
        return (this.type & 0x400) == 1024;
    }

    public boolean isPscDefinitionChange() {
        return (this.type & 0x800) == 2048;
    }

    public boolean isServiceDefinitionChange() {
        return (this.type & 0x1000) == 4096;
    }

    public String paramString() {
        StringBuffer ancestorTxt = new StringBuffer();
        if (this.ancestors == null) {
            ancestorTxt.append("None");
        } else {
            for (int i = 0; i < this.ancestors.length; ++i) {
                ancestorTxt.append(this.ancestors[i]);
                if (i >= this.ancestors.length - 1) continue;
                ancestorTxt.append(", ");
            }
        }
        return new StringBuffer().append("type=").append(this.getTypeText()).append(", source=").append(this.getSource()).append(", ancestors=").append(ancestorTxt).toString();
    }

    protected void setAncestors(Object[] theAncestors) {
        this.ancestors = theAncestors;
        Object source = this.getSource();
        if (source instanceof ProductServiceConfig) {
            this.type = this.ancestors[0] instanceof ProductType ? (this.type |= 0x800) : (this.type |= 0x100);
        } else if (source instanceof ServiceComponentDefn) {
            this.type |= 0x1000;
        } else if (source instanceof VMComponentDefn) {
            this.type |= 0x80;
        } else if (source instanceof Host) {
            this.type |= 0x40;
        } else if (source instanceof ProductType) {
            this.type |= 0x400;
        } else if (source instanceof Configuration) {
            this.type |= 0x20;
        } else if (source instanceof DeployedComponent) {
            this.type |= 0x200;
        }
    }

    protected int getAncestorIndex(int theAncestorType) {
        int index = -1;
        if (theAncestorType == 64) {
            if (this.isProcessChange()) {
                index = 0;
            } else if (this.isDeployedPscChange()) {
                index = 1;
            } else if (this.isDeployedServiceChange()) {
                index = 2;
            }
        } else if (theAncestorType == 256) {
            if (this.isDeployedServiceChange()) {
                index = 0;
            }
        } else if (theAncestorType == 128) {
            if (this.isDeployedPscChange()) {
                index = 0;
            } else if (this.isDeployedServiceChange()) {
                index = 1;
            }
        } else if (theAncestorType == 1024) {
            if (this.isPscDefinitionChange()) {
                index = 0;
            } else if (this.isServiceDefinitionChange()) {
                index = 1;
            }
        } else if (theAncestorType == 2048 && this.isServiceDefinitionChange()) {
            index = 0;
        }
        return index;
    }
}

