/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.deploy.event;

import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ProductType;
import com.metamatrix.console.ui.views.deploy.event.ConfigurationChangeEvent;
import com.metamatrix.console.ui.views.deploy.model.ConfigurationTreeModel;
import com.metamatrix.toolbox.ui.widget.tree.DefaultTreeNode;

public final class ConfigurationTreeModelEvent
extends ConfigurationChangeEvent {
    private DefaultTreeNode[] ancestorNodes;
    private DefaultTreeNode sourceNode;
    private DefaultTreeNode configNode;

    public ConfigurationTreeModelEvent(int theType, DefaultTreeNode theChangedNode, DefaultTreeNode theConfigNode, DefaultTreeNode[] theAncestorNodes) throws IllegalArgumentException, NullPointerException {
        super(theType, theChangedNode.getContent(), (Configuration)theConfigNode.getContent());
        this.sourceNode = theChangedNode;
        this.configNode = theConfigNode;
        this.ancestorNodes = theAncestorNodes;
        if (this.ancestorNodes != null) {
            Object[] ancestors = new Object[theAncestorNodes.length];
            for (int i = 0; i < theAncestorNodes.length; ++i) {
                Object ancestor = theAncestorNodes[i].getContent();
                if (ancestor instanceof ConfigurationTreeModel.PscWrapper) {
                    ancestor = ((ConfigurationTreeModel.PscWrapper)ancestor).getPsc();
                } else if (ancestor instanceof ConfigurationTreeModel.HostWrapper) {
                    ancestor = ((ConfigurationTreeModel.HostWrapper)ancestor).getHost();
                }
                ancestors[i] = ancestor;
            }
            this.setAncestors(ancestors);
        }
    }

    public DefaultTreeNode[] getAncestorNodes() {
        return this.ancestorNodes;
    }

    public DefaultTreeNode getConfigurationNode() {
        return this.configNode;
    }

    public DefaultTreeNode getDeployedPscNode() {
        DefaultTreeNode pscNode = null;
        if (this.isDeployedPscChange()) {
            pscNode = (DefaultTreeNode)this.getSource();
        } else {
            int index = this.getAncestorIndex(256);
            if (index != -1) {
                pscNode = this.ancestorNodes[index];
            }
        }
        return pscNode;
    }

    public DefaultTreeNode getDeployedServiceNode() {
        DefaultTreeNode serviceNode = null;
        if (this.isDeployedServiceChange()) {
            serviceNode = (DefaultTreeNode)this.getSource();
        }
        return serviceNode;
    }

    public DefaultTreeNode getHostNode() {
        DefaultTreeNode hostNode = null;
        if (this.isHostChange()) {
            hostNode = (DefaultTreeNode)this.getSource();
        } else {
            int index = this.getAncestorIndex(64);
            if (index != -1) {
                hostNode = this.ancestorNodes[index];
            }
        }
        return hostNode;
    }

    public DefaultTreeNode getProcessNode() {
        DefaultTreeNode processNode = null;
        if (this.isProcessChange()) {
            processNode = (DefaultTreeNode)this.getSource();
        } else {
            int index = this.getAncestorIndex(128);
            if (index != -1) {
                processNode = this.ancestorNodes[index];
            }
        }
        return processNode;
    }

    public DefaultTreeNode getProductNode() {
        DefaultTreeNode productNode = null;
        if (this.isProductChange()) {
            productNode = (DefaultTreeNode)this.getSource();
        } else {
            int index = this.getAncestorIndex(1024);
            if (index != -1) {
                productNode = this.ancestorNodes[index];
            }
        }
        return productNode;
    }

    public DefaultTreeNode getPscDefinitionNode() {
        DefaultTreeNode pscNode = null;
        if (this.isPscDefinitionChange()) {
            pscNode = (DefaultTreeNode)this.getSource();
        } else {
            int index = this.getAncestorIndex(2048);
            if (index != -1) {
                pscNode = this.ancestorNodes[index];
            }
        }
        return pscNode;
    }

    public DefaultTreeNode getServiceDefinitionNode() {
        DefaultTreeNode serviceNode = null;
        if (this.isServiceDefinitionChange()) {
            serviceNode = (DefaultTreeNode)this.getSource();
        }
        return serviceNode;
    }

    public DefaultTreeNode getSourceNode() {
        return this.sourceNode;
    }

    public DefaultTreeNode getSourceNodeParent() {
        return this.ancestorNodes[0];
    }

    @Override
    protected void setAncestors(Object[] theAncestors) {
        this.ancestors = theAncestors;
        Object source = this.getSource();
        if (source instanceof ConfigurationTreeModel.PscWrapper) {
            this.type = this.ancestors[0] instanceof ProductType ? (this.type |= 0x800) : (this.type |= 0x100);
        } else if (source instanceof ConfigurationTreeModel.HostWrapper) {
            this.type |= 0x40;
        } else {
            super.setAncestors(theAncestors);
        }
    }
}

