/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.deploy.model;

import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ProductType;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.namedobject.BaseID;
import com.metamatrix.console.ui.tree.SortableChildrenNode;
import com.metamatrix.console.ui.views.deploy.event.ConfigurationChangeEvent;
import com.metamatrix.console.ui.views.deploy.event.ConfigurationChangeListener;
import com.metamatrix.console.ui.views.deploy.event.ConfigurationTreeModelEvent;
import com.metamatrix.console.ui.views.deploy.event.ConfigurationTreeModelListener;
import com.metamatrix.console.ui.views.deploy.util.DeployPkgUtils;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.toolbox.ui.widget.tree.DefaultTreeModel;
import com.metamatrix.toolbox.ui.widget.tree.DefaultTreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingUtilities;

public final class ConfigurationTreeModel
extends DefaultTreeModel
implements ConfigurationChangeListener {
    public static final String DEPLOYMENTS_HDR = DeployPkgUtils.getString("dtm.deploymentshdrnode");
    public static final String PSC_DEFS_HDR = DeployPkgUtils.getString("dtm.pscdefshdrnode");
    private HashMap objNodeMap = new HashMap();
    private HashMap configDeployHdrMap = new HashMap();
    private HashMap configPscDefHdrMap = new HashMap();
    private HashMap hostConfigMap = new HashMap();
    private HashMap prodConfigMap = new HashMap();
    private HashMap procPscMap = new HashMap();
    private HashMap pscConfigMap = new HashMap();
    private DefaultTreeNode root;
    private ArrayList listeners = new ArrayList();

    public ConfigurationTreeModel() throws ExternalException {
        super(new DefaultTreeNode());
        this.root = (DefaultTreeNode)this.getRoot();
    }

    private void addConfig(Configuration theConfig) {
        SortableChildrenNode configNode = this.createNode(theConfig, this.root);
        SortableChildrenNode deployHdrNode = new SortableChildrenNode(DEPLOYMENTS_HDR, theConfig);
        configNode.addChild(deployHdrNode);
        this.configDeployHdrMap.put(theConfig.getID(), deployHdrNode);
        SortableChildrenNode pscDefsHdrNode = new SortableChildrenNode(PSC_DEFS_HDR, theConfig);
        configNode.addChild(pscDefsHdrNode);
        this.configPscDefHdrMap.put(theConfig.getID(), pscDefsHdrNode);
        ConfigurationTreeModelEvent event = new ConfigurationTreeModelEvent(4, configNode, configNode, null);
        this.fireConfigurationChange(event);
    }

    public void addConfigurationTreeModelListener(ConfigurationTreeModelListener theListener) {
        this.listeners.add(theListener);
    }

    public void addDeployedHost(Host theHost, Configuration theConfig) {
        DefaultTreeNode configNode = this.getUserObjectNode(theConfig);
        DefaultTreeNode deployHdrNode = (DefaultTreeNode)this.configDeployHdrMap.get(theConfig.getID());
        SortableChildrenNode hostNode = this.createHostNode(theHost, theConfig, deployHdrNode);
        HashMap<BaseID, SortableChildrenNode> map = (HashMap<BaseID, SortableChildrenNode>)this.hostConfigMap.get(theHost.getID());
        if (map == null) {
            map = new HashMap<BaseID, SortableChildrenNode>();
            this.hostConfigMap.put(theHost.getID(), map);
        }
        map.put(theConfig.getID(), hostNode);
        ConfigurationTreeModelEvent event = new ConfigurationTreeModelEvent(4, hostNode, configNode, new DefaultTreeNode[]{configNode});
        this.fireConfigurationChange(event);
    }

    public void addDeployedProcess(VMComponentDefn theProcess, Host theHost, Configuration theConfig) {
        DefaultTreeNode configNode = this.getUserObjectNode(theConfig);
        DefaultTreeNode hostNode = this.getHostNode(theHost, theConfig);
        if (hostNode != null) {
            SortableChildrenNode processNode = this.createNode(theProcess, hostNode);
            ConfigurationTreeModelEvent event = new ConfigurationTreeModelEvent(4, processNode, configNode, new DefaultTreeNode[]{hostNode, configNode});
            this.fireConfigurationChange(event);
        }
    }

    public void addDeployedPsc(ProductServiceConfig thePsc, VMComponentDefn theProcess, Host theHost, Configuration theConfig) {
        this.createPscNode(thePsc, theProcess, theHost, theConfig);
    }

    private void addProduct(ProductType theProduct, Configuration theConfig) {
        DefaultTreeNode configNode = this.getUserObjectNode(theConfig);
        DefaultTreeNode pscDefHdrNode = (DefaultTreeNode)this.configPscDefHdrMap.get(theConfig.getID());
        SortableChildrenNode productNode = this.createNode(theProduct, pscDefHdrNode);
        HashMap<BaseID, SortableChildrenNode> map = (HashMap<BaseID, SortableChildrenNode>)this.prodConfigMap.get(theProduct.getID());
        if (map == null) {
            map = new HashMap<BaseID, SortableChildrenNode>();
            this.prodConfigMap.put(theProduct.getID(), map);
        }
        map.put(theConfig.getID(), productNode);
        ConfigurationTreeModelEvent event = new ConfigurationTreeModelEvent(4, productNode, configNode, new DefaultTreeNode[]{configNode});
        this.fireConfigurationChange(event);
    }

    public void addPscDefn(ProductServiceConfig thePsc, ProductType theProduct, Configuration theConfig) {
        this.createPscNode(thePsc, theProduct, theConfig);
    }

    public void addServiceDefinition(ServiceComponentDefn theService, ProductServiceConfig thePsc, ProductType theProduct, Configuration theConfig) {
        DefaultTreeNode pscNode = this.getPscNode(thePsc, theConfig);
        SortableChildrenNode serviceNode = this.createNode(theService, pscNode);
        DefaultTreeNode productNode = serviceNode.getParent();
        DefaultTreeNode configNode = this.getUserObjectNode(theConfig);
        ConfigurationTreeModelEvent event = new ConfigurationTreeModelEvent(4, serviceNode, configNode, new DefaultTreeNode[]{pscNode, productNode, configNode});
        this.fireConfigurationChange(event);
    }

    @Override
    public void configurationChanged(final ConfigurationChangeEvent theEvent) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Configuration config = theEvent.getConfiguration();
                if (theEvent.isNew()) {
                    if (theEvent.isConfigurationChange()) {
                        ConfigurationTreeModel.this.addConfig(config);
                    } else if (theEvent.isHostChange()) {
                        ConfigurationTreeModel.this.addDeployedHost(theEvent.getHost(), config);
                    } else if (theEvent.isProcessChange()) {
                        ConfigurationTreeModel.this.addDeployedProcess(theEvent.getProcess(), theEvent.getHost(), config);
                    } else if (theEvent.isPscDefinitionChange()) {
                        ConfigurationTreeModel.this.addPscDefn(theEvent.getPscDefinition(), theEvent.getProduct(), config);
                    } else if (theEvent.isDeployedPscChange()) {
                        ConfigurationTreeModel.this.addDeployedPsc(theEvent.getDeployedPsc(), theEvent.getProcess(), theEvent.getHost(), config);
                    } else if (theEvent.isProductChange()) {
                        ConfigurationTreeModel.this.addProduct(theEvent.getProduct(), config);
                    }
                } else if (theEvent.isDeleted()) {
                    if (theEvent.isHostChange()) {
                        ConfigurationTreeModel.this.deleteHost(theEvent.getHost(), config);
                    } else if (theEvent.isProcessChange()) {
                        ConfigurationTreeModel.this.deleteDeployedProcess(theEvent.getProcess(), theEvent.getHost(), config);
                    } else if (theEvent.isPscDefinitionChange()) {
                        ConfigurationTreeModel.this.deletePscDefintion(theEvent.getPscDefinition(), theEvent.getProduct(), config);
                    } else if (theEvent.isDeployedPscChange()) {
                        ConfigurationTreeModel.this.deleteDeployedPsc(theEvent.getDeployedPsc(), theEvent.getProcess(), theEvent.getHost(), theEvent.getConfiguration());
                    }
                } else if (theEvent.isModified()) {
                    if (theEvent.isHostChange()) {
                        ConfigurationTreeModel.this.modifyHost(theEvent.getHost(), config);
                    } else if (theEvent.isProcessChange()) {
                        ConfigurationTreeModel.this.modifyDeployedProcess(theEvent.getProcess(), theEvent.getHost(), theEvent.getConfiguration());
                    } else if (theEvent.isPscDefinitionChange()) {
                        ConfigurationTreeModel.this.modifyPscDefinition(theEvent.getPscDefinition(), theEvent.getProduct(), config);
                    } else if (theEvent.isServiceDefinitionChange()) {
                        ConfigurationTreeModel.this.modifyServiceDefintion(theEvent.getServiceDefinition(), theEvent.getPscDefinition(), theEvent.getProduct(), config);
                    }
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public boolean contains(DefaultTreeNode theNode) {
        Object obj = theNode.getContent();
        return this.objNodeMap.get(obj) != null;
    }

    private SortableChildrenNode createNode(Object theUserObject, DefaultTreeNode theParent) {
        SortableChildrenNode child = new SortableChildrenNode(theUserObject);
        theParent.addChild(child);
        this.objNodeMap.put(theUserObject, child);
        this.fireNodeAddedEvent(this, child);
        return child;
    }

    private SortableChildrenNode createHostNode(Host theHost, Configuration theConfig, DefaultTreeNode theParent) {
        HostWrapper wrap = new HostWrapper(theHost, theConfig);
        return this.createNode(wrap, theParent);
    }

    private void createPscNode(ProductServiceConfig thePsc, ProductType theProduct, Configuration theConfig) {
        PscWrapper wrapper = new PscWrapper(thePsc, theConfig);
        HashMap map = (HashMap)this.prodConfigMap.get(theProduct.getID());
        DefaultTreeNode productNode = (DefaultTreeNode)map.get(theConfig.getID());
        SortableChildrenNode pscNode = this.createNode(wrapper, productNode);
        DefaultTreeNode configNode = this.getUserObjectNode(theConfig);
        map = (HashMap)this.pscConfigMap.get(thePsc.getID());
        if (map == null) {
            map = new HashMap();
            this.pscConfigMap.put(thePsc.getID(), map);
        }
        map.put(theConfig.getID(), pscNode);
        ConfigurationTreeModelEvent event = new ConfigurationTreeModelEvent(4, pscNode, configNode, new DefaultTreeNode[]{productNode, configNode});
        this.fireConfigurationChange(event);
    }

    private void createPscNode(ProductServiceConfig thePsc, VMComponentDefn theProcess, Host theHost, Configuration theConfig) {
        PscWrapper wrapper = new PscWrapper(thePsc, theProcess);
        DefaultTreeNode processNode = this.getUserObjectNode(theProcess);
        if (processNode == null) {
            return;
        }
        SortableChildrenNode pscNode = this.createNode(wrapper, processNode);
        DefaultTreeNode hostNode = pscNode.getParent();
        DefaultTreeNode configNode = this.getUserObjectNode(theConfig);
        HashMap<BaseID, SortableChildrenNode> map = (HashMap<BaseID, SortableChildrenNode>)this.procPscMap.get(theProcess.getID());
        if (map == null) {
            map = new HashMap<BaseID, SortableChildrenNode>();
            this.procPscMap.put(theProcess.getID(), map);
        }
        map.put(thePsc.getID(), pscNode);
        ConfigurationTreeModelEvent event = new ConfigurationTreeModelEvent(4, pscNode, configNode, new DefaultTreeNode[]{processNode, hostNode, configNode});
        this.fireConfigurationChange(event);
    }

    public void deleteHost(Host theHost, Configuration theConfig) {
        DefaultTreeNode hostNode = this.getHostNode(theHost, theConfig);
        if (hostNode != null) {
            DefaultTreeNode configNode = this.getUserObjectNode(theConfig);
            this.removeUserObject(hostNode.getContent());
            ConfigurationTreeModelEvent event = new ConfigurationTreeModelEvent(1, hostNode, configNode, new DefaultTreeNode[]{configNode});
            this.fireConfigurationChange(event);
        }
    }

    public void deleteDeployedProcess(VMComponentDefn theProcess, Host theHost, Configuration theConfig) {
        DefaultTreeNode processNode = this.getUserObjectNode(theProcess);
        DefaultTreeNode hostNode = processNode.getParent();
        DefaultTreeNode configNode = this.getUserObjectNode(theConfig);
        this.removeUserObject(theProcess);
        ConfigurationTreeModelEvent event = new ConfigurationTreeModelEvent(1, processNode, configNode, new DefaultTreeNode[]{hostNode, configNode});
        this.fireConfigurationChange(event);
    }

    public void deleteDeployedPsc(ProductServiceConfig thePsc, VMComponentDefn theProcess, Host theHost, Configuration theConfig) {
        DefaultTreeNode pscNode = this.getPscNode(thePsc, theProcess);
        DefaultTreeNode processNode = pscNode.getParent();
        DefaultTreeNode hostNode = processNode.getParent();
        DefaultTreeNode configNode = this.getUserObjectNode(theConfig);
        this.removeUserObject(pscNode.getContent());
        HashMap map = (HashMap)this.procPscMap.get(theProcess.getID());
        map.remove(thePsc.getID());
        ConfigurationTreeModelEvent event = new ConfigurationTreeModelEvent(1, pscNode, configNode, new DefaultTreeNode[]{processNode, hostNode, configNode});
        this.fireConfigurationChange(event);
    }

    public void deletePscDefintion(ProductServiceConfig thePsc, ProductType theProduct, Configuration theConfig) {
        DefaultTreeNode pscNode = this.getPscNode(thePsc, theConfig);
        DefaultTreeNode productNode = pscNode.getParent();
        DefaultTreeNode configNode = this.getUserObjectNode(theConfig);
        this.removeUserObject(pscNode.getContent());
        ConfigurationTreeModelEvent event = new ConfigurationTreeModelEvent(1, pscNode, configNode, new DefaultTreeNode[]{productNode, configNode});
        this.fireConfigurationChange(event);
    }

    private void fireConfigurationChange(ConfigurationTreeModelEvent theEvent) {
        LogManager.logDetail((String)"PSC-DEPLOYMENT", (Object[])new Object[]{"ConfigurationTreeModelEvent=" + theEvent.paramString()});
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ConfigurationTreeModelListener l = (ConfigurationTreeModelListener)this.listeners.get(i);
            l.treeNodesChanged(theEvent);
        }
    }

    public DefaultTreeNode getDeploymentsHeaderNode(Configuration theConfig) {
        return (DefaultTreeNode)this.configDeployHdrMap.get(theConfig.getID());
    }

    private DefaultTreeNode getHostNode(Host theHost, Configuration theConfig) {
        this.getUserObjectNode(theConfig);
        HashMap map = (HashMap)this.hostConfigMap.get(theHost.getID());
        DefaultTreeNode result = null;
        if (map != null) {
            result = (DefaultTreeNode)map.get(theConfig.getID());
        }
        return result;
    }

    public DefaultTreeNode getPscDefinitionsHeaderNode(Configuration theConfig) {
        return (DefaultTreeNode)this.configPscDefHdrMap.get(theConfig.getID());
    }

    public DefaultTreeNode getPscNode(ProductServiceConfig thePsc, Configuration theConfig) {
        HashMap map = (HashMap)this.pscConfigMap.get(thePsc.getID());
        return (DefaultTreeNode)map.get(theConfig.getID());
    }

    public DefaultTreeNode getPscNode(ProductServiceConfig thePsc, VMComponentDefn theProcess) {
        HashMap map = (HashMap)this.procPscMap.get(theProcess.getID());
        return (DefaultTreeNode)map.get(thePsc.getID());
    }

    public DefaultTreeNode getUserObjectNode(Object theUserObject) {
        return (DefaultTreeNode)this.objNodeMap.get(theUserObject);
    }

    public boolean isHeaderNode(DefaultTreeNode theNode) {
        return this.isDeploymentsHeaderNode(theNode) || this.isPscDefinitionsHeaderNode(theNode);
    }

    public boolean isDeploymentsHeaderNode(DefaultTreeNode theNode) {
        return this.configDeployHdrMap.containsValue(theNode);
    }

    public boolean isPscDefinitionsHeaderNode(DefaultTreeNode theNode) {
        return this.configPscDefHdrMap.containsValue(theNode);
    }

    public void modifyDeployedProcess(VMComponentDefn theProcess, Host theHost, Configuration theConfig) {
    }

    public void modifyHost(Host theHost, Configuration theConfig) {
        HashMap map = (HashMap)this.hostConfigMap.get(theHost.getID());
        if (map != null) {
            for (DefaultTreeNode hostNode : map.values()) {
                if (theHost instanceof HostWrapper) {
                    hostNode.setContent(theHost);
                    continue;
                }
                HostWrapper wrap = new HostWrapper(theHost, theConfig);
                hostNode.setContent(wrap);
            }
        }
    }

    public void modifyPscDefinition(ProductServiceConfig thePsc, ProductType theProduct, Configuration theConfig) {
    }

    public void modifyServiceDefintion(ServiceComponentDefn theService, ProductServiceConfig thePsc, ProductType theProduct, Configuration theConfig) {
    }

    public void refresh() {
        this.root.removeAllChildren();
        this.objNodeMap.clear();
        this.configDeployHdrMap.clear();
        this.configPscDefHdrMap.clear();
        this.hostConfigMap.clear();
        this.prodConfigMap.clear();
        this.procPscMap.clear();
        this.pscConfigMap.clear();
        this.fireModelChangedEvent(this, this.root);
    }

    public void removeConfigurationTreeModelListener(ConfigurationTreeModelListener theListener) {
        this.listeners.remove(theListener);
    }

    public void removeUserObject(Object theUserObject) {
        DefaultTreeNode node = this.getUserObjectNode(theUserObject);
        List kids = node.getChildren();
        if (kids != null && !kids.isEmpty()) {
            int size = kids.size();
            for (int i = size - 1; i >= 0; --i) {
                DefaultTreeNode childNode = (DefaultTreeNode)kids.get(i);
                this.removeUserObject(childNode.getContent());
            }
        }
        this.objNodeMap.remove(theUserObject);
        this.removeNode(node);
    }

    public class HostWrapper {
        private Host host;
        private Configuration config;

        public HostWrapper(Host theHost, Configuration theConfig) {
            this.host = theHost;
            this.config = theConfig;
        }

        public boolean equals(Object theObject) {
            HostWrapper otherObj;
            if (theObject instanceof HostWrapper && this.host.equals((otherObj = (HostWrapper)theObject).getHost())) {
                return this.config.equals(otherObj.getConfig());
            }
            return false;
        }

        public Host getHost() {
            return this.host;
        }

        public Configuration getConfig() {
            return this.config;
        }

        public int hashCode() {
            return this.host.hashCode() + this.config.hashCode();
        }

        public String toString() {
            return this.host.toString();
        }
    }

    public class PscWrapper {
        private ProductServiceConfig psc;
        private VMComponentDefn proc;
        private Configuration config;

        public PscWrapper(ProductServiceConfig thePsc, VMComponentDefn theProcess) {
            this.psc = thePsc;
            this.proc = theProcess;
        }

        public PscWrapper(ProductServiceConfig thePsc, Configuration theConfig) {
            this.psc = thePsc;
            this.config = theConfig;
        }

        public boolean equals(Object theObject) {
            if (theObject instanceof PscWrapper) {
                PscWrapper otherObj = (PscWrapper)theObject;
                if (this.psc.equals(otherObj.getPsc()) && this.isDefinition() == otherObj.isDefinition()) {
                    if (this.isDefinition()) {
                        return this.config.equals(otherObj.getConfig());
                    }
                    return this.proc.equals(otherObj.getProcess());
                }
                return false;
            }
            return false;
        }

        public Configuration getConfig() {
            return this.config;
        }

        public VMComponentDefn getProcess() {
            return this.proc;
        }

        public ProductServiceConfig getPsc() {
            return this.psc;
        }

        public boolean isDefinition() {
            return this.config != null;
        }

        public boolean isDeployed() {
            return this.proc != null;
        }

        public int hashCode() {
            int result = this.psc.hashCode();
            if (this.isDefinition()) {
                return result + this.config.hashCode();
            }
            return result + this.proc.hashCode();
        }

        public String toString() {
            return this.psc.toString();
        }
    }
}

