/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.deploy.util;

import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ProductType;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConfigurationManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.ui.util.property.GuiComponentFactory;
import com.metamatrix.console.ui.util.property.PropertyProvider;
import com.metamatrix.console.ui.views.deploy.util.PropertyConstants;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.border.EmptyBorder;

public final class DeployPkgUtils
implements PropertyConstants {
    public static final String PROPS = "com/metamatrix/console/ui/views/deploy/data/ui";
    public static final EmptyBorder EMPTY_BORDER;
    public static final String[] DEPLOY_HDRS;
    public static final int HOST_COL = 0;
    public static final int PROCESS_COL = 1;
    public static final int DEPLOY_PROD_COL = 2;
    public static final int DEPLOY_PSC_COL = 3;
    public static final String[] PSC_SERV_DEF_HDRS;
    public static final int PRODUCT_COL = 0;
    public static final int PSC_COL = 1;
    public static final int SERV_COL = 2;
    public static final int ENABLED_COL = 3;
    public static final int ESSENTIAL_COL = 4;
    private static PropertyProvider propProvider;

    private DeployPkgUtils() {
    }

    public static LabelWidget createLabel(String theStringId) {
        String value = DeployPkgUtils.getString(theStringId);
        return new LabelWidget(value);
    }

    public static TextFieldWidget createTextField(String theType) {
        return GuiComponentFactory.createTextField(theType);
    }

    public static boolean getBoolean(String theKey) {
        return propProvider.getBoolean(theKey);
    }

    public static Icon getIcon(String theKey) {
        return propProvider.getIcon(theKey);
    }

    public static int getInt(String theKey, int theDefault) {
        return propProvider.getInt(theKey, theDefault);
    }

    public static int getMnemonic(String theKey) {
        String key = propProvider.getString(theKey, true);
        return key == null ? 0 : (int)key.charAt(0);
    }

    public static Object getObject(String theKey) {
        return propProvider.getObject(theKey);
    }

    public static String getString(String theKey) {
        return propProvider.getString(theKey);
    }

    public static String getString(String theKey, boolean theReturnNullFlag) {
        return propProvider.getString(theKey, theReturnNullFlag);
    }

    public static String getString(String theKey, Object[] theArgs) {
        return propProvider.getString(theKey, theArgs);
    }

    public static boolean equivalent(String theOne, String theOther) {
        boolean result = true;
        if (theOne == null || theOne.length() == 0) {
            if (theOther != null && theOther.length() > 0) {
                result = false;
            }
        } else {
            result = theOther == null || theOther.length() == 0 ? false : theOne.equals(theOther);
        }
        return result;
    }

    public static void loadDeployments(Configuration theConfiguration, DefaultTableModel theModel, ConnectionInfo connection) throws ExternalException {
        theModel.setNumRows(0);
        ConfigurationManager configMgr = ModelManager.getConfigurationManager(connection);
        Collection hosts = theConfiguration.getHosts();
        if (hosts != null) {
            for (Host host : hosts) {
                Collection procs = theConfiguration.getVMsForHost((HostID)host.getID());
                if (procs == null) continue;
                for (VMComponentDefn process : procs) {
                    Collection pscs = theConfiguration.getPSCsForVM(process);
                    if (pscs == null) continue;
                    for (ProductServiceConfig psc : pscs) {
                        ProductType product = configMgr.getProduct(psc);
                        Vector<Object> row = new Vector<Object>(DEPLOY_HDRS.length);
                        row.setSize(DEPLOY_HDRS.length);
                        row.setElementAt(host, 0);
                        row.setElementAt(process, 1);
                        row.setElementAt(product, 2);
                        row.setElementAt(psc, 3);
                        theModel.addRow(row);
                    }
                }
            }
        }
    }

    public static void loadPscServiceDefintions(Configuration theConfiguration, DefaultTableModel theModel, ConnectionInfo connection) throws ExternalException {
        theModel.setNumRows(0);
        ConfigurationManager configMgr = ModelManager.getConfigurationManager(connection);
        Collection prods = configMgr.getProducts();
        if (prods != null) {
            for (ProductType prod : prods) {
                Collection pscs = configMgr.getPscDefinitions(prod, theConfiguration);
                if (pscs == null) continue;
                for (ProductServiceConfig psc : pscs) {
                    Collection services = configMgr.getServiceDefinitions(psc, theConfiguration);
                    if (services == null) continue;
                    for (ServiceComponentDefn service : services) {
                        Vector<Object> row = new Vector<Object>(PSC_SERV_DEF_HDRS.length);
                        row.setSize(PSC_SERV_DEF_HDRS.length);
                        row.setElementAt(prod, 0);
                        row.setElementAt(psc, 1);
                        row.setElementAt(service, 2);
                        ServiceComponentDefnID svcID = (ServiceComponentDefnID)service.getID();
                        if (!psc.containsService(svcID)) {
                            throw new IllegalArgumentException("Service " + svcID + " not contained in PSC " + psc.getName());
                        }
                        Boolean enabled = new Boolean(psc.isServiceEnabled((ServiceComponentDefnID)service.getID()));
                        row.setElementAt(enabled, 3);
                        row.setElementAt(new Boolean(service.getProperty(ESSENTIAL_PROP)), 4);
                        theModel.addRow(row);
                    }
                }
            }
        }
    }

    public static DefaultTableModel setup(TableWidget theTable, String[] theHeaders, int theVisibleRows, int[] theEditableColumns) {
        DefaultTableModel model = (DefaultTableModel)theTable.getModel();
        model.setColumnIdentifiers(theHeaders);
        theTable.setEditable(false);
        if (theEditableColumns != null) {
            int i = 0;
            while (i < theEditableColumns.length) {
                theTable.setColumnEditable(theEditableColumns[i++], true);
            }
        }
        theTable.setPreferredScrollableViewportSize(new Dimension(theTable.getPreferredSize().width, theVisibleRows * theTable.getRowHeight()));
        theTable.setSelectionMode(0);
        theTable.setAutoResizeMode(4);
        theTable.setSortable(true);
        return model;
    }

    static {
        ArrayList<String> propFiles = new ArrayList<String>();
        propFiles.add(PROPS);
        propFiles.add("com/metamatrix/console/ui/data/common_ui");
        propFiles.add("com/metamatrix/console/ui/data/type_defs");
        propProvider = new PropertyProvider(propFiles);
        int inset = DeployPkgUtils.getInt("emptyinsets", 10);
        EMPTY_BORDER = new EmptyBorder(inset, inset, inset, inset);
        DEPLOY_HDRS = new String[4];
        DeployPkgUtils.DEPLOY_HDRS[0] = DeployPkgUtils.getString("dpu.deployedhost.hdr");
        DeployPkgUtils.DEPLOY_HDRS[1] = DeployPkgUtils.getString("dpu.deployedprocess.hdr");
        DeployPkgUtils.DEPLOY_HDRS[2] = DeployPkgUtils.getString("dpu.deployedproduct.hdr");
        DeployPkgUtils.DEPLOY_HDRS[3] = DeployPkgUtils.getString("dpu.deployedpsc.hdr");
        PSC_SERV_DEF_HDRS = new String[5];
        DeployPkgUtils.PSC_SERV_DEF_HDRS[0] = DeployPkgUtils.getString("dpu.product.hdr");
        DeployPkgUtils.PSC_SERV_DEF_HDRS[1] = DeployPkgUtils.getString("dpu.psc.hdr");
        DeployPkgUtils.PSC_SERV_DEF_HDRS[2] = DeployPkgUtils.getString("dpu.service.hdr");
        DeployPkgUtils.PSC_SERV_DEF_HDRS[3] = DeployPkgUtils.getString("dpu.enabled.hdr");
        DeployPkgUtils.PSC_SERV_DEF_HDRS[4] = DeployPkgUtils.getString("dpu.essential.hdr");
    }
}

