/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.entitlements;

import com.metamatrix.console.ui.views.entitlements.AuthorizationsCheckBox;
import com.metamatrix.console.ui.views.entitlements.AuthorizationsTreeTable;
import com.metamatrix.console.ui.views.entitlements.DataNodesTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

class AuthorizationsCheckBoxRenderer
extends DefaultCellEditor
implements TableCellRenderer {
    private AuthorizationsTreeTable treeTable;
    private AuthorizationsCheckBox editor;
    private AuthorizationsCheckBox renderer;

    public AuthorizationsCheckBoxRenderer(AuthorizationsTreeTable treeTbl) {
        super(new AuthorizationsCheckBox());
        this.treeTable = treeTbl;
        this.editor = (AuthorizationsCheckBox)this.getComponent();
        this.editor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AuthorizationsCheckBoxRenderer.this.setModel();
            }
        });
        this.renderer = new AuthorizationsCheckBox();
    }

    @Override
    public Component getTableCellEditorComponent(JTable theTable, Object theValue, boolean isSelected, int theRow, int theColumn) {
        DataNodesTreeNode node = ((AuthorizationsTreeTable)theTable).getNodeForRow(theRow);
        boolean enabling = false;
        switch (theColumn) {
            case 1: {
                enabling = node.isCreateEnabled();
                break;
            }
            case 2: {
                enabling = node.isReadEnabled();
                break;
            }
            case 3: {
                enabling = node.isUpdateEnabled();
                break;
            }
            case 4: {
                enabling = node.isDeleteEnabled();
            }
        }
        this.editor.setEnabled(enabling);
        int state = (Integer)this.treeTable.getModel().getValueAt(theRow, theColumn);
        switch (state) {
            case 0: {
                this.editor.setPartiallySelected(false);
                this.editor.setSelected(false);
                break;
            }
            case 2: {
                this.editor.setPartiallySelected(true);
                break;
            }
            case 1: {
                this.editor.setPartiallySelected(false);
                this.editor.setSelected(true);
            }
        }
        this.editor.setCurrentRow(theRow);
        this.editor.setCurrentColumn(theColumn);
        this.editor.setUseType("editor");
        return this.editor;
    }

    @Override
    public Component getTableCellRendererComponent(JTable theTable, Object theValue, boolean isSelected, boolean hasFocus, int theRow, int theColumn) {
        AuthorizationsTreeTable treeTable = (AuthorizationsTreeTable)theTable;
        DataNodesTreeNode node = treeTable.getNodeForRow(theRow);
        boolean enabling = false;
        switch (theColumn) {
            case 1: {
                enabling = node.isCreateEnabled();
                break;
            }
            case 2: {
                enabling = node.isReadEnabled();
                break;
            }
            case 3: {
                enabling = node.isUpdateEnabled();
                break;
            }
            case 4: {
                enabling = node.isDeleteEnabled();
            }
        }
        this.renderer.setEnabled(enabling);
        int state = (Integer)theValue;
        switch (state) {
            case 0: {
                this.renderer.setPartiallySelected(false);
                this.renderer.setSelected(false);
                break;
            }
            case 2: {
                this.renderer.setPartiallySelected(true);
                break;
            }
            case 1: {
                this.renderer.setPartiallySelected(false);
                this.renderer.setSelected(true);
            }
        }
        Color backgroundColor = isSelected ? theTable.getSelectionBackground() : theTable.getBackground();
        this.renderer.setBackground(backgroundColor);
        this.renderer.setCurrentRow(theRow);
        this.renderer.setCurrentColumn(theColumn);
        this.renderer.setUseType("renderer");
        return this.renderer;
    }

    private void setModel() {
        int row = this.treeTable.getSelectedRow();
        int col = this.treeTable.getSelectedColumn();
        int value = this.editor.isPartiallySelected() ? 1 : (this.editor.isSelected() ? 0 : 0);
        Integer integerVal = new Integer(value);
        this.treeTable.getModel().setValueAt(integerVal, row, col);
    }
}

