/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.entitlements;

import com.metamatrix.console.ui.treetable.DynamicTreeTableModel;
import com.metamatrix.console.ui.treetable.TreeTableModel;
import com.metamatrix.console.ui.views.entitlements.AuthorizationsTreeTable;
import com.metamatrix.console.ui.views.entitlements.DataNodesTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class AuthorizationsModel
extends DynamicTreeTableModel {
    public static final int TREE_COLUMN_NUM = 0;
    public static final int CREATE_COLUMN_NUM = 1;
    public static final int READ_COLUMN_NUM = 2;
    public static final int UPDATE_COLUMN_NUM = 3;
    public static final int DELETE_COLUMN_NUM = 4;
    private static final String[] DATA_COLUMN_NAMES = new String[]{"Data Nodes", "Create", "Read", "Update", "Delete"};
    private static final String[] GETTER_METHOD_NAMES = new String[]{"getName", "getCreateState", "getReadState", "getUpdateState", "getDeleteState"};
    private static final String[] SETTER_METHOD_NAMES = new String[]{null, "setCreateState", "setReadState", "setUpdateState", "setDeleteState"};
    private static final Class[] CLASSES = new Class[]{TreeTableModel.class, Integer.class, Integer.class, Integer.class, Integer.class};
    private AuthorizationsTreeTable treeTable = null;

    public static String columnNumToString(int columnNum) {
        return DATA_COLUMN_NAMES[columnNum];
    }

    public AuthorizationsModel(DefaultTreeModel model) {
        super((TreeNode)model.getRoot(), DATA_COLUMN_NAMES, GETTER_METHOD_NAMES, SETTER_METHOD_NAMES, CLASSES);
    }

    public void setTreeTable(AuthorizationsTreeTable treeTbl) {
        this.treeTable = treeTbl;
    }

    @Override
    public boolean isCellEditable(Object nodeObj, int column) {
        DataNodesTreeNode node;
        boolean editable = true;
        if (column != 0 && this.treeTable != null && (node = (DataNodesTreeNode)nodeObj) != null) {
            switch (column) {
                case 1: {
                    editable = node.isCreateEnabled();
                    break;
                }
                case 2: {
                    editable = node.isReadEnabled();
                    break;
                }
                case 3: {
                    editable = node.isUpdateEnabled();
                    break;
                }
                case 4: {
                    editable = node.isDeleteEnabled();
                }
            }
        }
        return editable;
    }

    @Override
    public Object getValueAt(Object node, int col) {
        Object val = super.getValueAt(node, col);
        return val;
    }
}

