/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.entitlements;

import com.metamatrix.console.ui.util.ConsoleCellRenderer;
import com.metamatrix.console.ui.views.entitlements.DataNodesTreeNode;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.platform.admin.api.PermissionDataNode;
import com.metamatrix.platform.admin.api.PermissionNode;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class AuthorizationsTreeCellRenderer
extends DefaultTreeCellRenderer {
    public static final Color XML_DOCUMENT_FOREGROUND_COLOR = StaticUtilities.averageRGBVals(new Color[]{Color.black, Color.red});
    public static final Color STORED_PROCEDURE_FOREGROUND_COLOR = Color.blue;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
        JLabel comp = (JLabel)super.getTreeCellRendererComponent(tree, value, isSelected, isExpanded, isLeaf, row, hasFocus);
        if (value != null) {
            DataNodesTreeNode node = (DataNodesTreeNode)value;
            ImageIcon icon = null;
            PermissionNode pNode = (PermissionNode)node.getCorrespondingTreeNode();
            if (pNode instanceof PermissionDataNode) {
                PermissionDataNode pdNode = (PermissionDataNode)pNode;
                int type = pdNode.getDataNodeType();
                if (type == 5) {
                    icon = ConsoleCellRenderer.STORED_PROCEDURE_ICON;
                    comp.setForeground(STORED_PROCEDURE_FOREGROUND_COLOR);
                } else if (type == 6) {
                    icon = ConsoleCellRenderer.XML_DOCUMENT_ICON;
                    comp.setForeground(XML_DOCUMENT_FOREGROUND_COLOR);
                } else if (node.parentIsRoot()) {
                    boolean isPhysicalModel = pdNode.isPhysical();
                    icon = isPhysicalModel ? ConsoleCellRenderer.PHYSICAL_MODEL_ICON : ConsoleCellRenderer.VIRTUAL_MODEL_ICON;
                } else {
                    boolean isAttribute;
                    boolean bl = isAttribute = node.getChildCount() == 0;
                    if (isAttribute) {
                        icon = ConsoleCellRenderer.ATTRIBUTE_ICON;
                    }
                }
            }
            comp.setIcon(icon);
        }
        return comp;
    }
}

