/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.entitlements;

import com.metamatrix.console.ui.treetable.JTreeTable;
import com.metamatrix.console.ui.views.entitlements.AuthorizationsCheckBoxListener;
import com.metamatrix.console.ui.views.entitlements.AuthorizationsCheckBoxRenderer;
import com.metamatrix.console.ui.views.entitlements.AuthorizationsModel;
import com.metamatrix.console.ui.views.entitlements.AuthorizationsTreeCellRenderer;
import com.metamatrix.console.ui.views.entitlements.DataNodePermissionChange;
import com.metamatrix.console.ui.views.entitlements.DataNodePermissions;
import com.metamatrix.console.ui.views.entitlements.DataNodePermissionsWithNodeName;
import com.metamatrix.console.ui.views.entitlements.DataNodesTreeNode;
import com.metamatrix.console.util.StaticTreeUtilities;
import com.metamatrix.platform.admin.api.PermissionNode;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AuthorizationsTreeTable
extends JTreeTable {
    public static final int TREE_COLUMN_NUM = 0;
    private AuthorizationsCheckBoxRenderer checkBoxRenderer;
    private List systemModelRootNodes;
    private AuthorizationsCheckBoxListener checkBoxListener;
    private List changedNodes = new ArrayList();
    private boolean usingRoot;
    private TreeCellRenderer treeCellRenderer;

    public AuthorizationsTreeTable(AuthorizationsModel model, AuthorizationsCheckBoxListener checkBoxLsnr, boolean rootVisible) {
        super(model);
        this.usingRoot = rootVisible;
        this.checkBoxListener = checkBoxLsnr;
        this.treeCellRenderer = new AuthorizationsTreeCellRenderer();
        this.getTree().setCellRenderer(this.treeCellRenderer);
        this.getTree().setRootVisible(rootVisible);
        this.getTree().setShowsRootHandles(true);
        this.checkBoxRenderer = new AuthorizationsCheckBoxRenderer(this);
        this.setDefaultRenderer(Integer.class, this.checkBoxRenderer);
        this.setDefaultEditor(Integer.class, this.checkBoxRenderer);
        this.getTableHeader().setReorderingAllowed(false);
        this.setShowHorizontalLines(true);
        this.setShowVerticalLines(true);
        this.getSelectionModel().setSelectionMode(0);
        model.setTreeTable(this);
        this.checkBoxRenderer.setClickCountToStart(1);
    }

    public TreeCellRenderer getTreeCellRenderer() {
        return this.treeCellRenderer;
    }

    public void setSystemModelRootNodes() {
        DataNodesTreeNode root = (DataNodesTreeNode)this.getTree().getModel().getRoot();
        this.systemModelRootNodes = new ArrayList(2);
        Enumeration<TreeNode> enumeration = root.children();
        while (enumeration.hasMoreElements()) {
            DataNodesTreeNode node = (DataNodesTreeNode)enumeration.nextElement();
            String displayName = node.getNodeDisplayName();
            if (!displayName.equals("SystemPhysical") && !displayName.equals("SystemAdminPhysical") && !displayName.equals("SystemAdmin") && !displayName.equals("System")) continue;
            this.systemModelRootNodes.add(node);
        }
    }

    public DataNodesTreeNode getNodeForRow(int row) {
        JTree tree = this.getTree();
        TreePath path = tree.getPathForRow(row);
        DataNodesTreeNode node = null;
        if (path != null) {
            node = (DataNodesTreeNode)path.getLastPathComponent();
        }
        return node;
    }

    public int getRowForNode(DataNodesTreeNode node) {
        JTree tree = this.getTree();
        int row = -1;
        int numRows = tree.getRowCount();
        for (int i = 0; row < 0 && i < numRows; ++i) {
            TreePath path = tree.getPathForRow(i);
            if (path == null || node != path.getLastPathComponent()) continue;
            row = i;
        }
        return row;
    }

    public DataNodesTreeNode anyAuthorizationsChangesMade() {
        List allNodes = StaticTreeUtilities.descendantsOfNode((DataNodesTreeNode)this.getTree().getModel().getRoot(), this.usingRoot);
        DataNodesTreeNode changedNode = null;
        boolean changeFound = false;
        Iterator it = allNodes.iterator();
        while (!changeFound && it.hasNext()) {
            DataNodesTreeNode node = (DataNodesTreeNode)it.next();
            int createState = node.getCreateState();
            int initialCreateState = node.getInitialCreateState();
            if (initialCreateState == 0 && createState != 0 || initialCreateState != 0 && createState == 0) {
                changeFound = true;
                changedNode = node;
                continue;
            }
            int readState = node.getReadState();
            int initialReadState = node.getInitialReadState();
            if (initialReadState == 0 && readState != 0 || initialReadState != 0 && readState == 0) {
                changeFound = true;
                changedNode = node;
                continue;
            }
            int updateState = node.getUpdateState();
            int initialUpdateState = node.getInitialUpdateState();
            if (initialUpdateState == 0 && updateState != 0 || initialUpdateState != 0 && updateState == 0) {
                changeFound = true;
                changedNode = node;
                continue;
            }
            int deleteState = node.getDeleteState();
            int initialDeleteState = node.getInitialDeleteState();
            if ((initialDeleteState != 0 || deleteState == 0) && (initialDeleteState == 0 || deleteState != 0)) continue;
            changeFound = true;
            changedNode = node;
        }
        return changedNode;
    }

    public Integer proceedWithAuthorizationChange(DataNodesTreeNode node, int column) {
        return this.checkBoxListener.proceedWithAuthorizationChange(node, column);
    }

    public void checkBoxChanged(DataNodesTreeNode node, int column, int newState) {
        boolean ignore = this.checkBoxListener.isProgrammaticChange();
        this.checkBoxListener.checkBoxChanged(node, column, newState);
        if (!ignore) {
            this.changedNodes.add(new DataNodePermissionChange((PermissionNode)node.getCorrespondingTreeNode(), column, newState != 0));
        }
    }

    public void clearChangedNodesList() {
        this.changedNodes.clear();
    }

    public List nodesWithAuthorizationChanges() {
        List allNodes = StaticTreeUtilities.descendantsOfNode((DataNodesTreeNode)this.getTree().getModel().getRoot(), this.usingRoot);
        ArrayList<DataNodePermissionsWithNodeName> nodesWithAuthChanges = new ArrayList<DataNodePermissionsWithNodeName>(50);
        Iterator it = allNodes.iterator();
        while (it.hasNext()) {
            boolean addNode = false;
            DataNodesTreeNode node = (DataNodesTreeNode)it.next();
            int createState = node.getCreateState();
            int initialCreateState = node.getInitialCreateState();
            if (initialCreateState == 0 && createState != 0 || initialCreateState != 0 && createState == 0) {
                addNode = true;
            } else {
                int readState = node.getReadState();
                int initialReadState = node.getInitialReadState();
                if (initialReadState == 0 && readState != 0 || initialReadState != 0 && readState == 0) {
                    addNode = true;
                } else {
                    int updateState = node.getUpdateState();
                    int initialUpdateState = node.getInitialUpdateState();
                    if (initialUpdateState == 0 && updateState != 0 || initialUpdateState != 0 && updateState == 0) {
                        addNode = true;
                    } else {
                        int deleteState = node.getDeleteState();
                        int initialDeleteState = node.getInitialDeleteState();
                        if (initialDeleteState == 0 && deleteState != 0 || initialDeleteState != 0 && deleteState == 0) {
                            addNode = true;
                        }
                    }
                }
            }
            if (!addNode) continue;
            DataNodePermissions oldPermissions = this.stateAsDataNodePermissions(node.getInitialCreateState(), node.getInitialReadState(), node.getInitialUpdateState(), node.getInitialDeleteState());
            DataNodePermissions newPermissions = this.stateAsDataNodePermissions(node.getCreateState(), node.getReadState(), node.getUpdateState(), node.getDeleteState());
            DataNodePermissionsWithNodeName perm = new DataNodePermissionsWithNodeName((PermissionNode)node.getCorrespondingTreeNode(), oldPermissions, newPermissions, node.getNodeDisplayName(), node.getNodeFullName());
            nodesWithAuthChanges.add(perm);
        }
        return nodesWithAuthChanges;
    }

    private DataNodePermissions stateAsDataNodePermissions(int create, int read, int update, int delete) {
        boolean hasCreate = create != 0;
        boolean hasRead = read != 0;
        boolean hasUpdate = update != 0;
        boolean hasDelete = delete != 0;
        return new DataNodePermissions(hasCreate, hasRead, hasUpdate, hasDelete);
    }

    public void removeSystemModelRootNodes() {
        TreeModel obj;
        DataNodesTreeNode root = (DataNodesTreeNode)this.getTree().getModel().getRoot();
        Iterator it = this.systemModelRootNodes.iterator();
        boolean changed = false;
        while (it.hasNext()) {
            DataNodesTreeNode node = (DataNodesTreeNode)it.next();
            int index = root.getIndex(node);
            if (index == 0) continue;
            root.remove(index);
            changed = true;
        }
        if (changed && (obj = this.getTree().getModel()) instanceof DefaultTreeModel) {
            ((DefaultTreeModel)obj).reload();
        }
    }

    public void insertSystemModelRootNodes() {
        TreeModel obj;
        DataNodesTreeNode root = (DataNodesTreeNode)this.getTree().getModel().getRoot();
        Iterator it = this.systemModelRootNodes.iterator();
        boolean changed = false;
        while (it.hasNext()) {
            DataNodesTreeNode node = (DataNodesTreeNode)it.next();
            int index = root.getIndex(node);
            if (index >= 0) continue;
            root.add(node);
            changed = true;
        }
        if (changed && (obj = this.getTree().getModel()) instanceof DefaultTreeModel) {
            ((DefaultTreeModel)obj).reload();
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object obj = super.getValueAt(row, col);
        return obj;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }
}

