/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.entitlements;

import com.metamatrix.console.ui.tree.TreePathExpansion;
import com.metamatrix.console.ui.views.entitlements.AuthorizationPropagationListener;
import com.metamatrix.console.ui.views.entitlements.AuthorizationsCheckBoxListener;
import com.metamatrix.console.ui.views.entitlements.AuthorizationsModel;
import com.metamatrix.console.ui.views.entitlements.AuthorizationsTreeTable;
import com.metamatrix.console.ui.views.entitlements.ButtonsStateController;
import com.metamatrix.console.ui.views.entitlements.DataNodesTreeModel;
import com.metamatrix.console.ui.views.entitlements.DataNodesTreeModelGenerator;
import com.metamatrix.console.ui.views.entitlements.DataNodesTreeNode;
import com.metamatrix.console.ui.views.entitlements.PropagateChangesDialog;
import com.metamatrix.console.util.StaticTreeUtilities;
import com.metamatrix.platform.admin.api.PermissionNode;
import com.metamatrix.platform.admin.api.PermissionTreeView;
import com.metamatrix.platform.security.api.AuthorizationActions;
import com.metamatrix.toolbox.ui.widget.CheckBox;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.TreeNode;

public class DataNodeAuthorizationsControl
extends JPanel
implements AuthorizationPropagationListener,
AuthorizationsCheckBoxListener {
    private DataNodesTreeModel treeModel;
    private AuthorizationsModel authModel;
    private AuthorizationsTreeTable treeTable;
    private ButtonsStateController buttonsStateController;
    private DataNodesTreeModelGenerator treeModelGenerator;
    private boolean programmaticChange = false;
    private boolean promptUserOnPropagatedChanges = true;
    private JCheckBox systemModelsCheckBox;
    private int stateChangingTo = -1;
    private boolean rootVisible;
    private boolean useDataColNames;
    private boolean propagateChanges;

    public DataNodeAuthorizationsControl(ButtonsStateController bsc, boolean modifiable, boolean rootVisible, boolean useDataColNames, boolean propagateChanges) {
        this.rootVisible = rootVisible;
        this.useDataColNames = useDataColNames;
        this.propagateChanges = propagateChanges;
        this.buttonsStateController = bsc;
        this.systemModelsCheckBox = new CheckBox("Show System models");
        this.systemModelsCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                DataNodeAuthorizationsControl.this.showModelsCheckBoxChanged();
            }
        });
        this.systemModelsCheckBox.setSelected(true);
        this.createComponent();
        if (this.propagateChanges) {
            this.treeModel.setPropagationListener(this);
        }
    }

    public DataNodesTreeModel getTreeModel() {
        return this.treeModel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setTreeView(PermissionTreeView tView, boolean repopulatingSameEntitlement, boolean canModifyEntitlements) {
        this.treeModelGenerator = new DataNodesTreeModelGenerator(tView, canModifyEntitlements, this.rootVisible);
        TreePathExpansion[] tpe = null;
        try {
            Date startingTime = new Date();
            tpe = StaticTreeUtilities.expansionState(this.treeTable.getTree());
            Date endingTime = new Date();
            long startingTimeLong = startingTime.getTime();
            long endingTimeLong = endingTime.getTime();
            long timeDiffLong = endingTimeLong - startingTimeLong;
            double timeDiff = (double)timeDiffLong / 1000.0;
            if (!(timeDiff >= 2.0)) {
                // empty if block
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.createComponent();
        if (tpe == null) return;
        try {
            StaticTreeUtilities.restoreExpansionState(this.treeTable.getTree(), tpe, false);
            return;
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private void createComponent() {
        this.removeAll();
        if (this.treeModelGenerator == null) {
            this.treeModel = new DataNodesTreeModel(this.rootVisible, -1, -1, -1, -1);
        } else {
            try {
                this.treeModel = this.treeModelGenerator.generateModel();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (this.treeModel == null) {
            this.treeModel = new DataNodesTreeModel(this.rootVisible, -1, -1, -1, -1);
        }
        this.authModel = new AuthorizationsModel(this.treeModel);
        this.treeTable = new AuthorizationsTreeTable(this.authModel, this, this.rootVisible);
        this.treeTable.setSystemModelRootNodes();
        this.treeModel.setTreeTableForEachNode(this.treeTable);
        this.programmaticChange = true;
        if (this.propagateChanges) {
            this.treeModel.setStatesToChecked();
            this.treeModel.setStatesToPartial();
        }
        this.programmaticChange = false;
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        JScrollPane treeTableJSP = new JScrollPane(this.treeTable);
        this.add(treeTableJSP);
        layout.setConstraints(treeTableJSP, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.systemModelsCheckBox);
        layout.setConstraints(this.systemModelsCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.systemModelsCheckBox.setVisible(false);
        if (!this.systemModelsCheckBox.isSelected()) {
            this.treeTable.removeSystemModelRootNodes();
        }
    }

    private void showModelsCheckBoxChanged() {
        if (this.treeTable != null) {
            boolean selected = this.systemModelsCheckBox.isSelected();
            if (selected) {
                this.treeTable.insertSystemModelRootNodes();
            } else {
                this.treeTable.removeSystemModelRootNodes();
            }
        }
    }

    @Override
    public boolean isProgrammaticChange() {
        return this.programmaticChange;
    }

    @Override
    public void authorizationPropagated(DataNodesTreeNode node, int authorizationType) {
        int row = this.treeTable.getRowForNode(node);
        if (row >= 0) {
            int state = -1;
            switch (authorizationType) {
                case 1: {
                    state = node.getCreateState();
                    break;
                }
                case 2: {
                    state = node.getReadState();
                    break;
                }
                case 3: {
                    state = node.getUpdateState();
                    break;
                }
                case 4: {
                    state = node.getDeleteState();
                }
            }
            this.programmaticChange = true;
            this.treeTable.setValueAt(new Integer(state), row, authorizationType);
            this.programmaticChange = false;
        }
    }

    public void reset() {
        DataNodesTreeNode changedNode;
        List allNodes = StaticTreeUtilities.descendantsOfNode((DataNodesTreeNode)this.treeTable.getTree().getModel().getRoot(), this.rootVisible);
        for (DataNodesTreeNode node : allNodes) {
            int initialCreateState = node.getInitialCreateState();
            int currentCreateState = node.getCreateState();
            if (currentCreateState != initialCreateState) {
                this.programmaticChange = true;
                this.stateChangingTo = initialCreateState;
                node.setCreateState(initialCreateState);
                this.programmaticChange = false;
            }
            int initialReadState = node.getInitialReadState();
            int currentReadState = node.getReadState();
            if (currentReadState != initialReadState) {
                this.programmaticChange = true;
                this.stateChangingTo = initialReadState;
                node.setReadState(initialReadState);
                this.programmaticChange = false;
            }
            int initialUpdateState = node.getInitialUpdateState();
            int currentUpdateState = node.getUpdateState();
            if (currentUpdateState != initialUpdateState) {
                this.programmaticChange = true;
                this.stateChangingTo = initialUpdateState;
                node.setUpdateState(initialUpdateState);
                this.programmaticChange = false;
            }
            int initialDeleteState = node.getInitialDeleteState();
            int currentDeleteState = node.getDeleteState();
            if (currentDeleteState == initialDeleteState) continue;
            this.programmaticChange = true;
            this.stateChangingTo = initialDeleteState;
            node.setDeleteState(initialDeleteState);
            this.programmaticChange = false;
        }
        if (this.propagateChanges) {
            this.programmaticChange = true;
            this.treeModel.setStatesToPartial();
            this.programmaticChange = false;
        }
        if ((changedNode = this.treeTable.anyAuthorizationsChangesMade()) != null) {
            System.err.println("missed resetting node " + changedNode + ", initial CRUD states: " + changedNode.getInitialCreateState() + changedNode.getInitialReadState() + changedNode.getInitialUpdateState() + changedNode.getInitialDeleteState() + ", current CRUD states: " + changedNode.getCreateState() + changedNode.getReadState() + changedNode.getUpdateState() + changedNode.getDeleteState());
        }
        this.treeTable.clearChangedNodesList();
    }

    @Override
    public Integer proceedWithAuthorizationChange(DataNodesTreeNode node, int columnID) {
        return this.promptUserOnChange(node, columnID);
    }

    @Override
    public void checkBoxChanged(DataNodesTreeNode node, int column, int newState) {
        if (!this.programmaticChange) {
            this.programmaticChange = true;
            this.stateChangingTo = newState;
            int curState = -1;
            switch (column) {
                case 1: {
                    curState = node.getCreateState();
                    if (curState == newState) break;
                    node.setCreateState(newState);
                    curState = newState;
                    break;
                }
                case 2: {
                    curState = node.getReadState();
                    if (curState == newState) break;
                    node.setReadState(newState);
                    curState = newState;
                    break;
                }
                case 3: {
                    curState = node.getUpdateState();
                    if (curState == newState) break;
                    node.setUpdateState(newState);
                    curState = newState;
                    break;
                }
                case 4: {
                    curState = node.getDeleteState();
                    if (curState == newState) break;
                    node.setDeleteState(newState);
                    curState = newState;
                }
            }
            if (this.propagateChanges) {
                this.propagateValueDownward(node, column, curState == 1);
                this.handleAuthorizationChangeUpward(node, column, curState);
            }
            this.buttonsStateController.permissionsChanged();
            this.programmaticChange = false;
        }
    }

    private void handleAuthorizationChangeUpward(DataNodesTreeNode node, int columnID, int columnState) {
        if (columnState == 0) {
            this.handleChangeToUnauthorizedUpward(node, columnID);
        } else {
            this.handleChangeToAuthorizedUpward(node, columnID);
        }
    }

    private void handleChangeToAuthorizedUpward(DataNodesTreeNode node, int columnID) {
        DataNodesTreeNode curNode = node;
        boolean done = false;
        boolean setTheRestToPartial = false;
        boolean firstTime = true;
        while (!done) {
            DataNodesTreeNode ancestor;
            if (firstTime) {
                ancestor = curNode;
                firstTime = false;
            } else {
                ancestor = (DataNodesTreeNode)curNode.getParent();
            }
            if (ancestor == null || ancestor.isRootNode()) {
                done = true;
            } else {
                int row = this.treeTable.getRowForNode(ancestor);
                switch (columnID) {
                    case 1: {
                        ancestor.getCreateState();
                        break;
                    }
                    case 2: {
                        ancestor.getReadState();
                        break;
                    }
                    case 3: {
                        ancestor.getUpdateState();
                        break;
                    }
                    case 4: {
                        ancestor.getDeleteState();
                    }
                }
                if (setTheRestToPartial) {
                    this.setToValue(columnID, row, ancestor, 2);
                    curNode = ancestor;
                } else {
                    int state;
                    boolean hasUnauthorizedDescendant = ancestor.hasDescendantUnauthorized(columnID);
                    if (hasUnauthorizedDescendant) {
                        setTheRestToPartial = true;
                        state = 2;
                    } else {
                        state = 1;
                    }
                    this.setToValue(columnID, row, ancestor, state);
                }
            }
            curNode = ancestor;
        }
    }

    private void handleChangeToUnauthorizedUpward(DataNodesTreeNode node, int columnID) {
        DataNodesTreeNode curNode = node;
        boolean done = false;
        while (!done) {
            DataNodesTreeNode ancestor = (DataNodesTreeNode)curNode.getParent();
            if (ancestor == null || ancestor.isRootNode()) {
                done = true;
            } else {
                int row = this.treeTable.getRowForNode(ancestor);
                int curVal = -1;
                switch (columnID) {
                    case 1: {
                        curVal = ancestor.getCreateState();
                        break;
                    }
                    case 2: {
                        curVal = ancestor.getReadState();
                        break;
                    }
                    case 3: {
                        curVal = ancestor.getUpdateState();
                        break;
                    }
                    case 4: {
                        curVal = ancestor.getDeleteState();
                    }
                }
                if (curVal != 0) {
                    int checkBoxState = ancestor.hasDescendantAuthorized(columnID) ? 2 : 0;
                    this.setToValue(columnID, row, ancestor, checkBoxState);
                }
            }
            curNode = ancestor;
        }
    }

    private void setToValue(int columnID, int row, DataNodesTreeNode node, int value) {
        switch (columnID) {
            case 1: {
                node.setCreateState(value);
                this.treeTable.getModel().setValueAt(new Integer(value), row, 1);
                break;
            }
            case 2: {
                node.setReadState(value);
                this.treeTable.getModel().setValueAt(new Integer(value), row, 2);
                break;
            }
            case 3: {
                node.setUpdateState(value);
                this.treeTable.getModel().setValueAt(new Integer(value), row, 3);
                break;
            }
            case 4: {
                node.setDeleteState(value);
                this.treeTable.getModel().setValueAt(new Integer(value), row, 4);
            }
        }
    }

    private void propagateValueDownward(DataNodesTreeNode startingNode, int columnID, boolean authorized) {
        List nodes = StaticTreeUtilities.descendantsOfNode(startingNode, true);
        for (DataNodesTreeNode node : nodes) {
            PermissionNode pn = (PermissionNode)node.getCorrespondingTreeNode();
            AuthorizationActions allowedActions = pn.getAllowedActions();
            boolean setable = false;
            switch (columnID) {
                case 1: {
                    setable = DataNodesTreeNode.hasCreate(allowedActions);
                    break;
                }
                case 2: {
                    setable = DataNodesTreeNode.hasRead(allowedActions);
                    break;
                }
                case 3: {
                    setable = DataNodesTreeNode.hasUpdate(allowedActions);
                    break;
                }
                case 4: {
                    setable = DataNodesTreeNode.hasDelete(allowedActions);
                }
            }
            if (!setable) continue;
            int row = this.treeTable.getRowForNode(node);
            switch (columnID) {
                case 1: {
                    node.setCreateState(authorized ? 1 : 0);
                    if (row < 0) break;
                    this.treeTable.getModel().setValueAt(new Integer(node.getCreateState()), row, 1);
                    break;
                }
                case 2: {
                    node.setReadState(authorized ? 1 : 0);
                    if (row < 0) break;
                    this.treeTable.getModel().setValueAt(new Integer(node.getReadState()), row, 2);
                    break;
                }
                case 3: {
                    node.setUpdateState(authorized ? 1 : 0);
                    if (row < 0) break;
                    this.treeTable.getModel().setValueAt(new Integer(node.getUpdateState()), row, 3);
                    break;
                }
                case 4: {
                    node.setDeleteState(authorized ? 1 : 0);
                    if (row < 0) break;
                    this.treeTable.getModel().setValueAt(new Integer(node.getDeleteState()), row, 4);
                }
            }
        }
    }

    private Integer promptUserOnChange(DataNodesTreeNode node, int columnID) {
        Integer changeTo = null;
        String permissionName = "";
        int curVal = -1;
        switch (columnID) {
            case 1: {
                curVal = node.getCreateState();
                permissionName = "Create";
                break;
            }
            case 2: {
                curVal = node.getReadState();
                permissionName = "Read";
                break;
            }
            case 3: {
                curVal = node.getUpdateState();
                permissionName = "Update";
                break;
            }
            case 4: {
                curVal = node.getDeleteState();
                permissionName = "Delete";
            }
        }
        switch (curVal) {
            case 2: {
                break;
            }
            case 0: {
                changeTo = new Integer(1);
                break;
            }
            case 1: {
                changeTo = new Integer(0);
            }
        }
        if (!this.programmaticChange) {
            int numChildren = 0;
            if (this.propagateChanges) {
                numChildren = this.numChildrenPropagatableTo(node, columnID);
            }
            if (numChildren > 0 && this.promptUserOnPropagatedChanges || curVal == 2) {
                boolean proceeding;
                PropagateChangesDialog dialog;
                boolean toAuthorized = false;
                if (curVal == 2) {
                    dialog = new PropagateChangesDialog(permissionName);
                    dialog.show();
                    proceeding = dialog.proceeding();
                } else {
                    toAuthorized = curVal != 1;
                    dialog = new PropagateChangesDialog(permissionName, toAuthorized);
                    dialog.show();
                    this.promptUserOnPropagatedChanges = !dialog.discontinueDisplaying();
                    proceeding = dialog.proceeding();
                }
                changeTo = proceeding ? (curVal != 2 ? (toAuthorized ? new Integer(1) : new Integer(0)) : (dialog.setToAuthorized() ? new Integer(1) : new Integer(0))) : null;
                dialog = null;
            }
        }
        if (changeTo == null && this.programmaticChange && this.stateChangingTo >= 0) {
            changeTo = new Integer(this.stateChangingTo);
        }
        return changeTo;
    }

    private int numChildrenPropagatableTo(DataNodesTreeNode node, int columnID) {
        int numPropagatableTo = 0;
        Enumeration<TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            DataNodesTreeNode child = (DataNodesTreeNode)enumeration.nextElement();
            PermissionNode pn = (PermissionNode)child.getCorrespondingTreeNode();
            AuthorizationActions allowableActions = pn.getAllowedActions();
            boolean propagatable = false;
            switch (columnID) {
                case 1: {
                    propagatable = DataNodesTreeNode.hasCreate(allowableActions);
                    break;
                }
                case 2: {
                    propagatable = DataNodesTreeNode.hasRead(allowableActions);
                    break;
                }
                case 3: {
                    propagatable = DataNodesTreeNode.hasUpdate(allowableActions);
                    break;
                }
                case 4: {
                    propagatable = DataNodesTreeNode.hasDelete(allowableActions);
                }
            }
            if (!propagatable) continue;
            ++numPropagatableTo;
        }
        return numPropagatableTo;
    }

    public boolean anyAuthorizationsChangesMade() {
        return this.treeTable.anyAuthorizationsChangesMade() != null;
    }

    public List nodesWithAuthorizationChanges() {
        return this.treeTable.nodesWithAuthorizationChanges();
    }
}

