/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.entitlements;

import com.metamatrix.platform.admin.api.PermissionNode;

public class DataNodePermissions {
    public static final String NONE = "(none)";
    private boolean create;
    private boolean read;
    private boolean update;
    private boolean delete;

    public static DataNodePermissions getDefaultRootNodePermissions() {
        return new DataNodePermissions(false, true, false, false);
    }

    public static String[] getDefaultRootNodePermissionsStringArray() {
        return new String[]{"Read"};
    }

    public DataNodePermissions(boolean c, boolean r, boolean u, boolean d) {
        this.create = c;
        this.read = r;
        this.update = u;
        this.delete = d;
    }

    public DataNodePermissions(String[] perm) {
        this.create = false;
        this.read = false;
        this.update = false;
        this.delete = false;
        for (int i = 0; i < perm.length; ++i) {
            if (perm[i].equalsIgnoreCase("Create")) {
                this.create = true;
                continue;
            }
            if (perm[i].equalsIgnoreCase("Read")) {
                this.read = true;
                continue;
            }
            if (perm[i].equalsIgnoreCase("Update")) {
                this.update = true;
                continue;
            }
            if (!perm[i].equalsIgnoreCase("Delete")) continue;
            this.delete = true;
        }
    }

    public DataNodePermissions(PermissionNode node) {
        this(node.getActions().getLabels());
    }

    public boolean hasCreate() {
        return this.create;
    }

    public boolean hasRead() {
        return this.read;
    }

    public boolean hasUpdate() {
        return this.update;
    }

    public boolean hasDelete() {
        return this.delete;
    }

    public Object clone() {
        return new DataNodePermissions(this.hasCreate(), this.hasRead(), this.hasUpdate(), this.hasDelete());
    }

    public boolean equals(Object obj) {
        boolean same = false;
        if (obj == this) {
            same = true;
        } else if (obj instanceof DataNodePermissions) {
            DataNodePermissions perm = (DataNodePermissions)obj;
            same = this.hasCreate() == perm.hasCreate() && this.hasRead() == perm.hasRead() && this.hasUpdate() == perm.hasUpdate() && this.hasDelete() == perm.hasDelete();
        }
        return same;
    }

    public String toString() {
        String str = "DataNodePermissions: " + this.toPermissionsString();
        return str;
    }

    public String toPermissionsString() {
        String str = "";
        if (this.hasCreate()) {
            str = str + "C";
        }
        if (this.hasRead()) {
            str = str + "R";
        }
        if (this.hasUpdate()) {
            str = str + "U";
        }
        if (this.hasDelete()) {
            str = str + "D";
        }
        if (str.length() == 0) {
            str = NONE;
        }
        return str;
    }
}

