/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.entitlements;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.ui.views.entitlements.AuthorizationPropagationListener;
import com.metamatrix.console.ui.views.entitlements.AuthorizationsTreeTable;
import com.metamatrix.console.ui.views.entitlements.DataNodesTreeNode;
import com.metamatrix.console.util.StaticTreeUtilities;
import com.metamatrix.platform.admin.api.PermissionNode;
import com.metamatrix.platform.admin.api.PermissionTreeView;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class DataNodesTreeModel
extends DefaultTreeModel
implements AuthorizationPropagationListener {
    private static final double TIME_REPORTING_THRESHOLD = 2.0;
    private AuthorizationPropagationListener propagationListener;
    private boolean usingRoot;

    public static DataNodesTreeModel createDefaultTreeModelFromTreeView(PermissionTreeView treeView, boolean canModifyEntitlements, boolean usingRoot) throws Exception {
        DataNodesTreeNode ourRoot;
        Date startingTime = new Date();
        PermissionNode root = treeView.getRoot();
        if (usingRoot) {
            ourRoot = DataNodesTreeModel.setUpNode(treeView, (com.metamatrix.common.tree.TreeNode)root, canModifyEntitlements);
            ourRoot.setRootNode(true);
            if (ourRoot.getNodeDisplayName().trim().length() == 0) {
                ourRoot.setNodeDisplayName("Repository root");
            }
        } else {
            ourRoot = new DataNodesTreeNode("root", "root", (com.metamatrix.common.tree.TreeNode)root, true, -1, -1, -1, -1, canModifyEntitlements);
        }
        ourRoot.setSortType(3);
        DataNodesTreeModel ourModel = new DataNodesTreeModel(ourRoot);
        PermissionNode curNode = root;
        DataNodesTreeNode ourCurNode = ourRoot;
        boolean done = false;
        while (!done) {
            List children = treeView.getChildren(curNode);
            if (children.size() > 0) {
                curNode = (com.metamatrix.common.tree.TreeNode)children.get(0);
                DataNodesTreeNode ourChild = DataNodesTreeModel.setUpNode(treeView, (com.metamatrix.common.tree.TreeNode)curNode, canModifyEntitlements);
                ourCurNode.add(ourChild);
                ourCurNode = ourChild;
                continue;
            }
            boolean nextNodeFound = false;
            while (!nextNodeFound && !done) {
                List allChildrenForNode;
                if (ourCurNode.isRootNode()) {
                    done = true;
                    continue;
                }
                PermissionNode parent = treeView.getParent(curNode);
                DataNodesTreeNode ourParent = (DataNodesTreeNode)ourCurNode.getParent();
                int numChildrenAddedSoFar = ourParent.getChildCount();
                if (numChildrenAddedSoFar < (allChildrenForNode = treeView.getChildren(parent)).size()) {
                    curNode = (com.metamatrix.common.tree.TreeNode)allChildrenForNode.get(numChildrenAddedSoFar);
                    ourCurNode = DataNodesTreeModel.setUpNode(treeView, (com.metamatrix.common.tree.TreeNode)curNode, canModifyEntitlements);
                    ourParent.add(ourCurNode);
                    nextNodeFound = true;
                    continue;
                }
                curNode = parent;
                ourCurNode = ourParent;
            }
        }
        DataNodesTreeModel.removeUnwantedNodes(ourRoot);
        DataNodesTreeModel.sortTheModel(ourModel);
        Date endingTime = new Date();
        long startingTimeLong = startingTime.getTime();
        long endingTimeLong = endingTime.getTime();
        long timeDiffLong = endingTimeLong - startingTimeLong;
        double timeDiff = (double)timeDiffLong / 1000.0;
        if (timeDiff >= 2.0) {
            List tempList = StaticTreeUtilities.descendantsOfNode(ourRoot, true);
            int numNodes = tempList.size();
            String message = "Time duration in DataNodesTreeModel..createDefaultTreeModelFromTreeView() is " + timeDiff + " seconds for model containing " + numNodes + " nodes";
            LogManager.logInfo((String)"ROLES", (String)message);
        }
        return ourModel;
    }

    private static void removeUnwantedNodes(DataNodesTreeNode root) {
        List nodes = StaticTreeUtilities.descendantsOfNode(root, false);
        for (DataNodesTreeNode node : nodes) {
            String displayName = node.getNodeDisplayName();
            if (!displayName.equals("SystemPhysical") && !displayName.equals("SystemAdminPhysical")) continue;
            node.removeFromParent();
            break;
        }
    }

    private static DataNodesTreeNode setUpNode(PermissionTreeView treeView, com.metamatrix.common.tree.TreeNode curNode, boolean canModify) {
        PermissionNode pdn = (PermissionNode)curNode;
        String displayName = pdn.getDisplayName();
        String resourceName = pdn.getResourceName();
        int createState = 0;
        int readState = 0;
        int updateState = 0;
        int deleteState = 0;
        String[] permissions = pdn.getActions().getLabels();
        for (int i = 0; i < permissions.length; ++i) {
            if (permissions[i].equalsIgnoreCase("Create")) {
                createState = 1;
                continue;
            }
            if (permissions[i].equalsIgnoreCase("Read")) {
                readState = 1;
                continue;
            }
            if (permissions[i].equalsIgnoreCase("Update")) {
                updateState = 1;
                continue;
            }
            if (!permissions[i].equalsIgnoreCase("Delete")) continue;
            deleteState = 1;
        }
        DataNodesTreeNode theNode = new DataNodesTreeNode(displayName, resourceName, curNode, false, createState, readState, updateState, deleteState, canModify);
        theNode.setSortType(3);
        return theNode;
    }

    private static void sortTheModel(DataNodesTreeModel model) {
        List nodes = StaticTreeUtilities.descendantsOfNode((DataNodesTreeNode)model.getRoot(), true);
        for (DataNodesTreeNode node : nodes) {
            node.setSortType(2);
            node.sortChildren();
        }
    }

    public DataNodesTreeModel(boolean usingRoot, int rootCreateState, int rootReadState, int rootUpdateState, int rootDeleteState) {
        super(new DataNodesTreeNode("root", "root", null, true, rootCreateState, rootReadState, rootUpdateState, rootDeleteState, false));
        this.usingRoot = usingRoot;
    }

    public DataNodesTreeModel(DataNodesTreeNode root) {
        super(root);
    }

    public void setStatesToChecked() {
        if (this.usingRoot) {
            DataNodesTreeNode root = (DataNodesTreeNode)this.getRoot();
            root.recalculateStates();
        } else {
            Enumeration<TreeNode> rootsChildren = ((DataNodesTreeNode)this.getRoot()).children();
            while (rootsChildren.hasMoreElements()) {
                DataNodesTreeNode rootsChild = (DataNodesTreeNode)rootsChildren.nextElement();
                rootsChild.recalculateStates();
            }
        }
    }

    public void setStatesToPartial() {
        DataNodesTreeNode root = (DataNodesTreeNode)this.getRoot();
        List nodes = StaticTreeUtilities.descendantsOfNode(root, this.usingRoot);
        for (DataNodesTreeNode node : nodes) {
            block13: for (int i = 0; i <= 3; ++i) {
                int col = -1;
                boolean selected = false;
                switch (i) {
                    case 0: {
                        selected = node.getCreateState() == 1;
                        col = 1;
                        break;
                    }
                    case 1: {
                        selected = node.getReadState() == 1;
                        col = 2;
                        break;
                    }
                    case 2: {
                        selected = node.getUpdateState() == 1;
                        col = 3;
                        break;
                    }
                    case 3: {
                        selected = node.getDeleteState() == 1;
                        col = 4;
                    }
                }
                boolean changeToPartial = selected ? node.hasDescendantUnauthorized(col) : node.hasDescendantAuthorized(col);
                if (!changeToPartial) continue;
                switch (col) {
                    case 1: {
                        node.setCreateState(2);
                        node.setInitialCreateState(2);
                        continue block13;
                    }
                    case 2: {
                        node.setReadState(2);
                        node.setInitialReadState(2);
                        continue block13;
                    }
                    case 3: {
                        node.setUpdateState(2);
                        node.setInitialUpdateState(2);
                        continue block13;
                    }
                    case 4: {
                        node.setDeleteState(2);
                        node.setInitialDeleteState(2);
                    }
                }
            }
        }
    }

    public void setPropagationListener(AuthorizationPropagationListener lsnr) {
        this.propagationListener = lsnr;
    }

    @Override
    public void authorizationPropagated(DataNodesTreeNode node, int authorizationType) {
        if (this.propagationListener != null) {
            this.propagationListener.authorizationPropagated(node, authorizationType);
        }
    }

    public void setTreeTableForEachNode(AuthorizationsTreeTable treeTable) {
        List nodes = StaticTreeUtilities.descendantsOfNode((DataNodesTreeNode)this.getRoot(), true);
        for (DataNodesTreeNode node : nodes) {
            node.setTreeTable(treeTable);
        }
    }
}

