/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.entitlements;

import com.metamatrix.console.ui.tree.ChildSortingTreeNode;
import com.metamatrix.console.ui.views.entitlements.AuthorizationsTreeTable;
import com.metamatrix.console.util.StaticTreeUtilities;
import com.metamatrix.platform.admin.api.PermissionNode;
import com.metamatrix.platform.security.api.AuthorizationActions;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreeNode;

public class DataNodesTreeNode
extends ChildSortingTreeNode {
    private com.metamatrix.common.tree.TreeNode correspondingTreeNode;
    private boolean rootNode;
    private String nodeDisplayName;
    private String nodeFullName;
    private boolean createEnabled;
    private boolean readEnabled;
    private boolean updateEnabled;
    private boolean deleteEnabled;
    private int createState;
    private int readState;
    private int updateState;
    private int deleteState;
    private int initialCreateState;
    private int initialReadState;
    private int initialUpdateState;
    private int initialDeleteState;
    private int recalcCreateStateFlag = -1;
    private int recalcReadStateFlag = -1;
    private int recalcUpdateStateFlag = -1;
    private int recalcDeleteStateFlag = -1;
    private AuthorizationsTreeTable treeTable;

    public static boolean hasDelete(AuthorizationActions actions) {
        String[] actionLabels = actions.getLabels();
        return DataNodesTreeNode.stringArrayContains(actionLabels, "Delete");
    }

    public static boolean hasCreate(AuthorizationActions actions) {
        String[] actionLabels = actions.getLabels();
        return DataNodesTreeNode.stringArrayContains(actionLabels, "Create");
    }

    public static boolean hasRead(AuthorizationActions actions) {
        String[] actionLabels = actions.getLabels();
        return DataNodesTreeNode.stringArrayContains(actionLabels, "Read");
    }

    public static boolean hasUpdate(AuthorizationActions actions) {
        String[] actionLabels = actions.getLabels();
        return DataNodesTreeNode.stringArrayContains(actionLabels, "Update");
    }

    public static boolean stringArrayContains(String[] array, String str) {
        int i = 0;
        boolean found = false;
        while (!found && i < array.length) {
            if (array[i].equals(str)) {
                found = true;
                continue;
            }
            ++i;
        }
        return found;
    }

    public DataNodesTreeNode(String displayName, String fullName, com.metamatrix.common.tree.TreeNode treeNode, boolean root, int create, int read, int update, int delete, boolean userCanModifyEntitlements) {
        super(null, displayName);
        this.nodeDisplayName = displayName;
        this.nodeFullName = fullName;
        this.correspondingTreeNode = treeNode;
        if (this.correspondingTreeNode != null) {
            this.setEnabledFlags(userCanModifyEntitlements);
        }
        this.rootNode = root;
        this.createState = create;
        this.readState = read;
        this.updateState = update;
        this.deleteState = delete;
        this.initialCreateState = this.createState;
        this.initialReadState = this.readState;
        this.initialUpdateState = this.updateState;
        this.initialDeleteState = this.deleteState;
    }

    private void setEnabledFlags(boolean userCanModifyEntitlements) {
        this.createEnabled = false;
        this.readEnabled = false;
        this.updateEnabled = false;
        this.deleteEnabled = false;
        if (userCanModifyEntitlements) {
            PermissionNode node = (PermissionNode)this.correspondingTreeNode;
            AuthorizationActions allowedActions = node.getAllowedActions();
            String[] labels = allowedActions.getLabels();
            for (int i = 0; i < labels.length; ++i) {
                if (labels[i].equals("Create")) {
                    this.createEnabled = true;
                    continue;
                }
                if (labels[i].equals("Read")) {
                    this.readEnabled = true;
                    continue;
                }
                if (labels[i].equals("Update")) {
                    this.updateEnabled = true;
                    continue;
                }
                if (!labels[i].equals("Delete")) continue;
                this.deleteEnabled = true;
            }
        }
    }

    public void setTreeTable(AuthorizationsTreeTable treeTbl) {
        this.treeTable = treeTbl;
    }

    public boolean isRootNode() {
        return this.rootNode;
    }

    public void setRootNode(boolean flag) {
        this.rootNode = flag;
    }

    public boolean parentIsRoot() {
        boolean parentIsRoot = false;
        if (!this.isRoot()) {
            DataNodesTreeNode parent = (DataNodesTreeNode)this.getParent();
            parentIsRoot = parent.isRoot();
        }
        return parentIsRoot;
    }

    public com.metamatrix.common.tree.TreeNode getCorrespondingTreeNode() {
        return this.correspondingTreeNode;
    }

    public String getNodeDisplayName() {
        return this.nodeDisplayName;
    }

    public void setNodeDisplayName(String name) {
        this.nodeDisplayName = name;
        this.setUserObject(this.nodeDisplayName);
    }

    public String getNodeFullName() {
        return this.nodeFullName;
    }

    public int getCreateState() {
        return this.createState;
    }

    public void setCreateState(Integer val) {
        this.setCreateState((int)val);
    }

    public void setCreateState(int val) {
        if (this.createState != val) {
            Integer newState = null;
            if (this.treeTable != null) {
                newState = this.treeTable.proceedWithAuthorizationChange(this, 1);
            }
            if (newState != null) {
                this.createState = val;
                if (this.treeTable != null) {
                    this.treeTable.checkBoxChanged(this, 1, newState);
                }
            }
        }
    }

    public int getInitialCreateState() {
        return this.initialCreateState;
    }

    public void setInitialCreateState(int state) {
        this.initialCreateState = state;
    }

    public int getReadState() {
        return this.readState;
    }

    public void setReadState(Integer val) {
        this.setReadState((int)val);
    }

    public void setReadState(int val) {
        if (this.readState != val) {
            Integer newState = null;
            if (this.treeTable != null) {
                newState = this.treeTable.proceedWithAuthorizationChange(this, 2);
            }
            if (newState != null) {
                this.readState = val;
                if (this.treeTable != null) {
                    this.treeTable.checkBoxChanged(this, 2, newState);
                }
            }
        }
    }

    public int getInitialReadState() {
        return this.initialReadState;
    }

    public void setInitialReadState(int state) {
        this.initialReadState = state;
    }

    public int getUpdateState() {
        return this.updateState;
    }

    public void setUpdateState(Integer val) {
        this.setUpdateState((int)val);
    }

    public void setUpdateState(int val) {
        if (this.updateState != val) {
            Integer newState = null;
            if (this.treeTable != null) {
                newState = this.treeTable.proceedWithAuthorizationChange(this, 3);
            }
            if (newState != null) {
                this.updateState = val;
                if (this.treeTable != null) {
                    this.treeTable.checkBoxChanged(this, 3, newState);
                }
            }
        }
    }

    public int getInitialUpdateState() {
        return this.initialUpdateState;
    }

    public void setInitialUpdateState(int state) {
        this.initialUpdateState = state;
    }

    public int getDeleteState() {
        return this.deleteState;
    }

    public void setDeleteState(Integer val) {
        this.setDeleteState((int)val);
    }

    public void setDeleteState(int val) {
        if (this.deleteState != val) {
            Integer newState = null;
            if (this.treeTable != null) {
                newState = this.treeTable.proceedWithAuthorizationChange(this, 4);
            }
            if (newState != null) {
                this.deleteState = val;
                if (this.treeTable != null) {
                    this.treeTable.checkBoxChanged(this, 4, newState);
                }
            }
        }
    }

    public int getInitialDeleteState() {
        return this.initialDeleteState;
    }

    public void setInitialDeleteState(int state) {
        this.initialDeleteState = state;
    }

    public boolean isCreateEnabled() {
        return this.createEnabled;
    }

    public boolean isReadEnabled() {
        return this.readEnabled;
    }

    public boolean isUpdateEnabled() {
        return this.updateEnabled;
    }

    public boolean isDeleteEnabled() {
        return this.deleteEnabled;
    }

    @Override
    public boolean sortChildren() {
        int numChildren = this.getChildCount();
        boolean changed = super.sortChildren();
        if (this.isRootNode() && numChildren > 1) {
            DataNodesTreeNode nodeToMove;
            DataNodesTreeNode curChild;
            int matchLoc = -1;
            int loc = 0;
            while (matchLoc < 0 && loc < numChildren) {
                curChild = (DataNodesTreeNode)this.getChildAt(loc);
                if (curChild.getNodeDisplayName().equals("SystemPhysical")) {
                    matchLoc = loc;
                    continue;
                }
                ++loc;
            }
            if (matchLoc >= 0) {
                nodeToMove = (DataNodesTreeNode)this.getChildAt(matchLoc);
                this.remove(matchLoc);
                this.setSortType(3);
                this.add(nodeToMove);
                this.setSortType(2);
                changed = true;
            }
            matchLoc = -1;
            loc = 0;
            while (matchLoc < 0 && loc < numChildren) {
                curChild = (DataNodesTreeNode)this.getChildAt(loc);
                if (curChild.getNodeDisplayName().equals("System")) {
                    matchLoc = loc;
                    continue;
                }
                ++loc;
            }
            if (matchLoc >= 0) {
                nodeToMove = (DataNodesTreeNode)this.getChildAt(matchLoc);
                this.remove(matchLoc);
                this.setSortType(3);
                this.add(nodeToMove);
                this.setSortType(2);
                changed = true;
            }
        }
        return changed;
    }

    public boolean hasDescendantUnauthorized(int columnID) {
        List descendants = StaticTreeUtilities.descendantsOfNode(this, false);
        boolean unauthorized = false;
        Iterator it = descendants.iterator();
        while (!unauthorized && it.hasNext()) {
            DataNodesTreeNode node = (DataNodesTreeNode)it.next();
            PermissionNode pn = (PermissionNode)node.getCorrespondingTreeNode();
            AuthorizationActions allowedActions = pn.getAllowedActions();
            boolean authorizable = false;
            int value = -1;
            switch (columnID) {
                case 1: {
                    authorizable = DataNodesTreeNode.hasCreate(allowedActions);
                    value = node.getCreateState();
                    break;
                }
                case 2: {
                    authorizable = DataNodesTreeNode.hasRead(allowedActions);
                    value = node.getReadState();
                    break;
                }
                case 3: {
                    authorizable = DataNodesTreeNode.hasUpdate(allowedActions);
                    value = node.getUpdateState();
                    break;
                }
                case 4: {
                    authorizable = DataNodesTreeNode.hasDelete(allowedActions);
                    value = node.getDeleteState();
                }
            }
            if (value != 0 || !authorizable) continue;
            unauthorized = true;
        }
        return unauthorized;
    }

    public boolean hasDescendantAuthorized(int columnID) {
        List descendants = StaticTreeUtilities.descendantsOfNode(this, false);
        boolean authorized = false;
        Iterator it = descendants.iterator();
        while (!authorized && it.hasNext()) {
            DataNodesTreeNode node = (DataNodesTreeNode)it.next();
            int value = -1;
            switch (columnID) {
                case 1: {
                    value = node.getCreateState();
                    break;
                }
                case 2: {
                    value = node.getReadState();
                    break;
                }
                case 3: {
                    value = node.getUpdateState();
                    break;
                }
                case 4: {
                    value = node.getDeleteState();
                }
            }
            if (value == 0) continue;
            authorized = true;
        }
        return authorized;
    }

    public void recalculateStates() {
        for (int counter = 0; counter <= 3; ++counter) {
            int col = -1;
            switch (counter) {
                case 0: {
                    col = 1;
                    break;
                }
                case 1: {
                    col = 2;
                    break;
                }
                case 2: {
                    col = 3;
                    break;
                }
                case 3: {
                    col = 4;
                }
            }
            this.recalculateState(col);
        }
    }

    public int recalculateState(int col) {
        boolean isSet = false;
        int value = -1;
        switch (col) {
            case 1: {
                isSet = this.recalcCreateStateFlag >= 0;
                value = this.createState;
                break;
            }
            case 2: {
                isSet = this.recalcReadStateFlag >= 0;
                value = this.readState;
                break;
            }
            case 3: {
                isSet = this.recalcUpdateStateFlag >= 0;
                value = this.updateState;
                break;
            }
            case 4: {
                isSet = this.recalcDeleteStateFlag >= 0;
                value = this.deleteState;
            }
        }
        if (!isSet) {
            boolean changingToChecked = false;
            int numChildren = this.getChildCount();
            if (numChildren > 0) {
                Enumeration<TreeNode> enumeration = this.children();
                boolean uncheckedFound = false;
                boolean checkedFound = false;
                while (enumeration.hasMoreElements()) {
                    DataNodesTreeNode child = (DataNodesTreeNode)enumeration.nextElement();
                    int childsState = child.recalculateState(col);
                    if (childsState == 0) {
                        PermissionNode pn = (PermissionNode)child.getCorrespondingTreeNode();
                        AuthorizationActions allowedActions = pn.getAllowedActions();
                        boolean selectable = false;
                        switch (col) {
                            case 1: {
                                selectable = DataNodesTreeNode.hasCreate(allowedActions);
                                break;
                            }
                            case 2: {
                                selectable = DataNodesTreeNode.hasRead(allowedActions);
                                break;
                            }
                            case 3: {
                                selectable = DataNodesTreeNode.hasUpdate(allowedActions);
                                break;
                            }
                            case 4: {
                                selectable = DataNodesTreeNode.hasDelete(allowedActions);
                            }
                        }
                        if (!selectable) continue;
                        uncheckedFound = true;
                        continue;
                    }
                    checkedFound = true;
                }
                boolean bl = changingToChecked = checkedFound && !uncheckedFound;
            }
            if (changingToChecked) {
                value = 1;
            }
            switch (col) {
                case 1: {
                    this.recalcCreateStateFlag = 1;
                    if (!changingToChecked) break;
                    this.createState = 1;
                    this.initialCreateState = 1;
                    break;
                }
                case 2: {
                    this.recalcReadStateFlag = 1;
                    if (!changingToChecked) break;
                    this.readState = 1;
                    this.initialReadState = 1;
                    break;
                }
                case 3: {
                    this.recalcUpdateStateFlag = 1;
                    if (!changingToChecked) break;
                    this.updateState = 1;
                    this.initialUpdateState = 1;
                    break;
                }
                case 4: {
                    this.recalcDeleteStateFlag = 1;
                    if (!changingToChecked) break;
                    this.deleteState = 1;
                    this.initialDeleteState = 1;
                }
            }
        }
        return value;
    }
}

