/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.entitlements;

import com.metamatrix.console.models.AuthenticationProviderManager;
import com.metamatrix.console.models.EntitlementManager;
import com.metamatrix.console.models.GroupsManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.ui.NotifyOnExitConsole;
import com.metamatrix.console.ui.ViewManager;
import com.metamatrix.console.ui.layout.BasePanel;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.util.NoMinTextFieldWidget;
import com.metamatrix.console.ui.util.RepaintController;
import com.metamatrix.console.ui.views.entitlements.ButtonsStateController;
import com.metamatrix.console.ui.views.entitlements.DataNodeAuthorizationsControl;
import com.metamatrix.console.ui.views.entitlements.EntitlementInfo;
import com.metamatrix.console.ui.views.entitlements.EntitlementsDataInterface;
import com.metamatrix.console.ui.views.entitlements.PrincipalChangeListener;
import com.metamatrix.console.ui.views.users.GroupAccumulatorController;
import com.metamatrix.console.ui.views.users.GroupsAccumulatorPanel;
import com.metamatrix.console.ui.views.users.NewGroupsWizardController;
import com.metamatrix.console.util.DialogUtility;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.platform.admin.api.PermissionDataNodeTreeView;
import com.metamatrix.platform.admin.api.PermissionTreeView;
import com.metamatrix.platform.security.api.AuthorizationPolicy;
import com.metamatrix.platform.security.api.AuthorizationPolicyID;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.text.DefaultTextFieldModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class EntitlementDetailPanel
extends BasePanel
implements ButtonsStateController,
NotifyOnExitConsole,
PrincipalChangeListener,
GroupAccumulatorController {
    public static final Color VALUES_COLOR = Color.black;
    public static final int INITIAL_LIST_SIZES = 50;
    private EntitlementsDataInterface dataSource;
    private boolean showingMetaMatrix;
    private boolean showingEnterprise;
    private boolean canModify;
    private DataNodeAuthorizationsControl authorizationsPanel = null;
    private GroupsAccumulatorPanel groupsAccumulator = null;
    private ButtonWidget applyButton;
    private ButtonWidget resetButton;
    private TextFieldWidget vdbNameValue;
    private TextFieldWidget vdbVersionValue;
    private TextFieldWidget entitlementNameValue;
    private JTextArea entitlementDescription;
    private JTabbedPane tabbedPane;
    private JPanel buttonsPanel;
    private JPanel textPanel;
    private GridBagLayout layout;
    private List allAddedEnterpriseGroups = new ArrayList(1);
    private List allRemovedEnterpriseGroups = new ArrayList(1);
    private String existingDescription = "";
    private AuthorizationPolicyID policyID;
    private AuthorizationPolicy policy;
    private String vdbName;
    private int vdbVersion;
    private String entitlementName;
    private String entitlementDesc;
    private PermissionTreeView treeView;
    private JScrollPane authPanelScrollPane;
    private List existingEnterpriseGroups = null;
    private EntitlementManager manager;
    private GroupsManager groupsManager;

    public EntitlementDetailPanel(EntitlementsDataInterface dataSrc, RepaintController rc, boolean showMetaMatrix, boolean showEnterprise, boolean modifiable, EntitlementManager mgr, GroupsManager userMgr) {
        this.dataSource = dataSrc;
        this.showingMetaMatrix = showMetaMatrix;
        this.showingEnterprise = showEnterprise;
        this.canModify = modifiable;
        this.manager = mgr;
        this.groupsManager = userMgr;
        this.init();
        AuthenticationProviderManager authMgr = ModelManager.getAuthenticationProviderManager(userMgr.getConnection());
        if (authMgr != null) {
            authMgr.addProvidersChangeListener(this.groupsAccumulator);
        }
        this.groupsManager.addPrincipalChangeListener(this);
    }

    private void init() {
        this.layout = new GridBagLayout();
        this.setLayout(this.layout);
        this.applyButton = new ButtonWidget("Apply");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                EntitlementDetailPanel.this.applyPressed();
            }
        });
        this.resetButton = new ButtonWidget("Reset");
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                EntitlementDetailPanel.this.resetPressed();
            }
        });
        this.buttonsPanel = new JPanel();
        GridBagLayout bl = new GridBagLayout();
        this.buttonsPanel.setLayout(bl);
        this.buttonsPanel.add(this.applyButton);
        this.buttonsPanel.add(this.resetButton);
        bl.setConstraints(this.applyButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 15), 0, 0));
        bl.setConstraints(this.resetButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 5, 5), 0, 0));
        this.add(this.buttonsPanel);
        this.layout.setConstraints(this.buttonsPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonsPanel.setVisible(this.canModify);
        this.textPanel = new JPanel();
        GridBagLayout tl = new GridBagLayout();
        this.textPanel.setLayout(tl);
        LabelWidget nameLabel = new LabelWidget("Name:");
        this.textPanel.add(nameLabel);
        tl.setConstraints(nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.entitlementNameValue = new NoMinTextFieldWidget(75);
        this.entitlementNameValue.setEditable(false);
        this.entitlementNameValue.setForeground(VALUES_COLOR);
        this.textPanel.add(this.entitlementNameValue);
        tl.setConstraints(this.entitlementNameValue, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        LabelWidget descriptionLabel = new LabelWidget("Description:");
        this.textPanel.add(descriptionLabel);
        tl.setConstraints(descriptionLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
        DefaultTextFieldModel document = new DefaultTextFieldModel();
        document.setMaximumLength(250);
        this.entitlementDescription = new JTextArea(document);
        this.entitlementDescription.setColumns(40);
        this.entitlementDescription.setRows(4);
        this.entitlementDescription.setPreferredSize(new Dimension(150, 68));
        this.entitlementDescription.setLineWrap(true);
        this.entitlementDescription.setWrapStyleWord(true);
        this.entitlementDescription.setEditable(false);
        this.entitlementDescription.setText("");
        this.entitlementDescription.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent ev) {
            }

            @Override
            public void keyReleased(KeyEvent ev) {
                EntitlementDetailPanel.this.setButtonStates();
            }

            @Override
            public void keyTyped(KeyEvent ev) {
                EntitlementDetailPanel.this.setButtonStates();
            }
        });
        this.textPanel.add(this.entitlementDescription);
        tl.setConstraints(this.entitlementDescription, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        LabelWidget vdbNameLabel = new LabelWidget("VDB Name:");
        this.textPanel.add(vdbNameLabel);
        tl.setConstraints(vdbNameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.vdbNameValue = new NoMinTextFieldWidget(50);
        this.vdbNameValue.setEditable(false);
        this.vdbNameValue.setForeground(VALUES_COLOR);
        this.textPanel.add(this.vdbNameValue);
        tl.setConstraints(this.vdbNameValue, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        LabelWidget vdbVersLabel = new LabelWidget("VDB Version:");
        this.textPanel.add(vdbVersLabel);
        tl.setConstraints(vdbVersLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.vdbVersionValue = new NoMinTextFieldWidget(5);
        this.vdbVersionValue.setEditable(false);
        this.vdbVersionValue.setForeground(VALUES_COLOR);
        this.textPanel.add(this.vdbVersionValue);
        tl.setConstraints(this.vdbVersionValue, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.authorizationsPanel = new DataNodeAuthorizationsControl(this, this.canModify, false, true, true);
        this.groupsAccumulator = new GroupsAccumulatorPanel(new ArrayList(), this);
        this.tabbedPane = new JTabbedPane();
        this.add(this.tabbedPane);
        this.layout.setConstraints(this.tabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tabbedPane.addTab("Details", this.textPanel);
        this.tabbedPane.addTab("Authorizations", this.authorizationsPanel);
        this.tabbedPane.addTab("Groups", this.groupsAccumulator);
        this.resetButton.setEnabled(false);
        this.applyButton.setEnabled(false);
    }

    public String getEntitlementName() {
        return this.entitlementName;
    }

    public String getVDBName() {
        return this.vdbName;
    }

    public int getVDBVersion() {
        return this.vdbVersion;
    }

    public boolean isShowingMetaMatrix() {
        return this.showingMetaMatrix;
    }

    public boolean isShowingEnterprise() {
        return this.showingEnterprise;
    }

    private void applyPressed() {
        JScrollBar vertScrollBar;
        int value = -1;
        boolean resettingDataNodesTreeScrollPosit = false;
        if (this.authPanelScrollPane != null && (vertScrollBar = this.authPanelScrollPane.getVerticalScrollBar()) != null) {
            value = vertScrollBar.getValue();
            resettingDataNodesTreeScrollPosit = true;
        }
        this.doChanges();
        this.forceRepaint();
        if (resettingDataNodesTreeScrollPosit) {
            final int val = value;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EntitlementDetailPanel.this.authPanelScrollPane.getVerticalScrollBar().setValue(val);
                }
            });
        }
    }

    private void resetPressed() {
        this.clearChanges();
        this.forceRepaint();
    }

    @Override
    public GroupsManager getGroupsManager() {
        return this.groupsManager;
    }

    public void forceRepaint() {
        ConsoleMainFrame.getInstance().repaintNeeded();
    }

    public AuthorizationPolicyID getPolicyID() {
        return this.policyID;
    }

    public void populate(EntitlementInfo ent, boolean repopulatingSameEntitlement, boolean canModifyEntitlements) {
        if (ent != null) {
            this.policyID = ent.getPolicyID();
            this.policy = ent.getPolicy();
            this.vdbName = ent.getVDBName();
            this.vdbVersion = ent.getVDBVersion();
            this.entitlementName = ent.getEntitlementName();
            this.entitlementDesc = ent.getEntitlementDescription();
            this.treeView = ent.getTreeView();
            this.allAddedEnterpriseGroups = new ArrayList(50);
            this.allRemovedEnterpriseGroups = new ArrayList(50);
            this.vdbVersionValue.setText(new Integer(ent.getVDBVersion()).toString());
        } else {
            this.policyID = null;
            this.policy = null;
            this.vdbName = "";
            this.vdbVersion = -1;
            this.entitlementName = "";
            this.entitlementDesc = "";
            this.treeView = null;
            this.vdbVersionValue.setText("");
        }
        this.authPanelScrollPane = null;
        this.vdbNameValue.setText(this.vdbName);
        this.entitlementNameValue.setText(this.entitlementName);
        this.entitlementDescription.setText(this.entitlementDesc);
        this.authorizationsPanel.setTreeView(this.treeView, repopulatingSameEntitlement, canModifyEntitlements);
        if (ent != null) {
            this.existingDescription = ent.getEntitlementDescription();
            this.existingEnterpriseGroups = ent.getEnterpriseGroups();
        } else {
            this.existingDescription = "";
            this.existingEnterpriseGroups = new ArrayList();
        }
        this.setButtonStates();
        this.entitlementDescription.setEditable(this.canModify && ent != null);
        this.groupsAccumulator.repopulateTable(this.existingEnterpriseGroups);
        this.forceRepaint();
    }

    public void clear() {
        this.populate(null, false, this.canModify);
    }

    @Override
    public void postRealize() {
    }

    @Override
    public void permissionsChanged() {
        this.setButtonStates();
    }

    @Override
    public void principalsChanged() {
        this.setButtonStates();
    }

    private void setButtonStates() {
        boolean enabling = this.anyChangeMade();
        this.resetButton.setEnabled(enabling);
        this.applyButton.setEnabled(enabling);
    }

    private boolean anyChangeMade() {
        boolean change = false;
        if (!this.entitlementDescription.getText().equals(this.existingDescription)) {
            change = true;
        } else if (this.allRemovedEnterpriseGroups.size() > 0 || this.allAddedEnterpriseGroups.size() > 0) {
            change = true;
        } else if (this.anyDataNodesPermissionsChangeMade()) {
            change = true;
        }
        return change;
    }

    @Override
    public boolean havePendingChanges() {
        boolean changed = false;
        if (this.policy != null) {
            changed = this.anyChangeMade();
        }
        return changed;
    }

    @Override
    public boolean finishUp() {
        boolean stayingHere = false;
        String msg = "Save changes to role \"" + this.entitlementName + "\"?";
        int response = DialogUtility.showPendingChangesDialog(msg, this.manager.getConnection().getURL(), this.manager.getConnection().getUser());
        switch (response) {
            case 0: {
                this.doChanges();
                stayingHere = false;
                break;
            }
            case 1: {
                stayingHere = false;
                break;
            }
            case 2: {
                stayingHere = true;
            }
        }
        return !stayingHere;
    }

    private boolean anyDataNodesPermissionsChangeMade() {
        return this.authorizationsPanel.anyAuthorizationsChangesMade();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection addPressed(Component callingPanel) {
        try {
            NewGroupsWizardController controller = new NewGroupsWizardController(this.groupsManager);
            List newGroups = controller.runWizard(this.getExistingPlusAddedGroups());
            for (int i = 0; i < newGroups.size(); ++i) {
                Object group = newGroups.get(i);
                if (this.allRemovedEnterpriseGroups.contains(group)) {
                    this.allRemovedEnterpriseGroups.remove(group);
                }
                if (this.allAddedEnterpriseGroups.contains(group)) continue;
                this.allAddedEnterpriseGroups.add(group);
            }
            this.groupsAccumulator.repopulateTable(this.getExistingPlusAddedGroups());
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Assign Role to Groups", e);
        }
        finally {
            StaticUtilities.endWait(this);
        }
        this.principalsChanged();
        return null;
    }

    @Override
    public boolean removeConfirmed(Component callingPanel, Collection removedMMPrincipals) {
        for (Object group : removedMMPrincipals) {
            if (this.allAddedEnterpriseGroups.contains(group)) {
                this.allAddedEnterpriseGroups.remove(group);
            }
            if (this.allRemovedEnterpriseGroups.contains(group)) continue;
            this.allRemovedEnterpriseGroups.add(group);
        }
        this.principalsChanged();
        return true;
    }

    private List getExistingPlusAddedGroups() {
        if (this.existingEnterpriseGroups != null) {
            ArrayList existingPlusAdded = new ArrayList(this.existingEnterpriseGroups);
            for (Object group : this.allAddedEnterpriseGroups) {
                existingPlusAdded.add(group);
            }
            return existingPlusAdded;
        }
        return Collections.EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doChanges() {
        StaticUtilities.startWait(ViewManager.getMainFrame());
        String displayedDescription = this.entitlementDescription.getText();
        if (!displayedDescription.equals(this.existingDescription) && displayedDescription == null) {
            displayedDescription = "";
        }
        boolean continuing = true;
        try {
            List changedNodes = this.authorizationsPanel.nodesWithAuthorizationChanges();
            this.manager.changeAPolicy((PermissionDataNodeTreeView)this.treeView, this.policy, displayedDescription, this.allAddedEnterpriseGroups, this.allRemovedEnterpriseGroups, changedNodes);
        }
        catch (Exception ex) {
            StaticUtilities.endWait(ViewManager.getMainFrame());
            ExceptionUtility.showMessage("Modify Role", ex);
            continuing = false;
        }
        if (continuing) {
            try {
                EntitlementInfo info = this.dataSource.getEntitlementInfo(this.entitlementName, this.vdbName, this.vdbVersion);
                try {
                    this.populate(info, true, this.canModify);
                }
                catch (Exception e) {
                    StaticUtilities.endWait(ViewManager.getMainFrame());
                    ExceptionUtility.showMessage("Failed populating the detail panel ", e);
                    continuing = false;
                }
                finally {
                    StaticUtilities.endWait(ViewManager.getMainFrame());
                }
                this.forceRepaint();
                this.setButtonStates();
            }
            catch (Exception ex) {
                StaticUtilities.endWait(ViewManager.getMainFrame());
                ExceptionUtility.showMessage("Retrieve modified role", ex);
                continuing = false;
            }
        }
        if (continuing) {
            StaticUtilities.endWait(ViewManager.getMainFrame());
        }
    }

    private void clearChanges() {
        this.allAddedEnterpriseGroups.clear();
        this.allRemovedEnterpriseGroups.clear();
        this.groupsAccumulator.repopulateTable(this.existingEnterpriseGroups);
        this.entitlementDescription.setText(this.existingDescription);
        this.authorizationsPanel.reset();
        this.forceRepaint();
        this.setButtonStates();
    }

    @Override
    public void principalCreated(MetaMatrixPrincipalName princ) {
    }

    @Override
    public void principalDeleted(MetaMatrixPrincipalName princ) {
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }
}

