/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.entitlements;

import com.metamatrix.console.ui.layout.BasePanel;
import com.metamatrix.console.ui.views.entitlements.EntitlementsTable;
import com.metamatrix.console.ui.views.entitlements.EntitlementsTableRowData;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;

public class EntitlementSelector
extends BasePanel {
    private String title;
    private EntitlementsTable table;
    private ButtonWidget button = new ButtonWidget(" >> ");
    private TextFieldWidget entName = new TextFieldWidget();
    private TextFieldWidget vdbName = new TextFieldWidget();
    private TextFieldWidget vdbVers = new TextFieldWidget();
    private String entNameText;
    private String vdbNameText;
    private String vdbVersText;

    public EntitlementSelector(String ttl, EntitlementsTable tbl) {
        this.title = ttl;
        this.table = tbl;
        this.init();
    }

    private void init() {
        TitledBorder tBorder = new TitledBorder(this.title);
        this.setBorder(tBorder);
        tBorder.setTitleFont(tBorder.getTitleFont().deriveFont(1));
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                EntitlementSelector.this.buttonPressed();
            }
        });
        this.entName.setEditable(false);
        this.vdbName.setEditable(false);
        this.vdbVers.setEditable(false);
        LabelWidget entNameLabel = new LabelWidget("Role:");
        LabelWidget vdbNameLabel = new LabelWidget("VDB:");
        LabelWidget vdbVersLabel = new LabelWidget("vers:");
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        this.add(this.button);
        layout.setConstraints(this.button, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        JPanel listPanel = new JPanel();
        this.add(listPanel);
        layout.setConstraints(listPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        GridBagLayout ll = new GridBagLayout();
        listPanel.setLayout(ll);
        listPanel.add(entNameLabel);
        ll.setConstraints(entNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        listPanel.add(vdbNameLabel);
        ll.setConstraints(vdbNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        listPanel.add(vdbVersLabel);
        ll.setConstraints(vdbVersLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        listPanel.add(this.entName);
        listPanel.add(this.vdbName);
        listPanel.add(this.vdbVers);
        ll.setConstraints(this.entName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        ll.setConstraints(this.vdbName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        ll.setConstraints(this.vdbVers, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.table.getSelectionModel().setSelectionInterval(0, 0);
        this.buttonPressed();
    }

    private void buttonPressed() {
        this.entNameText = "";
        this.vdbNameText = "";
        this.vdbVersText = "";
        int row = this.table.getSelectionModel().getLeadSelectionIndex();
        if (row >= 0) {
            this.entNameText = this.table.getModel().getValueAt(row, 0).toString();
            this.vdbNameText = this.table.getModel().getValueAt(row, 1).toString();
            Object versNum = this.table.getModel().getValueAt(row, 2);
            if (versNum != null) {
                this.vdbVersText = versNum.toString();
            }
        }
        this.entName.setText(this.entNameText);
        this.vdbName.setText(this.vdbNameText);
        this.vdbVers.setText(this.vdbVersText);
    }

    public EntitlementsTableRowData getSelection() {
        String entNameStr = this.entNameText;
        String vdbNameStr = "";
        int vdbVersion = -1;
        if (!entNameStr.equals("") && !entNameStr.equals("")) {
            vdbNameStr = this.vdbNameText;
            vdbVersion = new Integer(this.vdbVersText);
        }
        return new EntitlementsTableRowData(entNameStr, vdbNameStr, vdbVersion);
    }
}

