/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.entitlements;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.EntitlementManager;
import com.metamatrix.console.models.GroupsManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.notification.DataEntitlementChangeNotification;
import com.metamatrix.console.notification.RuntimeUpdateNotification;
import com.metamatrix.console.security.UserCapabilities;
import com.metamatrix.console.ui.NotifyOnExitConsole;
import com.metamatrix.console.ui.layout.BasePanel;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.layout.MenuEntry;
import com.metamatrix.console.ui.layout.PanelsTree;
import com.metamatrix.console.ui.layout.WorkspacePanel;
import com.metamatrix.console.ui.util.RepaintController;
import com.metamatrix.console.ui.views.entitlements.EntitlementDetailPanel;
import com.metamatrix.console.ui.views.entitlements.EntitlementInfo;
import com.metamatrix.console.ui.views.entitlements.EntitlementsDataInterface;
import com.metamatrix.console.ui.views.entitlements.EntitlementsTable;
import com.metamatrix.console.ui.views.entitlements.EntitlementsTableModel;
import com.metamatrix.console.ui.views.entitlements.EntitlementsTableRowData;
import com.metamatrix.console.ui.views.entitlements.NewEntitlementController;
import com.metamatrix.console.util.DialogUtility;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.Refreshable;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.Splitter;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EntitlementsPanel
extends BasePanel
implements WorkspacePanel,
NotifyOnExitConsole,
RepaintController,
Refreshable {
    private final double DEFAULT_SPLITTER_PROPORTION = 0.25;
    private EntitlementsDataInterface dataSource;
    private ConnectionInfo connection;
    private EntitlementManager entitlementManager;
    private GroupsManager userManager;
    private ButtonWidget newButton;
    private ButtonWidget deleteButton;
    private Action deleteAction;
    private EntitlementsTable table;
    private EntitlementsTableModel tableModel;
    private EntitlementDetailPanel detailPanel;
    private boolean created = false;
    private JSplitPane splitPane = null;
    private List currentActions = new ArrayList(10);
    private boolean programmaticTableSelection = false;
    private boolean showingEditable;
    private boolean showingReadOnly;
    private boolean canModify;
    private int iSplitterChange = 5;
    private int currentSelectedModelIndex = 0;
    private int oldSelectedModelIndex;
    private String message = "Cannot create a role because no VDBs exist.";
    private boolean showingNewlyCreatedEntitlement = false;

    public EntitlementsPanel(EntitlementsDataInterface ds, boolean showEditable, boolean showReadOnly, ConnectionInfo conn) throws AuthorizationException, ExternalException {
        this.dataSource = ds;
        this.showingEditable = showEditable;
        this.showingReadOnly = showReadOnly;
        this.connection = conn;
        this.entitlementManager = ModelManager.getEntitlementManager(this.connection);
        this.userManager = ModelManager.getGroupsManager(this.connection);
        try {
            this.canModify = UserCapabilities.getInstance().canModifyEntitlements(this.connection);
        }
        catch (Exception ex) {
            throw new ExternalException(ex);
        }
        this.init();
    }

    @Override
    public void postRealize() {
        this.splitPane.setDividerLocation((int)((double)this.getSize().height * 0.25));
    }

    private void init() throws AuthorizationException, ExternalException {
        int splitterLoc = -1;
        if (this.created) {
            splitterLoc = this.splitPane.getDividerLocation();
            this.removeAll();
        }
        GridBagLayout l = new GridBagLayout();
        this.setLayout(l);
        EntitlementsTableRowData[] rows = this.dataSource.getEntitlements();
        this.tableModel = new EntitlementsTableModel(rows);
        this.table = new EntitlementsTable(this.tableModel);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                int index;
                EntitlementsPanel.this.oldSelectedModelIndex = EntitlementsPanel.this.currentSelectedModelIndex;
                if (!EntitlementsPanel.this.programmaticTableSelection && !ev.getValueIsAdjusting() && (index = EntitlementsPanel.this.table.getSelectionModel().getLeadSelectionIndex()) >= 0 && index < EntitlementsPanel.this.tableModel.getRowCount()) {
                    int modelIndex = EntitlementsPanel.this.table.convertRowIndexToModel(index);
                    EntitlementsPanel.this.currentSelectedModelIndex = modelIndex;
                    if (modelIndex >= 0) {
                        String entName = (String)EntitlementsPanel.this.table.getModel().getValueAt(modelIndex, 0);
                        String vdbName = (String)EntitlementsPanel.this.table.getModel().getValueAt(modelIndex, 1);
                        Integer vdbVersionInt = (Integer)EntitlementsPanel.this.table.getModel().getValueAt(modelIndex, 2);
                        int vdbVersion = vdbVersionInt;
                        StaticUtilities.startWait();
                        try {
                            EntitlementsPanel.this.showDetailForEntitlement(entName, vdbName, vdbVersion);
                            StaticUtilities.endWait();
                        }
                        catch (RuntimeException ex) {
                            StaticUtilities.endWait();
                            throw ex;
                        }
                    }
                }
                if ((index = EntitlementsPanel.this.table.getSelectionModel().getLeadSelectionIndex()) >= 0 && index < EntitlementsPanel.this.tableModel.getRowCount()) {
                    Rectangle rect = EntitlementsPanel.this.table.getCellRect(index, 0, true);
                    EntitlementsPanel.this.table.scrollRectToVisible(rect);
                } else {
                    EntitlementsPanel.this.clearDetail();
                }
            }
        });
        JScrollPane tablePane = new JScrollPane(this.table);
        this.newButton = new ButtonWidget("New...");
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (!EntitlementsPanel.this.anyVDBs()) {
                    JOptionPane.showMessageDialog(EntitlementsPanel.this, EntitlementsPanel.this.message);
                } else {
                    boolean proceeding = true;
                    if (EntitlementsPanel.this.havePendingChanges()) {
                        proceeding = EntitlementsPanel.this.finishUp();
                    }
                    if (proceeding) {
                        EntitlementsPanel.this.createNewEntitlement();
                    }
                }
            }
        });
        this.deleteButton = new ButtonWidget("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                EntitlementsPanel.this.deleteRequested();
            }
        });
        this.deleteButton.setEnabled(false);
        JPanel topPanel = new JPanel();
        GridBagLayout tl = new GridBagLayout();
        topPanel.setLayout(tl);
        topPanel.add(tablePane);
        tl.setConstraints(tablePane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        if (this.canModify) {
            EntitlementsCreateAction createAction = new EntitlementsCreateAction(this);
            this.currentActions.add(new MenuEntry("action", createAction));
            this.deleteAction = new EntitlementsDeleteAction(this);
            this.currentActions.add(new MenuEntry("action", this.deleteAction));
            this.deleteAction.setEnabled(false);
            JPanel buttonsPanel = new JPanel();
            topPanel.add(buttonsPanel);
            buttonsPanel.setLayout(new GridLayout(2, 1, 5, 5));
            buttonsPanel.add(this.newButton);
            buttonsPanel.add(this.deleteButton);
            tl.setConstraints(buttonsPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.detailPanel = new EntitlementDetailPanel(this.dataSource, this, this.showingEditable, this.showingReadOnly, this.canModify, this.entitlementManager, this.userManager);
        this.splitPane = new Splitter(0, true, topPanel, this.detailPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.add(this.splitPane);
        l.setConstraints(this.splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.created = true;
        if (splitterLoc >= 0) {
            this.splitPane.setDividerLocation(splitterLoc);
        }
    }

    public EntitlementsTable getTable() {
        return this.table;
    }

    private boolean anyVDBs() {
        boolean any = false;
        try {
            any = this.dataSource.getAllVDBs().size() > 0;
        }
        catch (Exception ex) {
            LogManager.logError((String)"ROLES", (Throwable)ex, (String)"Error retrieving list of VDBs");
            ExceptionUtility.showMessage("Retrieve list of VDBs", ex);
        }
        return any;
    }

    @Override
    public List resume() {
        if (this.table.getRowCount() <= 0) {
            this.clearDetail();
        }
        this.refreshImpl(false);
        return this.currentActions;
    }

    @Override
    public void receiveUpdateNotification(RuntimeUpdateNotification notification) {
        if (notification instanceof DataEntitlementChangeNotification) {
            this.refresh();
        }
    }

    @Override
    public void refresh() {
        this.refreshImpl(true);
    }

    private void refreshImpl(boolean repopulateSubpanels) {
        String selectedEntitlementName = null;
        String selectedVDBName = null;
        int selectedVDBVersionNum = -1;
        int curSelectedRow = this.table.getSelectedRow();
        if (curSelectedRow >= 0) {
            curSelectedRow = this.table.convertRowIndexToModel(curSelectedRow);
            selectedEntitlementName = (String)this.table.getModel().getValueAt(curSelectedRow, 0);
            selectedVDBName = (String)this.table.getModel().getValueAt(curSelectedRow, 1);
            selectedVDBVersionNum = (Integer)this.table.getModel().getValueAt(curSelectedRow, 2);
        }
        try {
            StaticUtilities.startWait();
            PanelsTree tree = PanelsTree.getInstance(this.getConnection());
            tree.setCursor(Cursor.getPredefinedCursor(3));
            this.repopulateTable(selectedEntitlementName, selectedVDBName, selectedVDBVersionNum, repopulateSubpanels);
            tree.setCursor(Cursor.getPredefinedCursor(0));
            StaticUtilities.endWait();
        }
        catch (RuntimeException ex) {
            StaticUtilities.endWait();
            throw ex;
        }
    }

    @Override
    public String getTitle() {
        return " Data Roles";
    }

    @Override
    public ConnectionInfo getConnection() {
        return this.connection;
    }

    public List getCurrentActions() {
        return this.currentActions;
    }

    public boolean doesEntitlementExist(String entName, String vdbName, int vdbVersion) throws AuthorizationException, ExternalException, ComponentNotFoundException {
        return this.dataSource.doesEntitlementExist(entName, vdbName, vdbVersion);
    }

    public void createNewEntitlement() {
        NewEntitlementController controller = null;
        try {
            controller = new NewEntitlementController(this, this.dataSource);
        }
        catch (Exception ex) {
            LogManager.logError((String)"ROLES", (Throwable)ex, (String)"Error creating NewEntitlementController");
            ExceptionUtility.showMessage("Create New Role", ex);
        }
        if (controller != null) {
            controller.go();
            if (controller.isCreated()) {
                EntitlementsTableRowData principalsEntitlement;
                String principalsEntName;
                EntitlementsTableRowData dataNodesEntitlement = controller.getDataNodesEntitlement();
                String dataNodesEntName = dataNodesEntitlement.getEntitlementName();
                if (dataNodesEntName == null || dataNodesEntName.equals("(none)") || dataNodesEntName.equals("")) {
                    dataNodesEntitlement = null;
                }
                if ((principalsEntName = (principalsEntitlement = controller.getPrincipalsEntitlement()).getEntitlementName()) == null || principalsEntName.equals("(none)") || principalsEntName.equals("")) {
                    principalsEntitlement = null;
                }
                boolean created = false;
                StaticUtilities.startWait();
                try {
                    this.entitlementManager.createNewEntitlement(controller.getEntitlementName(), controller.getEntitlementDescription(), controller.getVDBName(), controller.getVDBVersion(), dataNodesEntitlement, principalsEntitlement);
                    created = true;
                }
                catch (Exception ex) {
                    StaticUtilities.endWait();
                    LogManager.logError((String)"ROLES", (Throwable)ex, (String)"Error creating new role");
                    ExceptionUtility.showMessage("Create New Role", ex);
                }
                if (created) {
                    try {
                        this.showingNewlyCreatedEntitlement = true;
                        this.repopulateTable(controller.getEntitlementName(), controller.getVDBName(), controller.getVDBVersion(), true);
                        this.showingNewlyCreatedEntitlement = false;
                        new EntitlementsTableRowData(controller.getEntitlementName(), controller.getVDBName(), controller.getVDBVersion());
                        StaticUtilities.endWait();
                    }
                    catch (RuntimeException ex) {
                        StaticUtilities.endWait();
                        throw ex;
                    }
                }
            }
        }
    }

    private void repopulateTable(String selectionName, String vdbName, int vdbVersion, boolean repopulateSubpanels) {
        if (this.canModify) {
            this.deleteButton.setEnabled(false);
            this.deleteAction.setEnabled(false);
        }
        try {
            EntitlementsTableRowData[] rows = this.dataSource.getEntitlements();
            this.tableModel.init(rows);
            this.programmaticTableSelection = true;
            this.table.sort();
            this.programmaticTableSelection = false;
            int modelSelectionRow = -1;
            if (selectionName != null && vdbName != null && vdbVersion >= 0) {
                modelSelectionRow = this.modelRowForEntitlement(selectionName, vdbName, vdbVersion);
            }
            if (modelSelectionRow >= 0) {
                this.programmaticTableSelection = true;
                int viewSelectionRow = this.modelRowToViewRow(modelSelectionRow);
                this.table.getSelectionModel().setSelectionInterval(viewSelectionRow, viewSelectionRow);
                this.programmaticTableSelection = false;
                if (repopulateSubpanels) {
                    this.showDetailForEntitlement(selectionName, vdbName, vdbVersion);
                }
                this.forceRepaint();
            } else {
                this.programmaticTableSelection = true;
                this.table.clearSelection();
                this.programmaticTableSelection = false;
                this.forceRepaint();
            }
        }
        catch (Exception ex) {
            LogManager.logError((String)"ROLES", (Throwable)ex, (String)"Error populating roles table");
            ExceptionUtility.showMessage("Re-populate Roles Table", ex);
        }
    }

    @Override
    public void repaintNeeded() {
        int splitterLoc = this.splitPane.getDividerLocation();
        this.iSplitterChange *= -1;
        this.splitPane.setDividerLocation(splitterLoc + this.iSplitterChange);
        this.detailPanel.repaint();
    }

    private int modelRowForEntitlement(String name, String vdbName, int vdbVersion) {
        int matchRow = -1;
        if (name != null) {
            int numRows = this.table.getRowCount();
            int i = 0;
            while (i < numRows && matchRow < 0) {
                int vdbVers;
                String vdb;
                String entName = (String)this.table.getModel().getValueAt(i, 0);
                if (entName.equals(name) && (vdb = (String)this.table.getModel().getValueAt(i, 1)).equals(vdbName) && (vdbVers = ((Integer)this.table.getModel().getValueAt(i, 2)).intValue()) == vdbVersion) {
                    matchRow = i;
                }
                if (matchRow >= 0) continue;
                ++i;
            }
        }
        return matchRow;
    }

    private int modelRowToViewRow(int modelRow) {
        int viewRow = this.table.convertRowIndexToView(modelRow);
        return viewRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showDetailForEntitlement(String entName, String vdbName, int vdbVersion) {
        try {
            boolean proceeding = true;
            if (!this.showingNewlyCreatedEntitlement && this.havePendingChanges()) {
                proceeding = this.finishUp();
            }
            if (proceeding) {
                EntitlementInfo info = null;
                try {
                    info = this.dataSource.getEntitlementInfo(entName, vdbName, vdbVersion);
                }
                catch (Exception ex) {
                    LogManager.logError((String)"ROLES", (Throwable)ex, (String)"Error retrieving role details");
                    ExceptionUtility.showMessage("Retrieve Role Details", ex);
                    this.programmaticTableSelection = true;
                    this.table.getSelectionModel().setSelectionInterval(this.oldSelectedModelIndex, this.oldSelectedModelIndex);
                    this.programmaticTableSelection = false;
                }
                if (info != null) {
                    this.detailPanel.populate(info, false, this.canModify);
                }
            } else {
                this.programmaticTableSelection = true;
                this.table.getSelectionModel().setSelectionInterval(this.oldSelectedModelIndex, this.oldSelectedModelIndex);
                this.programmaticTableSelection = false;
            }
            if (this.canModify) {
                this.deleteButton.setEnabled(true);
                this.deleteAction.setEnabled(true);
            }
            this.forceRepaint();
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed populating the detail panel ", e);
        }
        finally {
            this.forceRepaint();
        }
    }

    private void deleteRequested() {
        boolean deleting = DialogUtility.yesNoDialog(ConsoleMainFrame.getInstance(), "Delete role \"" + this.detailPanel.getEntitlementName() + "\" for VDB \"" + this.detailPanel.getVDBName() + "\", version " + this.detailPanel.getVDBVersion() + "?", "Confirm Deletion");
        if (deleting) {
            boolean continuing = true;
            try {
                this.dataSource.deleteEntitlement(this.detailPanel.getPolicyID());
            }
            catch (Exception ex) {
                LogManager.logError((String)"ROLES", (Throwable)ex, (String)"Error deleting role");
                ExceptionUtility.showMessage("Delete Role", ex);
                continuing = false;
            }
            if (continuing) {
                this.clearDetail();
                this.programmaticTableSelection = true;
                this.repopulateTable(null, null, 0, true);
                this.programmaticTableSelection = false;
            }
        }
    }

    private void clearDetail() {
        this.detailPanel.clear();
        this.forceRepaint();
    }

    private void forceRepaint() {
        StaticUtilities.jiggleSplitter(this.splitPane);
        this.detailPanel.forceRepaint();
    }

    @Override
    public boolean havePendingChanges() {
        boolean haveChanges = false;
        if (this.detailPanel != null) {
            haveChanges = this.detailPanel.havePendingChanges();
        }
        return haveChanges;
    }

    @Override
    public boolean finishUp() {
        return this.detailPanel.finishUp();
    }

    class EntitlementsDeleteAction
    extends AbstractAction {
        private EntitlementsPanel caller;

        public EntitlementsDeleteAction(EntitlementsPanel cllr) {
            super("Delete Role");
            this.caller = cllr;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            this.caller.deleteRequested();
        }
    }

    class EntitlementsCreateAction
    extends AbstractAction {
        private EntitlementsPanel caller;

        public EntitlementsCreateAction(EntitlementsPanel cllr) {
            super("Create Role...");
            this.caller = cllr;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (!this.caller.anyVDBs()) {
                JOptionPane.showMessageDialog(EntitlementsPanel.this, EntitlementsPanel.this.message);
            } else {
                boolean proceeding = true;
                if (this.caller.havePendingChanges()) {
                    proceeding = this.caller.finishUp();
                }
                if (proceeding) {
                    this.caller.createNewEntitlement();
                }
            }
        }
    }
}

