/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.entitlements;

import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.WizardInterface;
import com.metamatrix.console.ui.views.entitlements.EntitlementsTable;
import com.metamatrix.console.ui.views.entitlements.EntitlementsTableModel;
import com.metamatrix.console.ui.views.entitlements.EntitlementsTableRowData;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class NewEntitlementBasedOnPanel
extends BasicWizardSubpanelContainer {
    private EntitlementsTable table;
    private String entNameText;
    private String vdbNameText;
    private String vdbVersText;
    private Object versNum;
    private LabelWidget name = new LabelWidget("Role Name");
    private TextFieldWidget nameTW = new TextFieldWidget(10);
    private LabelWidget versionLW = new LabelWidget("Role Version");
    private TextFieldWidget versionTW = new TextFieldWidget();
    private LabelWidget versionNLW = new LabelWidget("Version Number");
    private TextFieldWidget versionNum = new TextFieldWidget();

    public NewEntitlementBasedOnPanel(int stepNum, String title, String[] paragraphs, EntitlementsTableModel model, WizardInterface wizardInterface) {
        super(wizardInterface);
        JPanel panel = this.init(model);
        this.setMainContent(panel);
        this.setStepText(stepNum, true, title, paragraphs);
    }

    private JPanel init(EntitlementsTableModel oldModel) {
        JPanel panel = new JPanel();
        ButtonWidget clearButton = new ButtonWidget("Clear");
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewEntitlementBasedOnPanel.this.table.getSelectionModel().clearSelection();
                NewEntitlementBasedOnPanel.this.versionNum.setText("");
                NewEntitlementBasedOnPanel.this.nameTW.setText("");
                NewEntitlementBasedOnPanel.this.versionTW.setText("");
            }
        });
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        EntitlementsTableRowData[] rowData = this.convertToRowData(oldModel);
        EntitlementsTableModel newModel = new EntitlementsTableModel(rowData);
        this.table = new EntitlementsTable(newModel);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                NewEntitlementBasedOnPanel.this.tableSelectionChanged();
            }
        });
        JScrollPane tableSP = new JScrollPane(this.table);
        panel.add(tableSP);
        layout.setConstraints(tableSP, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add(clearButton);
        layout.setConstraints(clearButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        JPanel detailPanel = new JPanel();
        GridBagLayout dpLayout = new GridBagLayout();
        detailPanel.setLayout(dpLayout);
        dpLayout.setConstraints(this.name, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        dpLayout.setConstraints(this.nameTW, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        dpLayout.setConstraints(this.versionLW, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        dpLayout.setConstraints(this.versionTW, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        dpLayout.setConstraints(this.versionNLW, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        dpLayout.setConstraints(this.versionNum, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.nameTW.setEditable(false);
        this.versionTW.setEditable(false);
        this.versionNum.setEditable(false);
        detailPanel.add(this.name);
        detailPanel.add(this.nameTW);
        detailPanel.add(this.versionLW);
        detailPanel.add(this.versionTW);
        detailPanel.add(this.versionNLW);
        detailPanel.add(this.versionNum);
        layout.setConstraints(detailPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 15, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add(detailPanel);
        return panel;
    }

    private void tableSelectionChanged() {
        int apparentRow = this.table.getSelectionModel().getLeadSelectionIndex();
        int row = this.table.convertRowIndexToModel(apparentRow);
        if (row >= 0) {
            String enText = this.table.getModel().getValueAt(row, 0).toString();
            String vnText = this.table.getModel().getValueAt(row, 1).toString();
            Object vNum = this.table.getModel().getValueAt(row, 2);
            if (vNum != null) {
                String vvText = vNum.toString().trim();
                this.versionNum.setText(vvText);
            }
            this.nameTW.setText(enText);
            this.versionTW.setText(vnText);
        }
    }

    private EntitlementsTableRowData[] convertToRowData(EntitlementsTableModel model) {
        int modelRowCount = model.getRowCount();
        EntitlementsTableRowData[] rows = new EntitlementsTableRowData[modelRowCount];
        for (int i = 0; i < modelRowCount; ++i) {
            rows[i] = new EntitlementsTableRowData(model.getValueAt(i, 0).toString(), model.getValueAt(i, 1).toString(), (Integer)model.getValueAt(i, 2));
        }
        return rows;
    }

    public EntitlementsTableRowData getDataNodesSelectionRowData() {
        if (this.table.getSelectionModel().isSelectionEmpty()) {
            return new EntitlementsTableRowData(null, null, -1);
        }
        int apparentRow = this.table.getSelectionModel().getLeadSelectionIndex();
        int row = this.table.convertRowIndexToModel(apparentRow);
        if (row >= 0) {
            this.entNameText = this.table.getModel().getValueAt(row, 0).toString();
            this.vdbNameText = this.table.getModel().getValueAt(row, 1).toString();
            this.versNum = this.table.getModel().getValueAt(row, 2);
            if (this.versNum != null) {
                this.vdbVersText = this.versNum.toString().trim();
                this.versionNum.setText(this.vdbVersText);
            }
            this.nameTW.setText(this.entNameText);
            this.versionTW.setText(this.vdbNameText);
        }
        return this.getSelection();
    }

    public EntitlementsTableRowData getSelection() {
        String entNameStr = this.entNameText;
        String vdbNameStr = "";
        int vdbVersion = -1;
        vdbNameStr = this.vdbNameText;
        if (this.vdbVersText != null) {
            vdbVersion = new Integer(this.vdbVersText);
        }
        return new EntitlementsTableRowData(entNameStr, vdbNameStr, vdbVersion);
    }
}

