/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.entitlements;

import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.WizardInterface;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import com.metamatrix.toolbox.ui.widget.text.DefaultTextFieldModel;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class NewEntitlementConfirmationPanel
extends BasicWizardSubpanelContainer {
    public static final String NONE = "(none)";
    private TextFieldWidget nameValue;
    private JTextArea descValue;
    private TextFieldWidget vdbNameValue;
    private TextFieldWidget dataNodesValue;
    private TextFieldWidget principalsValue;
    public static final int MAX_DESCRIPTION_LENGTH = 250;
    private JScrollPane scpnDescription = new JScrollPane();

    public NewEntitlementConfirmationPanel(WizardInterface wizardInterface) {
        super(wizardInterface);
        JPanel panel = this.init();
        this.setMainContent(panel);
        this.setStepText(4, "Check and confirm the assigned values.");
    }

    public void setPrincipalsTexts(String principalsEnt, String principalsVDB, int principalsVDBVersion) {
        if (principalsEnt == null || principalsEnt.length() == 0 || principalsEnt.equals(NONE)) {
            this.principalsValue.setText(NONE);
        } else {
            this.principalsValue.setText(principalsEnt + ",  VDB: " + principalsVDB + "  Vers. " + principalsVDBVersion);
        }
    }

    public void clear() {
    }

    public void setTexts(String entitlementName, String description, String vdbName, String vdbVersion, String dataNodesEnt, String dataNodesVDB, int dataNodesVDBVersion) {
        this.nameValue.setText(entitlementName);
        this.descValue.setText(description);
        this.vdbNameValue.setText(vdbName + "      Vers. " + vdbVersion);
        if (dataNodesEnt == null || dataNodesEnt.length() == 0 || dataNodesEnt.equals(NONE)) {
            this.dataNodesValue.setText(NONE);
        } else {
            this.dataNodesValue.setText(dataNodesEnt + ",  VDB: " + dataNodesVDB + "  Vers. " + dataNodesVDBVersion);
        }
    }

    private JPanel init() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        LabelWidget pressFinishLabel = new LabelWidget("Press 'Finish' to create role:");
        pressFinishLabel.setFont(pressFinishLabel.getFont().deriveFont(1));
        panel.add(pressFinishLabel);
        layout.setConstraints(pressFinishLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 20, 10), 0, 0));
        JPanel infoPanel = new JPanel();
        infoPanel.setBorder(new TitledBorder(""));
        GridBagLayout il = new GridBagLayout();
        infoPanel.setLayout(il);
        LabelWidget nameLabel = new LabelWidget("Role name:");
        infoPanel.add(nameLabel);
        il.setConstraints(nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        LabelWidget descLabel = new LabelWidget("Role description:");
        infoPanel.add(descLabel);
        il.setConstraints(descLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        LabelWidget vdbNameLabel = new LabelWidget("VDB name:");
        infoPanel.add(vdbNameLabel);
        il.setConstraints(vdbNameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        LabelWidget dataNodesLabel = new LabelWidget("Authorizations set from role:");
        infoPanel.add(dataNodesLabel);
        il.setConstraints(dataNodesLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        LabelWidget principalsLabel = new LabelWidget("Groups set from role:");
        infoPanel.add(principalsLabel);
        il.setConstraints(principalsLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.nameValue = new TextFieldWidget();
        this.nameValue.setEditable(false);
        infoPanel.add(this.nameValue);
        il.setConstraints(this.nameValue, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        DefaultTextFieldModel document = new DefaultTextFieldModel();
        document.setMaximumLength(250);
        this.descValue = new JTextArea(document);
        this.descValue.setColumns(30);
        this.descValue.setRows(6);
        this.descValue.setPreferredSize(new Dimension(150, 68));
        this.descValue.setLineWrap(true);
        this.descValue.setWrapStyleWord(true);
        this.descValue.setText("");
        this.scpnDescription.setViewportView(this.descValue);
        this.descValue.setEditable(false);
        infoPanel.add(this.descValue);
        il.setConstraints(this.descValue, new GridBagConstraints(1, 1, 1, 1, 0.9, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.vdbNameValue = new TextFieldWidget();
        this.vdbNameValue.setEditable(false);
        infoPanel.add(this.vdbNameValue);
        il.setConstraints(this.vdbNameValue, new GridBagConstraints(1, 2, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.dataNodesValue = new TextFieldWidget();
        this.dataNodesValue.setEditable(false);
        infoPanel.add(this.dataNodesValue);
        il.setConstraints(this.dataNodesValue, new GridBagConstraints(1, 4, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.principalsValue = new TextFieldWidget();
        this.principalsValue.setEditable(false);
        infoPanel.add(this.principalsValue);
        il.setConstraints(this.principalsValue, new GridBagConstraints(1, 5, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add(infoPanel);
        layout.setConstraints(infoPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(20, 10, 20, 10), 0, 0));
        return panel;
    }
}

