/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.entitlements;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.views.entitlements.EntitlementsDataInterface;
import com.metamatrix.console.ui.views.entitlements.EntitlementsPanel;
import com.metamatrix.console.ui.views.entitlements.EntitlementsTableModel;
import com.metamatrix.console.ui.views.entitlements.EntitlementsTableRowData;
import com.metamatrix.console.ui.views.entitlements.NewEntitlementBasedOnPanel;
import com.metamatrix.console.ui.views.entitlements.NewEntitlementConfirmationPanel;
import com.metamatrix.console.ui.views.entitlements.NewEntitlementNamePanel;
import com.metamatrix.console.ui.views.entitlements.NewEntitlementWizardPanel;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.StaticUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;

public class NewEntitlementController {
    public static final int NOT_SHOWN = 1;
    public static final int DISABLED = 2;
    public static final int ENABLED = 3;
    public static final int CANCELLED = 1;
    public static final int NEXT_PRESSED = 2;
    public static final int FINISHED = 3;
    public static final int BACK_PRESSED = 4;
    public static final int HELP_PRESSED = 5;
    private EntitlementsPanel caller;
    private NewEntitlementWizardPanel wizard;
    private JDialog dialog;
    private boolean created = false;
    private NewEntitlementNamePanel firstPanel;
    private NewEntitlementBasedOnPanel secondPanel;
    private NewEntitlementBasedOnPanel thirdPanel;
    private NewEntitlementConfirmationPanel fourthPanel;
    private EntitlementsDataInterface dataSource;
    private int titleStepNum = 2;
    private String title = "Select existing roles on which to base authorizations.";
    private String[] titleParagraphs = new String[]{"Authorizations for the new role will be initially set to match authorizations for the selected role, for all data nodes existing in both roles."};
    private int pTitleStepNum = 3;
    private String pTitle = "Select existing roles on which to base groups.";
    private String[] pTitleParagraphs = new String[]{"groups for the new role will be initially set to match groups for the selected role."};

    public NewEntitlementController(EntitlementsPanel callr, EntitlementsDataInterface dataSrc) throws AuthorizationException, ExternalException, ComponentNotFoundException {
        this.caller = callr;
        this.dataSource = dataSrc;
        this.init();
    }

    private void init() throws AuthorizationException, ExternalException, ComponentNotFoundException {
        this.wizard = new NewEntitlementWizardPanel(this);
        this.firstPanel = new NewEntitlementNamePanel(this.dataSource, this, this.wizard);
        this.secondPanel = new NewEntitlementBasedOnPanel(this.titleStepNum, this.title, this.titleParagraphs, (EntitlementsTableModel)this.caller.getTable().getModel(), this.wizard);
        this.thirdPanel = new NewEntitlementBasedOnPanel(this.pTitleStepNum, this.pTitle, this.pTitleParagraphs, (EntitlementsTableModel)this.caller.getTable().getModel(), this.wizard);
        this.fourthPanel = new NewEntitlementConfirmationPanel(this.wizard);
        this.wizard.addPage(this.firstPanel);
        this.wizard.addPage(this.secondPanel);
        this.wizard.addPage(this.thirdPanel);
        this.wizard.addPage(this.fourthPanel);
        this.wizard.getFinishButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NewEntitlementController.this.finish();
                NewEntitlementController.this.dialog.dispose();
            }
        });
        this.wizard.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NewEntitlementController.this.dialog.dispose();
            }
        });
    }

    public void go() {
        this.dialog = new JDialog((Frame)ConsoleMainFrame.getInstance(), "Create New Role Wizard");
        this.dialog.setModal(true);
        this.dialog.getContentPane().add(this.wizard);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                NewEntitlementController.this.dialog.dispose();
            }
        });
        this.dialog.pack();
        Dimension size = this.dialog.getSize();
        this.dialog.setSize(size.width, Math.min(size.height, (int)((double)Toolkit.getDefaultToolkit().getScreenSize().height * 0.6)));
        this.dialog.setLocation(StaticUtilities.centerFrame(this.dialog.getSize()));
        this.dialog.show();
    }

    public boolean showNextPage() {
        boolean proceeding = true;
        Component comp = this.wizard.getCurrentPage();
        if (comp == this.secondPanel) {
            String entName = this.getEntitlementName();
            String entDescription = this.getEntitlementDescription();
            String vdbName = this.getVDBName();
            int vdbVersion = this.getVDBVersion();
            EntitlementsTableRowData dataNodesEnt = this.getDataNodesEntitlement();
            this.getPrincipalsEntitlement();
            this.fourthPanel.setTexts(entName, entDescription, vdbName, new Integer(vdbVersion).toString(), dataNodesEnt.getEntitlementName(), dataNodesEnt.getVDBName(), dataNodesEnt.getVDBVersion());
        } else if (comp == this.thirdPanel) {
            EntitlementsTableRowData principalsEnt = this.getPrincipalsEntitlement();
            this.fourthPanel.setPrincipalsTexts(principalsEnt.getEntitlementName(), principalsEnt.getVDBName(), principalsEnt.getVDBVersion());
        } else if (comp == this.firstPanel) {
            String entName = this.getEntitlementName();
            String vdbName = this.getVDBName();
            int vdbVersion = this.getVDBVersion();
            boolean exists = false;
            try {
                exists = this.caller.doesEntitlementExist(entName, vdbName, vdbVersion);
            }
            catch (Exception ex) {
                LogManager.logError((String)"ROLES", (Throwable)ex, (String)"Error determining if role exists.");
                ExceptionUtility.showMessage("Determine if role exists", ex);
            }
            if (exists) {
                proceeding = false;
                StaticUtilities.displayModalDialogWithOK("Role Already Exists", "Role \"" + entName + "\" for VDB \"" + vdbName + "\" version " + vdbVersion + " already exists.  " + "Must enter a different role name or select " + "another VDB.");
            }
        }
        return proceeding;
    }

    public void showPreviousPage() {
    }

    public void finish() {
        this.created = true;
    }

    public boolean isCreated() {
        return this.created;
    }

    public String getEntitlementName() {
        String entName = this.firstPanel.getEntitlementName().trim();
        return entName;
    }

    public String getEntitlementDescription() {
        String entDescription = this.firstPanel.getEntitlementDescription().trim();
        return entDescription;
    }

    public String getVDBName() {
        String vdbName = this.firstPanel.getVDBName().trim();
        return vdbName;
    }

    public int getVDBVersion() {
        int vdbVersion = this.firstPanel.getVDBVersion();
        return vdbVersion;
    }

    public EntitlementsTableRowData getDataNodesEntitlement() {
        EntitlementsTableRowData dataNodesEnt = this.secondPanel.getDataNodesSelectionRowData();
        return dataNodesEnt;
    }

    public EntitlementsTableRowData getPrincipalsEntitlement() {
        EntitlementsTableRowData dataNodesEnt = this.thirdPanel.getDataNodesSelectionRowData();
        return dataNodesEnt;
    }
}

