/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.entitlements;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.WizardInterface;
import com.metamatrix.console.ui.util.property.GuiComponentFactory;
import com.metamatrix.console.ui.util.property.TypeConstants;
import com.metamatrix.console.ui.views.entitlements.EntitlementsDataInterface;
import com.metamatrix.console.ui.views.entitlements.NewEntitlementController;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.StaticQuickSorter;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.text.DefaultTextFieldModel;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class NewEntitlementNamePanel
extends BasicWizardSubpanelContainer
implements TypeConstants {
    private static final double LABELS_X_WEIGHT = 0.3;
    private static final double VALUES_X_WEIGHT = 0.7;
    public static final int MAX_DESCRIPTION_LENGTH = 250;
    private TextFieldWidget nameField = GuiComponentFactory.createTextField("entitlementname");
    private JTextArea descriptionArea;
    private JScrollPane scpnDescription = new JScrollPane();
    private JComboBox vdbNameBox = new JComboBox();
    private JComboBox vdbVersionBox = new JComboBox();
    private EntitlementsDataInterface dataSource;
    private boolean hasBeenPainted = false;

    public NewEntitlementNamePanel(EntitlementsDataInterface dataSrc, NewEntitlementController ctrlr, WizardInterface wizardInterface) throws ExternalException, AuthorizationException, ComponentNotFoundException {
        super(wizardInterface);
        this.dataSource = dataSrc;
        JPanel panel = this.init();
        this.setMainContent(panel);
        this.setStepText(1, "Enter Role name and VDB information.");
    }

    private JPanel init() throws ExternalException, AuthorizationException, ComponentNotFoundException {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        this.vdbNameBox.setEditable(false);
        this.vdbVersionBox.setEditable(false);
        JPanel entryPanel = new JPanel();
        panel.add(entryPanel);
        layout.setConstraints(entryPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 20, 0, 0), 0, 0));
        GridBagLayout el = new GridBagLayout();
        entryPanel.setLayout(el);
        DefaultTextFieldModel document = new DefaultTextFieldModel();
        document.setMaximumLength(250);
        this.descriptionArea = new JTextArea(document);
        this.descriptionArea.setColumns(30);
        this.descriptionArea.setRows(6);
        this.descriptionArea.setPreferredSize(new Dimension(150, 68));
        this.descriptionArea.setLineWrap(true);
        this.descriptionArea.setWrapStyleWord(true);
        this.descriptionArea.setText("");
        this.scpnDescription.setViewportView(this.descriptionArea);
        LabelWidget nameLabel = new LabelWidget("*Role name:");
        this.setBoldFont(nameLabel);
        entryPanel.add(nameLabel);
        el.setConstraints(nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.3, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.nameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ev) {
                NewEntitlementNamePanel.this.checkOnEnabling(false);
            }

            @Override
            public void keyTyped(KeyEvent ev) {
                NewEntitlementNamePanel.this.checkOnEnabling(false);
            }
        });
        try {
            this.nameField.setInvalidCharacters(new String(new byte[]{33}));
        }
        catch (ParseException ex) {
            // empty catch block
        }
        entryPanel.add(this.nameField);
        el.setConstraints(this.nameField, new GridBagConstraints(1, 0, 1, 1, 0.7, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        LabelWidget descriptionLabel = new LabelWidget("Role description:");
        entryPanel.add(descriptionLabel);
        el.setConstraints(descriptionLabel, new GridBagConstraints(0, 1, 1, 1, 0.3, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        entryPanel.add(this.descriptionArea);
        el.setConstraints(this.descriptionArea, new GridBagConstraints(1, 1, 1, 1, 0.7, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        LabelWidget vdbNameLabel = new LabelWidget("*VDB name:");
        this.setBoldFont(vdbNameLabel);
        entryPanel.add(vdbNameLabel);
        el.setConstraints(vdbNameLabel, new GridBagConstraints(0, 2, 1, 1, 0.3, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        Collection vdbsColl = this.dataSource.getAllVDBs();
        String[] unsortedVDBs = new String[vdbsColl.size() + 1];
        unsortedVDBs[0] = "                    ";
        Iterator it = vdbsColl.iterator();
        int i = 1;
        while (it.hasNext()) {
            VirtualDatabase vdb = (VirtualDatabase)it.next();
            unsortedVDBs[i] = vdb.getName();
            ++i;
        }
        String[] vdbs = StaticQuickSorter.quickStringSort(unsortedVDBs);
        vdbs = this.removeDuplicates(vdbs);
        this.vdbNameBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                NewEntitlementNamePanel.this.checkOnEnabling(true);
            }
        });
        this.vdbNameBox.setModel(new DefaultComboBoxModel<String>(vdbs));
        entryPanel.add(this.vdbNameBox);
        el.setConstraints(this.vdbNameBox, new GridBagConstraints(1, 2, 1, 1, 0.7, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        LabelWidget vdbVersionLabel = new LabelWidget("*VDB Version:");
        this.setBoldFont(vdbVersionLabel);
        entryPanel.add(vdbVersionLabel);
        el.setConstraints(vdbVersionLabel, new GridBagConstraints(0, 3, 1, 1, 0.3, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.vdbVersionBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                NewEntitlementNamePanel.this.checkOnEnabling(false);
            }
        });
        this.vdbVersionBox.setEnabled(false);
        entryPanel.add(this.vdbVersionBox);
        el.setConstraints(this.vdbVersionBox, new GridBagConstraints(1, 3, 1, 1, 0.7, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        LabelWidget requiredFieldLabel = new LabelWidget("*Required field");
        this.setBoldFont(requiredFieldLabel);
        entryPanel.add(requiredFieldLabel);
        el.setConstraints(requiredFieldLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(15, 5, 5, 5), 0, 0));
        this.nameField.requestFocus();
        return panel;
    }

    @Override
    public void postRealize() {
        this.nameField.requestFocus();
    }

    public void checkOnEnabling(boolean vdbNameSelectionChanged) {
        String name = this.nameField.getText().trim();
        boolean nameEntered = name.length() > 0;
        String vdb = ((String)this.vdbNameBox.getSelectedItem()).trim();
        boolean vdbSelected = vdb.length() > 0;
        this.vdbVersionBox.setEnabled(vdbSelected);
        Vector<Object> versions = null;
        if (vdbNameSelectionChanged) {
            if (vdbSelected) {
                try {
                    int[] versionsArray = this.getVersionsForVDB(vdb);
                    versions = new Vector(versionsArray.length);
                    for (int i = 0; i < versionsArray.length; ++i) {
                        versions.add(new Integer(versionsArray[i]));
                    }
                }
                catch (Exception ex) {
                    ExceptionUtility.showMessage("Retrieve versions for selected VDB", ex);
                    return;
                }
            } else {
                versions = new Vector<Object>(1);
                versions.add("");
            }
            this.vdbVersionBox.setModel(new DefaultComboBoxModel(versions));
            this.vdbVersionBox.setSelectedIndex(versions.size() - 1);
        }
        AbstractButton nextButton = this.getWizardInterface().getForwardButton();
        nextButton.setEnabled(nameEntered && vdbSelected);
    }

    private int[] getVersionsForVDB(String vdb) throws AuthorizationException, ExternalException, ComponentNotFoundException {
        return this.dataSource.getVersionsForVDB(vdb);
    }

    public String getEntitlementName() {
        return this.nameField.getText().trim();
    }

    public String getEntitlementDescription() {
        return this.descriptionArea.getText().trim();
    }

    public String getVDBName() {
        return (String)this.vdbNameBox.getSelectedItem();
    }

    public int getVDBVersion() {
        return (Integer)this.vdbVersionBox.getSelectedItem();
    }

    private String[] removeDuplicates(String[] sortedStr) {
        if (sortedStr.length == 0) {
            return sortedStr;
        }
        ArrayList<String> c = new ArrayList<String>(sortedStr.length);
        c.add(sortedStr[0]);
        for (int i = 1; i < sortedStr.length; ++i) {
            if (sortedStr[i].equals(sortedStr[i - 1])) continue;
            c.add(sortedStr[i]);
        }
        String[] withoutDuplicates = new String[c.size()];
        Iterator it = c.iterator();
        int i = 0;
        while (it.hasNext()) {
            withoutDuplicates[i] = (String)it.next();
            ++i;
        }
        return withoutDuplicates;
    }

    private void setBoldFont(LabelWidget label) {
        Font tempFont = label.getFont();
        Font newFont = new Font(tempFont.getName(), 1, tempFont.getSize());
        label.setFont(newFont);
    }

    @Override
    public void paint(Graphics g) {
        if (!this.hasBeenPainted) {
            AbstractButton nextButton = this.getWizardInterface().getForwardButton();
            nextButton.setEnabled(false);
            this.hasBeenPainted = true;
        }
        super.paint(g);
    }
}

