/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.entitlements;

import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.CheckBox;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class PropagateChangesDialog
extends JDialog {
    private JCheckBox suppressDialogInFutureCheckBox;
    private boolean proceeding = true;
    private AbstractButton setToAuthorizedButton;
    private AbstractButton setToUnauthorizedButton;

    public PropagateChangesDialog(String permissionName, boolean toAuthorized) {
        super((Frame)ConsoleMainFrame.getInstance(), "Change Will be Propagated");
        this.setModal(true);
        this.init(permissionName, toAuthorized);
    }

    public PropagateChangesDialog(String permissionName) {
        super((Frame)ConsoleMainFrame.getInstance(), "Change Will be Propagated");
        this.setModal(true);
        this.initForPartial(permissionName);
    }

    private void init(String permissionName, boolean toAuthorized) {
        GridBagLayout layout = new GridBagLayout();
        this.getContentPane().setLayout(layout);
        String toWhat = toAuthorized ? "unauthorized to authorized" : "authorized to unauthorized";
        String firstLineStr = "\"" + permissionName + "\" permission change " + "from " + toWhat + " will be propagated";
        LabelWidget firstLine = new LabelWidget(firstLineStr);
        LabelWidget secondLine = new LabelWidget("to all descendant nodes of the selected node.");
        LabelWidget questionLine = new LabelWidget("Proceed with this change?");
        this.suppressDialogInFutureCheckBox = new CheckBox("In the future, do not show this warning");
        JPanel buttonsPanel = this.createButtonsPanel();
        this.getContentPane().add(firstLine);
        this.getContentPane().add(secondLine);
        this.getContentPane().add(questionLine);
        this.getContentPane().add(buttonsPanel);
        this.getContentPane().add(this.suppressDialogInFutureCheckBox);
        layout.setConstraints(firstLine, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 2, 10), 0, 0));
        layout.setConstraints(secondLine, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 10, 10, 10), 0, 0));
        layout.setConstraints(questionLine, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        layout.setConstraints(buttonsPanel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 5, 10), 0, 0));
        layout.setConstraints(this.suppressDialogInFutureCheckBox, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 5, 10), 0, 0));
        this.pack();
        this.setLocation(StaticUtilities.centerFrame(this.getSize()));
    }

    private void initForPartial(String permissionName) {
        GridBagLayout layout = new GridBagLayout();
        this.getContentPane().setLayout(layout);
        String firstLineStr = "\"" + permissionName + "\" permission change " + " will be propagated to all descendant nodes ";
        LabelWidget firstLine = new LabelWidget(firstLineStr);
        LabelWidget secondLine = new LabelWidget("of the selected node.");
        LabelWidget questionLine = new LabelWidget("Proceed with this change?");
        JPanel buttonsPanel = this.createButtonsPanel();
        JPanel changeToWhatPanel = this.createChangeToPanel(permissionName);
        this.getContentPane().add(changeToWhatPanel);
        this.getContentPane().add(firstLine);
        this.getContentPane().add(secondLine);
        this.getContentPane().add(questionLine);
        this.getContentPane().add(buttonsPanel);
        layout.setConstraints(changeToWhatPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 5, 10), 0, 0));
        layout.setConstraints(firstLine, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 2, 10), 0, 0));
        layout.setConstraints(secondLine, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 10, 10, 10), 0, 0));
        layout.setConstraints(questionLine, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        layout.setConstraints(buttonsPanel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 5, 10), 0, 0));
        this.pack();
        this.setLocation(StaticUtilities.centerFrame(this.getSize()));
    }

    private JPanel createButtonsPanel() {
        ButtonWidget yesButton = new ButtonWidget("Yes");
        ButtonWidget noButton = new ButtonWidget("No");
        JPanel buttonsPanel = new JPanel(new GridLayout(1, 2, 15, 15));
        buttonsPanel.add(yesButton);
        buttonsPanel.add(noButton);
        yesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                PropagateChangesDialog.this.yesPressed();
            }
        });
        noButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                PropagateChangesDialog.this.noPressed();
            }
        });
        return buttonsPanel;
    }

    private JPanel createChangeToPanel(String permissionName) {
        this.setToAuthorizedButton = new JRadioButton("Authorized (checked)");
        this.setToUnauthorizedButton = new JRadioButton("Unauthorized (unchecked)");
        ButtonGroup group = new ButtonGroup();
        group.add(this.setToAuthorizedButton);
        group.add(this.setToUnauthorizedButton);
        this.setToAuthorizedButton.setSelected(true);
        LabelWidget changeLabel = new LabelWidget("Change \"" + permissionName + "\" permission to:");
        GridBagLayout layout = new GridBagLayout();
        JPanel panel = new JPanel();
        panel.setLayout(layout);
        panel.add(this.setToAuthorizedButton);
        panel.add(this.setToUnauthorizedButton);
        panel.add(changeLabel);
        layout.setConstraints(changeLabel, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
        layout.setConstraints(this.setToAuthorizedButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        layout.setConstraints(this.setToUnauthorizedButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.setBorder(new TitledBorder(""));
        return panel;
    }

    private void yesPressed() {
        this.proceeding = true;
        this.dispose();
    }

    private void noPressed() {
        this.proceeding = false;
        this.dispose();
    }

    public boolean proceeding() {
        return this.proceeding;
    }

    public boolean discontinueDisplaying() {
        return this.suppressDialogInFutureCheckBox != null && this.suppressDialogInFutureCheckBox.isSelected();
    }

    public boolean setToAuthorized() {
        return this.setToAuthorizedButton.isSelected();
    }
}

