/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.extensionsource;

import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.WizardInterface;
import com.metamatrix.console.ui.views.extensionsource.NewExtensionSourceInfo;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JTextArea;

class AddConfirmationPanel
extends BasicWizardSubpanelContainer {
    private JPanel panel = null;
    private TextFieldWidget filePathTFW;
    private TextFieldWidget lengthTFW;
    private TextFieldWidget moduleNameTFW;
    private TextFieldWidget moduleTypeTFW;
    private JTextArea descriptionTextArea;

    public AddConfirmationPanel(WizardInterface wizardInterface) {
        super(wizardInterface);
        super.setStepText(3, "Confirmation.  Press \"Finish\" to add the module.");
    }

    public void setInfo(NewExtensionSourceInfo info) {
        if (this.panel == null) {
            this.panel = new JPanel();
            GridBagLayout layout = new GridBagLayout();
            this.panel.setLayout(layout);
            LabelWidget moduleFileLabel = new LabelWidget("Load module from file:");
            this.panel.add(moduleFileLabel);
            this.filePathTFW = new TextFieldWidget(info.getFileName());
            this.panel.add(this.filePathTFW);
            LabelWidget lengthLabel = new LabelWidget("File length:");
            this.panel.add(lengthLabel);
            this.lengthTFW = new TextFieldWidget(info.getFileContents().length + " bytes");
            this.panel.add(this.lengthTFW);
            LabelWidget saveAsLabel = new LabelWidget("Module name:");
            this.panel.add(saveAsLabel);
            this.moduleNameTFW = new TextFieldWidget(info.getModuleName());
            this.panel.add(this.moduleNameTFW);
            LabelWidget typeLabel = new LabelWidget("Module type:");
            this.panel.add(typeLabel);
            this.moduleTypeTFW = new TextFieldWidget(info.getModuleType());
            this.panel.add(this.moduleTypeTFW);
            LabelWidget enabledLabel = new LabelWidget("Enabled:");
            this.panel.add(enabledLabel);
            LabelWidget descriptionLabel = new LabelWidget("Description:");
            this.panel.add(descriptionLabel);
            this.descriptionTextArea = new JTextArea(info.getDescription());
            this.descriptionTextArea.setRows(3);
            this.descriptionTextArea.setLineWrap(true);
            this.descriptionTextArea.setWrapStyleWord(true);
            this.panel.add(this.descriptionTextArea);
            this.filePathTFW.setEditable(false);
            this.lengthTFW.setEditable(false);
            this.moduleNameTFW.setEditable(false);
            this.moduleTypeTFW.setEditable(false);
            this.descriptionTextArea.setEditable(false);
            layout.setConstraints(saveAsLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 5, 10), 0, 0));
            layout.setConstraints(typeLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 5, 10), 0, 0));
            layout.setConstraints(moduleFileLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 5, 10), 0, 0));
            layout.setConstraints(lengthLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 5, 10), 0, 0));
            layout.setConstraints(descriptionLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 10, 5, 10), 0, 0));
            layout.setConstraints(this.moduleNameTFW, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 5, 10), 0, 0));
            layout.setConstraints(this.moduleTypeTFW, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 5, 10), 0, 0));
            layout.setConstraints(this.filePathTFW, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 5, 10), 0, 0));
            layout.setConstraints(this.lengthTFW, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 5, 10), 0, 0));
            layout.setConstraints(this.descriptionTextArea, new GridBagConstraints(1, 6, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 10, 5, 10), 0, 0));
            super.setMainContent(this.panel);
        } else {
            this.filePathTFW.setText(info.getFileName());
            this.lengthTFW.setText(info.getFileContents().length + " bytes");
            this.moduleNameTFW.setText(info.getModuleName());
            this.moduleTypeTFW.setText(info.getModuleType());
            this.descriptionTextArea.setText(info.getDescription());
        }
    }
}

