/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.extensionsource;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.models.ExtensionSourceManager;
import com.metamatrix.console.ui.views.extensionsource.AddConfirmationPanel;
import com.metamatrix.console.ui.views.extensionsource.AdderWizardPanel;
import com.metamatrix.console.ui.views.extensionsource.NewExtensionSourceInfo;
import com.metamatrix.console.ui.views.extensionsource.NewFileInfoPanel;
import com.metamatrix.console.ui.views.extensionsource.NewFileSelectorPanel;
import com.metamatrix.console.ui.views.extensionsource.WizardPanelDialog;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.preference.UserPreferences;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.swing.JPanel;

public class ExtensionSourceAdder {
    private ExtensionSourceManager manager;
    private String[] fileTypes;
    private JPanel currentPanel;
    private NewFileSelectorPanel selectorPanel;
    private NewFileInfoPanel infoPanel;
    private AddConfirmationPanel confirmationPanel;
    private WizardPanelDialog dialog;
    private boolean cancelled = false;
    private boolean finished = false;
    private byte[] fileContents = null;

    public static String getFileName(File file, int maxLengthAllowed, boolean removeExtension) {
        String nameToUse;
        String nameWithExtension = file.getName();
        if (removeExtension) {
            int dotPosit = -1;
            int posit = nameWithExtension.length() - 1;
            while (posit >= 0 && dotPosit < 0) {
                char curChar = nameWithExtension.charAt(posit);
                if (curChar == '.') {
                    dotPosit = posit;
                    continue;
                }
                --posit;
            }
            if (dotPosit < 0) {
                dotPosit = nameWithExtension.length();
            }
            nameToUse = nameWithExtension.substring(0, dotPosit);
        } else {
            nameToUse = nameWithExtension;
        }
        if (nameToUse.length() > maxLengthAllowed) {
            nameToUse = nameToUse.substring(0, maxLengthAllowed);
        }
        return nameToUse;
    }

    public static String getFileExtension(File file) {
        String nameWithExtension = file.getName();
        String extension = "";
        int dotPosit = -1;
        int posit = nameWithExtension.length() - 1;
        while (posit >= 0 && dotPosit < 0) {
            char curChar = nameWithExtension.charAt(posit);
            if (curChar == '.') {
                dotPosit = posit;
                continue;
            }
            --posit;
        }
        if (dotPosit >= 0) {
            extension = nameWithExtension.substring(dotPosit + 1, nameWithExtension.length());
        }
        return extension;
    }

    public static byte[] contentsOf(File file) throws Exception {
        int n;
        FileInputStream stream = new FileInputStream(file);
        int length = (int)file.length();
        byte[] contents = new byte[length];
        for (int pos = 0; pos < length; pos += n) {
            n = ((InputStream)stream).read(contents, pos, contents.length - pos);
        }
        return contents;
    }

    public ExtensionSourceAdder(ExtensionSourceManager mgr, String[] fTypes) {
        this.manager = mgr;
        this.fileTypes = fTypes;
    }

    public String go() {
        AdderWizardPanel wizardPanel = new AdderWizardPanel(this);
        String moduleName = null;
        String initialDirectory = (String)UserPreferences.getInstance().getValue("metamatrix.console.lastextensionmodulesdirectory");
        this.selectorPanel = new NewFileSelectorPanel(wizardPanel, initialDirectory);
        this.infoPanel = new NewFileInfoPanel(this.fileTypes, wizardPanel);
        this.confirmationPanel = new AddConfirmationPanel(wizardPanel);
        wizardPanel.addPage(this.selectorPanel);
        wizardPanel.addPage(this.infoPanel);
        wizardPanel.addPage(this.confirmationPanel);
        wizardPanel.getNextButton().setEnabled(false);
        this.currentPanel = this.selectorPanel;
        wizardPanel.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ExtensionSourceAdder.this.cancelPressed();
            }
        });
        wizardPanel.getFinishButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (ExtensionSourceAdder.this.currentPanel == ExtensionSourceAdder.this.confirmationPanel) {
                    ExtensionSourceAdder.this.finishPressed();
                }
            }
        });
        this.dialog = new WizardPanelDialog(this, wizardPanel);
        this.dialog.show();
        if (this.finished && !this.cancelled) {
            try {
                NewExtensionSourceInfo exInfo = this.infoPanel.getInfo(this.fileContents);
                this.manager.addModule(exInfo);
                moduleName = exInfo.getModuleName();
                String directoryForModule = this.selectorPanel.getDirectoryName();
                UserPreferences.getInstance().setValue("metamatrix.console.lastextensionmodulesdirectory", directoryForModule);
                UserPreferences.getInstance().saveChanges();
            }
            catch (Exception ex) {
                String msg = "Error adding extension module.";
                LogManager.logError((String)"EXTENSION_SOURCES", (Throwable)ex, (String)msg);
                ExceptionUtility.showMessage(msg, ex);
            }
        }
        this.selectorPanel = null;
        this.infoPanel = null;
        this.confirmationPanel = null;
        wizardPanel = null;
        return moduleName;
    }

    public void dialogWindowClosing() {
        this.cancelled = true;
    }

    private void cancelPressed() {
        this.dialog.cancelPressed();
        this.cancelled = true;
    }

    private void finishPressed() {
        this.dialog.finishPressed();
        this.finished = true;
    }

    public boolean showNextPage() {
        boolean goingToNextPage = true;
        if (this.currentPanel == this.selectorPanel) {
            String fileName = this.selectorPanel.getSelectedFileName();
            File file = new File(fileName);
            if (!file.exists()) {
                StaticUtilities.displayModalDialogWithOK("Unable to open file", "Unable to open file " + fileName + ".  Must select " + "a different file or cancel.");
                goingToNextPage = false;
            } else {
                try {
                    this.fileContents = ExtensionSourceAdder.contentsOf(file);
                }
                catch (Exception ex) {
                    StaticUtilities.displayModalDialogWithOK("Unable to read file", "Unable to read file " + fileName + ".  Must select a different file or cancel.");
                    goingToNextPage = false;
                }
            }
            if (goingToNextPage) {
                String moduleName = ExtensionSourceAdder.getFileName(file, 255, false);
                String extension = ExtensionSourceAdder.getFileExtension(file);
                this.infoPanel.setDisplayInfo(fileName, extension, moduleName);
                this.currentPanel = this.infoPanel;
            }
        } else if (this.currentPanel == this.infoPanel) {
            String saveAsName = this.infoPanel.getSaveAsName();
            boolean exists = false;
            try {
                exists = this.manager.moduleExists(saveAsName);
            }
            catch (Exception ex) {
                LogManager.logError((String)"EXTENSION_SOURCES", (Throwable)ex, (String)"Error determining if module exists.");
                ExceptionUtility.showMessage("System error determining if an extension module exists", ex);
                goingToNextPage = false;
            }
            if (exists) {
                String msg = "Module \"" + saveAsName + "\" already exists.  " + "Must change the name or cancel.";
                StaticUtilities.displayModalDialogWithOK("Module already exists", msg);
                this.infoPanel.giveFocusToSaveAs();
                goingToNextPage = false;
            }
            if (goingToNextPage) {
                NewExtensionSourceInfo info = this.infoPanel.getInfo(this.fileContents);
                this.confirmationPanel.setInfo(info);
                this.currentPanel = this.confirmationPanel;
            }
        }
        return goingToNextPage;
    }

    public void showPreviousPage() {
        if (this.currentPanel == this.infoPanel) {
            this.currentPanel = this.selectorPanel;
        } else if (this.currentPanel == this.confirmationPanel) {
            this.currentPanel = this.infoPanel;
        }
    }
}

