/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.extensionsource;

import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.util.CenteredOptionPane;
import com.metamatrix.console.ui.views.extensionsource.ExtensionSourceDetailInfo;
import com.metamatrix.console.ui.views.extensionsource.ExtensionSourceDetailListener;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.text.DefaultTextFieldModel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ExtensionSourceDetailPanel
extends JPanel {
    private ExtensionSourceDetailListener listener;
    private boolean canModify;
    private int maxDescriptionLength;
    private String moduleName;
    private String moduleType;
    private String description;
    private String creator;
    private Date creationDate;
    private String lastUpdater;
    private Date lastUpdateDate;
    private TextFieldWidget moduleNameTFW;
    private TextFieldWidget moduleTypeTFW;
    private JTextArea descriptionJTA;
    private TextFieldWidget creatorTFW;
    private TextFieldWidget creationDateTFW;
    private TextFieldWidget updaterTFW;
    private TextFieldWidget updateDateTFW;
    private ButtonWidget applyButton;
    private ButtonWidget resetButton;
    private ButtonWidget deleteButton;
    private ButtonWidget replaceButton;
    private ButtonWidget exportButton;
    private boolean settingInitialContents = false;
    private ExtensionSourceDetailInfo detailInfo = null;

    public ExtensionSourceDetailPanel(ExtensionSourceDetailListener lsnr, boolean modifiable, int maxDescLen) {
        this.listener = lsnr;
        this.canModify = modifiable;
        this.maxDescriptionLength = maxDescLen;
        this.init();
    }

    private void init() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        LabelWidget moduleNameLW = new LabelWidget("Module Name:");
        LabelWidget moduleTypeLW = new LabelWidget("Module Type:");
        LabelWidget createdLW = new LabelWidget("Created");
        LabelWidget createdByLW = new LabelWidget("by");
        LabelWidget lastUpdatedLW = new LabelWidget("Last Updated");
        LabelWidget lastUpdatedByLW = new LabelWidget("by");
        LabelWidget descriptionLW = new LabelWidget("Description:");
        this.moduleNameTFW = new TextFieldWidget();
        this.moduleTypeTFW = new TextFieldWidget();
        DefaultTextFieldModel document = new DefaultTextFieldModel();
        document.setMaximumLength(this.maxDescriptionLength);
        this.descriptionJTA = new JTextArea(document);
        this.descriptionJTA.setRows(5);
        this.descriptionJTA.setColumns(35);
        this.descriptionJTA.setLineWrap(true);
        this.descriptionJTA.setWrapStyleWord(true);
        this.creatorTFW = new TextFieldWidget();
        this.creationDateTFW = new TextFieldWidget();
        this.updaterTFW = new TextFieldWidget();
        this.updateDateTFW = new TextFieldWidget();
        this.moduleNameTFW.setEditable(this.canModify);
        this.moduleNameTFW.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent ev) {
                ExtensionSourceDetailPanel.this.checkForChanges();
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                ExtensionSourceDetailPanel.this.checkForChanges();
            }

            @Override
            public void insertUpdate(DocumentEvent ev) {
                ExtensionSourceDetailPanel.this.checkForChanges();
            }
        });
        this.descriptionJTA.setEditable(this.canModify);
        this.descriptionJTA.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent ev) {
                ExtensionSourceDetailPanel.this.checkForChanges();
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                ExtensionSourceDetailPanel.this.checkForChanges();
            }

            @Override
            public void insertUpdate(DocumentEvent ev) {
                ExtensionSourceDetailPanel.this.checkForChanges();
            }
        });
        this.moduleTypeTFW.setEditable(false);
        this.creatorTFW.setEditable(false);
        this.creationDateTFW.setEditable(false);
        this.updaterTFW.setEditable(false);
        this.updateDateTFW.setEditable(false);
        JPanel buttonsPanel = new JPanel();
        this.exportButton = new ButtonWidget("Export...");
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ExtensionSourceDetailPanel.this.exportPressed();
            }
        });
        this.exportButton.setEnabled(false);
        if (this.canModify) {
            this.applyButton = new ButtonWidget("Apply");
            this.applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    ExtensionSourceDetailPanel.this.applyPressed();
                }
            });
            this.applyButton.setEnabled(false);
            this.resetButton = new ButtonWidget("Reset");
            this.resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    ExtensionSourceDetailPanel.this.resetPressed();
                }
            });
            this.resetButton.setEnabled(false);
            this.replaceButton = new ButtonWidget("Replace...");
            this.replaceButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    ExtensionSourceDetailPanel.this.replacePressed();
                }
            });
            this.replaceButton.setEnabled(false);
            this.deleteButton = new ButtonWidget("Delete");
            this.deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    ExtensionSourceDetailPanel.this.deletePressed();
                }
            });
            this.deleteButton.setEnabled(false);
            buttonsPanel.setLayout(new GridLayout(1, 5, 18, 0));
            buttonsPanel.add(this.applyButton);
            buttonsPanel.add(this.resetButton);
            buttonsPanel.add(this.replaceButton);
            buttonsPanel.add(this.exportButton);
            buttonsPanel.add(this.deleteButton);
        } else {
            buttonsPanel.setLayout(new GridLayout(1, 1));
            buttonsPanel.add(this.exportButton);
        }
        JPanel namePanel = new JPanel();
        GridBagLayout nameLayout = new GridBagLayout();
        namePanel.setLayout(nameLayout);
        namePanel.add(moduleNameLW);
        namePanel.add(this.moduleNameTFW);
        namePanel.add(moduleTypeLW);
        namePanel.add(this.moduleTypeTFW);
        nameLayout.setConstraints(moduleNameLW, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        nameLayout.setConstraints(this.moduleNameTFW, new GridBagConstraints(1, 0, 1, 1, 2.0, 0.0, 10, 2, new Insets(0, 8, 0, 8), 0, 0));
        nameLayout.setConstraints(moduleTypeLW, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        nameLayout.setConstraints(this.moduleTypeTFW, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 8, 0, 0), 0, 0));
        JPanel datesPanel = new JPanel();
        GridBagLayout datesLayout = new GridBagLayout();
        datesPanel.setLayout(datesLayout);
        datesPanel.add(createdLW);
        datesPanel.add(this.creationDateTFW);
        datesPanel.add(createdByLW);
        datesPanel.add(this.creatorTFW);
        datesPanel.add(lastUpdatedLW);
        datesPanel.add(this.updateDateTFW);
        datesPanel.add(lastUpdatedByLW);
        datesPanel.add(this.updaterTFW);
        datesLayout.setConstraints(createdLW, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 4, 4), 0, 0));
        datesLayout.setConstraints(this.creationDateTFW, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 4, 4, 8), 0, 0));
        datesLayout.setConstraints(createdByLW, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 8, 4, 4), 0, 0));
        datesLayout.setConstraints(this.creatorTFW, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 4, 4, 0), 0, 0));
        datesLayout.setConstraints(lastUpdatedLW, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 0, 4, 4), 0, 0));
        datesLayout.setConstraints(this.updateDateTFW, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 4, 4, 8), 0, 0));
        datesLayout.setConstraints(lastUpdatedByLW, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 8, 4, 4), 0, 0));
        datesLayout.setConstraints(this.updaterTFW, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 4, 4, 0), 0, 0));
        JPanel descPanel = new JPanel();
        GridBagLayout descLayout = new GridBagLayout();
        descPanel.setLayout(descLayout);
        descPanel.add(descriptionLW);
        descPanel.add(this.descriptionJTA);
        descLayout.setConstraints(descriptionLW, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        descLayout.setConstraints(this.descriptionJTA, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 3, new Insets(0, 4, 0, 0), 0, 0));
        this.add(namePanel);
        this.add(datesPanel);
        this.add(descPanel);
        this.add(buttonsPanel);
        layout.setConstraints(namePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.5, 10, 2, new Insets(4, 10, 4, 10), 0, 0));
        layout.setConstraints(datesPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.5, 10, 2, new Insets(4, 10, 4, 10), 0, 0));
        layout.setConstraints(descPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 10, 4, 10), 0, 0));
        layout.setConstraints(buttonsPanel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 10, 8, 10), 0, 0));
    }

    public void setInfo(ExtensionSourceDetailInfo info) {
        this.detailInfo = info;
        if (info == null) {
            this.moduleName = "";
            this.moduleType = "";
            this.description = "";
            this.creator = "";
            this.creationDate = null;
            this.lastUpdater = "";
            this.lastUpdateDate = null;
            if (this.deleteButton != null) {
                this.deleteButton.setEnabled(false);
            }
            if (this.replaceButton != null) {
                this.replaceButton.setEnabled(false);
            }
            if (this.exportButton != null) {
                this.exportButton.setEnabled(false);
            }
        } else {
            this.moduleName = info.getModuleName();
            this.moduleType = info.getModuleType();
            this.description = info.getDescription();
            if (this.description == null) {
                this.description = "";
            }
            this.creator = info.getCreatedBy();
            this.creationDate = info.getCreated();
            this.lastUpdater = info.getLastUpdatedBy();
            this.lastUpdateDate = info.getLastUpdated();
            if (this.deleteButton != null) {
                this.deleteButton.setEnabled(this.canModify);
            }
            if (this.replaceButton != null) {
                this.replaceButton.setEnabled(this.canModify);
            }
            if (this.exportButton != null) {
                this.exportButton.setEnabled(true);
            }
        }
        this.displayInfo(false);
    }

    private void displayInfo(boolean resetting) {
        this.settingInitialContents = true;
        this.moduleNameTFW.setText(this.moduleName);
        this.descriptionJTA.setText(this.description);
        if (this.detailInfo == null) {
            this.moduleNameTFW.setEditable(false);
            this.descriptionJTA.setEditable(false);
        } else {
            this.moduleNameTFW.setEditable(this.canModify);
            this.descriptionJTA.setEditable(this.canModify);
        }
        if (!resetting) {
            this.moduleTypeTFW.setText(this.moduleType);
            this.creatorTFW.setText(this.creator);
            if (this.creationDate != null) {
                this.creationDateTFW.setText(this.formatDate(this.creationDate));
            } else {
                this.creationDateTFW.setText("");
            }
            this.updaterTFW.setText(this.lastUpdater);
            if (this.lastUpdateDate != null) {
                this.updateDateTFW.setText(this.formatDate(this.lastUpdateDate));
            } else {
                this.updateDateTFW.setText("");
            }
        }
        this.settingInitialContents = false;
    }

    public void changeLastUpdatedInfo(Date newDate, String newUpdater) {
        this.lastUpdater = newUpdater;
        this.lastUpdateDate = newDate;
        this.updaterTFW.setText(this.lastUpdater);
        if (this.lastUpdateDate != null) {
            this.updateDateTFW.setText(this.formatDate(this.lastUpdateDate));
        } else {
            this.updateDateTFW.setText("");
        }
    }

    private void applyPressed() {
        boolean changed;
        String currentDescription;
        String newModuleName = null;
        String newDescription = null;
        Boolean newEnabled = null;
        String currentModuleName = this.moduleNameTFW.getText();
        if (!currentModuleName.equals(this.moduleName)) {
            newModuleName = currentModuleName;
        }
        if (!(currentDescription = this.descriptionJTA.getText()).equals(this.description)) {
            newDescription = currentDescription;
        }
        if (changed = this.listener.modifyRequested(newModuleName, newDescription, newEnabled)) {
            this.applyButton.setEnabled(false);
            this.resetButton.setEnabled(false);
            if (newModuleName != null) {
                this.moduleName = newModuleName;
            }
            if (newDescription != null) {
                this.description = newDescription;
            }
        }
    }

    private void resetPressed() {
        this.displayInfo(true);
        this.applyButton.setEnabled(false);
        this.resetButton.setEnabled(false);
    }

    private void exportPressed() {
        this.listener.exportRequested();
    }

    private void deletePressed() {
        String msg = "Delete module \"" + this.moduleName + "\"?";
        int response = CenteredOptionPane.showConfirmDialog(ConsoleMainFrame.getInstance(), msg, "Confirm Deletion", 0);
        if (response == 0) {
            this.listener.deleteRequested();
        }
    }

    private void replacePressed() {
        this.listener.replaceRequested();
    }

    private String formatDate(Date date) {
        String formattedDate = date.toString();
        return formattedDate;
    }

    private void checkForChanges() {
        if (this.canModify) {
            boolean changed = false;
            if (!this.settingInitialContents) {
                boolean bl = changed = !this.moduleNameTFW.getText().equals(this.moduleName);
                if (!changed) {
                    changed = !this.descriptionJTA.getText().equals(this.description);
                }
            }
            this.resetButton.setEnabled(changed);
            this.applyButton.setEnabled(changed);
        }
    }

    public boolean havePendingChanges() {
        boolean havePending = false;
        if (this.applyButton != null) {
            havePending = this.applyButton.isEnabled();
        }
        return havePending;
    }

    public void saveChanges() {
        this.applyPressed();
    }
}

