/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.extensionsource;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.models.ExtensionSourceManager;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.views.extensionsource.ExporterWizardPanel;
import com.metamatrix.console.ui.views.extensionsource.ExporterWizardPanelDialog;
import com.metamatrix.console.ui.views.extensionsource.TargetSelectorPanel;
import com.metamatrix.console.util.DialogUtility;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.preference.UserPreferences;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;

public class ExtensionSourceExporter {
    private ExtensionSourceManager manager;
    private String moduleName;
    private TargetSelectorPanel selectorPanel = null;
    private boolean finished = false;
    private ExporterWizardPanelDialog dialog = null;

    public ExtensionSourceExporter(String name, ExtensionSourceManager mgr) {
        this.manager = mgr;
        this.moduleName = name;
    }

    public boolean go() {
        boolean exported = false;
        ExporterWizardPanel wizardPanel = new ExporterWizardPanel(this);
        String initialDirectory = (String)UserPreferences.getInstance().getValue("metamatrix.console.lastextensionmodulesdirectory");
        this.selectorPanel = new TargetSelectorPanel(this.moduleName, wizardPanel, initialDirectory);
        wizardPanel.addPage(this.selectorPanel);
        wizardPanel.getFinishButton().setEnabled(true);
        wizardPanel.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ExtensionSourceExporter.this.cancelPressed();
            }
        });
        wizardPanel.getFinishButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ExtensionSourceExporter.this.finishPressed();
            }
        });
        this.dialog = new ExporterWizardPanelDialog(this, wizardPanel);
        this.dialog.show();
        if (this.finished) {
            String fileName = this.selectorPanel.getSelectedFileName();
            File target = new File(fileName);
            boolean proceeding = true;
            if (target.exists()) {
                String hdr = "File already exists";
                String msg = "File " + fileName + " already exists.  Exporting " + "will overwrite its current contents.  Proceed and " + "overwrite contents of file?";
                int response = DialogUtility.displayYesNoDialog(ConsoleMainFrame.getInstance(), hdr, msg);
                proceeding = response == 0;
            } else {
                try {
                    target.createNewFile();
                }
                catch (IOException ex) {
                    StaticUtilities.displayModalDialogWithOK("Cannot create target file", "Unable to create target file " + fileName + ".  Must select another file name or cancel.");
                    proceeding = false;
                }
            }
            if (proceeding) {
                if (!target.canWrite()) {
                    StaticUtilities.displayModalDialogWithOK("Cannot write to target file", "Unable to write to target file " + fileName + ".  Must select another file name or cancel.");
                    proceeding = false;
                }
                if (proceeding) {
                    try {
                        this.manager.exportToFile(this.moduleName, target);
                        StaticUtilities.displayModalDialogWithOK("Export successful", "Extension module " + this.moduleName + " successfully exported to file " + fileName + ".");
                        exported = true;
                    }
                    catch (Exception ex) {
                        LogManager.logError((String)"EXTENSION_SOURCES", (Throwable)ex, (String)"Error exporting extension module.");
                        ExceptionUtility.showMessage("Error exporting to file", ex);
                    }
                    if (exported) {
                        String directoryForModule = this.selectorPanel.getDirectoryName();
                        UserPreferences.getInstance().setValue("metamatrix.console.lastextensionmodulesdirectory", directoryForModule);
                        UserPreferences.getInstance().saveChanges();
                    }
                }
            }
        }
        this.selectorPanel = null;
        wizardPanel = null;
        return exported;
    }

    public void dialogWindowClosing() {
    }

    public boolean showNextPage() {
        boolean continuing = true;
        return continuing;
    }

    public void showPreviousPage() {
    }

    private void cancelPressed() {
        this.dialog.cancelPressed();
    }

    private void finishPressed() {
        this.dialog.finishPressed();
        this.finished = true;
    }
}

