/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.extensionsource;

import com.metamatrix.common.extensionmodule.exception.ExtensionModuleNotFoundException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.models.ExtensionSourceManager;
import com.metamatrix.console.ui.views.extensionsource.ConfirmationPanel;
import com.metamatrix.console.ui.views.extensionsource.ReplacementFileSelectorPanel;
import com.metamatrix.console.ui.views.extensionsource.ReplacementWizardPanel;
import com.metamatrix.console.ui.views.extensionsource.ReplacerWizardPanelDialog;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.preference.UserPreferences;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;

public class ExtensionSourceReplacer {
    private String moduleName;
    private ExtensionSourceManager manager;
    private JPanel currentPanel;
    private ReplacementFileSelectorPanel selectorPanel;
    private ConfirmationPanel confirmationPanel;
    private byte[] contents;
    private boolean finished = false;
    private ReplacerWizardPanelDialog dialog = null;

    public ExtensionSourceReplacer(String module, ExtensionSourceManager mgr) {
        this.moduleName = module;
        this.manager = mgr;
    }

    public boolean go() {
        ReplacementWizardPanel wizardPanel = new ReplacementWizardPanel(this);
        boolean replaced = false;
        String initialDirectory = (String)UserPreferences.getInstance().getValue("metamatrix.console.lastextensionmodulesdirectory");
        this.selectorPanel = new ReplacementFileSelectorPanel(this.moduleName, wizardPanel, initialDirectory);
        this.confirmationPanel = new ConfirmationPanel(wizardPanel);
        wizardPanel.addPage(this.selectorPanel);
        wizardPanel.addPage(this.confirmationPanel);
        wizardPanel.getNextButton().setEnabled(false);
        this.currentPanel = this.selectorPanel;
        wizardPanel.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ExtensionSourceReplacer.this.cancelPressed();
            }
        });
        wizardPanel.getFinishButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (ExtensionSourceReplacer.this.currentPanel == ExtensionSourceReplacer.this.confirmationPanel) {
                    ExtensionSourceReplacer.this.finishPressed();
                }
            }
        });
        this.dialog = new ReplacerWizardPanelDialog(this, wizardPanel);
        this.dialog.show();
        if (this.finished) {
            try {
                this.manager.replaceModule(this.moduleName, this.contents);
                replaced = true;
                String directoryForModule = this.selectorPanel.getDirectoryName();
                UserPreferences.getInstance().setValue("metamatrix.console.lastextensionmodulesdirectory", directoryForModule);
                StaticUtilities.displayModalDialogWithOK("Replacement successful", "Extension module " + this.moduleName + " successfully replaced with contents of file " + this.selectorPanel.getSelectedFileName() + ".");
            }
            catch (ExtensionModuleNotFoundException ex) {
                ExceptionUtility.showMessage("Extension module \"" + this.moduleName + "\" not found.", ex);
            }
            catch (Exception ex) {
                ExceptionUtility.showMessage("Replace extension module", ex);
                LogManager.logError((String)"EXTENSION_SOURCES", (Throwable)ex, (String)"Error replacing extension module.");
            }
        }
        this.selectorPanel = null;
        this.confirmationPanel = null;
        wizardPanel = null;
        return replaced;
    }

    public void dialogWindowClosing() {
    }

    private void cancelPressed() {
        this.dialog.cancelPressed();
    }

    private void finishPressed() {
        this.dialog.finishPressed();
        this.finished = true;
    }

    public boolean showNextPage() {
        boolean continuing = true;
        if (this.currentPanel == this.selectorPanel) {
            try {
                this.contents = this.selectorPanel.getSelectedFileContents();
            }
            catch (Exception ex) {
                StaticUtilities.displayModalDialogWithOK("Unable to open file", "Unable to open file " + this.selectorPanel.getSelectedFileName() + ".  Must select " + "a different file or cancel.");
                continuing = false;
            }
            if (continuing) {
                this.confirmationPanel.init(this.moduleName, this.selectorPanel.getSelectedFileName(), this.contents.length);
                this.currentPanel = this.confirmationPanel;
            }
        }
        return continuing;
    }

    public void showPreviousPage() {
        this.currentPanel = this.selectorPanel;
    }
}

