/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.extensionsource;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ExtensionSourceManager;
import com.metamatrix.console.notification.RuntimeUpdateNotification;
import com.metamatrix.console.ui.NotifyOnExitConsole;
import com.metamatrix.console.ui.layout.BasePanel;
import com.metamatrix.console.ui.layout.MenuEntry;
import com.metamatrix.console.ui.layout.WorkspacePanel;
import com.metamatrix.console.ui.util.AbstractPanelAction;
import com.metamatrix.console.ui.views.extensionsource.ExtensionModulesTable;
import com.metamatrix.console.ui.views.extensionsource.ExtensionSourceAdder;
import com.metamatrix.console.ui.views.extensionsource.ExtensionSourceDetailInfo;
import com.metamatrix.console.ui.views.extensionsource.ExtensionSourceDetailListener;
import com.metamatrix.console.ui.views.extensionsource.ExtensionSourceDetailPanel;
import com.metamatrix.console.ui.views.extensionsource.ExtensionSourceExporter;
import com.metamatrix.console.ui.views.extensionsource.ExtensionSourceReplacer;
import com.metamatrix.console.ui.views.extensionsource.ExtensionSourcesTableModel;
import com.metamatrix.console.util.DialogUtility;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.Refreshable;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.Splitter;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ExtensionSourcesPanel
extends BasePanel
implements WorkspacePanel,
NotifyOnExitConsole,
ExtensionSourceDetailListener,
Refreshable {
    public static final String EXTENSION_MODULES_INITIAL_FOLDER_KEY = "metamatrix.console.lastextensionmodulesdirectory";
    private static final int MAX_DESCRIPTION_LENGTH = 255;
    private ExtensionSourceManager manager;
    private boolean canModify;
    private ConnectionInfo connection;
    private TableWidget table;
    private ExtensionSourcesTableModel tableModel;
    private ExtensionSourceDetailPanel detail;
    private ButtonWidget addButton;
    private String detailedModule;
    private JSplitPane splitPane;
    private boolean programmaticSelectionChange = false;
    private boolean repopulatingTableAfterAdd = false;
    private List actions = new ArrayList();
    private AbstractAction addAction;
    private boolean clearingSelection = false;
    private boolean doingRefresh = false;
    private boolean populatingTable;

    public ExtensionSourcesPanel(ExtensionSourceManager mgr, boolean modifiable, ConnectionInfo conn) {
        this.manager = mgr;
        this.canModify = modifiable;
        this.connection = conn;
        this.init();
    }

    private void init() {
        this.tableModel = new ExtensionSourcesTableModel();
        this.table = new ExtensionModulesTable(this.tableModel);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                if (!ev.getValueIsAdjusting()) {
                    ExtensionSourcesPanel.this.tableSelectionChanged();
                }
            }
        });
        if (this.canModify) {
            this.addAction = new PanelAction(0);
            this.addAction.setEnabled(true);
            this.actions.add(new MenuEntry("action", this.addAction));
            this.addButton = new ButtonWidget("   Add...   ");
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    ExtensionSourcesPanel.this.addPressed();
                }
            });
        }
        this.detail = new ExtensionSourceDetailPanel(this, this.canModify, 255);
        this.layoutStuff();
        if (this.manager != null) {
            this.populateTable(null, null);
        }
    }

    private void layoutStuff() {
        JPanel buttonsPanel = null;
        if (this.canModify) {
            buttonsPanel = new JPanel();
            GridBagLayout bl = new GridBagLayout();
            buttonsPanel.setLayout(bl);
            buttonsPanel.add(this.addButton);
            bl.setConstraints(this.addButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(8, 0, 8, 0), 0, 0));
        }
        JPanel upperPanel = new JPanel();
        GridBagLayout ul = new GridBagLayout();
        upperPanel.setLayout(ul);
        JScrollPane tableSP = new JScrollPane(this.table);
        upperPanel.add(tableSP);
        ul.setConstraints(tableSP, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 4), 0, 0));
        if (this.canModify) {
            upperPanel.add(buttonsPanel);
            ul.setConstraints(buttonsPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(30, 8, 0, 8), 0, 0));
        }
        this.splitPane = new Splitter(0, true, upperPanel, this.detail);
        this.splitPane.setOneTouchExpandable(true);
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        this.add(this.splitPane);
        layout.setConstraints(this.splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void postRealize() {
        this.splitPane.setDividerLocation(0.5);
    }

    public void populateTable(String moduleToSelect, ExtensionSourceDetailInfo[] modules) {
        try {
            int i;
            this.populatingTable = true;
            ExtensionSourceDetailInfo[] orderedModules = modules != null ? modules : this.manager.getModules();
            int numRows = this.tableModel.getRowCount();
            this.clearingSelection = true;
            this.table.getSelectionModel().clearSelection();
            this.clearingSelection = false;
            for (i = numRows - 1; i >= 0; --i) {
                this.tableModel.removeRow(i);
            }
            for (i = 0; i < orderedModules.length; ++i) {
                Object[] rowValues = new Object[]{orderedModules[i].getModuleName(), orderedModules[i].getModuleType()};
                this.tableModel.insertRow(i, rowValues);
            }
            this.populatingTable = false;
            if (moduleToSelect == null) {
                this.detail.setInfo(null);
            } else {
                int selectionRow = this.rowForModule(moduleToSelect);
                if (selectionRow >= 0) {
                    this.table.getSelectionModel().setSelectionInterval(selectionRow, selectionRow);
                }
            }
        }
        catch (Exception ex) {
            LogManager.logError((String)"EXTENSION_SOURCES", (Throwable)ex, (String)"Error populating extension modules table.");
            ExceptionUtility.showMessage("Error populating extension modules table", ex);
        }
        this.populatingTable = false;
    }

    @Override
    public String getTitle() {
        return "Extension Modules";
    }

    @Override
    public ConnectionInfo getConnection() {
        return this.connection;
    }

    @Override
    public void receiveUpdateNotification(RuntimeUpdateNotification notification) {
    }

    @Override
    public List resume() {
        return this.actions;
    }

    private boolean doDetailPendingChanges() {
        boolean continuing = true;
        String msg = "Save changes to extension module \"" + this.detailedModule + "\"?";
        int response = DialogUtility.showPendingChangesDialog(msg, this.manager.getConnection().getURL(), this.manager.getConnection().getUser());
        switch (response) {
            case 0: {
                this.detail.saveChanges();
                continuing = true;
                break;
            }
            case 1: {
                continuing = true;
                break;
            }
            case 2: {
                continuing = false;
            }
        }
        return continuing;
    }

    @Override
    public boolean havePendingChanges() {
        boolean havePending = this.doingRefresh ? false : this.detail.havePendingChanges();
        return havePending;
    }

    @Override
    public boolean finishUp() {
        boolean stayingHere = false;
        if (!this.doingRefresh && this.detail.havePendingChanges()) {
            stayingHere = !this.doDetailPendingChanges();
        }
        return !stayingHere;
    }

    private void tableSelectionChanged() {
        if (!this.programmaticSelectionChange && !this.populatingTable) {
            boolean proceeding = true;
            if (!this.repopulatingTableAfterAdd && this.detail.havePendingChanges()) {
                proceeding = this.doDetailPendingChanges();
            }
            if (proceeding) {
                int selectedRow = this.clearingSelection ? -1 : this.table.getSelectionModel().getLeadSelectionIndex();
                this.displayDetailForRow(selectedRow);
            } else {
                int prevSelectedRow = this.rowForModule(this.detailedModule);
                this.programmaticSelectionChange = true;
                this.table.getSelectionModel().setSelectionInterval(prevSelectedRow, prevSelectedRow);
                this.programmaticSelectionChange = false;
            }
        }
    }

    private void displayDetailForRow(int row) {
        String name = this.getNameForRow(row);
        ExtensionSourceDetailInfo detailInfo = null;
        if (row >= 0) {
            try {
                detailInfo = this.manager.getDetailForModule(name);
            }
            catch (Exception ex) {
                LogManager.logError((String)"EXTENSION_SOURCES", (Throwable)ex, (String)"Error retrieving details for extension module.");
                ExceptionUtility.showMessage("Retrieve details for extension module", ex);
            }
            if (detailInfo != null) {
                this.detailedModule = detailInfo.getModuleName();
                this.detail.setInfo(detailInfo);
            }
        } else {
            this.detail.setInfo(detailInfo);
        }
    }

    public void displayDetail(ExtensionSourceDetailInfo detailInfo) {
        this.detail.setInfo(detailInfo);
    }

    private String getNameForRow(int row) {
        String name = null;
        if (row >= 0) {
            int modelRow = this.table.convertRowIndexToModel(row);
            name = (String)this.table.getModel().getValueAt(modelRow, 0);
        }
        return name;
    }

    private int rowForModule(String moduleName) {
        int matchRow = -1;
        int i = 0;
        int numRows = this.table.getRowCount();
        while (i < numRows && matchRow < 0) {
            String moduleNameForRow = this.getNameForRow(i);
            if (moduleNameForRow.equals(moduleName)) {
                matchRow = i;
                continue;
            }
            ++i;
        }
        return matchRow;
    }

    @Override
    public void deleteRequested() {
        try {
            this.manager.deleteModule(this.detailedModule);
            this.detailedModule = null;
            this.populateTable(null, null);
        }
        catch (Exception ex) {
            LogManager.logError((String)"EXTENSION_SOURCES", (Throwable)ex, (String)"Error attempting to delete an extension module.");
            ExceptionUtility.showMessage("Error deleting extension module", ex);
        }
    }

    @Override
    public void exportRequested() {
        this.doExportModuleWizard();
    }

    @Override
    public void replaceRequested() {
        this.doReplaceModuleWizard();
    }

    @Override
    public boolean modifyRequested(String newModuleName, String newDescription, Boolean enabled) {
        boolean modified = false;
        try {
            this.manager.modifyModule(this.detailedModule, newModuleName, newDescription, enabled, null);
            modified = true;
            if (newModuleName != null) {
                int selectedRow = this.table.getSelectedRow();
                this.table.getModel().setValueAt(newModuleName, selectedRow, 0);
                this.detailedModule = newModuleName;
            }
        }
        catch (Exception ex) {
            LogManager.logError((String)"EXTENSION_SOURCES", (Throwable)ex, (String)"Error attempting to modify an extension module.");
            ExceptionUtility.showMessage("Error modifying extension module", ex);
        }
        if (modified) {
            try {
                ExtensionSourceDetailInfo detailInfo = this.manager.getDetailForModule(this.detailedModule);
                this.detail.changeLastUpdatedInfo(detailInfo.getLastUpdated(), detailInfo.getLastUpdatedBy());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return modified;
    }

    private void addPressed() {
        boolean proceeding = true;
        if (this.detail.havePendingChanges()) {
            proceeding = this.doDetailPendingChanges();
        }
        if (proceeding) {
            this.doAddNewModuleWizard();
        }
    }

    private void doAddNewModuleWizard() {
        ExtensionSourceAdder adder;
        String moduleName;
        String[] moduleTypes = null;
        try {
            moduleTypes = this.manager.getModuleTypes();
        }
        catch (Exception ex) {
            LogManager.logError((String)"EXTENSION_SOURCES", (Throwable)ex, (String)"Error retrieving extension module types");
            ExceptionUtility.showMessage("Error retrieving extension module types", ex);
        }
        if (moduleTypes != null && (moduleName = (adder = new ExtensionSourceAdder(this.manager, moduleTypes)).go()) != null) {
            this.repopulatingTableAfterAdd = true;
            this.populateTable(moduleName, null);
            this.repopulatingTableAfterAdd = false;
        }
    }

    private void doExportModuleWizard() {
        ExtensionSourceExporter exporter = new ExtensionSourceExporter(this.detailedModule, this.manager);
        exporter.go();
    }

    private void doReplaceModuleWizard() {
        ExtensionSourceReplacer replacer = new ExtensionSourceReplacer(this.detailedModule, this.manager);
        boolean replaced = replacer.go();
        if (replaced) {
            try {
                ExtensionSourceDetailInfo detailInfo = this.manager.getDetailForModule(this.detailedModule);
                this.detail.changeLastUpdatedInfo(detailInfo.getLastUpdated(), detailInfo.getLastUpdatedBy());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void refresh() {
        this.doingRefresh = true;
        this.populateTable(this.detailedModule, null);
        this.doingRefresh = false;
    }

    private class PanelAction
    extends AbstractPanelAction {
        public static final int ADD = 0;
        public static final int REFRESH = 1;

        public PanelAction(int theType) {
            super(theType);
            if (theType == 0) {
                this.putValue("Name", "Add...");
                this.putValue("ShortDescription", "Add Extension Modules");
            } else if (theType == 1) {
                this.putValue("Name", "Refresh");
                this.putValue("ShortDescription", "Query for current list of Extension Modules");
            }
        }

        @Override
        protected void actionImpl(ActionEvent theEvent) throws ExternalException {
            if (this.type == 0) {
                ExtensionSourcesPanel.this.doAddNewModuleWizard();
            } else if (this.type == 1) {
                ExtensionSourcesPanel.this.refresh();
            }
        }
    }
}

