/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.extensionsource;

import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.WizardInterface;
import com.metamatrix.console.ui.views.extensionsource.NewExtensionSourceInfo;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.text.DefaultTextFieldModel;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class NewFileInfoPanel
extends BasicWizardSubpanelContainer {
    private String initialModuleName;
    private String[] fileTypes;
    private JPanel panel = null;
    private TextFieldWidget fileNameTFW;
    private TextFieldWidget saveAsTFW;
    private JComboBox fileTypesComboBox;
    private JTextArea descriptionTextArea;

    public NewFileInfoPanel(String[] fTypes, WizardInterface wizardInterface) {
        super(wizardInterface);
        this.fileTypes = new String[fTypes.length + 1];
        this.fileTypes[0] = "";
        for (int i = 0; i < fTypes.length; ++i) {
            this.fileTypes[i + 1] = fTypes[i];
        }
        this.panel = this.init();
        super.setStepText(2, "Enter extension module information.");
        super.setMainContent(this.panel);
    }

    private JPanel init() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        this.fileNameTFW = new TextFieldWidget();
        this.fileNameTFW.setEditable(false);
        DefaultTextFieldModel document = new DefaultTextFieldModel();
        document.setMaximumLength(255);
        this.saveAsTFW = new TextFieldWidget();
        this.saveAsTFW.setDocument(document);
        this.saveAsTFW.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent ev) {
                NewFileInfoPanel.this.changeMade();
            }

            @Override
            public void insertUpdate(DocumentEvent ev) {
                NewFileInfoPanel.this.changeMade();
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                NewFileInfoPanel.this.changeMade();
            }
        });
        this.fileTypesComboBox = new JComboBox<String>(this.fileTypes);
        this.fileTypesComboBox.setEditable(false);
        this.fileTypesComboBox.setBackground(Color.white);
        this.addComboBoxActionListener();
        DefaultTextFieldModel document2 = new DefaultTextFieldModel();
        document2.setMaximumLength(255);
        this.descriptionTextArea = new JTextArea(document2);
        this.descriptionTextArea.setRows(3);
        this.descriptionTextArea.setText("");
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setWrapStyleWord(true);
        this.descriptionTextArea.setMinimumSize(this.descriptionTextArea.getPreferredSize());
        LabelWidget moduleFileLabel = new LabelWidget("File containing module:");
        LabelWidget saveAsLabel = new LabelWidget("*Save as module name:");
        this.setBoldFont(saveAsLabel);
        LabelWidget typeLabel = new LabelWidget("*Module type:");
        this.setBoldFont(typeLabel);
        LabelWidget descriptionLabel = new LabelWidget("Description:");
        LabelWidget requiredFieldLabel = new LabelWidget("*Required field");
        panel.add(this.fileNameTFW);
        panel.add(this.saveAsTFW);
        panel.add(this.fileTypesComboBox);
        panel.add(this.descriptionTextArea);
        panel.add(moduleFileLabel);
        panel.add(saveAsLabel);
        panel.add(typeLabel);
        panel.add(descriptionLabel);
        panel.add(requiredFieldLabel);
        this.setBoldFont(requiredFieldLabel);
        layout.setConstraints(moduleFileLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 5, 5), 0, 0));
        layout.setConstraints(saveAsLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        layout.setConstraints(typeLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        layout.setConstraints(descriptionLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 10, 5), 0, 0));
        layout.setConstraints(requiredFieldLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 1.0, 12, 0, new Insets(15, 5, 5, 5), 0, 0));
        layout.setConstraints(this.fileNameTFW, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        layout.setConstraints(this.saveAsTFW, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        layout.setConstraints(this.fileTypesComboBox, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        layout.setConstraints(this.descriptionTextArea, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private void setBoldFont(LabelWidget label) {
        Font tempFont = label.getFont();
        Font newFont = new Font(tempFont.getName(), 1, tempFont.getSize());
        label.setFont(newFont);
    }

    private void addComboBoxActionListener() {
        this.fileTypesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NewFileInfoPanel.this.changeMade();
            }
        });
    }

    public void setDisplayInfo(String fileName, String fileExtension, String initModuleName) {
        this.initialModuleName = initModuleName;
        this.fileNameTFW.setText(fileName);
        this.saveAsTFW.setText(this.initialModuleName);
        this.selectFileTypeForExtension(fileExtension);
    }

    private void selectFileTypeForExtension(String extension) {
        int selectionLoc = 0;
        int jarLoc = -1;
        int numEntries = this.fileTypesComboBox.getModel().getSize();
        for (int i = 0; i < numEntries && jarLoc < 0; ++i) {
            String curEntry = this.fileTypesComboBox.getModel().getElementAt(i).toString().trim();
            if (curEntry.length() < 3) continue;
            String startOfCurEntry = curEntry.substring(0, 3);
            if (jarLoc >= 0 || !startOfCurEntry.equalsIgnoreCase("jar")) continue;
            jarLoc = i;
        }
        if (extension.equalsIgnoreCase("jar") && jarLoc >= 0) {
            selectionLoc = jarLoc;
        }
        this.fileTypesComboBox.setSelectedIndex(selectionLoc);
    }

    public String getSaveAsName() {
        return this.saveAsTFW.getText();
    }

    public void giveFocusToSaveAs() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewFileInfoPanel.this.saveAsTFW.requestFocus();
            }
        });
    }

    private void changeMade() {
        AbstractButton forwardButton = this.getWizardInterface().getForwardButton();
        forwardButton.setEnabled(this.entriesLegal());
    }

    private boolean entriesLegal() {
        boolean legal = true;
        String moduleType = (String)this.fileTypesComboBox.getSelectedItem();
        if (moduleType == null) {
            legal = false;
        } else if (moduleType.equals("")) {
            legal = false;
        } else {
            int docLength = this.saveAsTFW.getDocument().getLength();
            String saveAs = null;
            try {
                saveAs = this.saveAsTFW.getDocument().getText(0, docLength);
            }
            catch (Exception ex) {
                // empty catch block
            }
            saveAs = saveAs.trim();
            if (saveAs.equals("")) {
                legal = false;
            }
        }
        return legal;
    }

    public NewExtensionSourceInfo getInfo(byte[] fileContents) {
        String moduleName = this.saveAsTFW.getText();
        String moduleType = this.fileTypesComboBox.getSelectedItem().toString();
        String description = this.descriptionTextArea.getText();
        NewExtensionSourceInfo info = new NewExtensionSourceInfo(this.fileNameTFW.getText(), moduleName, moduleType, description, true, fileContents);
        return info;
    }
}

