/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.extensionsource;

import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.directory.DirectoryEntry;
import com.metamatrix.common.tree.directory.DirectoryEntryView;
import com.metamatrix.common.tree.directory.FileSystemEntry;
import com.metamatrix.common.tree.directory.FileSystemView;
import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.MDCPOpenStateListener;
import com.metamatrix.console.ui.util.ModifiedDirectoryChooserPanel;
import com.metamatrix.console.ui.util.WizardInterface;
import java.io.File;
import javax.swing.AbstractButton;

class NewFileSelectorPanel
extends BasicWizardSubpanelContainer
implements MDCPOpenStateListener {
    private ModifiedDirectoryChooserPanel chooser;

    public NewFileSelectorPanel(WizardInterface wizardInterface, String initialDirectory) {
        super(wizardInterface);
        FileSystemView view = new FileSystemView();
        if (initialDirectory != null && initialDirectory.length() > 0) {
            try {
                DirectoryEntry dirEntry = view.lookup(initialDirectory);
                view.setHome((TreeNode)dirEntry);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.chooser = new ModifiedDirectoryChooserPanel((DirectoryEntryView)view, 0, this);
        this.chooser.setShowAcceptButton(false);
        this.chooser.setShowCancelButton(false);
        this.chooser.setShowDetailsButton(false);
        this.chooser.setShowFilterComboBox(false);
        this.chooser.setShowNewFolderButton(false);
        this.chooser.setShowPassThruFilter(false);
        super.setStepText(1, "Select file containing new extension module");
        super.setMainContent(this.chooser);
    }

    @Override
    public void fileSelectionIsValid(boolean flag) {
        AbstractButton forwardButton = this.getWizardInterface().getForwardButton();
        forwardButton.setEnabled(flag);
    }

    public String getSelectedFileName() {
        String name = null;
        FileSystemEntry fse = (FileSystemEntry)this.chooser.getSelectedTreeNode();
        if (fse != null) {
            name = fse.getFullName();
        }
        return name;
    }

    public String getDirectoryName() {
        String directoryName = null;
        String fullName = this.getSelectedFileName();
        if (fullName != null) {
            int index = fullName.lastIndexOf(File.separatorChar);
            directoryName = fullName.substring(0, index);
        }
        return directoryName;
    }
}

