/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.extensionsource;

import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.directory.DirectoryEntryView;
import com.metamatrix.common.tree.directory.FileSystemEntry;
import com.metamatrix.common.tree.directory.FileSystemView;
import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.MDCPOpenStateListener;
import com.metamatrix.console.ui.util.ModifiedDirectoryChooserPanel;
import com.metamatrix.console.ui.util.WizardInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.swing.AbstractButton;

class ReplacementFileSelectorPanel
extends BasicWizardSubpanelContainer
implements MDCPOpenStateListener {
    private String moduleName;
    private ModifiedDirectoryChooserPanel chooser;

    public ReplacementFileSelectorPanel(String module, WizardInterface wizardInterface, String initialDirectory) {
        super(wizardInterface);
        this.moduleName = module;
        FileSystemView view = new FileSystemView();
        if (initialDirectory != null && initialDirectory.length() > 0) {
            try {
                view.setHome((TreeNode)view.lookup(initialDirectory));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.chooser = new ModifiedDirectoryChooserPanel((DirectoryEntryView)view, 0, this);
        this.chooser.setShowAcceptButton(false);
        this.chooser.setShowCancelButton(false);
        this.chooser.setShowDetailsButton(false);
        this.chooser.setShowFilterComboBox(false);
        this.chooser.setShowNewFolderButton(false);
        this.chooser.setShowPassThruFilter(false);
        super.setStepText(1, "Select file containing new contents for module " + this.moduleName);
        super.setMainContent(this.chooser);
    }

    @Override
    public void fileSelectionIsValid(boolean flag) {
        AbstractButton forwardButton = this.getWizardInterface().getForwardButton();
        forwardButton.setEnabled(flag);
    }

    public String getSelectedFileName() {
        String name = null;
        FileSystemEntry fse = (FileSystemEntry)this.chooser.getSelectedTreeNode();
        if (fse != null) {
            name = fse.getName();
            name = fse.getFullName();
        } else {
            String directory = this.chooser.getParentDirectoryEntry().toString();
            if (!directory.endsWith(File.separator)) {
                directory = directory + File.separator;
            }
            String fileNameEntered = this.chooser.getNameFieldText().trim();
            name = directory + fileNameEntered;
        }
        return name;
    }

    public String getDirectoryName() {
        String directoryName = null;
        String fullName = this.getSelectedFileName();
        if (fullName != null) {
            int index = fullName.lastIndexOf(File.separatorChar);
            directoryName = fullName.substring(0, index);
        }
        return directoryName;
    }

    public byte[] getSelectedFileContents() throws Exception {
        int n;
        File file = new File(this.getSelectedFileName());
        FileInputStream stream = new FileInputStream(file);
        int length = (int)file.length();
        byte[] contents = new byte[length];
        for (int pos = 0; pos < length; pos += n) {
            n = ((InputStream)stream).read(contents, pos, contents.length - pos);
        }
        return contents;
    }
}

