/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.logsetup;

import com.metamatrix.console.ui.views.logsetup.ConfigurationLogSetUpPanelController;
import com.metamatrix.console.ui.views.logsetup.ContextsAccumulatorListener;
import com.metamatrix.console.ui.views.logsetup.ContextsAccumulatorOuterPanel;
import com.metamatrix.console.ui.views.logsetup.MessageLevelChangeNotifyee;
import com.metamatrix.console.ui.views.logsetup.MessageLevelPanel;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;

public class ConfigurationLogSetUpPanel
extends JPanel
implements MessageLevelChangeNotifyee,
ContextsAccumulatorListener {
    private ConfigurationLogSetUpPanelController controller;
    private String[] messageLevelNames;
    private int initialMessageLevel;
    private List initialAvailableContexts;
    private List initialSelectedContexts;
    private String[] sourceNames;
    private Icon[] sourceIcons;
    private MessageLevelPanel messageLevelPanel;
    private ContextsAccumulatorOuterPanel outerAccumPanel;
    private ButtonWidget applyButton;
    private ButtonWidget resetButton;
    private String panelTitle;
    private boolean canModify;

    public ConfigurationLogSetUpPanel(String panelTitle, boolean canModify, ConfigurationLogSetUpPanelController controller, String[] sourceNames, Icon[] sourceIcons, String[] messageLevelNames, int initialMessageLevel, List initialAvailableContexts, List initialSelectedContexts) {
        this.panelTitle = panelTitle;
        this.canModify = canModify;
        this.controller = controller;
        this.sourceNames = sourceNames;
        this.sourceIcons = sourceIcons;
        this.messageLevelNames = messageLevelNames;
        this.initialMessageLevel = initialMessageLevel;
        this.initialAvailableContexts = initialAvailableContexts;
        this.initialSelectedContexts = initialSelectedContexts;
        this.init();
    }

    private void init() {
        this.setBorder(new TitledBorder(this.panelTitle + " Configuration"));
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        this.applyButton = new ButtonWidget("Apply");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ConfigurationLogSetUpPanel.this.applyPressed();
            }
        });
        this.resetButton = new ButtonWidget("Reset");
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ConfigurationLogSetUpPanel.this.resetPressed();
            }
        });
        JPanel buttonsPanel = new JPanel(new GridLayout(1, 2, 16, 0));
        buttonsPanel.add(this.applyButton);
        buttonsPanel.add(this.resetButton);
        this.messageLevelPanel = new MessageLevelPanel(this.controller, this.sourceNames, this, this.messageLevelNames, this.initialMessageLevel, this.canModify);
        this.messageLevelPanel.setBorder(new TitledBorder("Message Levels"));
        this.outerAccumPanel = new ContextsAccumulatorOuterPanel(this.initialAvailableContexts, this.initialSelectedContexts, this, this.canModify, this.controller, this.sourceNames, this.sourceIcons);
        this.outerAccumPanel.setBorder(new TitledBorder("Message Contexts"));
        this.add(this.messageLevelPanel);
        layout.setConstraints(this.messageLevelPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.add(this.outerAccumPanel);
        layout.setConstraints(this.outerAccumPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        if (this.canModify) {
            this.add(buttonsPanel);
            layout.setConstraints(buttonsPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        } else {
            this.applyButton.setEnabled(false);
            this.resetButton.setEnabled(false);
        }
        this.checkButtonEnabling();
    }

    public int getSelectedMessageLevel() {
        return this.messageLevelPanel.getCurrentLevel();
    }

    public List getSelectedMessageContexts() {
        return this.outerAccumPanel.getSelectedContexts();
    }

    public List getAvailableMessageContexts() {
        return this.outerAccumPanel.getAvailableContexts();
    }

    @Override
    public void messageLevelsChanged() {
        this.checkButtonEnabling();
    }

    @Override
    public void selectedContextsChanged() {
        this.checkButtonEnabling();
    }

    private void checkButtonEnabling() {
        boolean isEnabled;
        boolean shouldBeEnabled;
        if (this.canModify && (shouldBeEnabled = this.hasLevelChanged() || this.haveContextsChanged()) != (isEnabled = this.applyButton.isEnabled())) {
            this.applyButton.setEnabled(shouldBeEnabled);
            this.resetButton.setEnabled(shouldBeEnabled);
            this.controller.applyButtonStateChanged(this.panelTitle, shouldBeEnabled);
        }
    }

    private boolean hasLevelChanged() {
        int curLevel = this.messageLevelPanel.getCurrentLevel();
        return curLevel != this.initialMessageLevel;
    }

    private boolean haveContextsChanged() {
        List currentSelectedContexts = this.outerAccumPanel.getSelectedContexts();
        boolean mismatchFound = false;
        int curNumContexts = currentSelectedContexts.size();
        if (curNumContexts != this.initialSelectedContexts.size()) {
            mismatchFound = true;
        } else {
            int i = 0;
            while (!mismatchFound && i < curNumContexts) {
                if (!currentSelectedContexts.get(i).equals(this.initialSelectedContexts.get(i))) {
                    mismatchFound = true;
                    continue;
                }
                ++i;
            }
        }
        return mismatchFound;
    }

    private void applyPressed() {
        this.controller.applyButtonPressed(this.panelTitle, this.messageLevelPanel.getCurrentLevel(), this.outerAccumPanel.getSelectedContexts());
    }

    private void resetPressed() {
        this.outerAccumPanel.setContexts(this.initialSelectedContexts);
        this.messageLevelPanel.setLevel(this.initialMessageLevel);
        this.checkButtonEnabling();
    }

    public void setNewValues(List availableContexts, List selectedContexts, int messageLevel) {
        this.initialAvailableContexts = availableContexts;
        this.initialSelectedContexts = selectedContexts;
        this.initialMessageLevel = messageLevel;
        this.resetPressed();
    }

    public void setCopyButtonState(String sourceName, boolean newState) {
        this.messageLevelPanel.setCopyButtonState(sourceName, newState);
        this.outerAccumPanel.setCopyButtonState(sourceName, newState);
    }

    public boolean havePendingChanges() {
        boolean pending = this.applyButton.isVisible() && this.applyButton.isEnabled();
        return pending;
    }

    public void doApply() {
        this.applyButton.doClick();
    }

    public void doReset() {
        this.resetButton.doClick();
    }
}

