/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.logsetup;

import com.metamatrix.console.ui.views.logsetup.ConfigurationLogSetUpPanelController;
import com.metamatrix.console.ui.views.logsetup.ContextsAccumulatorListener;
import com.metamatrix.console.ui.views.logsetup.ContextsAccumulatorPanel;
import com.metamatrix.console.util.StaticQuickSorter;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;

class ContextsAccumulatorOuterPanel
extends JPanel {
    private ConfigurationLogSetUpPanelController controller;
    ContextsAccumulatorPanel accumPanel;
    private String[] contextsSources;
    private Icon[] contextsIcons;
    private ButtonWidget[] copyFrom;

    public ContextsAccumulatorOuterPanel(List initialAvailableContexts, List initialSelectedContexts, ContextsAccumulatorListener listener, boolean canModify, ConfigurationLogSetUpPanelController controller, String[] contextsSources, Icon[] contextsIcons) {
        this.controller = controller;
        this.contextsSources = contextsSources;
        this.contextsIcons = contextsIcons;
        this.init(initialAvailableContexts, initialSelectedContexts, listener, canModify);
    }

    private void init(List initialAvailableContexts, List initialSelectedContexts, ContextsAccumulatorListener listener, boolean canModify) {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        this.accumPanel = new ContextsAccumulatorPanel(initialAvailableContexts, initialSelectedContexts, listener);
        if (!canModify) {
            this.accumPanel.setEnabled(false);
        }
        this.add(this.accumPanel);
        layout.setConstraints(this.accumPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (canModify) {
            JPanel buttonsPanel = new JPanel(new GridLayout(1, this.contextsSources.length, 20, 0));
            this.add(buttonsPanel);
            layout.setConstraints(buttonsPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 0, 10, 0), 0, 0));
            this.copyFrom = new ButtonWidget[this.contextsSources.length];
            for (int i = 0; i < this.contextsSources.length; ++i) {
                this.copyFrom[i] = new ButtonWidget("Copy contexts from " + this.contextsSources[i], this.contextsIcons[i]);
                buttonsPanel.add(this.copyFrom[i]);
                final int index = i;
                this.copyFrom[i].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        ContextsAccumulatorOuterPanel.this.copyButtonPressed(index);
                    }
                });
            }
        } else {
            this.accumPanel.setEnabled(false);
        }
    }

    private void copyButtonPressed(int index) {
        String sourceName = this.contextsSources[index];
        List contexts = this.controller.getContextsFrom(sourceName);
        this.setContexts(contexts);
    }

    public List getSelectedContexts() {
        return this.accumPanel.getValues();
    }

    public List getAvailableContexts() {
        return this.accumPanel.getAvailableValues();
    }

    public void setContexts(List selectedContexts) {
        this.accumPanel.setValues(selectedContexts);
    }

    public void setCopyButtonState(String sourceName, boolean newState) {
        int index;
        if (this.contextsSources != null && this.copyFrom != null && (index = StaticQuickSorter.unsortedStringArrayIndex(this.contextsSources, sourceName)) >= 0) {
            this.copyFrom[index].setEnabled(newState);
        }
    }
}

