/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.logsetup;

import com.metamatrix.console.ui.views.logsetup.MessageLevelChangeNotifyee;
import com.metamatrix.toolbox.ui.widget.CheckBox;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class MessageLevelCheckBoxes
extends JPanel
implements ItemListener {
    private static final int GAP_BETWEEN_ITEMS = 4;
    private MessageLevelChangeNotifyee notifyee;
    private JCheckBox[] checkBoxes;
    private boolean programmaticChange = false;
    private boolean checkAllLowerLevels;

    public MessageLevelCheckBoxes(MessageLevelChangeNotifyee notifyee, boolean checkAllLowerLevels, String[] levelNames, boolean[] levelInitialValues, boolean hideNone, boolean enabled) {
        this.notifyee = notifyee;
        this.checkAllLowerLevels = checkAllLowerLevels;
        if (levelNames.length != levelInitialValues.length) {
            throw new RuntimeException("Error in MessageLevelCheckBoxes constructor");
        }
        this.init(levelNames, levelInitialValues, hideNone, enabled);
    }

    public MessageLevelCheckBoxes(MessageLevelChangeNotifyee notifyee, String[] levelNames, int initialLevel, boolean hideNone, boolean enabled) {
        int i;
        this.notifyee = notifyee;
        this.checkAllLowerLevels = true;
        boolean[] levelInitialValues = new boolean[levelNames.length];
        for (i = 0; i <= initialLevel; ++i) {
            levelInitialValues[i] = true;
        }
        for (i = initialLevel + 1; i < levelInitialValues.length; ++i) {
            levelInitialValues[i] = false;
        }
        this.init(levelNames, levelInitialValues, hideNone, enabled);
    }

    private void init(String[] levelNames, boolean[] levelInitialValues, boolean hideNone, boolean enabled) {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        this.checkBoxes = new JCheckBox[levelNames.length];
        for (int i = 0; i < levelNames.length; ++i) {
            this.checkBoxes[i] = new CheckBox(levelNames[i]);
            this.checkBoxes[i].setSelected(levelInitialValues[i]);
            this.checkBoxes[i].addItemListener(this);
            this.checkBoxes[i].setEnabled(enabled);
            this.add(this.checkBoxes[i]);
            layout.setConstraints(this.checkBoxes[i], new GridBagConstraints(i, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, i == 0 ? 0 : 4, 0, i == levelNames.length - 1 ? 0 : 4), 0, 0));
            if (!hideNone || !levelNames[i].equalsIgnoreCase("None")) continue;
            this.checkBoxes[i].setVisible(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent ev) {
        if (!this.programmaticChange) {
            if (this.checkAllLowerLevels) {
                Object source = ev.getSource();
                int matchLoc = -1;
                int loc = 0;
                while (matchLoc < 0) {
                    if (source == this.checkBoxes[loc]) {
                        matchLoc = loc;
                        continue;
                    }
                    ++loc;
                }
                if (this.checkBoxes[loc].isSelected()) {
                    this.programmaticChange = true;
                    for (int i = 0; i < loc; ++i) {
                        this.checkBoxes[i].setSelected(true);
                    }
                    this.programmaticChange = false;
                } else {
                    this.programmaticChange = true;
                    for (int i = loc + 1; i < this.checkBoxes.length; ++i) {
                        this.checkBoxes[i].setSelected(false);
                    }
                    this.programmaticChange = false;
                }
            }
            this.notifyee.messageLevelsChanged();
        }
    }

    public boolean[] getCurrentValues() {
        boolean[] currentValues = new boolean[this.checkBoxes.length];
        for (int i = 0; i < currentValues.length; ++i) {
            currentValues[i] = this.checkBoxes[i].isSelected();
        }
        return currentValues;
    }

    public void setValues(boolean[] newValues) {
        this.programmaticChange = true;
        for (int i = 0; i < newValues.length; ++i) {
            this.checkBoxes[i].setSelected(newValues[i]);
        }
        this.programmaticChange = false;
    }

    public void setValuesUpThrough(int index) {
        int i;
        for (i = 0; i <= index; ++i) {
            this.checkBoxes[i].setSelected(true);
        }
        for (i = index + 1; i < this.checkBoxes.length; ++i) {
            this.checkBoxes[i].setSelected(false);
        }
    }
}

