/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.logsetup;

import com.metamatrix.console.ui.views.logsetup.ConfigurationLogSetUpPanelController;
import com.metamatrix.console.ui.views.logsetup.MessageLevelChangeNotifyee;
import com.metamatrix.console.ui.views.logsetup.MessageLevelCheckBoxes;
import com.metamatrix.console.util.StaticQuickSorter;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;

public class MessageLevelPanel
extends JPanel {
    private ConfigurationLogSetUpPanelController controller;
    private String[] copySourceNames;
    private MessageLevelChangeNotifyee notifyee;
    private MessageLevelCheckBoxes checkBoxPanel;
    private ButtonWidget[] copyFrom = null;

    public MessageLevelPanel(ConfigurationLogSetUpPanelController controller, String[] copySourceNames, MessageLevelChangeNotifyee notifyee, String[] messageLevelNames, int initialMessageLevel, boolean enabled) {
        this.controller = controller;
        this.copySourceNames = copySourceNames;
        this.notifyee = notifyee;
        this.init(messageLevelNames, initialMessageLevel, enabled);
    }

    private void init(String[] messageLevelNames, int initialMessageLevel, boolean enabled) {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        this.checkBoxPanel = new MessageLevelCheckBoxes(this.notifyee, messageLevelNames, initialMessageLevel, true, enabled);
        this.add(this.checkBoxPanel);
        layout.setConstraints(this.checkBoxPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 6, 0), 0, 0));
        if (enabled && this.copySourceNames.length > 0) {
            this.copyFrom = new ButtonWidget[this.copySourceNames.length];
            JPanel buttonsPanel = new JPanel(new GridLayout(1, this.copySourceNames.length, 6, 0));
            for (int i = 0; i < this.copyFrom.length; ++i) {
                this.copyFrom[i] = new ButtonWidget("Copy from " + this.copySourceNames[i]);
                final int index = i;
                this.copyFrom[i].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        MessageLevelPanel.this.copyFromPressed(index);
                    }
                });
                buttonsPanel.add(this.copyFrom[i]);
            }
        }
    }

    private void copyFromPressed(int buttonIndex) {
        int level = this.controller.getMessageLevelFrom(this.copySourceNames[buttonIndex]);
        this.setLevel(level);
        this.notifyee.messageLevelsChanged();
    }

    public int getCurrentLevel() {
        boolean[] values = this.checkBoxPanel.getCurrentValues();
        int highestLevel = -1;
        int loc = values.length - 1;
        while (loc >= 0 && highestLevel < 0) {
            if (values[loc]) {
                highestLevel = loc;
                continue;
            }
            --loc;
        }
        return highestLevel;
    }

    public void setLevel(int level) {
        this.checkBoxPanel.setValuesUpThrough(level);
    }

    public void setCopyButtonState(String sourceName, boolean newState) {
        int index;
        if (this.copySourceNames != null && this.copyFrom != null && (index = StaticQuickSorter.unsortedStringArrayIndex(this.copySourceNames, sourceName)) >= 0) {
            this.copyFrom[index].setEnabled(newState);
        }
    }
}

